# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V2
        module SecurityCenter
          # Path helper methods for the SecurityCenter API.
          module Paths
            ##
            # Create a fully-qualified BigQueryExport resource string.
            #
            # @overload big_query_export_path(organization:, location:, export:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/bigQueryExports/{export}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param export [String]
            #
            # @overload big_query_export_path(folder:, location:, export:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/bigQueryExports/{export}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param export [String]
            #
            # @overload big_query_export_path(project:, location:, export:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/bigQueryExports/{export}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param export [String]
            #
            # @return [::String]
            def big_query_export_path **args
              resources = {
                "export:location:organization" => (proc do |organization:, location:, export:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/bigQueryExports/#{export}"
                end),
                "export:folder:location" => (proc do |folder:, location:, export:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/bigQueryExports/#{export}"
                end),
                "export:location:project" => (proc do |project:, location:, export:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/bigQueryExports/#{export}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified DlpJob resource string.
            #
            # @overload dlp_job_path(project:, dlp_job:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/dlpJobs/{dlp_job}`
            #
            #   @param project [String]
            #   @param dlp_job [String]
            #
            # @overload dlp_job_path(project:, location:, dlp_job:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/dlpJobs/{dlp_job}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param dlp_job [String]
            #
            # @return [::String]
            def dlp_job_path **args
              resources = {
                "dlp_job:project" => (proc do |project:, dlp_job:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/dlpJobs/#{dlp_job}"
                end),
                "dlp_job:location:project" => (proc do |project:, location:, dlp_job:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/dlpJobs/#{dlp_job}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified ExternalSystem resource string.
            #
            # @overload external_system_path(organization:, source:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @overload external_system_path(organization:, source:, location:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @overload external_system_path(folder:, source:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @overload external_system_path(folder:, source:, location:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @overload external_system_path(project:, source:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @overload external_system_path(project:, source:, location:, finding:, externalsystem:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #   @param externalsystem [String]
            #
            # @return [::String]
            def external_system_path **args
              resources = {
                "externalsystem:finding:organization:source" => (proc do |organization:, source:, finding:, externalsystem:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/findings/#{finding}/externalSystems/#{externalsystem}"
                end),
                "externalsystem:finding:location:organization:source" => (proc do |organization:, source:, location:, finding:, externalsystem:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/locations/#{location}/findings/#{finding}/externalSystems/#{externalsystem}"
                end),
                "externalsystem:finding:folder:source" => (proc do |folder:, source:, finding:, externalsystem:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/findings/#{finding}/externalSystems/#{externalsystem}"
                end),
                "externalsystem:finding:folder:location:source" => (proc do |folder:, source:, location:, finding:, externalsystem:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/locations/#{location}/findings/#{finding}/externalSystems/#{externalsystem}"
                end),
                "externalsystem:finding:project:source" => (proc do |project:, source:, finding:, externalsystem:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/findings/#{finding}/externalSystems/#{externalsystem}"
                end),
                "externalsystem:finding:location:project:source" => (proc do |project:, source:, location:, finding:, externalsystem:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "finding cannot contain /" if finding.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/locations/#{location}/findings/#{finding}/externalSystems/#{externalsystem}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Finding resource string.
            #
            # @overload finding_path(organization:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/findings/{finding}`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload finding_path(organization:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @overload finding_path(folder:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/findings/{finding}`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload finding_path(folder:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/locations/{location}/findings/{finding}`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @overload finding_path(project:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/findings/{finding}`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload finding_path(project:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/locations/{location}/findings/{finding}`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @return [::String]
            def finding_path **args
              resources = {
                "finding:organization:source" => (proc do |organization:, source:, finding:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/findings/#{finding}"
                end),
                "finding:location:organization:source" => (proc do |organization:, source:, location:, finding:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/locations/#{location}/findings/#{finding}"
                end),
                "finding:folder:source" => (proc do |folder:, source:, finding:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/findings/#{finding}"
                end),
                "finding:folder:location:source" => (proc do |folder:, source:, location:, finding:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/locations/#{location}/findings/#{finding}"
                end),
                "finding:project:source" => (proc do |project:, source:, finding:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/findings/#{finding}"
                end),
                "finding:location:project:source" => (proc do |project:, source:, location:, finding:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/locations/#{location}/findings/#{finding}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Folder resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}`
            #
            # @param folder [String]
            #
            # @return [::String]
            def folder_path folder:
              "folders/#{folder}"
            end

            ##
            # Create a fully-qualified FolderLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}/locations/{location}`
            #
            # @param folder [String]
            # @param location [String]
            #
            # @return [::String]
            def folder_location_path folder:, location:
              raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

              "folders/#{folder}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified MuteConfig resource string.
            #
            # @overload mute_config_path(organization:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/muteConfigs/{mute_config}`
            #
            #   @param organization [String]
            #   @param mute_config [String]
            #
            # @overload mute_config_path(organization:, location:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/muteConfigs/{mute_config}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param mute_config [String]
            #
            # @overload mute_config_path(folder:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/muteConfigs/{mute_config}`
            #
            #   @param folder [String]
            #   @param mute_config [String]
            #
            # @overload mute_config_path(folder:, location:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/muteConfigs/{mute_config}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param mute_config [String]
            #
            # @overload mute_config_path(project:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/muteConfigs/{mute_config}`
            #
            #   @param project [String]
            #   @param mute_config [String]
            #
            # @overload mute_config_path(project:, location:, mute_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/muteConfigs/{mute_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param mute_config [String]
            #
            # @return [::String]
            def mute_config_path **args
              resources = {
                "mute_config:organization" => (proc do |organization:, mute_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/muteConfigs/#{mute_config}"
                end),
                "location:mute_config:organization" => (proc do |organization:, location:, mute_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/muteConfigs/#{mute_config}"
                end),
                "folder:mute_config" => (proc do |folder:, mute_config:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/muteConfigs/#{mute_config}"
                end),
                "folder:location:mute_config" => (proc do |folder:, location:, mute_config:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/muteConfigs/#{mute_config}"
                end),
                "mute_config:project" => (proc do |project:, mute_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/muteConfigs/#{mute_config}"
                end),
                "location:mute_config:project" => (proc do |project:, location:, mute_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/muteConfigs/#{mute_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified NotificationConfig resource string.
            #
            # @overload notification_config_path(organization:, location:, notification_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/notificationConfigs/{notification_config}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param notification_config [String]
            #
            # @overload notification_config_path(folder:, location:, notification_config:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/notificationConfigs/{notification_config}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param notification_config [String]
            #
            # @overload notification_config_path(project:, location:, notification_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/notificationConfigs/{notification_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param notification_config [String]
            #
            # @return [::String]
            def notification_config_path **args
              resources = {
                "location:notification_config:organization" => (proc do |organization:, location:, notification_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/notificationConfigs/#{notification_config}"
                end),
                "folder:location:notification_config" => (proc do |folder:, location:, notification_config:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/notificationConfigs/#{notification_config}"
                end),
                "location:notification_config:project" => (proc do |project:, location:, notification_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/notificationConfigs/#{notification_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationValuedResource resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}/simulations/{simulation}/valuedResources/{valued_resource}`
            #
            # @param organization [String]
            # @param location [String]
            # @param simulation [String]
            # @param valued_resource [String]
            #
            # @return [::String]
            def organization_valued_resource_path organization:, location:, simulation:, valued_resource:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "simulation cannot contain /" if simulation.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}/simulations/#{simulation}/valuedResources/#{valued_resource}"
            end

            ##
            # Create a fully-qualified Policy resource string.
            #
            # @overload policy_path(organization:, constraint_name:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/policies/{constraint_name}`
            #
            #   @param organization [String]
            #   @param constraint_name [String]
            #
            # @overload policy_path(folder:, constraint_name:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/policies/{constraint_name}`
            #
            #   @param folder [String]
            #   @param constraint_name [String]
            #
            # @overload policy_path(project:, constraint_name:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/policies/{constraint_name}`
            #
            #   @param project [String]
            #   @param constraint_name [String]
            #
            # @return [::String]
            def policy_path **args
              resources = {
                "constraint_name:organization" => (proc do |organization:, constraint_name:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/policies/#{constraint_name}"
                end),
                "constraint_name:folder" => (proc do |folder:, constraint_name:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/policies/#{constraint_name}"
                end),
                "constraint_name:project" => (proc do |project:, constraint_name:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/policies/#{constraint_name}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified ResourceValueConfig resource string.
            #
            # @overload resource_value_config_path(organization:, resource_value_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/resourceValueConfigs/{resource_value_config}`
            #
            #   @param organization [String]
            #   @param resource_value_config [String]
            #
            # @overload resource_value_config_path(organization:, location:, resource_value_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/resourceValueConfigs/{resource_value_config}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param resource_value_config [String]
            #
            # @return [::String]
            def resource_value_config_path **args
              resources = {
                "organization:resource_value_config" => (proc do |organization:, resource_value_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/resourceValueConfigs/#{resource_value_config}"
                end),
                "location:organization:resource_value_config" => (proc do |organization:, location:, resource_value_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/resourceValueConfigs/#{resource_value_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified SecurityMarks resource string.
            #
            # @overload security_marks_path(organization:, asset:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/assets/{asset}/securityMarks`
            #
            #   @param organization [String]
            #   @param asset [String]
            #
            # @overload security_marks_path(organization:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/findings/{finding}/securityMarks`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload security_marks_path(organization:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}/securityMarks`
            #
            #   @param organization [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @overload security_marks_path(folder:, asset:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/assets/{asset}/securityMarks`
            #
            #   @param folder [String]
            #   @param asset [String]
            #
            # @overload security_marks_path(folder:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/findings/{finding}/securityMarks`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload security_marks_path(folder:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}/locations/{location}/findings/{finding}/securityMarks`
            #
            #   @param folder [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @overload security_marks_path(project:, asset:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/assets/{asset}/securityMarks`
            #
            #   @param project [String]
            #   @param asset [String]
            #
            # @overload security_marks_path(project:, source:, finding:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/findings/{finding}/securityMarks`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param finding [String]
            #
            # @overload security_marks_path(project:, source:, location:, finding:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}/locations/{location}/findings/{finding}/securityMarks`
            #
            #   @param project [String]
            #   @param source [String]
            #   @param location [String]
            #   @param finding [String]
            #
            # @return [::String]
            def security_marks_path **args
              resources = {
                "asset:organization" => (proc do |organization:, asset:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/assets/#{asset}/securityMarks"
                end),
                "finding:organization:source" => (proc do |organization:, source:, finding:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/findings/#{finding}/securityMarks"
                end),
                "finding:location:organization:source" => (proc do |organization:, source:, location:, finding:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}/locations/#{location}/findings/#{finding}/securityMarks"
                end),
                "asset:folder" => (proc do |folder:, asset:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/assets/#{asset}/securityMarks"
                end),
                "finding:folder:source" => (proc do |folder:, source:, finding:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/findings/#{finding}/securityMarks"
                end),
                "finding:folder:location:source" => (proc do |folder:, source:, location:, finding:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}/locations/#{location}/findings/#{finding}/securityMarks"
                end),
                "asset:project" => (proc do |project:, asset:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/assets/#{asset}/securityMarks"
                end),
                "finding:project:source" => (proc do |project:, source:, finding:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/findings/#{finding}/securityMarks"
                end),
                "finding:location:project:source" => (proc do |project:, source:, location:, finding:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "source cannot contain /" if source.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/sources/#{source}/locations/#{location}/findings/#{finding}/securityMarks"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Simulation resource string.
            #
            # @overload simulation_path(organization:, simulation:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/simulations/{simulation}`
            #
            #   @param organization [String]
            #   @param simulation [String]
            #
            # @overload simulation_path(organization:, location:, simluation:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/simulations/{simluation}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param simluation [String]
            #
            # @return [::String]
            def simulation_path **args
              resources = {
                "organization:simulation" => (proc do |organization:, simulation:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/simulations/#{simulation}"
                end),
                "location:organization:simluation" => (proc do |organization:, location:, simluation:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/simulations/#{simluation}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Source resource string.
            #
            # @overload source_path(organization:, source:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/sources/{source}`
            #
            #   @param organization [String]
            #   @param source [String]
            #
            # @overload source_path(folder:, source:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/sources/{source}`
            #
            #   @param folder [String]
            #   @param source [String]
            #
            # @overload source_path(project:, source:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/sources/{source}`
            #
            #   @param project [String]
            #   @param source [String]
            #
            # @return [::String]
            def source_path **args
              resources = {
                "organization:source" => (proc do |organization:, source:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/sources/#{source}"
                end),
                "folder:source" => (proc do |folder:, source:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/sources/#{source}"
                end),
                "project:source" => (proc do |project:, source:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/sources/#{source}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified TableDataProfile resource string.
            #
            # @overload table_data_profile_path(project:, table_profile:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/tableProfiles/{table_profile}`
            #
            #   @param project [String]
            #   @param table_profile [String]
            #
            # @overload table_data_profile_path(project:, location:, table_profile:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/tableProfiles/{table_profile}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param table_profile [String]
            #
            # @return [::String]
            def table_data_profile_path **args
              resources = {
                "project:table_profile" => (proc do |project:, table_profile:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/tableProfiles/#{table_profile}"
                end),
                "location:project:table_profile" => (proc do |project:, location:, table_profile:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/tableProfiles/#{table_profile}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Topic resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/topics/{topic}`
            #
            # @param project [String]
            # @param topic [String]
            #
            # @return [::String]
            def topic_path project:, topic:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/topics/#{topic}"
            end

            ##
            # Create a fully-qualified ValuedResource resource string.
            #
            # @overload valued_resource_path(organization:, simulation:, valued_resource:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
            #
            #   @param organization [String]
            #   @param simulation [String]
            #   @param valued_resource [String]
            #
            # @overload valued_resource_path(organization:, location:, simluation:, valued_resource:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/simulations/{simluation}/valuedResources/{valued_resource}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param simluation [String]
            #   @param valued_resource [String]
            #
            # @return [::String]
            def valued_resource_path **args
              resources = {
                "organization:simulation:valued_resource" => (proc do |organization:, simulation:, valued_resource:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "simulation cannot contain /" if simulation.to_s.include? "/"

                  "organizations/#{organization}/simulations/#{simulation}/valuedResources/#{valued_resource}"
                end),
                "location:organization:simluation:valued_resource" => (proc do |organization:, location:, simluation:, valued_resource:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "simluation cannot contain /" if simluation.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/simulations/#{simluation}/valuedResources/#{valued_resource}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
