# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/securitycenter/v2/securitycenter_service_pb"

module Google
  module Cloud
    module SecurityCenter
      module V2
        module SecurityCenter
          ##
          # Client for the SecurityCenter service.
          #
          # V2 APIs for Security Center service.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "securitycenter.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :security_center_stub

            ##
            # Configure the SecurityCenter Client class.
            #
            # See {::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SecurityCenter clients
            #   ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "SecurityCenter", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SecurityCenter Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @security_center_stub.universe_domain
            end

            ##
            # Create a new SecurityCenter client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SecurityCenter client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/securitycenter/v2/securitycenter_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @security_center_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @security_center_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::SecurityCenter::V2::SecurityCenter::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @security_center_stub.logger
            end

            # Service calls

            ##
            # Creates a ResourceValueConfig for an organization. Maps user's tags to
            # difference resource values for use by the attack path simulation.
            #
            # @overload batch_create_resource_value_configs(request, options = nil)
            #   Pass arguments to `batch_create_resource_value_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_resource_value_configs(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_resource_value_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new ResourceValueConfig's parent.
            #     The parent field in the CreateResourceValueConfigRequest
            #     messages must either be empty or match this field.
            #   @param requests [::Array<::Google::Cloud::SecurityCenter::V2::CreateResourceValueConfigRequest, ::Hash>]
            #     Required. The resource value configs to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest.new
            #
            #   # Call the batch_create_resource_value_configs method.
            #   result = client.batch_create_resource_value_configs request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsResponse.
            #   p result
            #
            def batch_create_resource_value_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::BatchCreateResourceValueConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_resource_value_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_resource_value_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_resource_value_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :batch_create_resource_value_configs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Kicks off an LRO to bulk mute findings for a parent based on a filter. If
            # no location is specified, findings are muted in global. The parent
            # can be either an organization, folder, or project. The findings matched by
            # the filter will be muted after the LRO is done.
            #
            # @overload bulk_mute_findings(request, options = nil)
            #   Pass arguments to `bulk_mute_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload bulk_mute_findings(parent: nil, filter: nil, mute_state: nil)
            #   Pass arguments to `bulk_mute_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, at which bulk action needs to be applied. If no
            #     location is specified, findings are updated in global. The following list
            #     shows some examples:
            #
            #     + `organizations/[organization_id]`
            #     + `organizations/[organization_id]/locations/[location_id]`
            #     + `folders/[folder_id]`
            #     + `folders/[folder_id]/locations/[location_id]`
            #     + `projects/[project_id]`
            #     + `projects/[project_id]/locations/[location_id]`
            #   @param filter [::String]
            #     Expression that identifies findings that should be updated.
            #     The expression is a list of zero or more restrictions combined
            #     via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
            #     has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a
            #     `-` character in front of them to indicate negation. The fields map to
            #     those defined in the corresponding resource.
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #   @param mute_state [::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest::MuteState]
            #     Optional. All findings matching the given filter will have their mute state
            #     set to this value. The default value is `MUTED`. Setting this to
            #     `UNDEFINED` will clear the mute state on all matching findings.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest.new
            #
            #   # Call the bulk_mute_findings method.
            #   result = client.bulk_mute_findings request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def bulk_mute_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::BulkMuteFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.bulk_mute_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.bulk_mute_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.bulk_mute_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :bulk_mute_findings, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a BigQuery export.
            #
            # @overload create_big_query_export(request, options = nil)
            #   Pass arguments to `create_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_big_query_export(parent: nil, big_query_export: nil, big_query_export_id: nil)
            #   Pass arguments to `create_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource of the new BigQuery export. Its
            #     format is `organizations/[organization_id]/locations/[location_id]`,
            #     `folders/[folder_id]/locations/[location_id]`, or
            #     `projects/[project_id]/locations/[location_id]`.
            #   @param big_query_export [::Google::Cloud::SecurityCenter::V2::BigQueryExport, ::Hash]
            #     Required. The BigQuery export being created.
            #   @param big_query_export_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must consist of only lowercase letters, numbers, and hyphens, must start
            #     with a letter, must end with either a letter or a number, and must be 63
            #     characters or less.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest.new
            #
            #   # Call the create_big_query_export method.
            #   result = client.create_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::BigQueryExport.
            #   p result
            #
            def create_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::CreateBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a finding in a location. The corresponding source must exist for
            # finding creation to succeed.
            #
            # @overload create_finding(request, options = nil)
            #   Pass arguments to `create_finding` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::CreateFindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::CreateFindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_finding(parent: nil, finding_id: nil, finding: nil)
            #   Pass arguments to `create_finding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new finding's parent. The following list
            #     shows some examples of the format:
            #     +
            #     `organizations/[organization_id]/sources/[source_id]`
            #     +
            #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
            #   @param finding_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must be alphanumeric and less than or equal to 32 characters and
            #     greater than 0 characters in length.
            #   @param finding [::Google::Cloud::SecurityCenter::V2::Finding, ::Hash]
            #     Required. The Finding being created. The name and security_marks will be
            #     ignored as they are both output only fields on this resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::CreateFindingRequest.new
            #
            #   # Call the create_finding method.
            #   result = client.create_finding request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Finding.
            #   p result
            #
            def create_finding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::CreateFindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_finding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_finding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_finding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_finding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a mute config.
            #
            # @overload create_mute_config(request, options = nil)
            #   Pass arguments to `create_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_mute_config(parent: nil, mute_config: nil, mute_config_id: nil)
            #   Pass arguments to `create_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new mute configs's parent. Its format is
            #     `organizations/[organization_id]/locations/[location_id]`,
            #     `folders/[folder_id]/locations/[location_id]`, or
            #     `projects/[project_id]/locations/[location_id]`.
            #   @param mute_config [::Google::Cloud::SecurityCenter::V2::MuteConfig, ::Hash]
            #     Required. The mute config being created.
            #   @param mute_config_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must consist of only lowercase letters, numbers, and hyphens, must start
            #     with a letter, must end with either a letter or a number, and must be 63
            #     characters or less.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest.new
            #
            #   # Call the create_mute_config method.
            #   result = client.create_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::MuteConfig.
            #   p result
            #
            def create_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::CreateMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                regex_match = %r{^projects/[^/]+/locations/(?<location>[^/]+)/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.parent
                regex_match = %r{^organizations/[^/]+/locations/(?<location>[^/]+)/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.parent
                regex_match = %r{^folders/[^/]+/locations/(?<location>[^/]+)/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a notification config.
            #
            # @overload create_notification_config(request, options = nil)
            #   Pass arguments to `create_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_notification_config(parent: nil, config_id: nil, notification_config: nil)
            #   Pass arguments to `create_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new notification config's parent. Its format
            #     is `organizations/[organization_id]/locations/[location_id]`,
            #     `folders/[folder_id]/locations/[location_id]`, or
            #     `projects/[project_id]/locations/[location_id]`.
            #   @param config_id [::String]
            #     Required.
            #     Unique identifier provided by the client within the parent scope.
            #     It must be between 1 and 128 characters and contain alphanumeric
            #     characters, underscores, or hyphens only.
            #   @param notification_config [::Google::Cloud::SecurityCenter::V2::NotificationConfig, ::Hash]
            #     Required. The notification config being created. The name and the service
            #     account will be ignored as they are both output only fields on this
            #     resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest.new
            #
            #   # Call the create_notification_config method.
            #   result = client.create_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::NotificationConfig.
            #   p result
            #
            def create_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::CreateNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a source.
            #
            # @overload create_source(request, options = nil)
            #   Pass arguments to `create_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::CreateSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::CreateSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_source(parent: nil, source: nil)
            #   Pass arguments to `create_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new source's parent. Its format should be
            #     `organizations/[organization_id]`.
            #   @param source [::Google::Cloud::SecurityCenter::V2::Source, ::Hash]
            #     Required. The Source being created, only the display_name and description
            #     will be used. All other fields will be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::CreateSourceRequest.new
            #
            #   # Call the create_source method.
            #   result = client.create_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Source.
            #   p result
            #
            def create_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::CreateSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing BigQuery export.
            #
            # @overload delete_big_query_export(request, options = nil)
            #   Pass arguments to `delete_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_big_query_export(name: nil)
            #   Pass arguments to `delete_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the BigQuery export to delete. The following list
            #     shows some examples of the format:
            #
            #     +
            #     `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
            #     + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
            #     + `projects/{project}/locations/{location}/bigQueryExports/{export_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest.new
            #
            #   # Call the delete_big_query_export method.
            #   result = client.delete_big_query_export request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::DeleteBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing mute config. If no location is specified, default is
            # global.
            #
            # @overload delete_mute_config(request, options = nil)
            #   Pass arguments to `delete_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_mute_config(name: nil)
            #   Pass arguments to `delete_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mute config to delete. The following list shows some
            #     examples of the format:
            #
            #     + `organizations/{organization}/muteConfigs/{config_id}`
            #     +
            #     `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
            #     + `folders/{folder}/muteConfigs/{config_id}`
            #     + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
            #     + `projects/{project}/muteConfigs/{config_id}`
            #     + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest.new
            #
            #   # Call the delete_mute_config method.
            #   result = client.delete_mute_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::DeleteMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                regex_match = %r{^projects/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.name
                regex_match = %r{^organizations/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.name
                regex_match = %r{^folders/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a notification config.
            #
            # @overload delete_notification_config(request, options = nil)
            #   Pass arguments to `delete_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_notification_config(name: nil)
            #   Pass arguments to `delete_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the notification config to delete. The following list
            #     shows some examples of the format:
            #
            #     +
            #     `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
            #     +
            #     `folders/[folder_id]/locations/[location_id]notificationConfigs/[config_id]`
            #     +
            #     `projects/[project_id]/locations/[location_id]notificationConfigs/[config_id]`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest.new
            #
            #   # Call the delete_notification_config method.
            #   result = client.delete_notification_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::DeleteNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a ResourceValueConfig.
            #
            # @overload delete_resource_value_config(request, options = nil)
            #   Pass arguments to `delete_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_resource_value_config(name: nil)
            #   Pass arguments to `delete_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ResourceValueConfig to delete
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest.new
            #
            #   # Call the delete_resource_value_config method.
            #   result = client.delete_resource_value_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::DeleteResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a BigQuery export.
            #
            # @overload get_big_query_export(request, options = nil)
            #   Pass arguments to `get_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_big_query_export(name: nil)
            #   Pass arguments to `get_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the BigQuery export to retrieve. The following list shows
            #     some examples of the format:
            #
            #     +
            #     `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
            #     + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
            #     + `projects/{project}locations/{location}//bigQueryExports/{export_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest.new
            #
            #   # Call the get_big_query_export method.
            #   result = client.get_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::BigQueryExport.
            #   p result
            #
            def get_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the simulation by name or the latest simulation for the given
            # organization.
            #
            # @overload get_simulation(request, options = nil)
            #   Pass arguments to `get_simulation` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetSimulationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetSimulationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_simulation(name: nil)
            #   Pass arguments to `get_simulation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The organization name or simulation name of this simulation
            #
            #     Valid format:
            #     `organizations/{organization}/simulations/latest`
            #     `organizations/{organization}/simulations/{simulation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Simulation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Simulation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetSimulationRequest.new
            #
            #   # Call the get_simulation method.
            #   result = client.get_simulation request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Simulation.
            #   p result
            #
            def get_simulation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetSimulationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_simulation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_simulation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_simulation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_simulation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the valued resource by name
            #
            # @overload get_valued_resource(request, options = nil)
            #   Pass arguments to `get_valued_resource` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_valued_resource(name: nil)
            #   Pass arguments to `get_valued_resource` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of this valued resource
            #
            #     Valid format:
            #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::ValuedResource]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::ValuedResource]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest.new
            #
            #   # Call the get_valued_resource method.
            #   result = client.get_valued_resource request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::ValuedResource.
            #   p result
            #
            def get_valued_resource request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetValuedResourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_valued_resource.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_valued_resource.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_valued_resource.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_valued_resource, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the access control policy on the specified Source.
            #
            # @overload get_iam_policy(request, options = nil)
            #   Pass arguments to `get_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_iam_policy(resource: nil, options: nil)
            #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
            #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
            #     `GetIamPolicy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::GetIamPolicyRequest.new
            #
            #   # Call the get_iam_policy method.
            #   result = client.get_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def get_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a mute config. If no location is specified, default is
            # global.
            #
            # @overload get_mute_config(request, options = nil)
            #   Pass arguments to `get_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_mute_config(name: nil)
            #   Pass arguments to `get_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mute config to retrieve. The following list shows
            #     some examples of the format:
            #
            #     + `organizations/{organization}/muteConfigs/{config_id}`
            #     +
            #     `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
            #     + `folders/{folder}/muteConfigs/{config_id}`
            #     + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
            #     + `projects/{project}/muteConfigs/{config_id}`
            #     + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest.new
            #
            #   # Call the get_mute_config method.
            #   result = client.get_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::MuteConfig.
            #   p result
            #
            def get_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                regex_match = %r{^projects/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.name
                regex_match = %r{^organizations/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.name
                regex_match = %r{^folders/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a notification config.
            #
            # @overload get_notification_config(request, options = nil)
            #   Pass arguments to `get_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_notification_config(name: nil)
            #   Pass arguments to `get_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the notification config to get. The following list shows
            #     some examples of the format:
            #
            #     +
            #     `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
            #     +
            #     `folders/[folder_id]/locations/[location_id]/notificationConfigs/[config_id]`
            #     +
            #     `projects/[project_id]/locations/[location_id]/notificationConfigs/[config_id]`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest.new
            #
            #   # Call the get_notification_config method.
            #   result = client.get_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::NotificationConfig.
            #   p result
            #
            def get_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a ResourceValueConfig.
            #
            # @overload get_resource_value_config(request, options = nil)
            #   Pass arguments to `get_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource_value_config(name: nil)
            #   Pass arguments to `get_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource value config to retrieve. Its format is
            #     organizations/\\{organization}/resourceValueConfigs/\\{config_id}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest.new
            #
            #   # Call the get_resource_value_config method.
            #   result = client.get_resource_value_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::ResourceValueConfig.
            #   p result
            #
            def get_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a source.
            #
            # @overload get_source(request, options = nil)
            #   Pass arguments to `get_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GetSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GetSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_source(name: nil)
            #   Pass arguments to `get_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Relative resource name of the source. Its format is
            #     `organizations/[organization_id]/source/[source_id]`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GetSourceRequest.new
            #
            #   # Call the get_source method.
            #   result = client.get_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Source.
            #   p result
            #
            def get_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GetSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Filters an organization or source's findings and groups them by their
            # specified properties in a location. If no location is specified, findings
            # are assumed to be in global
            #
            # To group across all sources provide a `-` as the source id.
            # The following list shows some examples:
            #
            # + `/v2/organizations/{organization_id}/sources/-/findings`
            # +
            # `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
            # + `/v2/folders/{folder_id}/sources/-/findings`
            # + `/v2/folders/{folder_id}/sources/-/locations/{location_id}/findings`
            # + `/v2/projects/{project_id}/sources/-/findings`
            # + `/v2/projects/{project_id}/sources/-/locations/{location_id}/findings`
            #
            # @overload group_findings(request, options = nil)
            #   Pass arguments to `group_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload group_findings(parent: nil, filter: nil, group_by: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `group_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the source to groupBy. If no location is specified,
            #     finding is assumed to be in global.
            #      The following list shows some examples:
            #
            #     + `organizations/[organization_id]/sources/[source_id]`
            #     +
            #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
            #     + `folders/[folder_id]/sources/[source_id]`
            #     + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
            #     + `projects/[project_id]/sources/[source_id]`
            #     + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
            #
            #     To groupBy across all sources provide a source_id of `-`. The following
            #     list shows some examples:
            #
            #     + `organizations/{organization_id}/sources/-`
            #     + `organizations/{organization_id}/sources/-/locations/[location_id]`
            #     + `folders/{folder_id}/sources/-`
            #     + `folders/{folder_id}/sources/-/locations/[location_id]`
            #     + `projects/{project_id}/sources/-`
            #     + `projects/{project_id}/sources/-/locations/[location_id]`
            #   @param filter [::String]
            #     Expression that defines the filter to apply across findings.
            #     The expression is a list of one or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. Examples include:
            #
            #      * name
            #      * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following field and operator combinations are supported:
            #
            #     * name: `=`
            #     * parent: `=`, `:`
            #     * resource_name: `=`, `:`
            #     * state: `=`, `:`
            #     * category: `=`, `:`
            #     * external_uri: `=`, `:`
            #     * event_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `event_time = "2019-06-10T16:07:18-07:00"`
            #         `event_time = 1560208038000`
            #
            #     * severity: `=`, `:`
            #     * security_marks.marks: `=`, `:`
            #     * resource:
            #       * resource.name: `=`, `:`
            #       * resource.parent_name: `=`, `:`
            #       * resource.parent_display_name: `=`, `:`
            #       * resource.project_name: `=`, `:`
            #       * resource.project_display_name: `=`, `:`
            #       * resource.type: `=`, `:`
            #   @param group_by [::String]
            #     Required. Expression that defines what assets fields to use for grouping.
            #     The string value should follow SQL syntax: comma separated list of fields.
            #     For example: "parent,resource_name".
            #   @param page_token [::String]
            #     The value returned by the last `GroupFindingsResponse`; indicates
            #     that this is a continuation of a prior `GroupFindings` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::GroupResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::GroupResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::GroupFindingsRequest.new
            #
            #   # Call the group_findings method.
            #   result = client.group_findings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::GroupResult.
            #     p item
            #   end
            #
            def group_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::GroupFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.group_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.group_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.group_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :group_findings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :group_findings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the attack paths for a set of simulation results or valued resources
            # and filter.
            #
            # @overload list_attack_paths(request, options = nil)
            #   Pass arguments to `list_attack_paths` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_attack_paths(parent: nil, filter: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_attack_paths` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list attack paths.
            #
            #     Valid formats:
            #     `organizations/{organization}`,
            #     `organizations/{organization}/simulations/{simulation}`
            #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
            #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
            #   @param filter [::String]
            #     The filter expression that filters the attack path in the response.
            #     Supported fields:
            #
            #       * `valued_resources` supports =
            #   @param page_token [::String]
            #     The value returned by the last `ListAttackPathsResponse`; indicates
            #     that this is a continuation of a prior `ListAttackPaths` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::AttackPath>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::AttackPath>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest.new
            #
            #   # Call the list_attack_paths method.
            #   result = client.list_attack_paths request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::AttackPath.
            #     p item
            #   end
            #
            def list_attack_paths request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListAttackPathsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_attack_paths.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_attack_paths.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_attack_paths.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_attack_paths, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_attack_paths, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BigQuery exports. Note that when requesting BigQuery exports at a
            # given level all exports under that level are also returned e.g. if
            # requesting BigQuery exports under a folder, then all BigQuery exports
            # immediately under the folder plus the ones created under the projects
            # within the folder are returned.
            #
            # @overload list_big_query_exports(request, options = nil)
            #   Pass arguments to `list_big_query_exports` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_big_query_exports(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_big_query_exports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of BigQuery exports. Its
            #     format is `organizations/[organization_id]/locations/[location_id]`,
            #     `folders/[folder_id]/locations/[location_id]`, or
            #     `projects/[project_id]/locations/[location_id]`.
            #   @param page_size [::Integer]
            #     The maximum number of configs to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListBigQueryExports` call.
            #     Provide this to retrieve the subsequent page.
            #     When paginating, all other parameters provided to `ListBigQueryExports`
            #     must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::BigQueryExport>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::BigQueryExport>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest.new
            #
            #   # Call the list_big_query_exports method.
            #   result = client.list_big_query_exports request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::BigQueryExport.
            #     p item
            #   end
            #
            def list_big_query_exports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListBigQueryExportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_big_query_exports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_big_query_exports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_big_query_exports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_big_query_exports, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_big_query_exports, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists an organization or source's findings.
            #
            # To list across all sources for a given location provide a `-` as the source
            # id. If no location is specified, finding are assumed to be in global.
            # The following list shows some examples:
            #
            # + `/v2/organizations/{organization_id}/sources/-/findings`
            # +
            # `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
            #
            # @overload list_findings(request, options = nil)
            #   Pass arguments to `list_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_findings(parent: nil, filter: nil, order_by: nil, field_mask: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the source the findings belong to. If no location is
            #     specified, the default is global. The following list shows some examples:
            #
            #     + `organizations/[organization_id]/sources/[source_id]`
            #     +
            #     `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
            #     + `folders/[folder_id]/sources/[source_id]`
            #     + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
            #     + `projects/[project_id]/sources/[source_id]`
            #     + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
            #
            #     To list across all sources provide a source_id of `-`. The following
            #     list shows some examples:
            #
            #     + `organizations/{organization_id}/sources/-`
            #     + `organizations/{organization_id}/sources/-/locations/{location_id}`
            #     + `folders/{folder_id}/sources/-`
            #     + `folders/{folder_id}/sources/-locations/{location_id}`
            #     + `projects/{projects_id}/sources/-`
            #     + `projects/{projects_id}/sources/-/locations/{location_id}`
            #   @param filter [::String]
            #     Expression that defines the filter to apply across findings.
            #     The expression is a list of one or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. Examples include:
            #
            #      * name
            #      * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following field and operator combinations are supported:
            #
            #     * name: `=`
            #     * parent: `=`, `:`
            #     * resource_name: `=`, `:`
            #     * state: `=`, `:`
            #     * category: `=`, `:`
            #     * external_uri: `=`, `:`
            #     * event_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `event_time = "2019-06-10T16:07:18-07:00"`
            #         `event_time = 1560208038000`
            #
            #     * severity: `=`, `:`
            #     * security_marks.marks: `=`, `:`
            #     * resource:
            #       * resource.name: `=`, `:`
            #       * resource.parent_name: `=`, `:`
            #       * resource.parent_display_name: `=`, `:`
            #       * resource.project_name: `=`, `:`
            #       * resource.project_display_name: `=`, `:`
            #       * resource.type: `=`, `:`
            #       * resource.folders.resource_folder: `=`, `:`
            #       * resource.display_name: `=`, `:`
            #   @param order_by [::String]
            #     Expression that defines what fields and order to use for sorting. The
            #     string value should follow SQL syntax: comma separated list of fields. For
            #     example: "name,parent". The default sorting order
            #     is ascending. To specify descending order for a field, a suffix " desc"
            #     should be appended to the field name. For example: "name
            #     desc,parent". Redundant space characters in the
            #     syntax are insignificant. "name desc,parent" and "
            #     name     desc  ,   parent  " are equivalent.
            #
            #     The following fields are supported:
            #     name
            #     parent
            #     state
            #     category
            #     resource_name
            #     event_time
            #     security_marks.marks
            #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     A field mask to specify the Finding fields to be listed in the response.
            #     An empty field mask will list all fields.
            #   @param page_token [::String]
            #     The value returned by the last `ListFindingsResponse`; indicates
            #     that this is a continuation of a prior `ListFindings` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ListFindingsResponse::ListFindingsResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ListFindingsResponse::ListFindingsResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListFindingsRequest.new
            #
            #   # Call the list_findings method.
            #   result = client.list_findings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::ListFindingsResponse::ListFindingsResult.
            #     p item
            #   end
            #
            def list_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_findings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_findings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists mute configs. If no location is specified, default is
            # global.
            #
            # @overload list_mute_configs(request, options = nil)
            #   Pass arguments to `list_mute_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_mute_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_mute_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of mute configs. Its format
            #     is `organizations/[organization_id]", "folders/[folder_id]`,
            #     `projects/[project_id]`,
            #     `organizations/[organization_id]/locations/[location_id]`,
            #     `folders/[folder_id]/locations/[location_id]`,
            #     `projects/[project_id]/locations/[location_id]`.
            #   @param page_size [::Integer]
            #     The maximum number of configs to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListMuteConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListMuteConfigs` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::MuteConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::MuteConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest.new
            #
            #   # Call the list_mute_configs method.
            #   result = client.list_mute_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::MuteConfig.
            #     p item
            #   end
            #
            def list_mute_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListMuteConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_mute_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                regex_match = %r{^projects/[^/]+/locations/(?<location>[^/]+)/muteConfigs/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.parent
                regex_match = %r{^organizations/[^/]+/locations/(?<location>[^/]+)/muteConfigs/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.parent
                regex_match = %r{^folders/[^/]+/locations/(?<location>[^/]+)/muteConfigs/?$}.match request.parent
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_mute_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_mute_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_mute_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_mute_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists notification configs.
            #
            # @overload list_notification_configs(request, options = nil)
            #   Pass arguments to `list_notification_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_notification_configs(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_notification_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent in which to list the notification
            #     configurations. Its format is
            #     "organizations/[organization_id]/locations/[location_id]",
            #     "folders/[folder_id]/locations/[location_id]", or
            #     "projects/[project_id]/locations/[location_id]".
            #   @param page_token [::String]
            #     The value returned by the last `ListNotificationConfigsResponse`; indicates
            #     that this is a continuation of a prior `ListNotificationConfigs` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::NotificationConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::NotificationConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest.new
            #
            #   # Call the list_notification_configs method.
            #   result = client.list_notification_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::NotificationConfig.
            #     p item
            #   end
            #
            def list_notification_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListNotificationConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_notification_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_notification_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_notification_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_notification_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_notification_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all ResourceValueConfigs.
            #
            # @overload list_resource_value_configs(request, options = nil)
            #   Pass arguments to `list_resource_value_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resource_value_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_resource_value_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of resource value configs.
            #     Its format is
            #     `organizations/[organization_id]`
            #   @param page_size [::Integer]
            #     The maximum number of configs to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListResourceValueConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListResourceValueConfigs` must match the call that provided the
            #     page token.
            #
            #     page_size can be specified, and the new page_size will be used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ResourceValueConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ResourceValueConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest.new
            #
            #   # Call the list_resource_value_configs method.
            #   result = client.list_resource_value_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::ResourceValueConfig.
            #     p item
            #   end
            #
            def list_resource_value_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListResourceValueConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resource_value_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resource_value_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resource_value_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_resource_value_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_resource_value_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all sources belonging to an organization.
            #
            # @overload list_sources(request, options = nil)
            #   Pass arguments to `list_sources` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListSourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListSourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_sources(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_sources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent of sources to list. Its format should
            #     be `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param page_token [::String]
            #     The value returned by the last `ListSourcesResponse`; indicates
            #     that this is a continuation of a prior `ListSources` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::Source>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::Source>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListSourcesRequest.new
            #
            #   # Call the list_sources method.
            #   result = client.list_sources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::Source.
            #     p item
            #   end
            #
            def list_sources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListSourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_sources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_sources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_sources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_sources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_sources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the valued resources for a set of simulation results and filter.
            #
            # @overload list_valued_resources(request, options = nil)
            #   Pass arguments to `list_valued_resources` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_valued_resources(parent: nil, filter: nil, page_token: nil, page_size: nil, order_by: nil)
            #   Pass arguments to `list_valued_resources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list exposed resources.
            #
            #     Valid formats:
            #     `organizations/{organization}`,
            #     `organizations/{organization}/simulations/{simulation}`
            #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
            #   @param filter [::String]
            #     The filter expression that filters the valued resources in the response.
            #     Supported fields:
            #
            #       * `resource_value` supports =
            #       * `resource_type` supports =
            #   @param page_token [::String]
            #     The value returned by the last `ListValuedResourcesResponse`; indicates
            #     that this is a continuation of a prior `ListValuedResources` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #   @param order_by [::String]
            #     Optional. The fields by which to order the valued resources response.
            #
            #     Supported fields:
            #
            #       * `exposed_score`
            #
            #       * `resource_value`
            #
            #       * `resource_type`
            #
            #     Values should be a comma separated list of fields. For example:
            #     `exposed_score,resource_value`.
            #
            #     The default sorting order is descending. To specify ascending or descending
            #     order for a field, append a " ASC" or a " DESC" suffix, respectively; for
            #     example: `exposed_score DESC`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ValuedResource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V2::ValuedResource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest.new
            #
            #   # Call the list_valued_resources method.
            #   result = client.list_valued_resources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V2::ValuedResource.
            #     p item
            #   end
            #
            def list_valued_resources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::ListValuedResourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_valued_resources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_valued_resources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_valued_resources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_valued_resources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_valued_resources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the state of a finding. If no location is specified, finding is
            # assumed to be in global
            #
            # @overload set_finding_state(request, options = nil)
            #   Pass arguments to `set_finding_state` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_finding_state(name: nil, state: nil)
            #   Pass arguments to `set_finding_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The [relative resource
            #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
            #     of the finding. If no location is specified, finding is assumed to be in
            #     global. The following list shows some examples:
            #
            #     +
            #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #     + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #     + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #   @param state [::Google::Cloud::SecurityCenter::V2::Finding::State]
            #     Required. The desired State of the finding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::SetFindingStateRequest.new
            #
            #   # Call the set_finding_state method.
            #   result = client.set_finding_state request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Finding.
            #   p result
            #
            def set_finding_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::SetFindingStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_finding_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_finding_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_finding_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_finding_state, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the access control policy on the specified Source.
            #
            # @overload set_iam_policy(request, options = nil)
            #   Pass arguments to `set_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
            #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being specified.
            #     See the operation documentation for the appropriate value for this field.
            #   @param policy [::Google::Iam::V1::Policy, ::Hash]
            #     REQUIRED: The complete policy to be applied to the `resource`. The size of
            #     the policy is limited to a few 10s of KB. An empty policy is a
            #     valid policy but certain Cloud Platform services (such as Projects)
            #     might reject them.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
            #     the fields in the mask will be modified. If no mask is provided, the
            #     following default mask is used:
            #
            #     `paths: "bindings, etag"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::SetIamPolicyRequest.new
            #
            #   # Call the set_iam_policy method.
            #   result = client.set_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def set_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the mute state of a finding. If no location is specified, finding
            # is assumed to be in global
            #
            # @overload set_mute(request, options = nil)
            #   Pass arguments to `set_mute` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::SetMuteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::SetMuteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_mute(name: nil, mute: nil)
            #   Pass arguments to `set_mute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The [relative resource
            #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
            #     of the finding. If no location is specified, finding is assumed to be in
            #     global. The following list shows some examples:
            #
            #     +
            #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #     + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #     + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
            #     +
            #     `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
            #   @param mute [::Google::Cloud::SecurityCenter::V2::Finding::Mute]
            #     Required. The desired state of the Mute.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::SetMuteRequest.new
            #
            #   # Call the set_mute method.
            #   result = client.set_mute request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Finding.
            #   p result
            #
            def set_mute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::SetMuteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_mute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_mute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_mute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_mute, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the permissions that a caller has on the specified source.
            #
            # @overload test_iam_permissions(request, options = nil)
            #   Pass arguments to `test_iam_permissions` via a request object, either of type
            #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload test_iam_permissions(resource: nil, permissions: nil)
            #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy detail is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param permissions [::Array<::String>]
            #     The set of permissions to check for the `resource`. Permissions with
            #     wildcards (such as '*' or 'storage.*') are not allowed. For more
            #     information see
            #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::TestIamPermissionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::TestIamPermissionsRequest.new
            #
            #   # Call the test_iam_permissions method.
            #   result = client.test_iam_permissions request
            #
            #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
            #   p result
            #
            def test_iam_permissions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.test_iam_permissions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.test_iam_permissions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a BigQuery export.
            #
            # @overload update_big_query_export(request, options = nil)
            #   Pass arguments to `update_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_big_query_export(big_query_export: nil, update_mask: nil)
            #   Pass arguments to `update_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param big_query_export [::Google::Cloud::SecurityCenter::V2::BigQueryExport, ::Hash]
            #     Required. The BigQuery export being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest.new
            #
            #   # Call the update_big_query_export method.
            #   result = client.update_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::BigQueryExport.
            #   p result
            #
            def update_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.big_query_export&.name
                header_params["big_query_export.name"] = request.big_query_export.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates external system. This is for a given finding. If no location is
            # specified, finding is assumed to be in global
            #
            # @overload update_external_system(request, options = nil)
            #   Pass arguments to `update_external_system` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_external_system(external_system: nil, update_mask: nil)
            #   Pass arguments to `update_external_system` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param external_system [::Google::Cloud::SecurityCenter::V2::ExternalSystem, ::Hash]
            #     Required. The external system resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the external system resource.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::ExternalSystem]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::ExternalSystem]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest.new
            #
            #   # Call the update_external_system method.
            #   result = client.update_external_system request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::ExternalSystem.
            #   p result
            #
            def update_external_system request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateExternalSystemRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_external_system.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.external_system&.name
                header_params["external_system.name"] = request.external_system.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_external_system.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_external_system.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_external_system, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates or updates a finding. If no location is specified, finding is
            # assumed to be in global. The corresponding source must exist for a finding
            # creation to succeed.
            #
            # @overload update_finding(request, options = nil)
            #   Pass arguments to `update_finding` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_finding(finding: nil, update_mask: nil)
            #   Pass arguments to `update_finding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param finding [::Google::Cloud::SecurityCenter::V2::Finding, ::Hash]
            #     Required. The finding resource to update or create if it does not already
            #     exist. parent, security_marks, and update_time will be ignored.
            #
            #     In the case of creation, the finding id portion of the name must be
            #     alphanumeric and less than or equal to 32 characters and greater than 0
            #     characters in length.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the finding resource. This field should
            #     not be specified when creating a finding.
            #
            #     When updating a finding, an empty mask is treated as updating all mutable
            #     fields and replacing source_properties.  Individual source_properties can
            #     be added/updated by using "source_properties.<property key>" in the field
            #     mask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateFindingRequest.new
            #
            #   # Call the update_finding method.
            #   result = client.update_finding request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Finding.
            #   p result
            #
            def update_finding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateFindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_finding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.finding&.name
                header_params["finding.name"] = request.finding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_finding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_finding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_finding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a mute config. If no location is specified, default is
            # global.
            #
            # @overload update_mute_config(request, options = nil)
            #   Pass arguments to `update_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_mute_config(mute_config: nil, update_mask: nil)
            #   Pass arguments to `update_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param mute_config [::Google::Cloud::SecurityCenter::V2::MuteConfig, ::Hash]
            #     Required. The mute config being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest.new
            #
            #   # Call the update_mute_config method.
            #   result = client.update_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::MuteConfig.
            #   p result
            #
            def update_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.mute_config&.name
                regex_match = %r{^projects/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.mute_config.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.mute_config&.name
                regex_match = %r{^organizations/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.mute_config.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end
              if request.mute_config&.name
                regex_match = %r{^folders/[^/]+/locations/(?<location>[^/]+)/muteConfigs/[^/]+/?$}.match request.mute_config.name
                if regex_match
                  header_params["location"] = regex_match["location".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a notification config. The following update
            # fields are allowed: description, pubsub_topic, streaming_config.filter
            #
            # @overload update_notification_config(request, options = nil)
            #   Pass arguments to `update_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_notification_config(notification_config: nil, update_mask: nil)
            #   Pass arguments to `update_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param notification_config [::Google::Cloud::SecurityCenter::V2::NotificationConfig, ::Hash]
            #     Required. The notification config to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the notification config.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest.new
            #
            #   # Call the update_notification_config method.
            #   result = client.update_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::NotificationConfig.
            #   p result
            #
            def update_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.notification_config&.name
                header_params["notification_config.name"] = request.notification_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing ResourceValueConfigs with new rules.
            #
            # @overload update_resource_value_config(request, options = nil)
            #   Pass arguments to `update_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_resource_value_config(resource_value_config: nil, update_mask: nil)
            #   Pass arguments to `update_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource_value_config [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig, ::Hash]
            #     Required. The resource value config being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            #     To update nested fields, include the top level field in the mask
            #     For example, to update gcp_metadata.resource_type, include the
            #     "gcp_metadata" field mask
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::ResourceValueConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest.new
            #
            #   # Call the update_resource_value_config method.
            #   result = client.update_resource_value_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::ResourceValueConfig.
            #   p result
            #
            def update_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource_value_config&.name
                header_params["resource_value_config.name"] = request.resource_value_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates security marks. For Finding Security marks, if no location is
            # specified, finding is assumed to be in global. Assets Security Marks can
            # only be accessed through global endpoint.
            #
            # @overload update_security_marks(request, options = nil)
            #   Pass arguments to `update_security_marks` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_security_marks(security_marks: nil, update_mask: nil)
            #   Pass arguments to `update_security_marks` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param security_marks [::Google::Cloud::SecurityCenter::V2::SecurityMarks, ::Hash]
            #     Required. The security marks resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the security marks resource.
            #
            #     The field mask must not contain duplicate fields.
            #     If empty or set to "marks", all marks will be replaced.  Individual
            #     marks can be updated using "marks.<mark_key>".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::SecurityMarks]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::SecurityMarks]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest.new
            #
            #   # Call the update_security_marks method.
            #   result = client.update_security_marks request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::SecurityMarks.
            #   p result
            #
            def update_security_marks request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateSecurityMarksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_security_marks.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.security_marks&.name
                header_params["security_marks.name"] = request.security_marks.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_security_marks.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_security_marks.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_security_marks, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a source.
            #
            # @overload update_source(request, options = nil)
            #   Pass arguments to `update_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_source(source: nil, update_mask: nil)
            #   Pass arguments to `update_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param source [::Google::Cloud::SecurityCenter::V2::Source, ::Hash]
            #     Required. The source resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the source resource.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V2::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V2::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V2::UpdateSourceRequest.new
            #
            #   # Call the update_source method.
            #   result = client.update_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V2::Source.
            #   p result
            #
            def update_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V2::UpdateSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.source&.name
                header_params["source.name"] = request.source.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SecurityCenter API.
            #
            # This class represents the configuration for SecurityCenter,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # batch_create_resource_value_configs to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.batch_create_resource_value_configs.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.batch_create_resource_value_configs.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::SecurityCenter::V2::SecurityCenter::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "securitycenter.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SecurityCenter API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `batch_create_resource_value_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_resource_value_configs
                ##
                # RPC-specific configuration for `bulk_mute_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :bulk_mute_findings
                ##
                # RPC-specific configuration for `create_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_big_query_export
                ##
                # RPC-specific configuration for `create_finding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_finding
                ##
                # RPC-specific configuration for `create_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_mute_config
                ##
                # RPC-specific configuration for `create_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_notification_config
                ##
                # RPC-specific configuration for `create_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_source
                ##
                # RPC-specific configuration for `delete_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_big_query_export
                ##
                # RPC-specific configuration for `delete_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_mute_config
                ##
                # RPC-specific configuration for `delete_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_notification_config
                ##
                # RPC-specific configuration for `delete_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_resource_value_config
                ##
                # RPC-specific configuration for `get_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_big_query_export
                ##
                # RPC-specific configuration for `get_simulation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_simulation
                ##
                # RPC-specific configuration for `get_valued_resource`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_valued_resource
                ##
                # RPC-specific configuration for `get_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_iam_policy
                ##
                # RPC-specific configuration for `get_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_mute_config
                ##
                # RPC-specific configuration for `get_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_notification_config
                ##
                # RPC-specific configuration for `get_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource_value_config
                ##
                # RPC-specific configuration for `get_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_source
                ##
                # RPC-specific configuration for `group_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :group_findings
                ##
                # RPC-specific configuration for `list_attack_paths`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_attack_paths
                ##
                # RPC-specific configuration for `list_big_query_exports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_big_query_exports
                ##
                # RPC-specific configuration for `list_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_findings
                ##
                # RPC-specific configuration for `list_mute_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_mute_configs
                ##
                # RPC-specific configuration for `list_notification_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_notification_configs
                ##
                # RPC-specific configuration for `list_resource_value_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resource_value_configs
                ##
                # RPC-specific configuration for `list_sources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_sources
                ##
                # RPC-specific configuration for `list_valued_resources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_valued_resources
                ##
                # RPC-specific configuration for `set_finding_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_finding_state
                ##
                # RPC-specific configuration for `set_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_iam_policy
                ##
                # RPC-specific configuration for `set_mute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_mute
                ##
                # RPC-specific configuration for `test_iam_permissions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :test_iam_permissions
                ##
                # RPC-specific configuration for `update_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_big_query_export
                ##
                # RPC-specific configuration for `update_external_system`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_external_system
                ##
                # RPC-specific configuration for `update_finding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_finding
                ##
                # RPC-specific configuration for `update_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_mute_config
                ##
                # RPC-specific configuration for `update_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_notification_config
                ##
                # RPC-specific configuration for `update_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_resource_value_config
                ##
                # RPC-specific configuration for `update_security_marks`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_security_marks
                ##
                # RPC-specific configuration for `update_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_source

                # @private
                def initialize parent_rpcs = nil
                  batch_create_resource_value_configs_config = parent_rpcs.batch_create_resource_value_configs if parent_rpcs.respond_to? :batch_create_resource_value_configs
                  @batch_create_resource_value_configs = ::Gapic::Config::Method.new batch_create_resource_value_configs_config
                  bulk_mute_findings_config = parent_rpcs.bulk_mute_findings if parent_rpcs.respond_to? :bulk_mute_findings
                  @bulk_mute_findings = ::Gapic::Config::Method.new bulk_mute_findings_config
                  create_big_query_export_config = parent_rpcs.create_big_query_export if parent_rpcs.respond_to? :create_big_query_export
                  @create_big_query_export = ::Gapic::Config::Method.new create_big_query_export_config
                  create_finding_config = parent_rpcs.create_finding if parent_rpcs.respond_to? :create_finding
                  @create_finding = ::Gapic::Config::Method.new create_finding_config
                  create_mute_config_config = parent_rpcs.create_mute_config if parent_rpcs.respond_to? :create_mute_config
                  @create_mute_config = ::Gapic::Config::Method.new create_mute_config_config
                  create_notification_config_config = parent_rpcs.create_notification_config if parent_rpcs.respond_to? :create_notification_config
                  @create_notification_config = ::Gapic::Config::Method.new create_notification_config_config
                  create_source_config = parent_rpcs.create_source if parent_rpcs.respond_to? :create_source
                  @create_source = ::Gapic::Config::Method.new create_source_config
                  delete_big_query_export_config = parent_rpcs.delete_big_query_export if parent_rpcs.respond_to? :delete_big_query_export
                  @delete_big_query_export = ::Gapic::Config::Method.new delete_big_query_export_config
                  delete_mute_config_config = parent_rpcs.delete_mute_config if parent_rpcs.respond_to? :delete_mute_config
                  @delete_mute_config = ::Gapic::Config::Method.new delete_mute_config_config
                  delete_notification_config_config = parent_rpcs.delete_notification_config if parent_rpcs.respond_to? :delete_notification_config
                  @delete_notification_config = ::Gapic::Config::Method.new delete_notification_config_config
                  delete_resource_value_config_config = parent_rpcs.delete_resource_value_config if parent_rpcs.respond_to? :delete_resource_value_config
                  @delete_resource_value_config = ::Gapic::Config::Method.new delete_resource_value_config_config
                  get_big_query_export_config = parent_rpcs.get_big_query_export if parent_rpcs.respond_to? :get_big_query_export
                  @get_big_query_export = ::Gapic::Config::Method.new get_big_query_export_config
                  get_simulation_config = parent_rpcs.get_simulation if parent_rpcs.respond_to? :get_simulation
                  @get_simulation = ::Gapic::Config::Method.new get_simulation_config
                  get_valued_resource_config = parent_rpcs.get_valued_resource if parent_rpcs.respond_to? :get_valued_resource
                  @get_valued_resource = ::Gapic::Config::Method.new get_valued_resource_config
                  get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                  @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                  get_mute_config_config = parent_rpcs.get_mute_config if parent_rpcs.respond_to? :get_mute_config
                  @get_mute_config = ::Gapic::Config::Method.new get_mute_config_config
                  get_notification_config_config = parent_rpcs.get_notification_config if parent_rpcs.respond_to? :get_notification_config
                  @get_notification_config = ::Gapic::Config::Method.new get_notification_config_config
                  get_resource_value_config_config = parent_rpcs.get_resource_value_config if parent_rpcs.respond_to? :get_resource_value_config
                  @get_resource_value_config = ::Gapic::Config::Method.new get_resource_value_config_config
                  get_source_config = parent_rpcs.get_source if parent_rpcs.respond_to? :get_source
                  @get_source = ::Gapic::Config::Method.new get_source_config
                  group_findings_config = parent_rpcs.group_findings if parent_rpcs.respond_to? :group_findings
                  @group_findings = ::Gapic::Config::Method.new group_findings_config
                  list_attack_paths_config = parent_rpcs.list_attack_paths if parent_rpcs.respond_to? :list_attack_paths
                  @list_attack_paths = ::Gapic::Config::Method.new list_attack_paths_config
                  list_big_query_exports_config = parent_rpcs.list_big_query_exports if parent_rpcs.respond_to? :list_big_query_exports
                  @list_big_query_exports = ::Gapic::Config::Method.new list_big_query_exports_config
                  list_findings_config = parent_rpcs.list_findings if parent_rpcs.respond_to? :list_findings
                  @list_findings = ::Gapic::Config::Method.new list_findings_config
                  list_mute_configs_config = parent_rpcs.list_mute_configs if parent_rpcs.respond_to? :list_mute_configs
                  @list_mute_configs = ::Gapic::Config::Method.new list_mute_configs_config
                  list_notification_configs_config = parent_rpcs.list_notification_configs if parent_rpcs.respond_to? :list_notification_configs
                  @list_notification_configs = ::Gapic::Config::Method.new list_notification_configs_config
                  list_resource_value_configs_config = parent_rpcs.list_resource_value_configs if parent_rpcs.respond_to? :list_resource_value_configs
                  @list_resource_value_configs = ::Gapic::Config::Method.new list_resource_value_configs_config
                  list_sources_config = parent_rpcs.list_sources if parent_rpcs.respond_to? :list_sources
                  @list_sources = ::Gapic::Config::Method.new list_sources_config
                  list_valued_resources_config = parent_rpcs.list_valued_resources if parent_rpcs.respond_to? :list_valued_resources
                  @list_valued_resources = ::Gapic::Config::Method.new list_valued_resources_config
                  set_finding_state_config = parent_rpcs.set_finding_state if parent_rpcs.respond_to? :set_finding_state
                  @set_finding_state = ::Gapic::Config::Method.new set_finding_state_config
                  set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                  @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                  set_mute_config = parent_rpcs.set_mute if parent_rpcs.respond_to? :set_mute
                  @set_mute = ::Gapic::Config::Method.new set_mute_config
                  test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                  @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                  update_big_query_export_config = parent_rpcs.update_big_query_export if parent_rpcs.respond_to? :update_big_query_export
                  @update_big_query_export = ::Gapic::Config::Method.new update_big_query_export_config
                  update_external_system_config = parent_rpcs.update_external_system if parent_rpcs.respond_to? :update_external_system
                  @update_external_system = ::Gapic::Config::Method.new update_external_system_config
                  update_finding_config = parent_rpcs.update_finding if parent_rpcs.respond_to? :update_finding
                  @update_finding = ::Gapic::Config::Method.new update_finding_config
                  update_mute_config_config = parent_rpcs.update_mute_config if parent_rpcs.respond_to? :update_mute_config
                  @update_mute_config = ::Gapic::Config::Method.new update_mute_config_config
                  update_notification_config_config = parent_rpcs.update_notification_config if parent_rpcs.respond_to? :update_notification_config
                  @update_notification_config = ::Gapic::Config::Method.new update_notification_config_config
                  update_resource_value_config_config = parent_rpcs.update_resource_value_config if parent_rpcs.respond_to? :update_resource_value_config
                  @update_resource_value_config = ::Gapic::Config::Method.new update_resource_value_config_config
                  update_security_marks_config = parent_rpcs.update_security_marks if parent_rpcs.respond_to? :update_security_marks
                  @update_security_marks = ::Gapic::Config::Method.new update_security_marks_config
                  update_source_config = parent_rpcs.update_source if parent_rpcs.respond_to? :update_source
                  @update_source = ::Gapic::Config::Method.new update_source_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
