# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/securitycenter/v1p1beta1/securitycenter_service_pb"
require "google/cloud/security_center/v1p1beta1/security_center/rest"


class ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}

    create_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_source({ parent: parent, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_source parent: parent, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_source ::Google::Cloud::SecurityCenter::V1p1beta1::CreateSourceRequest.new(parent: parent, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_source({ parent: parent, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_source(::Google::Cloud::SecurityCenter::V1p1beta1::CreateSourceRequest.new(parent: parent, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_source_client_stub.call_count
      end
    end
  end

  def test_create_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    finding_id = "hello world"
    finding = {}

    create_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_finding parent: parent, finding_id: finding_id, finding: finding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_finding ::Google::Cloud::SecurityCenter::V1p1beta1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_finding(::Google::Cloud::SecurityCenter::V1p1beta1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_finding_client_stub.call_count
      end
    end
  end

  def test_create_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    config_id = "hello world"
    notification_config = {}

    create_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_notification_config parent: parent, config_id: config_id, notification_config: notification_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_notification_config ::Google::Cloud::SecurityCenter::V1p1beta1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_notification_config(::Google::Cloud::SecurityCenter::V1p1beta1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_notification_config_client_stub.call_count
      end
    end
  end

  def test_delete_notification_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notification_config ::Google::Cloud::SecurityCenter::V1p1beta1::DeleteNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notification_config(::Google::Cloud::SecurityCenter::V1p1beta1::DeleteNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notification_config_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notification_config ::Google::Cloud::SecurityCenter::V1p1beta1::GetNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notification_config(::Google::Cloud::SecurityCenter::V1p1beta1::GetNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notification_config_client_stub.call_count
      end
    end
  end

  def test_get_organization_settings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::OrganizationSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_organization_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_organization_settings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_organization_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_organization_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_organization_settings ::Google::Cloud::SecurityCenter::V1p1beta1::GetOrganizationSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_organization_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_organization_settings(::Google::Cloud::SecurityCenter::V1p1beta1::GetOrganizationSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_organization_settings_client_stub.call_count
      end
    end
  end

  def test_get_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_source ::Google::Cloud::SecurityCenter::V1p1beta1::GetSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_source(::Google::Cloud::SecurityCenter::V1p1beta1::GetSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_source_client_stub.call_count
      end
    end
  end

  def test_group_assets
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::GroupAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    compare_duration = {}
    read_time = {}
    page_token = "hello world"
    page_size = 42

    group_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_group_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, group_assets_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.group_assets parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.group_assets ::Google::Cloud::SecurityCenter::V1p1beta1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.group_assets(::Google::Cloud::SecurityCenter::V1p1beta1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, group_assets_client_stub.call_count
      end
    end
  end

  def test_group_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::GroupFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    read_time = {}
    compare_duration = {}
    page_token = "hello world"
    page_size = 42

    group_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_group_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, group_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.group_findings parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.group_findings ::Google::Cloud::SecurityCenter::V1p1beta1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.group_findings(::Google::Cloud::SecurityCenter::V1p1beta1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, group_findings_client_stub.call_count
      end
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::SecurityCenter::V1p1beta1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::SecurityCenter::V1p1beta1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_list_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::ListFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_findings parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_findings ::Google::Cloud::SecurityCenter::V1p1beta1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_findings(::Google::Cloud::SecurityCenter::V1p1beta1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_findings_client_stub.call_count
      end
    end
  end

  def test_list_notification_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::ListNotificationConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_notification_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_notification_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notification_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notification_configs parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notification_configs ::Google::Cloud::SecurityCenter::V1p1beta1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notification_configs(::Google::Cloud::SecurityCenter::V1p1beta1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notification_configs_client_stub.call_count
      end
    end
  end

  def test_list_sources
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::ListSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sources_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sources parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sources ::Google::Cloud::SecurityCenter::V1p1beta1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sources(::Google::Cloud::SecurityCenter::V1p1beta1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sources_client_stub.call_count
      end
    end
  end

  def test_run_asset_discovery
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    run_asset_discovery_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_run_asset_discovery_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_asset_discovery_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_asset_discovery({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_asset_discovery parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_asset_discovery ::Google::Cloud::SecurityCenter::V1p1beta1::RunAssetDiscoveryRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_asset_discovery({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_asset_discovery(::Google::Cloud::SecurityCenter::V1p1beta1::RunAssetDiscoveryRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_asset_discovery_client_stub.call_count
      end
    end
  end

  def test_set_finding_state
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state = :STATE_UNSPECIFIED
    start_time = {}

    set_finding_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_set_finding_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_finding_state_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_finding_state({ name: name, state: state, start_time: start_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_finding_state name: name, state: state, start_time: start_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_finding_state ::Google::Cloud::SecurityCenter::V1p1beta1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_finding_state({ name: name, state: state, start_time: start_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_finding_state(::Google::Cloud::SecurityCenter::V1p1beta1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_finding_state_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_update_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    finding = {}
    update_mask = {}

    update_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_finding({ finding: finding, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_finding finding: finding, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_finding ::Google::Cloud::SecurityCenter::V1p1beta1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_finding({ finding: finding, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_finding(::Google::Cloud::SecurityCenter::V1p1beta1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_finding_client_stub.call_count
      end
    end
  end

  def test_update_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    notification_config = {}
    update_mask = {}

    update_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_notification_config notification_config: notification_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_notification_config ::Google::Cloud::SecurityCenter::V1p1beta1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_notification_config(::Google::Cloud::SecurityCenter::V1p1beta1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_notification_config_client_stub.call_count
      end
    end
  end

  def test_update_organization_settings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::OrganizationSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    organization_settings = {}
    update_mask = {}

    update_organization_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_organization_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_organization_settings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_organization_settings organization_settings: organization_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_organization_settings ::Google::Cloud::SecurityCenter::V1p1beta1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_organization_settings(::Google::Cloud::SecurityCenter::V1p1beta1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_organization_settings_client_stub.call_count
      end
    end
  end

  def test_update_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source = {}
    update_mask = {}

    update_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_source({ source: source, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_source source: source, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_source ::Google::Cloud::SecurityCenter::V1p1beta1::UpdateSourceRequest.new(source: source, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_source({ source: source, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_source(::Google::Cloud::SecurityCenter::V1p1beta1::UpdateSourceRequest.new(source: source, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_source_client_stub.call_count
      end
    end
  end

  def test_update_security_marks
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityMarks.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    security_marks = {}
    update_mask = {}
    start_time = {}

    update_security_marks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_security_marks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_marks_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_marks security_marks: security_marks, update_mask: update_mask, start_time: start_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_marks ::Google::Cloud::SecurityCenter::V1p1beta1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_marks(::Google::Cloud::SecurityCenter::V1p1beta1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_marks_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenter::V1p1beta1::SecurityCenter::Rest::Client::Configuration, config
  end
end
