# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/securitycenter/v1/securitycenter_service_pb"
require "google/cloud/security_center/v1/security_center"

class ::Google::Cloud::SecurityCenter::V1::SecurityCenter::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_bulk_mute_findings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    mute_annotation = "hello world"
    mute_state = :MUTE_STATE_UNSPECIFIED

    bulk_mute_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_mute_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["mute_annotation"]
      assert_equal :MUTE_STATE_UNSPECIFIED, request["mute_state"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_mute_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_mute_findings({ parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_mute_findings parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_mute_findings ::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_mute_findings({ parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_mute_findings(::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_mute_findings_client_stub.call_rpc_count
    end
  end

  def test_create_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    security_health_analytics_custom_module = {}

    create_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule), request["security_health_analytics_custom_module"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_security_health_analytics_custom_module parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_create_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}

    create_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateSourceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::Source), request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_source({ parent: parent, source: source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_source parent: parent, source: source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_source ::Google::Cloud::SecurityCenter::V1::CreateSourceRequest.new(parent: parent, source: source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_source({ parent: parent, source: source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_source(::Google::Cloud::SecurityCenter::V1::CreateSourceRequest.new(parent: parent, source: source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_source_client_stub.call_rpc_count
    end
  end

  def test_create_finding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    finding_id = "hello world"
    finding = {}

    create_finding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_finding, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateFindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["finding_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::Finding), request["finding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_finding_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_finding parent: parent, finding_id: finding_id, finding: finding do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_finding ::Google::Cloud::SecurityCenter::V1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_finding(::Google::Cloud::SecurityCenter::V1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_finding_client_stub.call_rpc_count
    end
  end

  def test_create_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mute_config = {}
    mute_config_id = "hello world"

    create_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::MuteConfig), request["mute_config"]
      assert_equal "hello world", request["mute_config_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_mute_config parent: parent, mute_config: mute_config, mute_config_id: mute_config_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_mute_config ::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_mute_config(::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_mute_config_client_stub.call_rpc_count
    end
  end

  def test_create_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    config_id = "hello world"
    notification_config = {}

    create_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::NotificationConfig), request["notification_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_notification_config parent: parent, config_id: config_id, notification_config: notification_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_notification_config ::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_notification_config(::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_notification_config_client_stub.call_rpc_count
    end
  end

  def test_delete_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_mute_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_mute_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_mute_config ::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_mute_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_mute_config(::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_mute_config_client_stub.call_rpc_count
    end
  end

  def test_delete_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_notification_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_notification_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_notification_config ::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_notification_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_notification_config(::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_notification_config_client_stub.call_rpc_count
    end
  end

  def test_delete_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_security_health_analytics_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_security_health_analytics_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_security_health_analytics_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_simulation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Simulation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_simulation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_simulation, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetSimulationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_simulation_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_simulation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_simulation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_simulation ::Google::Cloud::SecurityCenter::V1::GetSimulationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_simulation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_simulation(::Google::Cloud::SecurityCenter::V1::GetSimulationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_simulation_client_stub.call_rpc_count
    end
  end

  def test_get_valued_resource
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ValuedResource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_valued_resource_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_valued_resource, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_valued_resource_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_valued_resource({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_valued_resource name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_valued_resource ::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_valued_resource({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_valued_resource(::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_valued_resource_client_stub.call_rpc_count
    end
  end

  def test_get_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_big_query_export({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_big_query_export name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_big_query_export ::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_big_query_export({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_big_query_export(::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_get_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_mute_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_mute_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_mute_config ::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_mute_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_mute_config(::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_mute_config_client_stub.call_rpc_count
    end
  end

  def test_get_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_notification_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_notification_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_notification_config ::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_notification_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_notification_config(::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_notification_config_client_stub.call_rpc_count
    end
  end

  def test_get_organization_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::OrganizationSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_organization_settings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_organization_settings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_organization_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_organization_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_organization_settings ::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_organization_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_organization_settings(::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_organization_settings_client_stub.call_rpc_count
    end
  end

  def test_get_effective_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_effective_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_effective_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_effective_security_health_analytics_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_effective_security_health_analytics_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_effective_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_effective_security_health_analytics_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_effective_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_effective_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_security_health_analytics_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_security_health_analytics_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_security_health_analytics_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_source ::Google::Cloud::SecurityCenter::V1::GetSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_source(::Google::Cloud::SecurityCenter::V1::GetSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_source_client_stub.call_rpc_count
    end
  end

  def test_group_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::GroupAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    compare_duration = {}
    read_time = {}
    page_token = "hello world"
    page_size = 42

    group_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :group_assets, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["group_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["compare_duration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, group_assets_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.group_assets parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.group_assets ::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.group_assets(::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, group_assets_client_stub.call_rpc_count
    end
  end

  def test_group_findings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::GroupFindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    read_time = {}
    compare_duration = {}
    page_token = "hello world"
    page_size = 42

    group_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :group_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["group_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["compare_duration"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, group_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.group_findings parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.group_findings ::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.group_findings(::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, group_findings_client_stub.call_rpc_count
    end
  end

  def test_list_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_assets, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["compare_duration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["field_mask"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_assets_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_assets parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_assets ::Google::Cloud::SecurityCenter::V1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_assets(::Google::Cloud::SecurityCenter::V1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_assets_client_stub.call_rpc_count
    end
  end

  def test_list_descendant_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_descendant_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_descendant_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_descendant_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_descendant_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_descendant_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_descendant_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_findings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListFindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_findings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_findings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListFindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["read_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["compare_duration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["field_mask"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_findings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_findings parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_findings ::Google::Cloud::SecurityCenter::V1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_findings(::Google::Cloud::SecurityCenter::V1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_findings_client_stub.call_rpc_count
    end
  end

  def test_list_mute_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mute_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_mute_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_mute_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_mute_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_mute_configs ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_mute_configs(::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_mute_configs_client_stub.call_rpc_count
    end
  end

  def test_list_notification_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_notification_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_notification_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_notification_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_notification_configs parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_notification_configs ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_notification_configs(::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_notification_configs_client_stub.call_rpc_count
    end
  end

  def test_list_effective_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_effective_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_effective_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_effective_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_effective_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_effective_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_effective_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_security_health_analytics_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_security_health_analytics_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_security_health_analytics_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_security_health_analytics_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_security_health_analytics_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_sources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sources, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sources_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sources parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sources ::Google::Cloud::SecurityCenter::V1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sources(::Google::Cloud::SecurityCenter::V1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sources_client_stub.call_rpc_count
    end
  end

  def test_run_asset_discovery
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    run_asset_discovery_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_asset_discovery, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_asset_discovery_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_asset_discovery({ parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_asset_discovery parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_asset_discovery ::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest.new(parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_asset_discovery({ parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_asset_discovery(::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_asset_discovery_client_stub.call_rpc_count
    end
  end

  def test_set_finding_state
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state = :STATE_UNSPECIFIED
    start_time = {}

    set_finding_state_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_finding_state, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :STATE_UNSPECIFIED, request["state"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_finding_state_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_finding_state({ name: name, state: state, start_time: start_time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_finding_state name: name, state: state, start_time: start_time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_finding_state ::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_finding_state({ name: name, state: state, start_time: start_time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_finding_state(::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_finding_state_client_stub.call_rpc_count
    end
  end

  def test_set_mute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mute = :MUTE_UNSPECIFIED

    set_mute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_mute, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::SetMuteRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :MUTE_UNSPECIFIED, request["mute"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_mute_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_mute({ name: name, mute: mute }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_mute name: name, mute: mute do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_mute ::Google::Cloud::SecurityCenter::V1::SetMuteRequest.new(name: name, mute: mute) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_mute({ name: name, mute: mute }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_mute(::Google::Cloud::SecurityCenter::V1::SetMuteRequest.new(name: name, mute: mute), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_mute_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_simulate_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_config = {}
    resource = {}

    simulate_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :simulate_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::CustomConfig), request["custom_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource), request["resource"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, simulate_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.simulate_security_health_analytics_custom_module parent: parent, custom_config: custom_config, resource: resource do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.simulate_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.simulate_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, simulate_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_update_external_system
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ExternalSystem.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    external_system = {}
    update_mask = {}

    update_external_system_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_external_system, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::ExternalSystem), request["external_system"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_external_system_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_external_system({ external_system: external_system, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_external_system external_system: external_system, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_external_system ::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_external_system({ external_system: external_system, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_external_system(::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_external_system_client_stub.call_rpc_count
    end
  end

  def test_update_finding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Finding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    finding = {}
    update_mask = {}

    update_finding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_finding, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::Finding), request["finding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_finding_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_finding({ finding: finding, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_finding finding: finding, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_finding ::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_finding({ finding: finding, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_finding(::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_finding_client_stub.call_rpc_count
    end
  end

  def test_update_mute_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    mute_config = {}
    update_mask = {}

    update_mute_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_mute_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::MuteConfig), request["mute_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_mute_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_mute_config mute_config: mute_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_mute_config ::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_mute_config(::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_mute_config_client_stub.call_rpc_count
    end
  end

  def test_update_notification_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    notification_config = {}
    update_mask = {}

    update_notification_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_notification_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::NotificationConfig), request["notification_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_notification_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_notification_config notification_config: notification_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_notification_config ::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_notification_config(::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_notification_config_client_stub.call_rpc_count
    end
  end

  def test_update_organization_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::OrganizationSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    organization_settings = {}
    update_mask = {}

    update_organization_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_organization_settings, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::OrganizationSettings), request["organization_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_organization_settings_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_organization_settings organization_settings: organization_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_organization_settings ::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_organization_settings(::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_organization_settings_client_stub.call_rpc_count
    end
  end

  def test_update_security_health_analytics_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    security_health_analytics_custom_module = {}
    update_mask = {}

    update_security_health_analytics_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_security_health_analytics_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule), request["security_health_analytics_custom_module"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_security_health_analytics_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_security_health_analytics_custom_module({ security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_security_health_analytics_custom_module security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_security_health_analytics_custom_module({ security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_security_health_analytics_custom_module_client_stub.call_rpc_count
    end
  end

  def test_update_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    source = {}
    update_mask = {}

    update_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_source, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::Source), request["source"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_source_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_source({ source: source, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_source source: source, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_source ::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest.new(source: source, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_source({ source: source, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_source(::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest.new(source: source, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_source_client_stub.call_rpc_count
    end
  end

  def test_update_security_marks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::SecurityMarks.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    security_marks = {}
    update_mask = {}
    start_time = {}

    update_security_marks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_security_marks, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::SecurityMarks), request["security_marks"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_security_marks_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_security_marks security_marks: security_marks, update_mask: update_mask, start_time: start_time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_security_marks ::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_security_marks(::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_security_marks_client_stub.call_rpc_count
    end
  end

  def test_create_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    big_query_export = {}
    big_query_export_id = "hello world"

    create_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::BigQueryExport), request["big_query_export"]
      assert_equal "hello world", request["big_query_export_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_big_query_export parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_big_query_export ::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_big_query_export(::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_delete_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_big_query_export({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_big_query_export name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_big_query_export ::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_big_query_export({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_big_query_export(::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_update_big_query_export
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    big_query_export = {}
    update_mask = {}

    update_big_query_export_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_big_query_export, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::BigQueryExport), request["big_query_export"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_big_query_export_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_big_query_export big_query_export: big_query_export, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_big_query_export ::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_big_query_export(::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_big_query_export_client_stub.call_rpc_count
    end
  end

  def test_list_big_query_exports
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_exports_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_big_query_exports, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_big_query_exports_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_big_query_exports parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_big_query_exports ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_big_query_exports(::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_big_query_exports_client_stub.call_rpc_count
    end
  end

  def test_create_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_threat_detection_custom_module = {}

    create_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule), request["event_threat_detection_custom_module"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_event_threat_detection_custom_module parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_delete_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_event_threat_detection_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_event_threat_detection_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_event_threat_detection_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event_threat_detection_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event_threat_detection_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event_threat_detection_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_list_descendant_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_descendant_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_descendant_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_descendant_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_descendant_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_descendant_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_descendant_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_descendant_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_list_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_update_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    event_threat_detection_custom_module = {}
    update_mask = {}

    update_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule), request["event_threat_detection_custom_module"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_event_threat_detection_custom_module({ event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_event_threat_detection_custom_module event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest.new(event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_event_threat_detection_custom_module({ event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest.new(event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_validate_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    raw_text = "hello world"
    type = "hello world"

    validate_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :validate_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["raw_text"]
      assert_equal "hello world", request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, validate_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.validate_event_threat_detection_custom_module parent: parent, raw_text: raw_text, type: type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.validate_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.validate_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, validate_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_get_effective_event_threat_detection_custom_module
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_event_threat_detection_custom_module_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_effective_event_threat_detection_custom_module, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_effective_event_threat_detection_custom_module_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_effective_event_threat_detection_custom_module({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_effective_event_threat_detection_custom_module name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_effective_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_effective_event_threat_detection_custom_module({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_effective_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_effective_event_threat_detection_custom_module_client_stub.call_rpc_count
    end
  end

  def test_list_effective_event_threat_detection_custom_modules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_effective_event_threat_detection_custom_modules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_effective_event_threat_detection_custom_modules, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_effective_event_threat_detection_custom_modules_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_effective_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_effective_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_effective_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_effective_event_threat_detection_custom_modules_client_stub.call_rpc_count
    end
  end

  def test_batch_create_resource_value_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_resource_value_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_resource_value_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::CreateResourceValueConfigRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_resource_value_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_resource_value_configs({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_resource_value_configs parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_resource_value_configs ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_resource_value_configs({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_resource_value_configs(::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_resource_value_configs_client_stub.call_rpc_count
    end
  end

  def test_delete_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_resource_value_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_resource_value_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_resource_value_config ::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_resource_value_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_resource_value_config(::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_get_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource_value_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource_value_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource_value_config ::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource_value_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource_value_config(::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_list_resource_value_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_resource_value_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resource_value_configs, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resource_value_configs_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resource_value_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resource_value_configs ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resource_value_configs(::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resource_value_configs_client_stub.call_rpc_count
    end
  end

  def test_update_resource_value_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource_value_config = {}
    update_mask = {}

    update_resource_value_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_resource_value_config, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig), request["resource_value_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_resource_value_config_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_resource_value_config resource_value_config: resource_value_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_resource_value_config ::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_resource_value_config(::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_resource_value_config_client_stub.call_rpc_count
    end
  end

  def test_list_valued_resources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42
    order_by = "hello world"

    list_valued_resources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_valued_resources, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_valued_resources_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_valued_resources parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_valued_resources ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_valued_resources(::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_valued_resources_client_stub.call_rpc_count
    end
  end

  def test_list_attack_paths
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecurityCenter::V1::ListAttackPathsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42

    list_attack_paths_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_attack_paths, name
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_attack_paths_client_stub do
      # Create client
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_attack_paths parent: parent, filter: filter, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_attack_paths ::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_attack_paths(::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_attack_paths_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Operations, client.operations_client
  end
end
