# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/securitycenter/v1/securitycenter_service_pb"
require "google/cloud/security_center/v1/security_center/rest"


class ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_bulk_mute_findings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    mute_annotation = "hello world"
    mute_state = :MUTE_STATE_UNSPECIFIED

    bulk_mute_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_bulk_mute_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_mute_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_mute_findings({ parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_mute_findings parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_mute_findings ::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_mute_findings({ parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_mute_findings(::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest.new(parent: parent, filter: filter, mute_annotation: mute_annotation, mute_state: mute_state), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_mute_findings_client_stub.call_count
      end
    end
  end

  def test_create_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    security_health_analytics_custom_module = {}

    create_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_security_health_analytics_custom_module parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_security_health_analytics_custom_module({ parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, security_health_analytics_custom_module: security_health_analytics_custom_module), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_create_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}

    create_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_source({ parent: parent, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_source parent: parent, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_source ::Google::Cloud::SecurityCenter::V1::CreateSourceRequest.new(parent: parent, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_source({ parent: parent, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_source(::Google::Cloud::SecurityCenter::V1::CreateSourceRequest.new(parent: parent, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_source_client_stub.call_count
      end
    end
  end

  def test_create_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    finding_id = "hello world"
    finding = {}

    create_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_finding parent: parent, finding_id: finding_id, finding: finding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_finding ::Google::Cloud::SecurityCenter::V1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_finding({ parent: parent, finding_id: finding_id, finding: finding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_finding(::Google::Cloud::SecurityCenter::V1::CreateFindingRequest.new(parent: parent, finding_id: finding_id, finding: finding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_finding_client_stub.call_count
      end
    end
  end

  def test_create_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mute_config = {}
    mute_config_id = "hello world"

    create_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_mute_config parent: parent, mute_config: mute_config, mute_config_id: mute_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_mute_config ::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_mute_config({ parent: parent, mute_config: mute_config, mute_config_id: mute_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_mute_config(::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest.new(parent: parent, mute_config: mute_config, mute_config_id: mute_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_mute_config_client_stub.call_count
      end
    end
  end

  def test_create_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    config_id = "hello world"
    notification_config = {}

    create_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_notification_config parent: parent, config_id: config_id, notification_config: notification_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_notification_config ::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_notification_config({ parent: parent, config_id: config_id, notification_config: notification_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_notification_config(::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest.new(parent: parent, config_id: config_id, notification_config: notification_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_notification_config_client_stub.call_count
      end
    end
  end

  def test_delete_mute_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_mute_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_mute_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_mute_config ::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_mute_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_mute_config(::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_mute_config_client_stub.call_count
      end
    end
  end

  def test_delete_notification_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notification_config ::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notification_config(::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notification_config_client_stub.call_count
      end
    end
  end

  def test_delete_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_security_health_analytics_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_security_health_analytics_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_security_health_analytics_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_simulation
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Simulation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_simulation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_simulation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_simulation_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_simulation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_simulation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_simulation ::Google::Cloud::SecurityCenter::V1::GetSimulationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_simulation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_simulation(::Google::Cloud::SecurityCenter::V1::GetSimulationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_simulation_client_stub.call_count
      end
    end
  end

  def test_get_valued_resource
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ValuedResource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_valued_resource_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_valued_resource_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_valued_resource_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_valued_resource({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_valued_resource name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_valued_resource ::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_valued_resource({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_valued_resource(::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_valued_resource_client_stub.call_count
      end
    end
  end

  def test_get_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_big_query_export({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_big_query_export name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_big_query_export ::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_big_query_export({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_big_query_export(::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_big_query_export_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_mute_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_mute_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_mute_config ::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_mute_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_mute_config(::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_mute_config_client_stub.call_count
      end
    end
  end

  def test_get_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notification_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notification_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notification_config ::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notification_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notification_config(::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notification_config_client_stub.call_count
      end
    end
  end

  def test_get_organization_settings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::OrganizationSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_organization_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_organization_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_organization_settings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_organization_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_organization_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_organization_settings ::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_organization_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_organization_settings(::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_organization_settings_client_stub.call_count
      end
    end
  end

  def test_get_effective_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_effective_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_effective_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_effective_security_health_analytics_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_effective_security_health_analytics_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_effective_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_effective_security_health_analytics_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_effective_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_effective_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_security_health_analytics_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_security_health_analytics_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_security_health_analytics_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_source ::Google::Cloud::SecurityCenter::V1::GetSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_source(::Google::Cloud::SecurityCenter::V1::GetSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_source_client_stub.call_count
      end
    end
  end

  def test_group_assets
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::GroupAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    compare_duration = {}
    read_time = {}
    page_token = "hello world"
    page_size = 42

    group_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_group_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, group_assets_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.group_assets parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.group_assets ::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.group_assets({ parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.group_assets(::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest.new(parent: parent, filter: filter, group_by: group_by, compare_duration: compare_duration, read_time: read_time, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, group_assets_client_stub.call_count
      end
    end
  end

  def test_group_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::GroupFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    read_time = {}
    compare_duration = {}
    page_token = "hello world"
    page_size = 42

    group_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_group_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, group_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.group_findings parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.group_findings ::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.group_findings({ parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.group_findings(::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest.new(parent: parent, filter: filter, group_by: group_by, read_time: read_time, compare_duration: compare_duration, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, group_findings_client_stub.call_count
      end
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::SecurityCenter::V1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::SecurityCenter::V1::ListAssetsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_list_descendant_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_descendant_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_descendant_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_descendant_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_descendant_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_descendant_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_descendant_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_descendant_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_descendant_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_findings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListFindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    order_by = "hello world"
    read_time = {}
    compare_duration = {}
    field_mask = {}
    page_token = "hello world"
    page_size = 42

    list_findings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_findings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_findings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_findings parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_findings ::Google::Cloud::SecurityCenter::V1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_findings({ parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_findings(::Google::Cloud::SecurityCenter::V1::ListFindingsRequest.new(parent: parent, filter: filter, order_by: order_by, read_time: read_time, compare_duration: compare_duration, field_mask: field_mask, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_findings_client_stub.call_count
      end
    end
  end

  def test_list_mute_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mute_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_mute_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_mute_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_mute_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_mute_configs ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_mute_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_mute_configs(::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_mute_configs_client_stub.call_count
      end
    end
  end

  def test_list_notification_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_notification_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_notification_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notification_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notification_configs parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notification_configs ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notification_configs({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notification_configs(::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notification_configs_client_stub.call_count
      end
    end
  end

  def test_list_effective_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_effective_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_effective_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_effective_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_effective_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_effective_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_effective_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_effective_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_effective_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_security_health_analytics_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_security_health_analytics_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_security_health_analytics_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_security_health_analytics_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_security_health_analytics_custom_modules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_security_health_analytics_custom_modules ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_security_health_analytics_custom_modules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_security_health_analytics_custom_modules(::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_security_health_analytics_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_sources
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sources_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sources parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sources ::Google::Cloud::SecurityCenter::V1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sources({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sources(::Google::Cloud::SecurityCenter::V1::ListSourcesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sources_client_stub.call_count
      end
    end
  end

  def test_run_asset_discovery
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    run_asset_discovery_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_run_asset_discovery_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_asset_discovery_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_asset_discovery({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_asset_discovery parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_asset_discovery ::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_asset_discovery({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_asset_discovery(::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_asset_discovery_client_stub.call_count
      end
    end
  end

  def test_set_finding_state
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state = :STATE_UNSPECIFIED
    start_time = {}

    set_finding_state_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_set_finding_state_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_finding_state_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_finding_state({ name: name, state: state, start_time: start_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_finding_state name: name, state: state, start_time: start_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_finding_state ::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_finding_state({ name: name, state: state, start_time: start_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_finding_state(::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest.new(name: name, state: state, start_time: start_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_finding_state_client_stub.call_count
      end
    end
  end

  def test_set_mute
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mute = :MUTE_UNSPECIFIED

    set_mute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_set_mute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_mute_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_mute({ name: name, mute: mute }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_mute name: name, mute: mute do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_mute ::Google::Cloud::SecurityCenter::V1::SetMuteRequest.new(name: name, mute: mute) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_mute({ name: name, mute: mute }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_mute(::Google::Cloud::SecurityCenter::V1::SetMuteRequest.new(name: name, mute: mute), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_mute_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_simulate_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_config = {}
    resource = {}

    simulate_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_simulate_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, simulate_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.simulate_security_health_analytics_custom_module parent: parent, custom_config: custom_config, resource: resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.simulate_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.simulate_security_health_analytics_custom_module({ parent: parent, custom_config: custom_config, resource: resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.simulate_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new(parent: parent, custom_config: custom_config, resource: resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, simulate_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_update_external_system
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ExternalSystem.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    external_system = {}
    update_mask = {}

    update_external_system_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_external_system_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_external_system_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_external_system({ external_system: external_system, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_external_system external_system: external_system, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_external_system ::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_external_system({ external_system: external_system, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_external_system(::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest.new(external_system: external_system, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_external_system_client_stub.call_count
      end
    end
  end

  def test_update_finding
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Finding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    finding = {}
    update_mask = {}

    update_finding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_finding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_finding_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_finding({ finding: finding, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_finding finding: finding, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_finding ::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_finding({ finding: finding, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_finding(::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest.new(finding: finding, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_finding_client_stub.call_count
      end
    end
  end

  def test_update_mute_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::MuteConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    mute_config = {}
    update_mask = {}

    update_mute_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_mute_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_mute_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_mute_config mute_config: mute_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_mute_config ::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_mute_config({ mute_config: mute_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_mute_config(::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest.new(mute_config: mute_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_mute_config_client_stub.call_count
      end
    end
  end

  def test_update_notification_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::NotificationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    notification_config = {}
    update_mask = {}

    update_notification_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_notification_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_notification_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_notification_config notification_config: notification_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_notification_config ::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_notification_config({ notification_config: notification_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_notification_config(::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest.new(notification_config: notification_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_notification_config_client_stub.call_count
      end
    end
  end

  def test_update_organization_settings
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::OrganizationSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    organization_settings = {}
    update_mask = {}

    update_organization_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_organization_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_organization_settings_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_organization_settings organization_settings: organization_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_organization_settings ::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_organization_settings({ organization_settings: organization_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_organization_settings(::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest.new(organization_settings: organization_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_organization_settings_client_stub.call_count
      end
    end
  end

  def test_update_security_health_analytics_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    security_health_analytics_custom_module = {}
    update_mask = {}

    update_security_health_analytics_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_security_health_analytics_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_health_analytics_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_health_analytics_custom_module({ security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_health_analytics_custom_module security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_health_analytics_custom_module ::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_health_analytics_custom_module({ security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_health_analytics_custom_module(::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new(security_health_analytics_custom_module: security_health_analytics_custom_module, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_health_analytics_custom_module_client_stub.call_count
      end
    end
  end

  def test_update_source
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source = {}
    update_mask = {}

    update_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_source_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_source({ source: source, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_source source: source, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_source ::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest.new(source: source, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_source({ source: source, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_source(::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest.new(source: source, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_source_client_stub.call_count
      end
    end
  end

  def test_update_security_marks
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::SecurityMarks.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    security_marks = {}
    update_mask = {}
    start_time = {}

    update_security_marks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_security_marks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_security_marks_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_security_marks security_marks: security_marks, update_mask: update_mask, start_time: start_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_security_marks ::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_security_marks({ security_marks: security_marks, update_mask: update_mask, start_time: start_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_security_marks(::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest.new(security_marks: security_marks, update_mask: update_mask, start_time: start_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_security_marks_client_stub.call_count
      end
    end
  end

  def test_create_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    big_query_export = {}
    big_query_export_id = "hello world"

    create_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_big_query_export parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_big_query_export ::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_big_query_export({ parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_big_query_export(::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest.new(parent: parent, big_query_export: big_query_export, big_query_export_id: big_query_export_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_big_query_export_client_stub.call_count
      end
    end
  end

  def test_delete_big_query_export
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_big_query_export({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_big_query_export name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_big_query_export ::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_big_query_export({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_big_query_export(::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_big_query_export_client_stub.call_count
      end
    end
  end

  def test_update_big_query_export
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::BigQueryExport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    big_query_export = {}
    update_mask = {}

    update_big_query_export_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_big_query_export_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_big_query_export_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_big_query_export big_query_export: big_query_export, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_big_query_export ::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_big_query_export({ big_query_export: big_query_export, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_big_query_export(::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest.new(big_query_export: big_query_export, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_big_query_export_client_stub.call_count
      end
    end
  end

  def test_list_big_query_exports
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_big_query_exports_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_big_query_exports_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_big_query_exports_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_big_query_exports parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_big_query_exports ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_big_query_exports({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_big_query_exports(::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_big_query_exports_client_stub.call_count
      end
    end
  end

  def test_create_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event_threat_detection_custom_module = {}

    create_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_create_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_event_threat_detection_custom_module parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_event_threat_detection_custom_module({ parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest.new(parent: parent, event_threat_detection_custom_module: event_threat_detection_custom_module), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_delete_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_event_threat_detection_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_event_threat_detection_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_event_threat_detection_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_event_threat_detection_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_event_threat_detection_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_event_threat_detection_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_list_descendant_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_descendant_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_descendant_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_descendant_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_descendant_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_descendant_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_descendant_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_descendant_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_descendant_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_list_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_update_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    event_threat_detection_custom_module = {}
    update_mask = {}

    update_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_event_threat_detection_custom_module({ event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_event_threat_detection_custom_module event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest.new(event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_event_threat_detection_custom_module({ event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest.new(event_threat_detection_custom_module: event_threat_detection_custom_module, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_validate_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    raw_text = "hello world"
    type = "hello world"

    validate_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_validate_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, validate_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.validate_event_threat_detection_custom_module parent: parent, raw_text: raw_text, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.validate_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.validate_event_threat_detection_custom_module({ parent: parent, raw_text: raw_text, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.validate_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest.new(parent: parent, raw_text: raw_text, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, validate_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_get_effective_event_threat_detection_custom_module
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_effective_event_threat_detection_custom_module_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_effective_event_threat_detection_custom_module_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_effective_event_threat_detection_custom_module_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_effective_event_threat_detection_custom_module({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_effective_event_threat_detection_custom_module name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_effective_event_threat_detection_custom_module ::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_effective_event_threat_detection_custom_module({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_effective_event_threat_detection_custom_module(::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_effective_event_threat_detection_custom_module_client_stub.call_count
      end
    end
  end

  def test_list_effective_event_threat_detection_custom_modules
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_effective_event_threat_detection_custom_modules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_effective_event_threat_detection_custom_modules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_effective_event_threat_detection_custom_modules_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_effective_event_threat_detection_custom_modules parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_effective_event_threat_detection_custom_modules ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_effective_event_threat_detection_custom_modules({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_effective_event_threat_detection_custom_modules(::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_effective_event_threat_detection_custom_modules_client_stub.call_count
      end
    end
  end

  def test_batch_create_resource_value_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_resource_value_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_batch_create_resource_value_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_resource_value_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_resource_value_configs({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_resource_value_configs parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_resource_value_configs ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_resource_value_configs({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_resource_value_configs(::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_resource_value_configs_client_stub.call_count
      end
    end
  end

  def test_delete_resource_value_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_delete_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_resource_value_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_resource_value_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_resource_value_config ::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_resource_value_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_resource_value_config(::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_get_resource_value_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_get_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource_value_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource_value_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource_value_config ::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource_value_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource_value_config(::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_list_resource_value_configs
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_resource_value_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_resource_value_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resource_value_configs_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resource_value_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resource_value_configs ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resource_value_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resource_value_configs(::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resource_value_configs_client_stub.call_count
      end
    end
  end

  def test_update_resource_value_config
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource_value_config = {}
    update_mask = {}

    update_resource_value_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_update_resource_value_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_resource_value_config_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_resource_value_config resource_value_config: resource_value_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_resource_value_config ::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_resource_value_config({ resource_value_config: resource_value_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_resource_value_config(::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest.new(resource_value_config: resource_value_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_resource_value_config_client_stub.call_count
      end
    end
  end

  def test_list_valued_resources
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42
    order_by = "hello world"

    list_valued_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_valued_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_valued_resources_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_valued_resources parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_valued_resources ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_valued_resources({ parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_valued_resources(::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_valued_resources_client_stub.call_count
      end
    end
  end

  def test_list_attack_paths
    # Create test objects.
    client_result = ::Google::Cloud::SecurityCenter::V1::ListAttackPathsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_token = "hello world"
    page_size = 42

    list_attack_paths_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::ServiceStub.stub :transcode_list_attack_paths_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_attack_paths_client_stub do
        # Create client
        client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_attack_paths parent: parent, filter: filter, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_attack_paths ::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_attack_paths({ parent: parent, filter: filter, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_attack_paths(::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest.new(parent: parent, filter: filter, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_attack_paths_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Rest::Client::Configuration, config
  end
end
