# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Refers to common vulnerability fields e.g. cve, cvss, cwe etc.
        # @!attribute [rw] cve
        #   @return [::Google::Cloud::SecurityCenter::V1::Cve]
        #     CVE stands for Common Vulnerabilities and Exposures
        #     (https://cve.mitre.org/about/)
        # @!attribute [rw] offending_package
        #   @return [::Google::Cloud::SecurityCenter::V1::Package]
        #     The offending package is relevant to the finding.
        # @!attribute [rw] fixed_package
        #   @return [::Google::Cloud::SecurityCenter::V1::Package]
        #     The fixed package is relevant to the finding.
        # @!attribute [rw] security_bulletin
        #   @return [::Google::Cloud::SecurityCenter::V1::SecurityBulletin]
        #     The security bulletin is relevant to this finding.
        class Vulnerability
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CVE stands for Common Vulnerabilities and Exposures.
        # Information from the [CVE
        # record](https://www.cve.org/ResourcesSupport/Glossary) that describes this
        # vulnerability.
        # @!attribute [rw] id
        #   @return [::String]
        #     The unique identifier for the vulnerability. e.g. CVE-2021-34527
        # @!attribute [rw] references
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::Reference>]
        #     Additional information about the CVE.
        #     e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
        # @!attribute [rw] cvssv3
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3]
        #     Describe Common Vulnerability Scoring System specified at
        #     https://www.first.org/cvss/v3.1/specification-document
        # @!attribute [rw] upstream_fix_available
        #   @return [::Boolean]
        #     Whether upstream fix is available for the CVE.
        # @!attribute [rw] impact
        #   @return [::Google::Cloud::SecurityCenter::V1::Cve::RiskRating]
        #     The potential impact of the vulnerability if it was to be exploited.
        # @!attribute [rw] exploitation_activity
        #   @return [::Google::Cloud::SecurityCenter::V1::Cve::ExploitationActivity]
        #     The exploitation activity of the vulnerability in the wild.
        # @!attribute [rw] observed_in_the_wild
        #   @return [::Boolean]
        #     Whether or not the vulnerability has been observed in the wild.
        # @!attribute [rw] zero_day
        #   @return [::Boolean]
        #     Whether or not the vulnerability was zero day when the finding was
        #     published.
        # @!attribute [rw] exploit_release_date
        #   @return [::Google::Protobuf::Timestamp]
        #     Date the first publicly available exploit or PoC was released.
        class Cve
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible values of impact of the vulnerability if it was to be
          # exploited.
          module RiskRating
            # Invalid or empty value.
            RISK_RATING_UNSPECIFIED = 0

            # Exploitation would have little to no security impact.
            LOW = 1

            # Exploitation would enable attackers to perform activities, or could allow
            # attackers to have a direct impact, but would require additional steps.
            MEDIUM = 2

            # Exploitation would enable attackers to have a notable direct impact
            # without needing to overcome any major mitigating factors.
            HIGH = 3

            # Exploitation would fundamentally undermine the security of affected
            # systems, enable actors to perform significant attacks with minimal
            # effort, with little to no mitigating factors to overcome.
            CRITICAL = 4
          end

          # The possible values of exploitation activity of the vulnerability in the
          # wild.
          module ExploitationActivity
            # Invalid or empty value.
            EXPLOITATION_ACTIVITY_UNSPECIFIED = 0

            # Exploitation has been reported or confirmed to widely occur.
            WIDE = 1

            # Limited reported or confirmed exploitation activities.
            CONFIRMED = 2

            # Exploit is publicly available.
            AVAILABLE = 3

            # No known exploitation activity, but has a high potential for
            # exploitation.
            ANTICIPATED = 4

            # No known exploitation activity.
            NO_KNOWN = 5
          end
        end

        # Additional Links
        # @!attribute [rw] source
        #   @return [::String]
        #     Source of the reference e.g. NVD
        # @!attribute [rw] uri
        #   @return [::String]
        #     Uri for the mentioned source e.g.
        #     https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527.
        class Reference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Common Vulnerability Scoring System version 3.
        # @!attribute [rw] base_score
        #   @return [::Float]
        #     The base score is a function of the base metric scores.
        # @!attribute [rw] attack_vector
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::AttackVector]
        #     Base Metrics
        #     Represents the intrinsic characteristics of a vulnerability that are
        #     constant over time and across user environments.
        #     This metric reflects the context by which vulnerability exploitation is
        #     possible.
        # @!attribute [rw] attack_complexity
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::AttackComplexity]
        #     This metric describes the conditions beyond the attacker's control that
        #     must exist in order to exploit the vulnerability.
        # @!attribute [rw] privileges_required
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::PrivilegesRequired]
        #     This metric describes the level of privileges an attacker must possess
        #     before successfully exploiting the vulnerability.
        # @!attribute [rw] user_interaction
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::UserInteraction]
        #     This metric captures the requirement for a human user, other than the
        #     attacker, to participate in the successful compromise of the vulnerable
        #     component.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::Scope]
        #     The Scope metric captures whether a vulnerability in one vulnerable
        #     component impacts resources in components beyond its security scope.
        # @!attribute [rw] confidentiality_impact
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::Impact]
        #     This metric measures the impact to the confidentiality of the information
        #     resources managed by a software component due to a successfully exploited
        #     vulnerability.
        # @!attribute [rw] integrity_impact
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::Impact]
        #     This metric measures the impact to integrity of a successfully exploited
        #     vulnerability.
        # @!attribute [rw] availability_impact
        #   @return [::Google::Cloud::SecurityCenter::V1::Cvssv3::Impact]
        #     This metric measures the impact to the availability of the impacted
        #     component resulting from a successfully exploited vulnerability.
        class Cvssv3
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This metric reflects the context by which vulnerability exploitation is
          # possible.
          module AttackVector
            # Invalid value.
            ATTACK_VECTOR_UNSPECIFIED = 0

            # The vulnerable component is bound to the network stack and the set of
            # possible attackers extends beyond the other options listed below, up to
            # and including the entire Internet.
            ATTACK_VECTOR_NETWORK = 1

            # The vulnerable component is bound to the network stack, but the attack is
            # limited at the protocol level to a logically adjacent topology.
            ATTACK_VECTOR_ADJACENT = 2

            # The vulnerable component is not bound to the network stack and the
            # attacker's path is via read/write/execute capabilities.
            ATTACK_VECTOR_LOCAL = 3

            # The attack requires the attacker to physically touch or manipulate the
            # vulnerable component.
            ATTACK_VECTOR_PHYSICAL = 4
          end

          # This metric describes the conditions beyond the attacker's control that
          # must exist in order to exploit the vulnerability.
          module AttackComplexity
            # Invalid value.
            ATTACK_COMPLEXITY_UNSPECIFIED = 0

            # Specialized access conditions or extenuating circumstances do not exist.
            # An attacker can expect repeatable success when attacking the vulnerable
            # component.
            ATTACK_COMPLEXITY_LOW = 1

            # A successful attack depends on conditions beyond the attacker's control.
            # That is, a successful attack cannot be accomplished at will, but requires
            # the attacker to invest in some measurable amount of effort in preparation
            # or execution against the vulnerable component before a successful attack
            # can be expected.
            ATTACK_COMPLEXITY_HIGH = 2
          end

          # This metric describes the level of privileges an attacker must possess
          # before successfully exploiting the vulnerability.
          module PrivilegesRequired
            # Invalid value.
            PRIVILEGES_REQUIRED_UNSPECIFIED = 0

            # The attacker is unauthorized prior to attack, and therefore does not
            # require any access to settings or files of the vulnerable system to
            # carry out an attack.
            PRIVILEGES_REQUIRED_NONE = 1

            # The attacker requires privileges that provide basic user capabilities
            # that could normally affect only settings and files owned by a user.
            # Alternatively, an attacker with Low privileges has the ability to access
            # only non-sensitive resources.
            PRIVILEGES_REQUIRED_LOW = 2

            # The attacker requires privileges that provide significant (e.g.,
            # administrative) control over the vulnerable component allowing access to
            # component-wide settings and files.
            PRIVILEGES_REQUIRED_HIGH = 3
          end

          # This metric captures the requirement for a human user, other than the
          # attacker, to participate in the successful compromise of the vulnerable
          # component.
          module UserInteraction
            # Invalid value.
            USER_INTERACTION_UNSPECIFIED = 0

            # The vulnerable system can be exploited without interaction from any user.
            USER_INTERACTION_NONE = 1

            # Successful exploitation of this vulnerability requires a user to take
            # some action before the vulnerability can be exploited.
            USER_INTERACTION_REQUIRED = 2
          end

          # The Scope metric captures whether a vulnerability in one vulnerable
          # component impacts resources in components beyond its security scope.
          module Scope
            # Invalid value.
            SCOPE_UNSPECIFIED = 0

            # An exploited vulnerability can only affect resources managed by the same
            # security authority.
            SCOPE_UNCHANGED = 1

            # An exploited vulnerability can affect resources beyond the security scope
            # managed by the security authority of the vulnerable component.
            SCOPE_CHANGED = 2
          end

          # The Impact metrics capture the effects of a successfully exploited
          # vulnerability on the component that suffers the worst outcome that is most
          # directly and predictably associated with the attack.
          module Impact
            # Invalid value.
            IMPACT_UNSPECIFIED = 0

            # High impact.
            IMPACT_HIGH = 1

            # Low impact.
            IMPACT_LOW = 2

            # No impact.
            IMPACT_NONE = 3
          end
        end

        # Package is a generic definition of a package.
        # @!attribute [rw] package_name
        #   @return [::String]
        #     The name of the package where the vulnerability was detected.
        # @!attribute [rw] cpe_uri
        #   @return [::String]
        #     The CPE URI where the vulnerability was detected.
        # @!attribute [rw] package_type
        #   @return [::String]
        #     Type of package, for example, os, maven, or go.
        # @!attribute [rw] package_version
        #   @return [::String]
        #     The version of the package.
        class Package
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SecurityBulletin are notifications of vulnerabilities of Google products.
        # @!attribute [rw] bulletin_id
        #   @return [::String]
        #     ID of the bulletin corresponding to the vulnerability.
        # @!attribute [rw] submission_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Submission time of this Security Bulletin.
        # @!attribute [rw] suggested_upgrade_version
        #   @return [::String]
        #     This represents a version that the cluster receiving this notification
        #     should be upgraded to, based on its current version. For example, 1.15.0
        class SecurityBulletin
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
