# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # A resource that is determined to have value to a user's system
        # @!attribute [rw] name
        #   @return [::String]
        #     Valued resource name, for example,
        #      e.g.:
        #      `organizations/123/simulations/456/valuedResources/789`
        # @!attribute [rw] resource
        #   @return [::String]
        #     The
        #     [full resource
        #     name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
        #     of the valued resource.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     The [resource
        #     type](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        #     of the valued resource.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human-readable name of the valued resource.
        # @!attribute [rw] resource_value
        #   @return [::Google::Cloud::SecurityCenter::V1::ValuedResource::ResourceValue]
        #     How valuable this resource is.
        # @!attribute [rw] exposed_score
        #   @return [::Float]
        #     Exposed score for this valued resource. A value of 0 means no exposure was
        #     detected exposure.
        # @!attribute [rw] resource_value_configs_used
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ResourceValueConfigMetadata>]
        #     List of resource value configurations' metadata used to determine the value
        #     of this resource. Maximum of 100.
        class ValuedResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How valuable the resource is.
          module ResourceValue
            # The resource value isn't specified.
            RESOURCE_VALUE_UNSPECIFIED = 0

            # This is a low-value resource.
            RESOURCE_VALUE_LOW = 1

            # This is a medium-value resource.
            RESOURCE_VALUE_MEDIUM = 2

            # This is a high-value resource.
            RESOURCE_VALUE_HIGH = 3
          end
        end

        # Metadata about a ResourceValueConfig. For example, id and name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource value config name
        class ResourceValueConfigMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
