# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Contains details about a group of security issues that, when the issues
        # occur together, represent a greater risk than when the issues occur
        # independently. A group of such issues is referred to as a toxic combination.
        # @!attribute [rw] attack_exposure_score
        #   @return [::Float]
        #     The
        #     [Attack exposure
        #     score](https://cloud.google.com/security-command-center/docs/attack-exposure-learn#attack_exposure_scores)
        #     of this toxic combination. The score is a measure of how much this toxic
        #     combination exposes one or more high-value resources to potential attack.
        # @!attribute [rw] related_findings
        #   @return [::Array<::String>]
        #     List of resource names of findings associated with this toxic combination.
        #     For example, `organizations/123/sources/456/findings/789`.
        class ToxicCombination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
