# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Request message for bulk findings update.
        #
        # Note:
        # 1. If multiple bulk update requests match the same resource, the order in
        # which they get executed is not defined.
        # 2. Once a bulk operation is started, there is no way to stop it.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, at which bulk action needs to be applied. Its format
        #     is `organizations/[organization_id]`, `folders/[folder_id]`,
        #     `projects/[project_id]`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that identifies findings that should be updated.
        #     The expression is a list of zero or more restrictions combined
        #     via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
        #     has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a
        #     `-` character in front of them to indicate negation. The fields map to
        #     those defined in the corresponding resource.
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        # @!attribute [rw] mute_annotation
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     This can be a mute configuration name or any identifier for mute/unmute
        #     of findings based on the filter.
        # @!attribute [rw] mute_state
        #   @return [::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest::MuteState]
        #     Optional. All findings matching the given filter will have their mute state
        #     set to this value. The default value is `MUTED`. Setting this to
        #     `UNDEFINED` will clear the mute state on all matching findings.
        class BulkMuteFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The mute state.
          module MuteState
            # Unused.
            MUTE_STATE_UNSPECIFIED = 0

            # Matching findings will be muted (default).
            MUTED = 1

            # Matching findings will have their mute state cleared.
            UNDEFINED = 2
          end
        end

        # The response to a BulkMute request. Contains the LRO information.
        class BulkMuteFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a finding.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new finding's parent. Its format should be
        #     `organizations/[organization_id]/sources/[source_id]`.
        # @!attribute [rw] finding_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must be alphanumeric and less than or equal to 32 characters and
        #     greater than 0 characters in length.
        # @!attribute [rw] finding
        #   @return [::Google::Cloud::SecurityCenter::V1::Finding]
        #     Required. The Finding being created. The name and security_marks will be
        #     ignored as they are both output only fields on this resource.
        class CreateFindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a mute config.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new mute configs's parent. Its format is
        #     `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] mute_config
        #   @return [::Google::Cloud::SecurityCenter::V1::MuteConfig]
        #     Required. The mute config being created.
        # @!attribute [rw] mute_config_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must consist of only lowercase letters, numbers, and hyphens, must start
        #     with a letter, must end with either a letter or a number, and must be 63
        #     characters or less.
        class CreateMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create single resource value config
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new ResourceValueConfig's parent.
        # @!attribute [rw] resource_value_config
        #   @return [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
        #     Required. The resource value config being created.
        class CreateResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create multiple resource value configs
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new ResourceValueConfig's parent.
        #     The parent field in the CreateResourceValueConfigRequest
        #     messages must either be empty or match this field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::CreateResourceValueConfigRequest>]
        #     Required. The resource value configs to be created.
        class BatchCreateResourceValueConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchCreateResourceValueConfigs
        # @!attribute [rw] resource_value_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ResourceValueConfig>]
        #     The resource value configs created
        class BatchCreateResourceValueConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete resource value config
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ResourceValueConfig to delete
        class DeleteResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to get resource value config
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource value config to retrieve. Its format is
        #     `organizations/{organization}/resourceValueConfigs/{config_id}`.
        class GetResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to list resource value configs of a parent
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of resource value configs.
        #     Its format is
        #     `organizations/[organization_id]`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of results to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListResourceValueConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListResourceValueConfigs` must match the call that provided the
        #     page token.
        #
        #     page_size can be specified, and the new page_size will be used.
        class ListResourceValueConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message to list resource value configs
        # @!attribute [rw] resource_value_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ResourceValueConfig>]
        #     The resource value configs from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is empty, there are no subsequent pages.
        class ListResourceValueConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to update resource value config
        # @!attribute [rw] resource_value_config
        #   @return [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
        #     Required. The resource value config being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateResourceValueConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a notification config.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new notification config's parent. Its format
        #     is `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] config_id
        #   @return [::String]
        #     Required.
        #     Unique identifier provided by the client within the parent scope.
        #     It must be between 1 and 128 characters and contain alphanumeric
        #     characters, underscores, or hyphens only.
        # @!attribute [rw] notification_config
        #   @return [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
        #     Required. The notification config being created. The name and the service
        #     account will be ignored as they are both output only fields on this
        #     resource.
        class CreateNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating Security Health Analytics custom modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new custom module's parent. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings`,
        #     `folders/{folder}/securityHealthAnalyticsSettings`, or
        #     `projects/{project}/securityHealthAnalyticsSettings`
        # @!attribute [rw] security_health_analytics_custom_module
        #   @return [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
        #     Required. SecurityHealthAnalytics custom module to create. The provided
        #     name is ignored and reset with provided parent information and
        #     server-generated ID.
        class CreateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a source.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the new source's parent. Its format should be
        #     `organizations/[organization_id]`.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::SecurityCenter::V1::Source]
        #     Required. The Source being created, only the display_name and description
        #     will be used. All other fields will be ignored.
        class CreateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a mute config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mute config to delete. Its format is
        #     `organizations/{organization}/muteConfigs/{config_id}`,
        #     `folders/{folder}/muteConfigs/{config_id}`,
        #     `projects/{project}/muteConfigs/{config_id}`,
        #     `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
        #     `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
        #     `projects/{project}/locations/global/muteConfigs/{config_id}`.
        class DeleteMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a notification config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the notification config to delete. Its format is
        #     `organizations/[organization_id]/notificationConfigs/[config_id]`,
        #     `folders/[folder_id]/notificationConfigs/[config_id]`,
        #     or `projects/[project_id]/notificationConfigs/[config_id]`.
        class DeleteNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting Security Health Analytics custom modules.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the custom module to delete. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
        #     `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
        #     or
        #     `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
        class DeleteSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a BigQuery export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the BigQuery export to retrieve. Its format is
        #     `organizations/{organization}/bigQueryExports/{export_id}`,
        #     `folders/{folder}/bigQueryExports/{export_id}`, or
        #     `projects/{project}/bigQueryExports/{export_id}`
        class GetBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a mute config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mute config to retrieve. Its format is
        #     `organizations/{organization}/muteConfigs/{config_id}`,
        #     `folders/{folder}/muteConfigs/{config_id}`,
        #     `projects/{project}/muteConfigs/{config_id}`,
        #     `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
        #     `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
        #     `projects/{project}/locations/global/muteConfigs/{config_id}`.
        class GetMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a notification config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the notification config to get. Its format is
        #     `organizations/[organization_id]/notificationConfigs/[config_id]`,
        #     `folders/[folder_id]/notificationConfigs/[config_id]`,
        #     or `projects/[project_id]/notificationConfigs/[config_id]`.
        class GetNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting organization settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the organization to get organization settings for. Its
        #     format is `organizations/[organization_id]/organizationSettings`.
        class GetOrganizationSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting effective Security Health Analytics custom
        # modules.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the effective custom module to get. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
        #     `folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
        #     or
        #     `projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`
        class GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting Security Health Analytics custom modules.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the custom module to get. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
        #     `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
        #     or
        #     `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
        class GetSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a source.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Relative resource name of the source. Its format is
        #     `organizations/[organization_id]/source/[source_id]`.
        class GetSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for grouping by assets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent to group the assets by. Its format is
        #     `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across assets.
        #     The expression is a list of zero or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. The fields map to those
        #     defined in the Asset resource. Examples include:
        #
        #     * name
        #     * security_center_properties.resource_name
        #     * resource_properties.a_property
        #     * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following field and operator combinations are supported:
        #
        #     * name: `=`
        #     * update_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `update_time = "2019-06-10T16:07:18-07:00"`
        #         `update_time = 1560208038000`
        #
        #     * create_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `create_time = "2019-06-10T16:07:18-07:00"`
        #         `create_time = 1560208038000`
        #
        #     * iam_policy.policy_blob: `=`, `:`
        #     * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
        #     * security_marks.marks: `=`, `:`
        #     * security_center_properties.resource_name: `=`, `:`
        #     * security_center_properties.resource_display_name: `=`, `:`
        #     * security_center_properties.resource_type: `=`, `:`
        #     * security_center_properties.resource_parent: `=`, `:`
        #     * security_center_properties.resource_parent_display_name: `=`, `:`
        #     * security_center_properties.resource_project: `=`, `:`
        #     * security_center_properties.resource_project_display_name: `=`, `:`
        #     * security_center_properties.resource_owners: `=`, `:`
        #
        #     For example, `resource_properties.size = 100` is a valid filter string.
        #
        #     Use a partial match on the empty string to filter based on a property
        #     existing: `resource_properties.my_property : ""`
        #
        #     Use a negated partial match on the empty string to filter based on a
        #     property not existing: `-resource_properties.my_property : ""`
        # @!attribute [rw] group_by
        #   @return [::String]
        #     Required. Expression that defines what assets fields to use for grouping.
        #     The string value should follow SQL syntax: comma separated list of fields.
        #     For example:
        #     "security_center_properties.resource_project,security_center_properties.project".
        #
        #     The following fields are supported when compare_duration is not set:
        #
        #     * security_center_properties.resource_project
        #     * security_center_properties.resource_project_display_name
        #     * security_center_properties.resource_type
        #     * security_center_properties.resource_parent
        #     * security_center_properties.resource_parent_display_name
        #
        #     The following fields are supported when compare_duration is set:
        #
        #     * security_center_properties.resource_type
        #     * security_center_properties.resource_project_display_name
        #     * security_center_properties.resource_parent_display_name
        # @!attribute [rw] compare_duration
        #   @return [::Google::Protobuf::Duration]
        #     When compare_duration is set, the GroupResult's "state_change" property is
        #     updated to indicate whether the asset was added, removed, or remained
        #     present during the compare_duration period of time that precedes the
        #     read_time. This is the time between (read_time - compare_duration) and
        #     read_time.
        #
        #     The state change value is derived based on the presence of the asset at the
        #     two points in time. Intermediate state changes between the two times don't
        #     affect the result. For example, the results aren't affected if the asset is
        #     removed and re-created again.
        #
        #     Possible "state_change" values when compare_duration is specified:
        #
        #     * "ADDED":   indicates that the asset was not present at the start of
        #                    compare_duration, but present at reference_time.
        #     * "REMOVED": indicates that the asset was present at the start of
        #                    compare_duration, but not present at reference_time.
        #     * "ACTIVE":  indicates that the asset was present at both the
        #                    start and the end of the time period defined by
        #                    compare_duration and reference_time.
        #
        #     If compare_duration is not specified, then the only possible state_change
        #     is "UNUSED", which will be the state_change set for all assets present at
        #     read_time.
        #
        #     If this field is set then `state_change` must be a specified field in
        #     `group_by`.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used as a reference point when filtering assets. The filter is limited
        #     to assets existing at the supplied time and their values are those at that
        #     specific time. Absence of this field will default to the API's version of
        #     NOW.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `GroupAssetsResponse`; indicates
        #     that this is a continuation of a prior `GroupAssets` call, and that the
        #     system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class GroupAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for grouping by assets.
        # @!attribute [rw] group_by_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::GroupResult>]
        #     Group results. There exists an element for each existing unique
        #     combination of property/values. The element contains a count for the number
        #     of times those specific property/values appear.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used for executing the groupBy request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of results matching the query.
        class GroupAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for grouping by findings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the source to groupBy. Its format is
        #     `organizations/[organization_id]/sources/[source_id]`,
        #     `folders/[folder_id]/sources/[source_id]`, or
        #     `projects/[project_id]/sources/[source_id]`. To groupBy across all sources
        #     provide a source_id of `-`. For example:
        #     `organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-`,
        #     or `projects/{project_id}/sources/-`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across findings.
        #     The expression is a list of one or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. Examples include:
        #
        #      * name
        #      * source_properties.a_property
        #      * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following field and operator combinations are supported:
        #
        #     * name: `=`
        #     * parent: `=`, `:`
        #     * resource_name: `=`, `:`
        #     * state: `=`, `:`
        #     * category: `=`, `:`
        #     * external_uri: `=`, `:`
        #     * event_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `event_time = "2019-06-10T16:07:18-07:00"`
        #         `event_time = 1560208038000`
        #
        #     * severity: `=`, `:`
        #     * workflow_state: `=`, `:`
        #     * security_marks.marks: `=`, `:`
        #     * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
        #
        #       For example, `source_properties.size = 100` is a valid filter string.
        #
        #       Use a partial match on the empty string to filter based on a property
        #       existing: `source_properties.my_property : ""`
        #
        #       Use a negated partial match on the empty string to filter based on a
        #       property not existing: `-source_properties.my_property : ""`
        #
        #     * resource:
        #       * resource.name: `=`, `:`
        #       * resource.parent_name: `=`, `:`
        #       * resource.parent_display_name: `=`, `:`
        #       * resource.project_name: `=`, `:`
        #       * resource.project_display_name: `=`, `:`
        #       * resource.type: `=`, `:`
        # @!attribute [rw] group_by
        #   @return [::String]
        #     Required. Expression that defines what assets fields to use for grouping
        #     (including `state_change`). The string value should follow SQL syntax:
        #     comma separated list of fields. For example: "parent,resource_name".
        #
        #     The following fields are supported when compare_duration is set:
        #
        #     * state_change
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used as a reference point when filtering findings. The filter is
        #     limited to findings existing at the supplied time and their values are
        #     those at that specific time. Absence of this field will default to the
        #     API's version of NOW.
        # @!attribute [rw] compare_duration
        #   @return [::Google::Protobuf::Duration]
        #     When compare_duration is set, the GroupResult's "state_change" attribute is
        #     updated to indicate whether the finding had its state changed, the
        #     finding's state remained unchanged, or if the finding was added during the
        #     compare_duration period of time that precedes the read_time. This is the
        #     time between (read_time - compare_duration) and read_time.
        #
        #     The state_change value is derived based on the presence and state of the
        #     finding at the two points in time. Intermediate state changes between the
        #     two times don't affect the result. For example, the results aren't affected
        #     if the finding is made inactive and then active again.
        #
        #     Possible "state_change" values when compare_duration is specified:
        #
        #     * "CHANGED":   indicates that the finding was present and matched the given
        #                      filter at the start of compare_duration, but changed its
        #                      state at read_time.
        #     * "UNCHANGED": indicates that the finding was present and matched the given
        #                      filter at the start of compare_duration and did not change
        #                      state at read_time.
        #     * "ADDED":     indicates that the finding did not match the given filter or
        #                      was not present at the start of compare_duration, but was
        #                      present at read_time.
        #     * "REMOVED":   indicates that the finding was present and matched the
        #                      filter at the start of compare_duration, but did not match
        #                      the filter at read_time.
        #
        #     If compare_duration is not specified, then the only possible state_change
        #     is "UNUSED",  which will be the state_change set for all findings present
        #     at read_time.
        #
        #     If this field is set then `state_change` must be a specified field in
        #     `group_by`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `GroupFindingsResponse`; indicates
        #     that this is a continuation of a prior `GroupFindings` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class GroupFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for group by findings.
        # @!attribute [rw] group_by_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::GroupResult>]
        #     Group results. There exists an element for each existing unique
        #     combination of property/values. The element contains a count for the number
        #     of times those specific property/values appear.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used for executing the groupBy request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of results matching the query.
        class GroupFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Result containing the properties and count of a groupBy request.
        # @!attribute [rw] properties
        #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
        #     Properties matching the groupBy fields in the request.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Total count of resources for the given properties.
        class GroupResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Protobuf::Value]
          class PropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for listing descendant Security Health Analytics custom
        # modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list descendant custom modules. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings`,
        #     `folders/{folder}/securityHealthAnalyticsSettings`, or
        #     `projects/{project}/securityHealthAnalyticsSettings`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last call indicating a continuation
        class ListDescendantSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing descendant Security Health Analytics custom
        # modules.
        # @!attribute [rw] security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
        #     Custom modules belonging to the requested parent and its descendants.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If not empty, indicates that there may be more custom modules to be
        #     returned.
        class ListDescendantSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing the valued resources for a given simulation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list valued resources.
        #
        #     Valid formats:
        #     `organizations/{organization}`,
        #     `organizations/{organization}/simulations/{simulation}`
        #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter expression that filters the valued resources in the response.
        #     Supported fields:
        #
        #       * `resource_value` supports =
        #       * `resource_type` supports =
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListValuedResourcesResponse`; indicates
        #     that this is a continuation of a prior `ListValuedResources` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The fields by which to order the valued resources response.
        #
        #     Supported fields:
        #
        #       * `exposed_score`
        #
        #       * `resource_value`
        #
        #       * `resource_type`
        #
        #       * `resource`
        #
        #       * `display_name`
        #
        #     Values should be a comma separated list of fields. For example:
        #     `exposed_score,resource_value`.
        #
        #     The default sorting order is descending. To specify ascending or descending
        #     order for a field, append a ` ASC` or a ` DESC` suffix, respectively; for
        #     example: `exposed_score DESC`.
        class ListValuedResourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing the valued resources for a given simulation.
        # @!attribute [rw] valued_resources
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ValuedResource>]
        #     The valued resources that the attack path simulation identified.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The estimated total number of results matching the query.
        class ListValuedResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing the attack paths for a given simulation or valued
        # resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list attack paths.
        #
        #     Valid formats:
        #     `organizations/{organization}`,
        #     `organizations/{organization}/simulations/{simulation}`
        #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
        #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter expression that filters the attack path in the response.
        #     Supported fields:
        #
        #       * `valued_resources` supports =
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListAttackPathsResponse`; indicates
        #     that this is a continuation of a prior `ListAttackPaths` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListAttackPathsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing the attack paths for a given simulation or
        # valued resource.
        # @!attribute [rw] attack_paths
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::AttackPath>]
        #     The attack paths that the attack path simulation identified.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListAttackPathsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting simulation.
        # Simulation name can include "latest" to retrieve the latest simulation
        # For example, "organizations/123/simulations/latest"
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The organization name or simulation name of this simulation
        #
        #     Valid format:
        #     `organizations/{organization}/simulations/latest`
        #     `organizations/{organization}/simulations/{simulation}`
        class GetSimulationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a valued resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of this valued resource
        #
        #     Valid format:
        #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
        class GetValuedResourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing  mute configs at a given scope e.g. organization,
        # folder or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of mute configs. Its format
        #     is `organizations/[organization_id]`, `folders/[folder_id]`,
        #     `projects/[project_id]`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of configs to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListMuteConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListMuteConfigs` must
        #     match the call that provided the page token.
        class ListMuteConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing mute configs.
        # @!attribute [rw] mute_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::MuteConfig>]
        #     The mute configs from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListMuteConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing notification configs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent in which to list the notification
        #     configurations. Its format is "organizations/[organization_id]",
        #     "folders/[folder_id]", or "projects/[project_id]".
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListNotificationConfigsResponse`; indicates
        #     that this is a continuation of a prior `ListNotificationConfigs` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListNotificationConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing notification configs.
        # @!attribute [rw] notification_configs
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::NotificationConfig>]
        #     Notification configs belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListNotificationConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing effective Security Health Analytics custom
        # modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list effective custom modules. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings`,
        #     `folders/{folder}/securityHealthAnalyticsSettings`, or
        #     `projects/{project}/securityHealthAnalyticsSettings`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last call indicating a continuation
        class ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing effective Security Health Analytics custom
        # modules.
        # @!attribute [rw] effective_security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
        #     Effective custom modules belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If not empty, indicates that there may be more effective custom modules to
        #     be returned.
        class ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing Security Health Analytics custom modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of parent to list custom modules. Its format is
        #     `organizations/{organization}/securityHealthAnalyticsSettings`,
        #     `folders/{folder}/securityHealthAnalyticsSettings`, or
        #     `projects/{project}/securityHealthAnalyticsSettings`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last call indicating a continuation
        class ListSecurityHealthAnalyticsCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing Security Health Analytics custom modules.
        # @!attribute [rw] security_health_analytics_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
        #     Custom modules belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If not empty, indicates that there may be more custom modules to be
        #     returned.
        class ListSecurityHealthAnalyticsCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing sources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent of sources to list. Its format should
        #     be `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListSourcesResponse`; indicates
        #     that this is a continuation of a prior `ListSources` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListSourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing sources.
        # @!attribute [rw] sources
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::Source>]
        #     Sources belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        class ListSourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing assets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource that contains the assets. The
        #     value that you can specify on parent depends on the method in which you
        #     specify parent. You can specify one of the following values:
        #     `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across assets.
        #     The expression is a list of zero or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. The fields map to those
        #     defined in the Asset resource. Examples include:
        #
        #     * name
        #     * security_center_properties.resource_name
        #     * resource_properties.a_property
        #     * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following are the allowed field and operator combinations:
        #
        #     * name: `=`
        #     * update_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `update_time = "2019-06-10T16:07:18-07:00"`
        #         `update_time = 1560208038000`
        #
        #     * create_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `create_time = "2019-06-10T16:07:18-07:00"`
        #         `create_time = 1560208038000`
        #
        #     * iam_policy.policy_blob: `=`, `:`
        #     * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
        #     * security_marks.marks: `=`, `:`
        #     * security_center_properties.resource_name: `=`, `:`
        #     * security_center_properties.resource_display_name: `=`, `:`
        #     * security_center_properties.resource_type: `=`, `:`
        #     * security_center_properties.resource_parent: `=`, `:`
        #     * security_center_properties.resource_parent_display_name: `=`, `:`
        #     * security_center_properties.resource_project: `=`, `:`
        #     * security_center_properties.resource_project_display_name: `=`, `:`
        #     * security_center_properties.resource_owners: `=`, `:`
        #
        #     For example, `resource_properties.size = 100` is a valid filter string.
        #
        #     Use a partial match on the empty string to filter based on a property
        #     existing: `resource_properties.my_property : ""`
        #
        #     Use a negated partial match on the empty string to filter based on a
        #     property not existing: `-resource_properties.my_property : ""`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Expression that defines what fields and order to use for sorting. The
        #     string value should follow SQL syntax: comma separated list of fields. For
        #     example: "name,resource_properties.a_property". The default sorting order
        #     is ascending. To specify descending order for a field, a suffix " desc"
        #     should be appended to the field name. For example: "name
        #     desc,resource_properties.a_property". Redundant space characters in the
        #     syntax are insignificant. "name desc,resource_properties.a_property" and "
        #     name     desc  ,   resource_properties.a_property  " are equivalent.
        #
        #     The following fields are supported:
        #     name
        #     update_time
        #     resource_properties
        #     security_marks.marks
        #     security_center_properties.resource_name
        #     security_center_properties.resource_display_name
        #     security_center_properties.resource_parent
        #     security_center_properties.resource_parent_display_name
        #     security_center_properties.resource_project
        #     security_center_properties.resource_project_display_name
        #     security_center_properties.resource_type
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used as a reference point when filtering assets. The filter is limited
        #     to assets existing at the supplied time and their values are those at that
        #     specific time. Absence of this field will default to the API's version of
        #     NOW.
        # @!attribute [rw] compare_duration
        #   @return [::Google::Protobuf::Duration]
        #     When compare_duration is set, the ListAssetsResult's "state_change"
        #     attribute is updated to indicate whether the asset was added, removed, or
        #     remained present during the compare_duration period of time that precedes
        #     the read_time. This is the time between (read_time - compare_duration) and
        #     read_time.
        #
        #     The state_change value is derived based on the presence of the asset at the
        #     two points in time. Intermediate state changes between the two times don't
        #     affect the result. For example, the results aren't affected if the asset is
        #     removed and re-created again.
        #
        #     Possible "state_change" values when compare_duration is specified:
        #
        #     * "ADDED":   indicates that the asset was not present at the start of
        #                    compare_duration, but present at read_time.
        #     * "REMOVED": indicates that the asset was present at the start of
        #                    compare_duration, but not present at read_time.
        #     * "ACTIVE":  indicates that the asset was present at both the
        #                    start and the end of the time period defined by
        #                    compare_duration and read_time.
        #
        #     If compare_duration is not specified, then the only possible state_change
        #     is "UNUSED",  which will be the state_change set for all assets present at
        #     read_time.
        # @!attribute [rw] field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A field mask to specify the ListAssetsResult fields to be listed in the
        #     response.
        #     An empty field mask will list all fields.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListAssetsResponse`; indicates
        #     that this is a continuation of a prior `ListAssets` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing assets.
        # @!attribute [rw] list_assets_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ListAssetsResponse::ListAssetsResult>]
        #     Assets matching the list request.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used for executing the list request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of assets matching the query.
        class ListAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Result containing the Asset and its State.
          # @!attribute [rw] asset
          #   @return [::Google::Cloud::SecurityCenter::V1::Asset]
          #     Asset matching the search request.
          # @!attribute [rw] state_change
          #   @return [::Google::Cloud::SecurityCenter::V1::ListAssetsResponse::ListAssetsResult::StateChange]
          #     State change of the asset between the points in time.
          class ListAssetsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The change in state of the asset.
            #
            # When querying across two points in time this describes
            # the change between the two points: ADDED, REMOVED, or ACTIVE.
            # If there was no compare_duration supplied in the request the state change
            # will be: UNUSED
            module StateChange
              # State change is unused, this is the canonical default for this enum.
              UNUSED = 0

              # Asset was added between the points in time.
              ADDED = 1

              # Asset was removed between the points in time.
              REMOVED = 2

              # Asset was present at both point(s) in time.
              ACTIVE = 3
            end
          end
        end

        # Request message for listing findings.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the source the findings belong to. Its format is
        #     `organizations/[organization_id]/sources/[source_id]`,
        #     `folders/[folder_id]/sources/[source_id]`, or
        #     `projects/[project_id]/sources/[source_id]`. To list across all sources
        #     provide a source_id of `-`. For example:
        #     `organizations/{organization_id}/sources/-`,
        #     `folders/{folder_id}/sources/-` or `projects/{projects_id}/sources/-`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Expression that defines the filter to apply across findings.
        #     The expression is a list of one or more restrictions combined via logical
        #     operators `AND` and `OR`.
        #     Parentheses are supported, and `OR` has higher precedence than `AND`.
        #
        #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
        #     character in front of them to indicate negation. Examples include:
        #
        #      * name
        #      * source_properties.a_property
        #      * security_marks.marks.marka
        #
        #     The supported operators are:
        #
        #     * `=` for all value types.
        #     * `>`, `<`, `>=`, `<=` for integer values.
        #     * `:`, meaning substring matching, for strings.
        #
        #     The supported value types are:
        #
        #     * string literals in quotes.
        #     * integer literals without quotes.
        #     * boolean literals `true` and `false` without quotes.
        #
        #     The following field and operator combinations are supported:
        #
        #     * name: `=`
        #     * parent: `=`, `:`
        #     * resource_name: `=`, `:`
        #     * state: `=`, `:`
        #     * category: `=`, `:`
        #     * external_uri: `=`, `:`
        #     * event_time: `=`, `>`, `<`, `>=`, `<=`
        #
        #       Usage: This should be milliseconds since epoch or an RFC3339 string.
        #       Examples:
        #         `event_time = "2019-06-10T16:07:18-07:00"`
        #         `event_time = 1560208038000`
        #
        #     * severity: `=`, `:`
        #     * workflow_state: `=`, `:`
        #     * security_marks.marks: `=`, `:`
        #     * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
        #
        #       For example, `source_properties.size = 100` is a valid filter string.
        #
        #       Use a partial match on the empty string to filter based on a property
        #       existing: `source_properties.my_property : ""`
        #
        #       Use a negated partial match on the empty string to filter based on a
        #       property not existing: `-source_properties.my_property : ""`
        #
        #     * resource:
        #       * resource.name: `=`, `:`
        #       * resource.parent_name: `=`, `:`
        #       * resource.parent_display_name: `=`, `:`
        #       * resource.project_name: `=`, `:`
        #       * resource.project_display_name: `=`, `:`
        #       * resource.type: `=`, `:`
        #       * resource.folders.resource_folder: `=`, `:`
        #       * resource.display_name: `=`, `:`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Expression that defines what fields and order to use for sorting. The
        #     string value should follow SQL syntax: comma separated list of fields. For
        #     example: "name,resource_properties.a_property". The default sorting order
        #     is ascending. To specify descending order for a field, a suffix " desc"
        #     should be appended to the field name. For example: "name
        #     desc,source_properties.a_property". Redundant space characters in the
        #     syntax are insignificant. "name desc,source_properties.a_property" and "
        #     name     desc  ,   source_properties.a_property  " are equivalent.
        #
        #     The following fields are supported:
        #     name
        #     parent
        #     state
        #     category
        #     resource_name
        #     event_time
        #     source_properties
        #     security_marks.marks
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used as a reference point when filtering findings. The filter is
        #     limited to findings existing at the supplied time and their values are
        #     those at that specific time. Absence of this field will default to the
        #     API's version of NOW.
        # @!attribute [rw] compare_duration
        #   @return [::Google::Protobuf::Duration]
        #     When compare_duration is set, the ListFindingsResult's "state_change"
        #     attribute is updated to indicate whether the finding had its state changed,
        #     the finding's state remained unchanged, or if the finding was added in any
        #     state during the compare_duration period of time that precedes the
        #     read_time. This is the time between (read_time - compare_duration) and
        #     read_time.
        #
        #     The state_change value is derived based on the presence and state of the
        #     finding at the two points in time. Intermediate state changes between the
        #     two times don't affect the result. For example, the results aren't affected
        #     if the finding is made inactive and then active again.
        #
        #     Possible "state_change" values when compare_duration is specified:
        #
        #     * "CHANGED":   indicates that the finding was present and matched the given
        #                      filter at the start of compare_duration, but changed its
        #                      state at read_time.
        #     * "UNCHANGED": indicates that the finding was present and matched the given
        #                      filter at the start of compare_duration and did not change
        #                      state at read_time.
        #     * "ADDED":     indicates that the finding did not match the given filter or
        #                      was not present at the start of compare_duration, but was
        #                      present at read_time.
        #     * "REMOVED":   indicates that the finding was present and matched the
        #                      filter at the start of compare_duration, but did not match
        #                      the filter at read_time.
        #
        #     If compare_duration is not specified, then the only possible state_change
        #     is "UNUSED", which will be the state_change set for all findings present at
        #     read_time.
        # @!attribute [rw] field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A field mask to specify the Finding fields to be listed in the response.
        #     An empty field mask will list all fields.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListFindingsResponse`; indicates
        #     that this is a continuation of a prior `ListFindings` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in a single response. Default is
        #     10, minimum is 1, maximum is 1000.
        class ListFindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing findings.
        # @!attribute [rw] list_findings_results
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult>]
        #     Findings matching the list request.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time used for executing the list request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of findings matching the query.
        class ListFindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Result containing the Finding and its StateChange.
          # @!attribute [rw] finding
          #   @return [::Google::Cloud::SecurityCenter::V1::Finding]
          #     Finding matching the search request.
          # @!attribute [rw] state_change
          #   @return [::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult::StateChange]
          #     State change of the finding between the points in time.
          # @!attribute [r] resource
          #   @return [::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult::Resource]
          #     Output only. Resource that is associated with this finding.
          class ListFindingsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information related to the Google Cloud resource that is
            # associated with this finding.
            # @!attribute [rw] name
            #   @return [::String]
            #     The full resource name of the resource. See:
            #     https://cloud.google.com/apis/design/resource_names#full_resource_name
            # @!attribute [rw] display_name
            #   @return [::String]
            #     The human readable name of the resource.
            # @!attribute [rw] type
            #   @return [::String]
            #     The full resource type of the resource.
            # @!attribute [rw] project_name
            #   @return [::String]
            #     The full resource name of project that the resource belongs to.
            # @!attribute [rw] project_display_name
            #   @return [::String]
            #     The project ID that the resource belongs to.
            # @!attribute [rw] parent_name
            #   @return [::String]
            #     The full resource name of resource's parent.
            # @!attribute [rw] parent_display_name
            #   @return [::String]
            #     The human readable name of resource's parent.
            # @!attribute [rw] folders
            #   @return [::Array<::Google::Cloud::SecurityCenter::V1::Folder>]
            #     Contains a Folder message for each folder in the assets ancestry.
            #     The first folder is the deepest nested folder, and the last folder is
            #     the folder directly under the Organization.
            # @!attribute [rw] cloud_provider
            #   @return [::Google::Cloud::SecurityCenter::V1::CloudProvider]
            #     Indicates which cloud provider the finding is from.
            # @!attribute [rw] organization
            #   @return [::String]
            #     Indicates which organization / tenant the finding is for.
            # @!attribute [rw] service
            #   @return [::String]
            #     The service or resource provider associated with the resource.
            # @!attribute [rw] location
            #   @return [::String]
            #     The region or location of the service (if applicable).
            # @!attribute [rw] aws_metadata
            #   @return [::Google::Cloud::SecurityCenter::V1::AwsMetadata]
            #     The AWS metadata associated with the finding.
            #
            #     Note: The following fields are mutually exclusive: `aws_metadata`, `azure_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] azure_metadata
            #   @return [::Google::Cloud::SecurityCenter::V1::AzureMetadata]
            #     The Azure metadata associated with the finding.
            #
            #     Note: The following fields are mutually exclusive: `azure_metadata`, `aws_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] resource_path
            #   @return [::Google::Cloud::SecurityCenter::V1::ResourcePath]
            #     Provides the path to the resource within the resource hierarchy.
            # @!attribute [rw] resource_path_string
            #   @return [::String]
            #     A string representation of the resource path.
            #     For Google Cloud, it has the format of
            #     `org/{organization_id}/folder/{folder_id}/folder/{folder_id}/project/{project_id}`
            #     where there can be any number of folders.
            #     For AWS, it has the format of
            #     `org/{organization_id}/ou/{organizational_unit_id}/ou/{organizational_unit_id}/account/{account_id}`
            #     where there can be any number of organizational units.
            #     For Azure, it has the format of
            #     `mg/{management_group_id}/mg/{management_group_id}/subscription/{subscription_id}/rg/{resource_group_name}`
            #     where there can be any number of management groups.
            class Resource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The change in state of the finding.
            #
            # When querying across two points in time this describes
            # the change in the finding between the two points: CHANGED, UNCHANGED,
            # ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
            # the finding at timestamp does not match the filter specified, but it did
            # at timestamp - compare_duration. If there was no compare_duration
            # supplied in the request the state change will be: UNUSED
            module StateChange
              # State change is unused, this is the canonical default for this enum.
              UNUSED = 0

              # The finding has changed state in some way between the points in time
              # and existed at both points.
              CHANGED = 1

              # The finding has not changed state between the points in time and
              # existed at both points.
              UNCHANGED = 2

              # The finding was created between the points in time.
              ADDED = 3

              # The finding at timestamp does not match the filter specified, but it
              # did at timestamp - compare_duration.
              REMOVED = 4
            end
          end
        end

        # Request message for updating a finding's state.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The [relative resource
        #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
        #     of the finding. Example:
        #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
        #     `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
        #     `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::SecurityCenter::V1::Finding::State]
        #     Required. The desired State of the finding.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The time at which the updated state takes effect.
        class SetFindingStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a finding's mute status.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The [relative resource
        #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
        #     of the finding. Example:
        #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
        #     `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
        #     `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
        # @!attribute [rw] mute
        #   @return [::Google::Cloud::SecurityCenter::V1::Finding::Mute]
        #     Required. The desired state of the Mute.
        class SetMuteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for running asset discovery for an organization.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the organization to run asset discovery for. Its format
        #     is `organizations/[organization_id]`.
        class RunAssetDiscoveryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to simulate a CustomConfig against a given test resource.
        # Maximum size of the request is 4 MB by default.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the organization, project, or
        #     folder. For more information about relative resource names, see [Relative
        #     Resource
        #     Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
        #     Example: `organizations/{organization_id}`
        # @!attribute [rw] custom_config
        #   @return [::Google::Cloud::SecurityCenter::V1::CustomConfig]
        #     Required. The custom configuration that you need to test.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource]
        #     Required. Resource data to simulate custom module against.
        class SimulateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Manually constructed resource name. If the custom module evaluates against
          # only the resource data, you can omit the `iam_policy_data` field. If it
          # evaluates only the `iam_policy_data` field, you can omit the resource data.
          # @!attribute [rw] resource_type
          #   @return [::String]
          #     Required. The type of the resource, for example,
          #     `compute.googleapis.com/Disk`.
          # @!attribute [rw] resource_data
          #   @return [::Google::Protobuf::Struct]
          #     Optional. A representation of the Google Cloud resource. Should match the
          #     Google Cloud resource JSON format.
          # @!attribute [rw] iam_policy_data
          #   @return [::Google::Iam::V1::Policy]
          #     Optional. A representation of the IAM policy.
          class SimulatedResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for simulating a `SecurityHealthAnalyticsCustomModule`
        # against a given resource.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse::SimulatedResult]
        #     Result for test case in the corresponding request.
        class SimulateSecurityHealthAnalyticsCustomModuleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible test result.
          # @!attribute [rw] finding
          #   @return [::Google::Cloud::SecurityCenter::V1::Finding]
          #     Finding that would be published for the test case,
          #     if a violation is detected.
          #
          #     Note: The following fields are mutually exclusive: `finding`, `no_violation`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] no_violation
          #   @return [::Google::Protobuf::Empty]
          #     Indicates that the test case does not trigger any violation.
          #
          #     Note: The following fields are mutually exclusive: `no_violation`, `finding`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] error
          #   @return [::Google::Rpc::Status]
          #     Error encountered during the test.
          #
          #     Note: The following fields are mutually exclusive: `error`, `finding`, `no_violation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SimulatedResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for updating a ExternalSystem resource.
        # @!attribute [rw] external_system
        #   @return [::Google::Cloud::SecurityCenter::V1::ExternalSystem]
        #     Required. The external system resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the external system resource.
        #
        #     If empty all mutable fields will be updated.
        class UpdateExternalSystemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating or creating a finding.
        # @!attribute [rw] finding
        #   @return [::Google::Cloud::SecurityCenter::V1::Finding]
        #     Required. The finding resource to update or create if it does not already
        #     exist. parent, security_marks, and update_time will be ignored.
        #
        #     In the case of creation, the finding id portion of the name must be
        #     alphanumeric and less than or equal to 32 characters and greater than 0
        #     characters in length.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the finding resource. This field should
        #     not be specified when creating a finding.
        #
        #     When updating a finding, an empty mask is treated as updating all mutable
        #     fields and replacing source_properties.  Individual source_properties can
        #     be added/updated by using "source_properties.<property key>" in the field
        #     mask.
        class UpdateFindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a mute config.
        # @!attribute [rw] mute_config
        #   @return [::Google::Cloud::SecurityCenter::V1::MuteConfig]
        #     Required. The mute config being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateMuteConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a notification config.
        # @!attribute [rw] notification_config
        #   @return [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
        #     Required. The notification config to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the notification config.
        #
        #     If empty all mutable fields will be updated.
        class UpdateNotificationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating an organization's settings.
        # @!attribute [rw] organization_settings
        #   @return [::Google::Cloud::SecurityCenter::V1::OrganizationSettings]
        #     Required. The organization settings resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the settings resource.
        #
        #     If empty all mutable fields will be updated.
        class UpdateOrganizationSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating Security Health Analytics custom modules.
        # @!attribute [rw] security_health_analytics_custom_module
        #   @return [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
        #     Required. The SecurityHealthAnalytics custom module to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. The only fields that can be updated are
        #     `enablement_state` and `custom_config`. If empty or set to the wildcard
        #     value `*`, both `enablement_state` and `custom_config` are updated.
        class UpdateSecurityHealthAnalyticsCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a source.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::SecurityCenter::V1::Source]
        #     Required. The source resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the source resource.
        #
        #     If empty all mutable fields will be updated.
        class UpdateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a SecurityMarks resource.
        # @!attribute [rw] security_marks
        #   @return [::Google::Cloud::SecurityCenter::V1::SecurityMarks]
        #     Required. The security marks resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The FieldMask to use when updating the security marks resource.
        #
        #     The field mask must not contain duplicate fields.
        #     If empty or set to "marks", all marks will be replaced.  Individual
        #     marks can be updated using "marks.<mark_key>".
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the updated SecurityMarks take effect.
        #     If not set uses current server time.  Updates will be applied to the
        #     SecurityMarks that are active immediately preceding this time. Must be
        #     earlier or equal to the server time.
        class UpdateSecurityMarksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating a BigQuery export.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource of the new BigQuery export. Its
        #     format is `organizations/[organization_id]`, `folders/[folder_id]`, or
        #     `projects/[project_id]`.
        # @!attribute [rw] big_query_export
        #   @return [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
        #     Required. The BigQuery export being created.
        # @!attribute [rw] big_query_export_id
        #   @return [::String]
        #     Required. Unique identifier provided by the client within the parent scope.
        #     It must consist of only lowercase letters, numbers, and hyphens, must start
        #     with a letter, must end with either a letter or a number, and must be 63
        #     characters or less.
        class CreateBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a BigQuery export.
        # @!attribute [rw] big_query_export
        #   @return [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
        #     Required. The BigQuery export being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing BigQuery exports at a given scope e.g.
        # organization, folder or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns the collection of BigQuery exports. Its
        #     format is `organizations/[organization_id]`, `folders/[folder_id]`,
        #     `projects/[project_id]`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of configs to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListBigQueryExports` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListBigQueryExports`
        #     must match the call that provided the page token.
        class ListBigQueryExportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing BigQuery exports.
        # @!attribute [rw] big_query_exports
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::BigQueryExport>]
        #     The BigQuery exports from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListBigQueryExportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a BigQuery export.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the BigQuery export to delete. Its format is
        #     `organizations/{organization}/bigQueryExports/{export_id}`,
        #     `folders/{folder}/bigQueryExports/{export_id}`, or
        #     `projects/{project}/bigQueryExports/{export_id}`
        class DeleteBigQueryExportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create an Event Threat Detection custom module.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The new custom module's parent.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings`.
        #       * `folders/{folder}/eventThreatDetectionSettings`.
        #       * `projects/{project}/eventThreatDetectionSettings`.
        # @!attribute [rw] event_threat_detection_custom_module
        #   @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
        #     Required. The module to create. The
        #     event_threat_detection_custom_module.name will be ignored and server
        #     generated.
        class CreateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to validate an Event Threat Detection custom module.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent to validate the Custom Module under.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings`.
        #       * `folders/{folder}/eventThreatDetectionSettings`.
        #       * `projects/{project}/eventThreatDetectionSettings`.
        # @!attribute [rw] raw_text
        #   @return [::String]
        #     Required. The raw text of the module's contents. Used to generate error
        #     messages.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
        class ValidateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to validating an Event Threat Detection custom module.
        # @!attribute [rw] errors
        #   @return [::Google::Cloud::SecurityCenter::V1::CustomModuleValidationErrors]
        #     A list of errors returned by the validator. If the list is empty, there
        #     were no errors.
        class ValidateEventThreatDetectionCustomModuleResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete an Event Threat Detection custom module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the custom module to delete.
        #
        #     Its format is:
        #
        #     * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
        #     * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
        #     * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
        class DeleteEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get an Event Threat Detection custom module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the custom module to get.
        #
        #     Its format is:
        #
        #     * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
        #     * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
        #     * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
        class GetEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list current and descendant resident Event Threat Detection custom
        # modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent to list custom modules under.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings`.
        #       * `folders/{folder}/eventThreatDetectionSettings`.
        #       * `projects/{project}/eventThreatDetectionSettings`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `ListDescendantEventThreatDetectionCustomModules` call. Provide this to
        #     retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDescendantEventThreatDetectionCustomModules` must match the call that
        #     provided the page token.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of modules to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        class ListDescendantEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing current and descendant resident
        # Event Threat Detection custom modules.
        # @!attribute [rw] event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
        #     Custom modules belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDescendantEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list Event Threat Detection custom modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent to list custom modules under.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings`.
        #       * `folders/{folder}/eventThreatDetectionSettings`.
        #       * `projects/{project}/eventThreatDetectionSettings`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListEventThreatDetectionCustomModules` must match the call that provided
        #     the page token.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of modules to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        class ListEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing Event Threat Detection custom modules.
        # @!attribute [rw] event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
        #     Custom modules belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update an Event Threat Detection custom module.
        # @!attribute [rw] event_threat_detection_custom_module
        #   @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
        #     Required. The module being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     If empty all mutable fields will be updated.
        class UpdateEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get an EffectiveEventThreatDetectionCustomModule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the effective Event Threat Detection custom
        #     module.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
        #       * `folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
        #       * `projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
        class GetEffectiveEventThreatDetectionCustomModuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list effective Event Threat Detection custom modules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent to list custom modules for.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings`.
        #       * `folders/{folder}/eventThreatDetectionSettings`.
        #       * `projects/{project}/eventThreatDetectionSettings`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `ListEffectiveEventThreatDetectionCustomModules` call. Provide this to
        #     retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListEffectiveEventThreatDetectionCustomModules` must match the call that
        #     provided the page token.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of modules to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 10 configs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        class ListEffectiveEventThreatDetectionCustomModulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing EffectiveEventThreatDetectionCustomModules.
        # @!attribute [rw] effective_event_threat_detection_custom_modules
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule>]
        #     Effective custom modules belonging to the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListEffectiveEventThreatDetectionCustomModulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
