# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Defines the properties in a custom module configuration for Security
        # Health Analytics. Use the custom module configuration to create custom
        # detectors that generate custom findings for resources that you specify.
        # @!attribute [rw] predicate
        #   @return [::Google::Type::Expr]
        #     The CEL expression to evaluate to produce findings. When the expression
        #     evaluates to true against a resource, a finding is generated.
        # @!attribute [rw] custom_output
        #   @return [::Google::Cloud::SecurityCenter::V1::CustomConfig::CustomOutputSpec]
        #     Custom output properties.
        # @!attribute [rw] resource_selector
        #   @return [::Google::Cloud::SecurityCenter::V1::CustomConfig::ResourceSelector]
        #     The resource types that the custom module operates on. Each custom module
        #     can specify up to 5 resource types.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::SecurityCenter::V1::CustomConfig::Severity]
        #     The severity to assign to findings generated by the module.
        # @!attribute [rw] description
        #   @return [::String]
        #     Text that describes the vulnerability or misconfiguration that the custom
        #     module detects. This explanation is returned with each finding instance to
        #     help investigators understand the detected issue. The text must be enclosed
        #     in quotation marks.
        # @!attribute [rw] recommendation
        #   @return [::String]
        #     An explanation of the recommended steps that security teams can take to
        #     resolve the detected issue. This explanation is returned with each finding
        #     generated by this module in the `nextSteps` property of the finding JSON.
        class CustomConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A set of optional name-value pairs that define custom source properties to
          # return with each finding that is generated by the custom module. The custom
          # source properties that are defined here are included in the finding JSON
          # under `sourceProperties`.
          # @!attribute [rw] properties
          #   @return [::Array<::Google::Cloud::SecurityCenter::V1::CustomConfig::CustomOutputSpec::Property>]
          #     A list of custom output properties to add to the finding.
          class CustomOutputSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An individual name-value pair that defines a custom source property.
            # @!attribute [rw] name
            #   @return [::String]
            #     Name of the property for the custom output.
            # @!attribute [rw] value_expression
            #   @return [::Google::Type::Expr]
            #     The CEL expression for the custom output. A resource property can be
            #     specified to return the value of the property or a text string enclosed
            #     in quotation marks.
            class Property
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Resource for selecting resource type.
          # @!attribute [rw] resource_types
          #   @return [::Array<::String>]
          #     The resource types to run the detector on.
          class ResourceSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the valid value options for the severity of a finding.
          module Severity
            # Unspecified severity.
            SEVERITY_UNSPECIFIED = 0

            # Critical severity.
            CRITICAL = 1

            # High severity.
            HIGH = 2

            # Medium severity.
            MEDIUM = 3

            # Low severity.
            LOW = 4
          end
        end
      end
    end
  end
end
