# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Information related to the Google Cloud resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     The full resource name of the resource. See:
        #     https://cloud.google.com/apis/design/resource_names#full_resource_name
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The human readable name of the resource.
        # @!attribute [rw] type
        #   @return [::String]
        #     The full resource type of the resource.
        # @!attribute [rw] project
        #   @return [::String]
        #     The full resource name of project that the resource belongs to.
        # @!attribute [rw] project_display_name
        #   @return [::String]
        #     The project ID that the resource belongs to.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The full resource name of resource's parent.
        # @!attribute [rw] parent_display_name
        #   @return [::String]
        #     The human readable name of resource's parent.
        # @!attribute [r] folders
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::Folder>]
        #     Output only. Contains a Folder message for each folder in the assets
        #     ancestry. The first folder is the deepest nested folder, and the last
        #     folder is the folder directly under the Organization.
        # @!attribute [rw] cloud_provider
        #   @return [::Google::Cloud::SecurityCenter::V1::CloudProvider]
        #     Indicates which cloud provider the resource resides in.
        # @!attribute [rw] organization
        #   @return [::String]
        #     Indicates which organization or tenant in the cloud provider the finding
        #     applies to.
        # @!attribute [rw] service
        #   @return [::String]
        #     The parent service or product from which the resource is provided, for
        #     example, GKE or SNS.
        # @!attribute [rw] location
        #   @return [::String]
        #     The region or location of the service (if applicable).
        # @!attribute [rw] aws_metadata
        #   @return [::Google::Cloud::SecurityCenter::V1::AwsMetadata]
        #     The AWS metadata associated with the finding.
        #
        #     Note: The following fields are mutually exclusive: `aws_metadata`, `azure_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure_metadata
        #   @return [::Google::Cloud::SecurityCenter::V1::AzureMetadata]
        #     The Azure metadata associated with the finding.
        #
        #     Note: The following fields are mutually exclusive: `azure_metadata`, `aws_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resource_path
        #   @return [::Google::Cloud::SecurityCenter::V1::ResourcePath]
        #     Provides the path to the resource within the resource hierarchy.
        # @!attribute [rw] resource_path_string
        #   @return [::String]
        #     A string representation of the resource path.
        #     For Google Cloud, it has the format of
        #     `organizations/{organization_id}/folders/{folder_id}/folders/{folder_id}/projects/{project_id}`
        #     where there can be any number of folders.
        #     For AWS, it has the format of
        #     `org/{organization_id}/ou/{organizational_unit_id}/ou/{organizational_unit_id}/account/{account_id}`
        #     where there can be any number of organizational units.
        #     For Azure, it has the format of
        #     `mg/{management_group_id}/mg/{management_group_id}/subscription/{subscription_id}/rg/{resource_group_name}`
        #     where there can be any number of management groups.
        class Resource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AWS metadata associated with the resource, only applicable if the finding's
        # cloud provider is Amazon Web Services.
        # @!attribute [rw] organization
        #   @return [::Google::Cloud::SecurityCenter::V1::AwsMetadata::AwsOrganization]
        #     The AWS organization associated with the resource.
        # @!attribute [rw] organizational_units
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::AwsMetadata::AwsOrganizationalUnit>]
        #     A list of AWS organizational units associated with the resource, ordered
        #     from lowest level (closest to the account) to highest level.
        # @!attribute [rw] account
        #   @return [::Google::Cloud::SecurityCenter::V1::AwsMetadata::AwsAccount]
        #     The AWS account associated with the resource.
        class AwsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An organization is a collection of accounts that are centrally managed
          # together using consolidated billing, organized hierarchically with
          # organizational units (OUs), and controlled with policies.
          # @!attribute [rw] id
          #   @return [::String]
          #     The unique identifier (ID) for the organization. The regex pattern for an
          #     organization ID string requires "o-" followed by from 10 to 32 lowercase
          #     letters or digits.
          class AwsOrganization
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An Organizational Unit (OU) is a container of AWS accounts within a root of
          # an organization. Policies that are attached to an OU apply to all accounts
          # contained in that OU and in any child OUs.
          # @!attribute [rw] id
          #   @return [::String]
          #     The unique identifier (ID) associated with this OU. The regex pattern for
          #     an organizational unit ID string requires "ou-" followed by from 4 to 32
          #     lowercase letters or digits (the ID of the root that contains the OU).
          #     This string is followed by a second "-" dash and from 8 to 32 additional
          #     lowercase letters or digits. For example, "ou-ab12-cd34ef56".
          # @!attribute [rw] name
          #   @return [::String]
          #     The friendly name of the OU.
          class AwsOrganizationalUnit
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An AWS account that is a member of an organization.
          # @!attribute [rw] id
          #   @return [::String]
          #     The unique identifier (ID) of the account, containing exactly 12 digits.
          # @!attribute [rw] name
          #   @return [::String]
          #     The friendly name of this account.
          class AwsAccount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Azure metadata associated with the resource, only applicable if the finding's
        # cloud provider is Microsoft Azure.
        # @!attribute [rw] management_groups
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::AzureMetadata::AzureManagementGroup>]
        #     A list of Azure management groups associated with the resource, ordered
        #     from lowest level (closest to the subscription) to highest level.
        # @!attribute [rw] subscription
        #   @return [::Google::Cloud::SecurityCenter::V1::AzureMetadata::AzureSubscription]
        #     The Azure subscription associated with the resource.
        # @!attribute [rw] resource_group
        #   @return [::Google::Cloud::SecurityCenter::V1::AzureMetadata::AzureResourceGroup]
        #     The Azure resource group associated with the resource.
        class AzureMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents an Azure management group.
          # @!attribute [rw] id
          #   @return [::String]
          #     The UUID of the Azure management group, for example,
          #     `20000000-0001-0000-0000-000000000000`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the Azure management group.
          class AzureManagementGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents an Azure subscription.
          # @!attribute [rw] id
          #   @return [::String]
          #     The UUID of the Azure subscription, for example,
          #     `291bba3f-e0a5-47bc-a099-3bdcb2a50a05`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the Azure subscription.
          class AzureSubscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents an Azure resource group.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the Azure resource group. This is not a UUID.
          class AzureResourceGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents the path of resources leading up to the resource this finding is
        # about.
        # @!attribute [rw] nodes
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ResourcePath::ResourcePathNode>]
        #     The list of nodes that make the up resource path, ordered from lowest
        #     level to highest level.
        class ResourcePath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A node within the resource path. Each node represents a resource within the
          # resource hierarchy.
          # @!attribute [rw] node_type
          #   @return [::Google::Cloud::SecurityCenter::V1::ResourcePath::ResourcePathNodeType]
          #     The type of resource this node represents.
          # @!attribute [rw] id
          #   @return [::String]
          #     The ID of the resource this node represents.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the resource this node represents.
          class ResourcePathNode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of resource the node represents.
          module ResourcePathNodeType
            # Node type is unspecified.
            RESOURCE_PATH_NODE_TYPE_UNSPECIFIED = 0

            # The node represents a Google Cloud organization.
            GCP_ORGANIZATION = 1

            # The node represents a Google Cloud folder.
            GCP_FOLDER = 2

            # The node represents a Google Cloud project.
            GCP_PROJECT = 3

            # The node represents an AWS organization.
            AWS_ORGANIZATION = 4

            # The node represents an AWS organizational unit.
            AWS_ORGANIZATIONAL_UNIT = 5

            # The node represents an AWS account.
            AWS_ACCOUNT = 6

            # The node represents an Azure management group.
            AZURE_MANAGEMENT_GROUP = 7

            # The node represents an Azure subscription.
            AZURE_SUBSCRIPTION = 8

            # The node represents an Azure resource group.
            AZURE_RESOURCE_GROUP = 9
          end
        end

        # Enumeration representing the various cloud providers a finding's resource
        # could reside in.
        module CloudProvider
          # The cloud provider is unspecified.
          CLOUD_PROVIDER_UNSPECIFIED = 0

          # The cloud provider is Google Cloud Platform.
          GOOGLE_CLOUD_PLATFORM = 1

          # The cloud provider is Amazon Web Services.
          AMAZON_WEB_SERVICES = 2

          # The cloud provider is Microsoft Azure.
          MICROSOFT_AZURE = 3
        end
      end
    end
  end
end
