# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Exfiltration represents a data exfiltration attempt from one or more sources
        # to one or more targets. The `sources` attribute lists the sources of the
        # exfiltrated data. The `targets` attribute lists the destinations the data was
        # copied to.
        # @!attribute [rw] sources
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ExfilResource>]
        #     If there are multiple sources, then the data is considered "joined" between
        #     them. For instance, BigQuery can join multiple tables, and each
        #     table would be considered a source.
        # @!attribute [rw] targets
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::ExfilResource>]
        #     If there are multiple targets, each target would get a complete copy of the
        #     "joined" source data.
        # @!attribute [rw] total_exfiltrated_bytes
        #   @return [::Integer]
        #     Total exfiltrated bytes processed for the entire job.
        class Exfiltration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Resource where data was exfiltrated from or exfiltrated to.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource's [full resource
        #     name](https://cloud.google.com/apis/design/resource_names#full_resource_name).
        # @!attribute [rw] components
        #   @return [::Array<::String>]
        #     Subcomponents of the asset that was exfiltrated, like URIs used during
        #     exfiltration, table names, databases, and filenames. For example, multiple
        #     tables might have been exfiltrated from the same Cloud SQL instance, or
        #     multiple files might have been exfiltrated from the same Cloud Storage
        #     bucket.
        class ExfilResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
