# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # A list of zero or more errors encountered while validating the uploaded
        # configuration of an Event Threat Detection Custom Module.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::SecurityCenter::V1::CustomModuleValidationError>]
        class CustomModuleValidationErrors
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An error encountered while validating the uploaded configuration of an
        # Event Threat Detection Custom Module.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the error, suitable for human consumption. Required.
        # @!attribute [rw] field_path
        #   @return [::String]
        #     The path, in RFC 8901 JSON Pointer format, to the field that failed
        #     validation. This may be left empty if no specific field is affected.
        # @!attribute [rw] start
        #   @return [::Google::Cloud::SecurityCenter::V1::Position]
        #     The initial position of the error in the uploaded text version of the
        #     module. This field may be omitted if no specific position applies, or if
        #     one could not be computed.
        # @!attribute [rw] end
        #   @return [::Google::Cloud::SecurityCenter::V1::Position]
        #     The end position of the error in the uploaded text version of the
        #     module. This field may be omitted if no specific position applies, or if
        #     one could not be computed..
        class CustomModuleValidationError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A position in the uploaded text version of a module.
        # @!attribute [rw] line_number
        #   @return [::Integer]
        # @!attribute [rw] column_number
        #   @return [::Integer]
        class Position
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
