# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecurityCenter
      module V1
        # Represents an instance of an Event Threat Detection custom module,
        # including its full module name, display name, enablement state, and last
        # updated time. You can create a custom module at the organization, folder, or
        # project level. Custom modules that you create at the organization or folder
        # level are inherited by child folders and projects.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name of the Event Threat Detection custom module.
        #
        #     Its format is:
        #
        #       * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
        #       * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
        #       * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
        # @!attribute [rw] config
        #   @return [::Google::Protobuf::Struct]
        #     Config for the module. For the resident module, its config value is defined
        #     at this level. For the inherited module, its config value is inherited from
        #     the ancestor module.
        # @!attribute [r] ancestor_module
        #   @return [::String]
        #     Output only. The closest ancestor module that this module inherits the
        #     enablement state from. The format is the same as the
        #     EventThreatDetectionCustomModule resource name.
        # @!attribute [rw] enablement_state
        #   @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule::EnablementState]
        #     The state of enablement for the module at the given level of the hierarchy.
        # @!attribute [rw] type
        #   @return [::String]
        #     Type for the module. e.g. CONFIGURABLE_BAD_IP.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The human readable name to be displayed for the module.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description for the module.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the module was last updated.
        # @!attribute [r] last_editor
        #   @return [::String]
        #     Output only. The editor the module was last updated by.
        class EventThreatDetectionCustomModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enablement state of the module.
          module EnablementState
            # Unspecified enablement state.
            ENABLEMENT_STATE_UNSPECIFIED = 0

            # The module is enabled at the given level.
            ENABLED = 1

            # The module is disabled at the given level.
            DISABLED = 2

            # When the enablement state is inherited.
            INHERITED = 3
          end
        end
      end
    end
  end
end
