# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/securitycenter/v1/securitycenter_service_pb"

module Google
  module Cloud
    module SecurityCenter
      module V1
        module SecurityCenter
          ##
          # Client for the SecurityCenter service.
          #
          # V1 APIs for Security Center service.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "securitycenter.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :security_center_stub

            ##
            # Configure the SecurityCenter Client class.
            #
            # See {::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SecurityCenter clients
            #   ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "SecurityCenter", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.create_source.timeout = 60.0

                default_config.rpcs.create_finding.timeout = 60.0

                default_config.rpcs.create_notification_config.timeout = 60.0

                default_config.rpcs.delete_notification_config.timeout = 60.0

                default_config.rpcs.delete_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.get_iam_policy.timeout = 60.0
                default_config.rpcs.get_iam_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_notification_config.timeout = 60.0
                default_config.rpcs.get_notification_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_organization_settings.timeout = 60.0
                default_config.rpcs.get_organization_settings.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_effective_security_health_analytics_custom_module.timeout = 60.0
                default_config.rpcs.get_effective_security_health_analytics_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_security_health_analytics_custom_module.timeout = 60.0
                default_config.rpcs.get_security_health_analytics_custom_module.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_source.timeout = 60.0
                default_config.rpcs.get_source.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.group_assets.timeout = 480.0
                default_config.rpcs.group_assets.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.group_findings.timeout = 480.0
                default_config.rpcs.group_findings.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_assets.timeout = 480.0
                default_config.rpcs.list_assets.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_descendant_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_descendant_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_findings.timeout = 480.0
                default_config.rpcs.list_findings.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_notification_configs.timeout = 60.0
                default_config.rpcs.list_notification_configs.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_effective_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_effective_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_security_health_analytics_custom_modules.timeout = 60.0
                default_config.rpcs.list_security_health_analytics_custom_modules.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_sources.timeout = 60.0
                default_config.rpcs.list_sources.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.run_asset_discovery.timeout = 60.0

                default_config.rpcs.set_finding_state.timeout = 60.0

                default_config.rpcs.set_iam_policy.timeout = 60.0

                default_config.rpcs.test_iam_permissions.timeout = 60.0
                default_config.rpcs.test_iam_permissions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_finding.timeout = 60.0

                default_config.rpcs.update_notification_config.timeout = 60.0

                default_config.rpcs.update_organization_settings.timeout = 60.0

                default_config.rpcs.update_security_health_analytics_custom_module.timeout = 60.0

                default_config.rpcs.update_source.timeout = 60.0

                default_config.rpcs.update_security_marks.timeout = 480.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SecurityCenter Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @security_center_stub.universe_domain
            end

            ##
            # Create a new SecurityCenter client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SecurityCenter client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/securitycenter/v1/securitycenter_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @security_center_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @security_center_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SecurityCenter::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @security_center_stub.logger
            end

            # Service calls

            ##
            # Kicks off an LRO to bulk mute findings for a parent based on a filter. The
            # parent can be either an organization, folder or project. The findings
            # matched by the filter will be muted after the LRO is done.
            #
            # @overload bulk_mute_findings(request, options = nil)
            #   Pass arguments to `bulk_mute_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload bulk_mute_findings(parent: nil, filter: nil, mute_annotation: nil, mute_state: nil)
            #   Pass arguments to `bulk_mute_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, at which bulk action needs to be applied. Its format
            #     is `organizations/[organization_id]`, `folders/[folder_id]`,
            #     `projects/[project_id]`.
            #   @param filter [::String]
            #     Expression that identifies findings that should be updated.
            #     The expression is a list of zero or more restrictions combined
            #     via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
            #     has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a
            #     `-` character in front of them to indicate negation. The fields map to
            #     those defined in the corresponding resource.
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #   @param mute_annotation [::String]
            #     This can be a mute configuration name or any identifier for mute/unmute
            #     of findings based on the filter.
            #   @param mute_state [::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest::MuteState]
            #     Optional. All findings matching the given filter will have their mute state
            #     set to this value. The default value is `MUTED`. Setting this to
            #     `UNDEFINED` will clear the mute state on all matching findings.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest.new
            #
            #   # Call the bulk_mute_findings method.
            #   result = client.bulk_mute_findings request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def bulk_mute_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::BulkMuteFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.bulk_mute_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.bulk_mute_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.bulk_mute_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :bulk_mute_findings, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
            # given CRM parent, and also creates inherited
            # SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
            # parent. These modules are enabled by default.
            #
            # @overload create_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `create_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_security_health_analytics_custom_module(parent: nil, security_health_analytics_custom_module: nil)
            #   Pass arguments to `create_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new custom module's parent. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings`,
            #     `folders/{folder}/securityHealthAnalyticsSettings`, or
            #     `projects/{project}/securityHealthAnalyticsSettings`
            #   @param security_health_analytics_custom_module [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule, ::Hash]
            #     Required. SecurityHealthAnalytics custom module to create. The provided
            #     name is ignored and reset with provided parent information and
            #     server-generated ID.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the create_security_health_analytics_custom_module method.
            #   result = client.create_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def create_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a source.
            #
            # @overload create_source(request, options = nil)
            #   Pass arguments to `create_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_source(parent: nil, source: nil)
            #   Pass arguments to `create_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new source's parent. Its format should be
            #     `organizations/[organization_id]`.
            #   @param source [::Google::Cloud::SecurityCenter::V1::Source, ::Hash]
            #     Required. The Source being created, only the display_name and description
            #     will be used. All other fields will be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateSourceRequest.new
            #
            #   # Call the create_source method.
            #   result = client.create_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Source.
            #   p result
            #
            def create_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a finding. The corresponding source must exist for finding creation
            # to succeed.
            #
            # @overload create_finding(request, options = nil)
            #   Pass arguments to `create_finding` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateFindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateFindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_finding(parent: nil, finding_id: nil, finding: nil)
            #   Pass arguments to `create_finding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new finding's parent. Its format should be
            #     `organizations/[organization_id]/sources/[source_id]`.
            #   @param finding_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must be alphanumeric and less than or equal to 32 characters and
            #     greater than 0 characters in length.
            #   @param finding [::Google::Cloud::SecurityCenter::V1::Finding, ::Hash]
            #     Required. The Finding being created. The name and security_marks will be
            #     ignored as they are both output only fields on this resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateFindingRequest.new
            #
            #   # Call the create_finding method.
            #   result = client.create_finding request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Finding.
            #   p result
            #
            def create_finding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateFindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_finding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_finding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_finding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_finding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a mute config.
            #
            # @overload create_mute_config(request, options = nil)
            #   Pass arguments to `create_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_mute_config(parent: nil, mute_config: nil, mute_config_id: nil)
            #   Pass arguments to `create_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new mute configs's parent. Its format is
            #     `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param mute_config [::Google::Cloud::SecurityCenter::V1::MuteConfig, ::Hash]
            #     Required. The mute config being created.
            #   @param mute_config_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must consist of only lowercase letters, numbers, and hyphens, must start
            #     with a letter, must end with either a letter or a number, and must be 63
            #     characters or less.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest.new
            #
            #   # Call the create_mute_config method.
            #   result = client.create_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::MuteConfig.
            #   p result
            #
            def create_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a notification config.
            #
            # @overload create_notification_config(request, options = nil)
            #   Pass arguments to `create_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_notification_config(parent: nil, config_id: nil, notification_config: nil)
            #   Pass arguments to `create_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new notification config's parent. Its format
            #     is `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param config_id [::String]
            #     Required.
            #     Unique identifier provided by the client within the parent scope.
            #     It must be between 1 and 128 characters and contain alphanumeric
            #     characters, underscores, or hyphens only.
            #   @param notification_config [::Google::Cloud::SecurityCenter::V1::NotificationConfig, ::Hash]
            #     Required. The notification config being created. The name and the service
            #     account will be ignored as they are both output only fields on this
            #     resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest.new
            #
            #   # Call the create_notification_config method.
            #   result = client.create_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::NotificationConfig.
            #   p result
            #
            def create_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing mute config.
            #
            # @overload delete_mute_config(request, options = nil)
            #   Pass arguments to `delete_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_mute_config(name: nil)
            #   Pass arguments to `delete_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mute config to delete. Its format is
            #     `organizations/{organization}/muteConfigs/{config_id}`,
            #     `folders/{folder}/muteConfigs/{config_id}`,
            #     `projects/{project}/muteConfigs/{config_id}`,
            #     `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
            #     `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
            #     `projects/{project}/locations/global/muteConfigs/{config_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest.new
            #
            #   # Call the delete_mute_config method.
            #   result = client.delete_mute_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a notification config.
            #
            # @overload delete_notification_config(request, options = nil)
            #   Pass arguments to `delete_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_notification_config(name: nil)
            #   Pass arguments to `delete_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the notification config to delete. Its format is
            #     `organizations/[organization_id]/notificationConfigs/[config_id]`,
            #     `folders/[folder_id]/notificationConfigs/[config_id]`,
            #     or `projects/[project_id]/notificationConfigs/[config_id]`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest.new
            #
            #   # Call the delete_notification_config method.
            #   result = client.delete_notification_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
            # descendants in the CRM hierarchy. This method is only supported for
            # resident custom modules.
            #
            # @overload delete_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `delete_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_security_health_analytics_custom_module(name: nil)
            #   Pass arguments to `delete_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the custom module to delete. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
            #     `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
            #     or
            #     `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the delete_security_health_analytics_custom_module method.
            #   result = client.delete_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the simulation by name or the latest simulation for the given
            # organization.
            #
            # @overload get_simulation(request, options = nil)
            #   Pass arguments to `get_simulation` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetSimulationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetSimulationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_simulation(name: nil)
            #   Pass arguments to `get_simulation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The organization name or simulation name of this simulation
            #
            #     Valid format:
            #     `organizations/{organization}/simulations/latest`
            #     `organizations/{organization}/simulations/{simulation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Simulation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Simulation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetSimulationRequest.new
            #
            #   # Call the get_simulation method.
            #   result = client.get_simulation request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Simulation.
            #   p result
            #
            def get_simulation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetSimulationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_simulation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_simulation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_simulation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_simulation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the valued resource by name
            #
            # @overload get_valued_resource(request, options = nil)
            #   Pass arguments to `get_valued_resource` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_valued_resource(name: nil)
            #   Pass arguments to `get_valued_resource` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of this valued resource
            #
            #     Valid format:
            #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::ValuedResource]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::ValuedResource]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest.new
            #
            #   # Call the get_valued_resource method.
            #   result = client.get_valued_resource request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::ValuedResource.
            #   p result
            #
            def get_valued_resource request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetValuedResourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_valued_resource.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_valued_resource.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_valued_resource.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_valued_resource, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a BigQuery export.
            #
            # @overload get_big_query_export(request, options = nil)
            #   Pass arguments to `get_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_big_query_export(name: nil)
            #   Pass arguments to `get_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the BigQuery export to retrieve. Its format is
            #     `organizations/{organization}/bigQueryExports/{export_id}`,
            #     `folders/{folder}/bigQueryExports/{export_id}`, or
            #     `projects/{project}/bigQueryExports/{export_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest.new
            #
            #   # Call the get_big_query_export method.
            #   result = client.get_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::BigQueryExport.
            #   p result
            #
            def get_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the access control policy on the specified Source.
            #
            # @overload get_iam_policy(request, options = nil)
            #   Pass arguments to `get_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_iam_policy(resource: nil, options: nil)
            #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
            #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
            #     `GetIamPolicy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::GetIamPolicyRequest.new
            #
            #   # Call the get_iam_policy method.
            #   result = client.get_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def get_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a mute config.
            #
            # @overload get_mute_config(request, options = nil)
            #   Pass arguments to `get_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_mute_config(name: nil)
            #   Pass arguments to `get_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mute config to retrieve. Its format is
            #     `organizations/{organization}/muteConfigs/{config_id}`,
            #     `folders/{folder}/muteConfigs/{config_id}`,
            #     `projects/{project}/muteConfigs/{config_id}`,
            #     `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
            #     `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
            #     `projects/{project}/locations/global/muteConfigs/{config_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest.new
            #
            #   # Call the get_mute_config method.
            #   result = client.get_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::MuteConfig.
            #   p result
            #
            def get_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a notification config.
            #
            # @overload get_notification_config(request, options = nil)
            #   Pass arguments to `get_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_notification_config(name: nil)
            #   Pass arguments to `get_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the notification config to get. Its format is
            #     `organizations/[organization_id]/notificationConfigs/[config_id]`,
            #     `folders/[folder_id]/notificationConfigs/[config_id]`,
            #     or `projects/[project_id]/notificationConfigs/[config_id]`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest.new
            #
            #   # Call the get_notification_config method.
            #   result = client.get_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::NotificationConfig.
            #   p result
            #
            def get_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the settings for an organization.
            #
            # @overload get_organization_settings(request, options = nil)
            #   Pass arguments to `get_organization_settings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_organization_settings(name: nil)
            #   Pass arguments to `get_organization_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the organization to get organization settings for. Its
            #     format is `organizations/[organization_id]/organizationSettings`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::OrganizationSettings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::OrganizationSettings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest.new
            #
            #   # Call the get_organization_settings method.
            #   result = client.get_organization_settings request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::OrganizationSettings.
            #   p result
            #
            def get_organization_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetOrganizationSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_organization_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_organization_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_organization_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_organization_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
            #
            # @overload get_effective_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `get_effective_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_effective_security_health_analytics_custom_module(name: nil)
            #   Pass arguments to `get_effective_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the effective custom module to get. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
            #     `folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
            #     or
            #     `projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the get_effective_security_health_analytics_custom_module method.
            #   result = client.get_effective_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def get_effective_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetEffectiveSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_effective_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_effective_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_effective_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_effective_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a SecurityHealthAnalyticsCustomModule.
            #
            # @overload get_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `get_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_security_health_analytics_custom_module(name: nil)
            #   Pass arguments to `get_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the custom module to get. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
            #     `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
            #     or
            #     `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the get_security_health_analytics_custom_module method.
            #   result = client.get_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def get_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a source.
            #
            # @overload get_source(request, options = nil)
            #   Pass arguments to `get_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_source(name: nil)
            #   Pass arguments to `get_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Relative resource name of the source. Its format is
            #     `organizations/[organization_id]/source/[source_id]`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetSourceRequest.new
            #
            #   # Call the get_source method.
            #   result = client.get_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Source.
            #   p result
            #
            def get_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Filters an organization's assets and  groups them by their specified
            # properties.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload group_assets(request, options = nil)
            #   Pass arguments to `group_assets` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload group_assets(parent: nil, filter: nil, group_by: nil, compare_duration: nil, read_time: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `group_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent to group the assets by. Its format is
            #     `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param filter [::String]
            #     Expression that defines the filter to apply across assets.
            #     The expression is a list of zero or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. The fields map to those
            #     defined in the Asset resource. Examples include:
            #
            #     * name
            #     * security_center_properties.resource_name
            #     * resource_properties.a_property
            #     * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following field and operator combinations are supported:
            #
            #     * name: `=`
            #     * update_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `update_time = "2019-06-10T16:07:18-07:00"`
            #         `update_time = 1560208038000`
            #
            #     * create_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `create_time = "2019-06-10T16:07:18-07:00"`
            #         `create_time = 1560208038000`
            #
            #     * iam_policy.policy_blob: `=`, `:`
            #     * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
            #     * security_marks.marks: `=`, `:`
            #     * security_center_properties.resource_name: `=`, `:`
            #     * security_center_properties.resource_display_name: `=`, `:`
            #     * security_center_properties.resource_type: `=`, `:`
            #     * security_center_properties.resource_parent: `=`, `:`
            #     * security_center_properties.resource_parent_display_name: `=`, `:`
            #     * security_center_properties.resource_project: `=`, `:`
            #     * security_center_properties.resource_project_display_name: `=`, `:`
            #     * security_center_properties.resource_owners: `=`, `:`
            #
            #     For example, `resource_properties.size = 100` is a valid filter string.
            #
            #     Use a partial match on the empty string to filter based on a property
            #     existing: `resource_properties.my_property : ""`
            #
            #     Use a negated partial match on the empty string to filter based on a
            #     property not existing: `-resource_properties.my_property : ""`
            #   @param group_by [::String]
            #     Required. Expression that defines what assets fields to use for grouping.
            #     The string value should follow SQL syntax: comma separated list of fields.
            #     For example:
            #     "security_center_properties.resource_project,security_center_properties.project".
            #
            #     The following fields are supported when compare_duration is not set:
            #
            #     * security_center_properties.resource_project
            #     * security_center_properties.resource_project_display_name
            #     * security_center_properties.resource_type
            #     * security_center_properties.resource_parent
            #     * security_center_properties.resource_parent_display_name
            #
            #     The following fields are supported when compare_duration is set:
            #
            #     * security_center_properties.resource_type
            #     * security_center_properties.resource_project_display_name
            #     * security_center_properties.resource_parent_display_name
            #   @param compare_duration [::Google::Protobuf::Duration, ::Hash]
            #     When compare_duration is set, the GroupResult's "state_change" property is
            #     updated to indicate whether the asset was added, removed, or remained
            #     present during the compare_duration period of time that precedes the
            #     read_time. This is the time between (read_time - compare_duration) and
            #     read_time.
            #
            #     The state change value is derived based on the presence of the asset at the
            #     two points in time. Intermediate state changes between the two times don't
            #     affect the result. For example, the results aren't affected if the asset is
            #     removed and re-created again.
            #
            #     Possible "state_change" values when compare_duration is specified:
            #
            #     * "ADDED":   indicates that the asset was not present at the start of
            #                    compare_duration, but present at reference_time.
            #     * "REMOVED": indicates that the asset was present at the start of
            #                    compare_duration, but not present at reference_time.
            #     * "ACTIVE":  indicates that the asset was present at both the
            #                    start and the end of the time period defined by
            #                    compare_duration and reference_time.
            #
            #     If compare_duration is not specified, then the only possible state_change
            #     is "UNUSED", which will be the state_change set for all assets present at
            #     read_time.
            #
            #     If this field is set then `state_change` must be a specified field in
            #     `group_by`.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Time used as a reference point when filtering assets. The filter is limited
            #     to assets existing at the supplied time and their values are those at that
            #     specific time. Absence of this field will default to the API's version of
            #     NOW.
            #   @param page_token [::String]
            #     The value returned by the last `GroupAssetsResponse`; indicates
            #     that this is a continuation of a prior `GroupAssets` call, and that the
            #     system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::GroupResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::GroupResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GroupAssetsRequest.new
            #
            #   # Call the group_assets method.
            #   result = client.group_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::GroupResult.
            #     p item
            #   end
            #
            def group_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GroupAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.group_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.group_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.group_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :group_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :group_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Filters an organization or source's findings and  groups them by their
            # specified properties.
            #
            # To group across all sources provide a `-` as the source id.
            # Example: /v1/organizations/\\{organization_id}/sources/-/findings,
            # /v1/folders/\\{folder_id}/sources/-/findings,
            # /v1/projects/\\{project_id}/sources/-/findings
            #
            # @overload group_findings(request, options = nil)
            #   Pass arguments to `group_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload group_findings(parent: nil, filter: nil, group_by: nil, read_time: nil, compare_duration: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `group_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the source to groupBy. Its format is
            #     `organizations/[organization_id]/sources/[source_id]`,
            #     `folders/[folder_id]/sources/[source_id]`, or
            #     `projects/[project_id]/sources/[source_id]`. To groupBy across all sources
            #     provide a source_id of `-`. For example:
            #     `organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-`,
            #     or `projects/{project_id}/sources/-`
            #   @param filter [::String]
            #     Expression that defines the filter to apply across findings.
            #     The expression is a list of one or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. Examples include:
            #
            #      * name
            #      * source_properties.a_property
            #      * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following field and operator combinations are supported:
            #
            #     * name: `=`
            #     * parent: `=`, `:`
            #     * resource_name: `=`, `:`
            #     * state: `=`, `:`
            #     * category: `=`, `:`
            #     * external_uri: `=`, `:`
            #     * event_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `event_time = "2019-06-10T16:07:18-07:00"`
            #         `event_time = 1560208038000`
            #
            #     * severity: `=`, `:`
            #     * workflow_state: `=`, `:`
            #     * security_marks.marks: `=`, `:`
            #     * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
            #
            #       For example, `source_properties.size = 100` is a valid filter string.
            #
            #       Use a partial match on the empty string to filter based on a property
            #       existing: `source_properties.my_property : ""`
            #
            #       Use a negated partial match on the empty string to filter based on a
            #       property not existing: `-source_properties.my_property : ""`
            #
            #     * resource:
            #       * resource.name: `=`, `:`
            #       * resource.parent_name: `=`, `:`
            #       * resource.parent_display_name: `=`, `:`
            #       * resource.project_name: `=`, `:`
            #       * resource.project_display_name: `=`, `:`
            #       * resource.type: `=`, `:`
            #   @param group_by [::String]
            #     Required. Expression that defines what assets fields to use for grouping
            #     (including `state_change`). The string value should follow SQL syntax:
            #     comma separated list of fields. For example: "parent,resource_name".
            #
            #     The following fields are supported when compare_duration is set:
            #
            #     * state_change
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Time used as a reference point when filtering findings. The filter is
            #     limited to findings existing at the supplied time and their values are
            #     those at that specific time. Absence of this field will default to the
            #     API's version of NOW.
            #   @param compare_duration [::Google::Protobuf::Duration, ::Hash]
            #     When compare_duration is set, the GroupResult's "state_change" attribute is
            #     updated to indicate whether the finding had its state changed, the
            #     finding's state remained unchanged, or if the finding was added during the
            #     compare_duration period of time that precedes the read_time. This is the
            #     time between (read_time - compare_duration) and read_time.
            #
            #     The state_change value is derived based on the presence and state of the
            #     finding at the two points in time. Intermediate state changes between the
            #     two times don't affect the result. For example, the results aren't affected
            #     if the finding is made inactive and then active again.
            #
            #     Possible "state_change" values when compare_duration is specified:
            #
            #     * "CHANGED":   indicates that the finding was present and matched the given
            #                      filter at the start of compare_duration, but changed its
            #                      state at read_time.
            #     * "UNCHANGED": indicates that the finding was present and matched the given
            #                      filter at the start of compare_duration and did not change
            #                      state at read_time.
            #     * "ADDED":     indicates that the finding did not match the given filter or
            #                      was not present at the start of compare_duration, but was
            #                      present at read_time.
            #     * "REMOVED":   indicates that the finding was present and matched the
            #                      filter at the start of compare_duration, but did not match
            #                      the filter at read_time.
            #
            #     If compare_duration is not specified, then the only possible state_change
            #     is "UNUSED",  which will be the state_change set for all findings present
            #     at read_time.
            #
            #     If this field is set then `state_change` must be a specified field in
            #     `group_by`.
            #   @param page_token [::String]
            #     The value returned by the last `GroupFindingsResponse`; indicates
            #     that this is a continuation of a prior `GroupFindings` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::GroupResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::GroupResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GroupFindingsRequest.new
            #
            #   # Call the group_findings method.
            #   result = client.group_findings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::GroupResult.
            #     p item
            #   end
            #
            def group_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GroupFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.group_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.group_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.group_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :group_findings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :group_findings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists an organization's assets.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_assets(request, options = nil)
            #   Pass arguments to `list_assets` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_assets(parent: nil, filter: nil, order_by: nil, read_time: nil, compare_duration: nil, field_mask: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource that contains the assets. The
            #     value that you can specify on parent depends on the method in which you
            #     specify parent. You can specify one of the following values:
            #     `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param filter [::String]
            #     Expression that defines the filter to apply across assets.
            #     The expression is a list of zero or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. The fields map to those
            #     defined in the Asset resource. Examples include:
            #
            #     * name
            #     * security_center_properties.resource_name
            #     * resource_properties.a_property
            #     * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following are the allowed field and operator combinations:
            #
            #     * name: `=`
            #     * update_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `update_time = "2019-06-10T16:07:18-07:00"`
            #         `update_time = 1560208038000`
            #
            #     * create_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `create_time = "2019-06-10T16:07:18-07:00"`
            #         `create_time = 1560208038000`
            #
            #     * iam_policy.policy_blob: `=`, `:`
            #     * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
            #     * security_marks.marks: `=`, `:`
            #     * security_center_properties.resource_name: `=`, `:`
            #     * security_center_properties.resource_display_name: `=`, `:`
            #     * security_center_properties.resource_type: `=`, `:`
            #     * security_center_properties.resource_parent: `=`, `:`
            #     * security_center_properties.resource_parent_display_name: `=`, `:`
            #     * security_center_properties.resource_project: `=`, `:`
            #     * security_center_properties.resource_project_display_name: `=`, `:`
            #     * security_center_properties.resource_owners: `=`, `:`
            #
            #     For example, `resource_properties.size = 100` is a valid filter string.
            #
            #     Use a partial match on the empty string to filter based on a property
            #     existing: `resource_properties.my_property : ""`
            #
            #     Use a negated partial match on the empty string to filter based on a
            #     property not existing: `-resource_properties.my_property : ""`
            #   @param order_by [::String]
            #     Expression that defines what fields and order to use for sorting. The
            #     string value should follow SQL syntax: comma separated list of fields. For
            #     example: "name,resource_properties.a_property". The default sorting order
            #     is ascending. To specify descending order for a field, a suffix " desc"
            #     should be appended to the field name. For example: "name
            #     desc,resource_properties.a_property". Redundant space characters in the
            #     syntax are insignificant. "name desc,resource_properties.a_property" and "
            #     name     desc  ,   resource_properties.a_property  " are equivalent.
            #
            #     The following fields are supported:
            #     name
            #     update_time
            #     resource_properties
            #     security_marks.marks
            #     security_center_properties.resource_name
            #     security_center_properties.resource_display_name
            #     security_center_properties.resource_parent
            #     security_center_properties.resource_parent_display_name
            #     security_center_properties.resource_project
            #     security_center_properties.resource_project_display_name
            #     security_center_properties.resource_type
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Time used as a reference point when filtering assets. The filter is limited
            #     to assets existing at the supplied time and their values are those at that
            #     specific time. Absence of this field will default to the API's version of
            #     NOW.
            #   @param compare_duration [::Google::Protobuf::Duration, ::Hash]
            #     When compare_duration is set, the ListAssetsResult's "state_change"
            #     attribute is updated to indicate whether the asset was added, removed, or
            #     remained present during the compare_duration period of time that precedes
            #     the read_time. This is the time between (read_time - compare_duration) and
            #     read_time.
            #
            #     The state_change value is derived based on the presence of the asset at the
            #     two points in time. Intermediate state changes between the two times don't
            #     affect the result. For example, the results aren't affected if the asset is
            #     removed and re-created again.
            #
            #     Possible "state_change" values when compare_duration is specified:
            #
            #     * "ADDED":   indicates that the asset was not present at the start of
            #                    compare_duration, but present at read_time.
            #     * "REMOVED": indicates that the asset was present at the start of
            #                    compare_duration, but not present at read_time.
            #     * "ACTIVE":  indicates that the asset was present at both the
            #                    start and the end of the time period defined by
            #                    compare_duration and read_time.
            #
            #     If compare_duration is not specified, then the only possible state_change
            #     is "UNUSED",  which will be the state_change set for all assets present at
            #     read_time.
            #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     A field mask to specify the ListAssetsResult fields to be listed in the
            #     response.
            #     An empty field mask will list all fields.
            #   @param page_token [::String]
            #     The value returned by the last `ListAssetsResponse`; indicates
            #     that this is a continuation of a prior `ListAssets` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ListAssetsResponse::ListAssetsResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ListAssetsResponse::ListAssetsResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListAssetsRequest.new
            #
            #   # Call the list_assets method.
            #   result = client.list_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::ListAssetsResponse::ListAssetsResult.
            #     p item
            #   end
            #
            def list_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all resident SecurityHealthAnalyticsCustomModules under
            # the given CRM parent and all of the parent’s CRM descendants.
            #
            # @overload list_descendant_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_descendant_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_descendant_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_descendant_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list descendant custom modules. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings`,
            #     `folders/{folder}/securityHealthAnalyticsSettings`, or
            #     `projects/{project}/securityHealthAnalyticsSettings`
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     The value returned by the last call indicating a continuation
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_descendant_security_health_analytics_custom_modules method.
            #   result = client.list_descendant_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_descendant_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListDescendantSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_descendant_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_descendant_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_descendant_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_descendant_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_descendant_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists an organization or source's findings.
            #
            # To list across all sources provide a `-` as the source id.
            # Example: /v1/organizations/\\{organization_id}/sources/-/findings
            #
            # @overload list_findings(request, options = nil)
            #   Pass arguments to `list_findings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListFindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListFindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_findings(parent: nil, filter: nil, order_by: nil, read_time: nil, compare_duration: nil, field_mask: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_findings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the source the findings belong to. Its format is
            #     `organizations/[organization_id]/sources/[source_id]`,
            #     `folders/[folder_id]/sources/[source_id]`, or
            #     `projects/[project_id]/sources/[source_id]`. To list across all sources
            #     provide a source_id of `-`. For example:
            #     `organizations/{organization_id}/sources/-`,
            #     `folders/{folder_id}/sources/-` or `projects/{projects_id}/sources/-`
            #   @param filter [::String]
            #     Expression that defines the filter to apply across findings.
            #     The expression is a list of one or more restrictions combined via logical
            #     operators `AND` and `OR`.
            #     Parentheses are supported, and `OR` has higher precedence than `AND`.
            #
            #     Restrictions have the form `<field> <operator> <value>` and may have a `-`
            #     character in front of them to indicate negation. Examples include:
            #
            #      * name
            #      * source_properties.a_property
            #      * security_marks.marks.marka
            #
            #     The supported operators are:
            #
            #     * `=` for all value types.
            #     * `>`, `<`, `>=`, `<=` for integer values.
            #     * `:`, meaning substring matching, for strings.
            #
            #     The supported value types are:
            #
            #     * string literals in quotes.
            #     * integer literals without quotes.
            #     * boolean literals `true` and `false` without quotes.
            #
            #     The following field and operator combinations are supported:
            #
            #     * name: `=`
            #     * parent: `=`, `:`
            #     * resource_name: `=`, `:`
            #     * state: `=`, `:`
            #     * category: `=`, `:`
            #     * external_uri: `=`, `:`
            #     * event_time: `=`, `>`, `<`, `>=`, `<=`
            #
            #       Usage: This should be milliseconds since epoch or an RFC3339 string.
            #       Examples:
            #         `event_time = "2019-06-10T16:07:18-07:00"`
            #         `event_time = 1560208038000`
            #
            #     * severity: `=`, `:`
            #     * workflow_state: `=`, `:`
            #     * security_marks.marks: `=`, `:`
            #     * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
            #
            #       For example, `source_properties.size = 100` is a valid filter string.
            #
            #       Use a partial match on the empty string to filter based on a property
            #       existing: `source_properties.my_property : ""`
            #
            #       Use a negated partial match on the empty string to filter based on a
            #       property not existing: `-source_properties.my_property : ""`
            #
            #     * resource:
            #       * resource.name: `=`, `:`
            #       * resource.parent_name: `=`, `:`
            #       * resource.parent_display_name: `=`, `:`
            #       * resource.project_name: `=`, `:`
            #       * resource.project_display_name: `=`, `:`
            #       * resource.type: `=`, `:`
            #       * resource.folders.resource_folder: `=`, `:`
            #       * resource.display_name: `=`, `:`
            #   @param order_by [::String]
            #     Expression that defines what fields and order to use for sorting. The
            #     string value should follow SQL syntax: comma separated list of fields. For
            #     example: "name,resource_properties.a_property". The default sorting order
            #     is ascending. To specify descending order for a field, a suffix " desc"
            #     should be appended to the field name. For example: "name
            #     desc,source_properties.a_property". Redundant space characters in the
            #     syntax are insignificant. "name desc,source_properties.a_property" and "
            #     name     desc  ,   source_properties.a_property  " are equivalent.
            #
            #     The following fields are supported:
            #     name
            #     parent
            #     state
            #     category
            #     resource_name
            #     event_time
            #     source_properties
            #     security_marks.marks
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Time used as a reference point when filtering findings. The filter is
            #     limited to findings existing at the supplied time and their values are
            #     those at that specific time. Absence of this field will default to the
            #     API's version of NOW.
            #   @param compare_duration [::Google::Protobuf::Duration, ::Hash]
            #     When compare_duration is set, the ListFindingsResult's "state_change"
            #     attribute is updated to indicate whether the finding had its state changed,
            #     the finding's state remained unchanged, or if the finding was added in any
            #     state during the compare_duration period of time that precedes the
            #     read_time. This is the time between (read_time - compare_duration) and
            #     read_time.
            #
            #     The state_change value is derived based on the presence and state of the
            #     finding at the two points in time. Intermediate state changes between the
            #     two times don't affect the result. For example, the results aren't affected
            #     if the finding is made inactive and then active again.
            #
            #     Possible "state_change" values when compare_duration is specified:
            #
            #     * "CHANGED":   indicates that the finding was present and matched the given
            #                      filter at the start of compare_duration, but changed its
            #                      state at read_time.
            #     * "UNCHANGED": indicates that the finding was present and matched the given
            #                      filter at the start of compare_duration and did not change
            #                      state at read_time.
            #     * "ADDED":     indicates that the finding did not match the given filter or
            #                      was not present at the start of compare_duration, but was
            #                      present at read_time.
            #     * "REMOVED":   indicates that the finding was present and matched the
            #                      filter at the start of compare_duration, but did not match
            #                      the filter at read_time.
            #
            #     If compare_duration is not specified, then the only possible state_change
            #     is "UNUSED", which will be the state_change set for all findings present at
            #     read_time.
            #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     A field mask to specify the Finding fields to be listed in the response.
            #     An empty field mask will list all fields.
            #   @param page_token [::String]
            #     The value returned by the last `ListFindingsResponse`; indicates
            #     that this is a continuation of a prior `ListFindings` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListFindingsRequest.new
            #
            #   # Call the list_findings method.
            #   result = client.list_findings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::ListFindingsResponse::ListFindingsResult.
            #     p item
            #   end
            #
            def list_findings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListFindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_findings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_findings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_findings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_findings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_findings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists mute configs.
            #
            # @overload list_mute_configs(request, options = nil)
            #   Pass arguments to `list_mute_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_mute_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_mute_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of mute configs. Its format
            #     is `organizations/[organization_id]`, `folders/[folder_id]`,
            #     `projects/[project_id]`.
            #   @param page_size [::Integer]
            #     The maximum number of configs to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListMuteConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListMuteConfigs` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::MuteConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::MuteConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest.new
            #
            #   # Call the list_mute_configs method.
            #   result = client.list_mute_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::MuteConfig.
            #     p item
            #   end
            #
            def list_mute_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListMuteConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_mute_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_mute_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_mute_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_mute_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_mute_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists notification configs.
            #
            # @overload list_notification_configs(request, options = nil)
            #   Pass arguments to `list_notification_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_notification_configs(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_notification_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent in which to list the notification
            #     configurations. Its format is "organizations/[organization_id]",
            #     "folders/[folder_id]", or "projects/[project_id]".
            #   @param page_token [::String]
            #     The value returned by the last `ListNotificationConfigsResponse`; indicates
            #     that this is a continuation of a prior `ListNotificationConfigs` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::NotificationConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::NotificationConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest.new
            #
            #   # Call the list_notification_configs method.
            #   result = client.list_notification_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::NotificationConfig.
            #     p item
            #   end
            #
            def list_notification_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListNotificationConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_notification_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_notification_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_notification_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_notification_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_notification_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
            # given parent. This includes resident modules defined at the scope of the
            # parent, and inherited modules, inherited from CRM ancestors.
            #
            # @overload list_effective_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_effective_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_effective_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_effective_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list effective custom modules. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings`,
            #     `folders/{folder}/securityHealthAnalyticsSettings`, or
            #     `projects/{project}/securityHealthAnalyticsSettings`
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     The value returned by the last call indicating a continuation
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_effective_security_health_analytics_custom_modules method.
            #   result = client.list_effective_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::EffectiveSecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_effective_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListEffectiveSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_effective_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_effective_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_effective_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_effective_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_effective_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a list of all SecurityHealthAnalyticsCustomModules for the given
            # parent. This includes resident modules defined at the scope of the parent,
            # and inherited modules, inherited from CRM ancestors.
            #
            # @overload list_security_health_analytics_custom_modules(request, options = nil)
            #   Pass arguments to `list_security_health_analytics_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_security_health_analytics_custom_modules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_security_health_analytics_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list custom modules. Its format is
            #     `organizations/{organization}/securityHealthAnalyticsSettings`,
            #     `folders/{folder}/securityHealthAnalyticsSettings`, or
            #     `projects/{project}/securityHealthAnalyticsSettings`
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #   @param page_token [::String]
            #     The value returned by the last call indicating a continuation
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest.new
            #
            #   # Call the list_security_health_analytics_custom_modules method.
            #   result = client.list_security_health_analytics_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.
            #     p item
            #   end
            #
            def list_security_health_analytics_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListSecurityHealthAnalyticsCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_security_health_analytics_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_security_health_analytics_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_security_health_analytics_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_security_health_analytics_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_security_health_analytics_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all sources belonging to an organization.
            #
            # @overload list_sources(request, options = nil)
            #   Pass arguments to `list_sources` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListSourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListSourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_sources(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_sources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent of sources to list. Its format should
            #     be `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param page_token [::String]
            #     The value returned by the last `ListSourcesResponse`; indicates
            #     that this is a continuation of a prior `ListSources` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::Source>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::Source>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListSourcesRequest.new
            #
            #   # Call the list_sources method.
            #   result = client.list_sources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::Source.
            #     p item
            #   end
            #
            def list_sources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListSourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_sources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_sources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_sources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_sources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_sources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Runs asset discovery. The discovery is tracked with a long-running
            # operation.
            #
            # This API can only be called with limited frequency for an organization. If
            # it is called too frequently the caller will receive a TOO_MANY_REQUESTS
            # error.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload run_asset_discovery(request, options = nil)
            #   Pass arguments to `run_asset_discovery` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_asset_discovery(parent: nil)
            #   Pass arguments to `run_asset_discovery` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the organization to run asset discovery for. Its format
            #     is `organizations/[organization_id]`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest.new
            #
            #   # Call the run_asset_discovery method.
            #   result = client.run_asset_discovery request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def run_asset_discovery request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::RunAssetDiscoveryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_asset_discovery.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_asset_discovery.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_asset_discovery.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :run_asset_discovery, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the state of a finding.
            #
            # @overload set_finding_state(request, options = nil)
            #   Pass arguments to `set_finding_state` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_finding_state(name: nil, state: nil, start_time: nil)
            #   Pass arguments to `set_finding_state` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The [relative resource
            #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
            #     of the finding. Example:
            #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
            #     `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
            #     `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
            #   @param state [::Google::Cloud::SecurityCenter::V1::Finding::State]
            #     Required. The desired State of the finding.
            #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Required. The time at which the updated state takes effect.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::SetFindingStateRequest.new
            #
            #   # Call the set_finding_state method.
            #   result = client.set_finding_state request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Finding.
            #   p result
            #
            def set_finding_state request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::SetFindingStateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_finding_state.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_finding_state.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_finding_state.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_finding_state, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the mute state of a finding.
            #
            # @overload set_mute(request, options = nil)
            #   Pass arguments to `set_mute` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::SetMuteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::SetMuteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_mute(name: nil, mute: nil)
            #   Pass arguments to `set_mute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The [relative resource
            #     name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
            #     of the finding. Example:
            #     `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
            #     `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
            #     `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
            #   @param mute [::Google::Cloud::SecurityCenter::V1::Finding::Mute]
            #     Required. The desired state of the Mute.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::SetMuteRequest.new
            #
            #   # Call the set_mute method.
            #   result = client.set_mute request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Finding.
            #   p result
            #
            def set_mute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::SetMuteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_mute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_mute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_mute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_mute, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the access control policy on the specified Source.
            #
            # @overload set_iam_policy(request, options = nil)
            #   Pass arguments to `set_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
            #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being specified.
            #     See the operation documentation for the appropriate value for this field.
            #   @param policy [::Google::Iam::V1::Policy, ::Hash]
            #     REQUIRED: The complete policy to be applied to the `resource`. The size of
            #     the policy is limited to a few 10s of KB. An empty policy is a
            #     valid policy but certain Cloud Platform services (such as Projects)
            #     might reject them.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
            #     the fields in the mask will be modified. If no mask is provided, the
            #     following default mask is used:
            #
            #     `paths: "bindings, etag"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::SetIamPolicyRequest.new
            #
            #   # Call the set_iam_policy method.
            #   result = client.set_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def set_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the permissions that a caller has on the specified source.
            #
            # @overload test_iam_permissions(request, options = nil)
            #   Pass arguments to `test_iam_permissions` via a request object, either of type
            #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload test_iam_permissions(resource: nil, permissions: nil)
            #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy detail is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param permissions [::Array<::String>]
            #     The set of permissions to check for the `resource`. Permissions with
            #     wildcards (such as '*' or 'storage.*') are not allowed. For more
            #     information see
            #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::TestIamPermissionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::TestIamPermissionsRequest.new
            #
            #   # Call the test_iam_permissions method.
            #   result = client.test_iam_permissions request
            #
            #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
            #   p result
            #
            def test_iam_permissions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.test_iam_permissions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.test_iam_permissions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
            #
            # @overload simulate_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `simulate_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload simulate_security_health_analytics_custom_module(parent: nil, custom_config: nil, resource: nil)
            #   Pass arguments to `simulate_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative resource name of the organization, project, or
            #     folder. For more information about relative resource names, see [Relative
            #     Resource
            #     Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
            #     Example: `organizations/{organization_id}`
            #   @param custom_config [::Google::Cloud::SecurityCenter::V1::CustomConfig, ::Hash]
            #     Required. The custom configuration that you need to test.
            #   @param resource [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest::SimulatedResource, ::Hash]
            #     Required. Resource data to simulate custom module against.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the simulate_security_health_analytics_custom_module method.
            #   result = client.simulate_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleResponse.
            #   p result
            #
            def simulate_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::SimulateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.simulate_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.simulate_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.simulate_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :simulate_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates external system. This is for a given finding.
            #
            # @overload update_external_system(request, options = nil)
            #   Pass arguments to `update_external_system` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_external_system(external_system: nil, update_mask: nil)
            #   Pass arguments to `update_external_system` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param external_system [::Google::Cloud::SecurityCenter::V1::ExternalSystem, ::Hash]
            #     Required. The external system resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the external system resource.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::ExternalSystem]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::ExternalSystem]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest.new
            #
            #   # Call the update_external_system method.
            #   result = client.update_external_system request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::ExternalSystem.
            #   p result
            #
            def update_external_system request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateExternalSystemRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_external_system.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.external_system&.name
                header_params["external_system.name"] = request.external_system.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_external_system.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_external_system.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_external_system, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates or updates a finding. The corresponding source must exist for a
            # finding creation to succeed.
            #
            # @overload update_finding(request, options = nil)
            #   Pass arguments to `update_finding` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_finding(finding: nil, update_mask: nil)
            #   Pass arguments to `update_finding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param finding [::Google::Cloud::SecurityCenter::V1::Finding, ::Hash]
            #     Required. The finding resource to update or create if it does not already
            #     exist. parent, security_marks, and update_time will be ignored.
            #
            #     In the case of creation, the finding id portion of the name must be
            #     alphanumeric and less than or equal to 32 characters and greater than 0
            #     characters in length.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the finding resource. This field should
            #     not be specified when creating a finding.
            #
            #     When updating a finding, an empty mask is treated as updating all mutable
            #     fields and replacing source_properties.  Individual source_properties can
            #     be added/updated by using "source_properties.<property key>" in the field
            #     mask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Finding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Finding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateFindingRequest.new
            #
            #   # Call the update_finding method.
            #   result = client.update_finding request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Finding.
            #   p result
            #
            def update_finding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateFindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_finding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.finding&.name
                header_params["finding.name"] = request.finding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_finding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_finding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_finding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a mute config.
            #
            # @overload update_mute_config(request, options = nil)
            #   Pass arguments to `update_mute_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_mute_config(mute_config: nil, update_mask: nil)
            #   Pass arguments to `update_mute_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param mute_config [::Google::Cloud::SecurityCenter::V1::MuteConfig, ::Hash]
            #     Required. The mute config being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::MuteConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest.new
            #
            #   # Call the update_mute_config method.
            #   result = client.update_mute_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::MuteConfig.
            #   p result
            #
            def update_mute_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateMuteConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_mute_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.mute_config&.name
                header_params["mute_config.name"] = request.mute_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_mute_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_mute_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_mute_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a notification config. The following update
            # fields are allowed: description, pubsub_topic, streaming_config.filter
            #
            # @overload update_notification_config(request, options = nil)
            #   Pass arguments to `update_notification_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_notification_config(notification_config: nil, update_mask: nil)
            #   Pass arguments to `update_notification_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param notification_config [::Google::Cloud::SecurityCenter::V1::NotificationConfig, ::Hash]
            #     Required. The notification config to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the notification config.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::NotificationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest.new
            #
            #   # Call the update_notification_config method.
            #   result = client.update_notification_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::NotificationConfig.
            #   p result
            #
            def update_notification_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateNotificationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_notification_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.notification_config&.name
                header_params["notification_config.name"] = request.notification_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_notification_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_notification_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_notification_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an organization's settings.
            #
            # @overload update_organization_settings(request, options = nil)
            #   Pass arguments to `update_organization_settings` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_organization_settings(organization_settings: nil, update_mask: nil)
            #   Pass arguments to `update_organization_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param organization_settings [::Google::Cloud::SecurityCenter::V1::OrganizationSettings, ::Hash]
            #     Required. The organization settings resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the settings resource.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::OrganizationSettings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::OrganizationSettings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest.new
            #
            #   # Call the update_organization_settings method.
            #   result = client.update_organization_settings request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::OrganizationSettings.
            #   p result
            #
            def update_organization_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateOrganizationSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_organization_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.organization_settings&.name
                header_params["organization_settings.name"] = request.organization_settings.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_organization_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_organization_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_organization_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the SecurityHealthAnalyticsCustomModule under the given name based
            # on the given update mask. Updating the enablement state is supported on
            # both resident and inherited modules (though resident modules cannot have an
            # enablement state of "inherited"). Updating the display name and custom
            # config of a module is supported on resident modules only.
            #
            # @overload update_security_health_analytics_custom_module(request, options = nil)
            #   Pass arguments to `update_security_health_analytics_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_security_health_analytics_custom_module(security_health_analytics_custom_module: nil, update_mask: nil)
            #   Pass arguments to `update_security_health_analytics_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param security_health_analytics_custom_module [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule, ::Hash]
            #     Required. The SecurityHealthAnalytics custom module to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated. The only fields that can be updated are
            #     `enablement_state` and `custom_config`. If empty or set to the wildcard
            #     value `*`, both `enablement_state` and `custom_config` are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest.new
            #
            #   # Call the update_security_health_analytics_custom_module method.
            #   result = client.update_security_health_analytics_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::SecurityHealthAnalyticsCustomModule.
            #   p result
            #
            def update_security_health_analytics_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateSecurityHealthAnalyticsCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_security_health_analytics_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.security_health_analytics_custom_module&.name
                header_params["security_health_analytics_custom_module.name"] = request.security_health_analytics_custom_module.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_security_health_analytics_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_security_health_analytics_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_security_health_analytics_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a source.
            #
            # @overload update_source(request, options = nil)
            #   Pass arguments to `update_source` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_source(source: nil, update_mask: nil)
            #   Pass arguments to `update_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param source [::Google::Cloud::SecurityCenter::V1::Source, ::Hash]
            #     Required. The source resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the source resource.
            #
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::Source]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::Source]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateSourceRequest.new
            #
            #   # Call the update_source method.
            #   result = client.update_source request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::Source.
            #   p result
            #
            def update_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.source&.name
                header_params["source.name"] = request.source.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates security marks.
            #
            # @overload update_security_marks(request, options = nil)
            #   Pass arguments to `update_security_marks` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_security_marks(security_marks: nil, update_mask: nil, start_time: nil)
            #   Pass arguments to `update_security_marks` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param security_marks [::Google::Cloud::SecurityCenter::V1::SecurityMarks, ::Hash]
            #     Required. The security marks resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The FieldMask to use when updating the security marks resource.
            #
            #     The field mask must not contain duplicate fields.
            #     If empty or set to "marks", all marks will be replaced.  Individual
            #     marks can be updated using "marks.<mark_key>".
            #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time at which the updated SecurityMarks take effect.
            #     If not set uses current server time.  Updates will be applied to the
            #     SecurityMarks that are active immediately preceding this time. Must be
            #     earlier or equal to the server time.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::SecurityMarks]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::SecurityMarks]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest.new
            #
            #   # Call the update_security_marks method.
            #   result = client.update_security_marks request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::SecurityMarks.
            #   p result
            #
            def update_security_marks request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateSecurityMarksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_security_marks.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.security_marks&.name
                header_params["security_marks.name"] = request.security_marks.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_security_marks.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_security_marks.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_security_marks, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a BigQuery export.
            #
            # @overload create_big_query_export(request, options = nil)
            #   Pass arguments to `create_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_big_query_export(parent: nil, big_query_export: nil, big_query_export_id: nil)
            #   Pass arguments to `create_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource of the new BigQuery export. Its
            #     format is `organizations/[organization_id]`, `folders/[folder_id]`, or
            #     `projects/[project_id]`.
            #   @param big_query_export [::Google::Cloud::SecurityCenter::V1::BigQueryExport, ::Hash]
            #     Required. The BigQuery export being created.
            #   @param big_query_export_id [::String]
            #     Required. Unique identifier provided by the client within the parent scope.
            #     It must consist of only lowercase letters, numbers, and hyphens, must start
            #     with a letter, must end with either a letter or a number, and must be 63
            #     characters or less.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest.new
            #
            #   # Call the create_big_query_export method.
            #   result = client.create_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::BigQueryExport.
            #   p result
            #
            def create_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing BigQuery export.
            #
            # @overload delete_big_query_export(request, options = nil)
            #   Pass arguments to `delete_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_big_query_export(name: nil)
            #   Pass arguments to `delete_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the BigQuery export to delete. Its format is
            #     `organizations/{organization}/bigQueryExports/{export_id}`,
            #     `folders/{folder}/bigQueryExports/{export_id}`, or
            #     `projects/{project}/bigQueryExports/{export_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest.new
            #
            #   # Call the delete_big_query_export method.
            #   result = client.delete_big_query_export request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a BigQuery export.
            #
            # @overload update_big_query_export(request, options = nil)
            #   Pass arguments to `update_big_query_export` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_big_query_export(big_query_export: nil, update_mask: nil)
            #   Pass arguments to `update_big_query_export` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param big_query_export [::Google::Cloud::SecurityCenter::V1::BigQueryExport, ::Hash]
            #     Required. The BigQuery export being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::BigQueryExport]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest.new
            #
            #   # Call the update_big_query_export method.
            #   result = client.update_big_query_export request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::BigQueryExport.
            #   p result
            #
            def update_big_query_export request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateBigQueryExportRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_big_query_export.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.big_query_export&.name
                header_params["big_query_export.name"] = request.big_query_export.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_big_query_export.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_big_query_export.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_big_query_export, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BigQuery exports. Note that when requesting BigQuery exports at a
            # given level all exports under that level are also returned e.g. if
            # requesting BigQuery exports under a folder, then all BigQuery exports
            # immediately under the folder plus the ones created under the projects
            # within the folder are returned.
            #
            # @overload list_big_query_exports(request, options = nil)
            #   Pass arguments to `list_big_query_exports` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_big_query_exports(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_big_query_exports` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of BigQuery exports. Its
            #     format is `organizations/[organization_id]`, `folders/[folder_id]`,
            #     `projects/[project_id]`.
            #   @param page_size [::Integer]
            #     The maximum number of configs to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListBigQueryExports` call.
            #     Provide this to retrieve the subsequent page.
            #     When paginating, all other parameters provided to `ListBigQueryExports`
            #     must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::BigQueryExport>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::BigQueryExport>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest.new
            #
            #   # Call the list_big_query_exports method.
            #   result = client.list_big_query_exports request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::BigQueryExport.
            #     p item
            #   end
            #
            def list_big_query_exports request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListBigQueryExportsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_big_query_exports.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_big_query_exports.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_big_query_exports.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_big_query_exports, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_big_query_exports, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a resident Event Threat Detection custom module at the scope of the
            # given Resource Manager parent, and also creates inherited custom modules
            # for all descendants of the given parent. These modules are enabled by
            # default.
            #
            # @overload create_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `create_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_event_threat_detection_custom_module(parent: nil, event_threat_detection_custom_module: nil)
            #   Pass arguments to `create_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The new custom module's parent.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings`.
            #       * `folders/{folder}/eventThreatDetectionSettings`.
            #       * `projects/{project}/eventThreatDetectionSettings`.
            #   @param event_threat_detection_custom_module [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule, ::Hash]
            #     Required. The module to create. The
            #     event_threat_detection_custom_module.name will be ignored and server
            #     generated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the create_event_threat_detection_custom_module method.
            #   result = client.create_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def create_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::CreateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :create_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified Event Threat Detection custom module and all of its
            # descendants in the Resource Manager hierarchy. This method is only
            # supported for resident custom modules.
            #
            # @overload delete_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `delete_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_event_threat_detection_custom_module(name: nil)
            #   Pass arguments to `delete_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the custom module to delete.
            #
            #     Its format is:
            #
            #     * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
            #     * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
            #     * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the delete_event_threat_detection_custom_module method.
            #   result = client.delete_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Event Threat Detection custom module.
            #
            # @overload get_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `get_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_event_threat_detection_custom_module(name: nil)
            #   Pass arguments to `get_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the custom module to get.
            #
            #     Its format is:
            #
            #     * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
            #     * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
            #     * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the get_event_threat_detection_custom_module method.
            #   result = client.get_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def get_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all resident Event Threat Detection custom modules under the
            # given Resource Manager parent and its descendants.
            #
            # @overload list_descendant_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_descendant_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_descendant_event_threat_detection_custom_modules(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_descendant_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent to list custom modules under.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings`.
            #       * `folders/{folder}/eventThreatDetectionSettings`.
            #       * `projects/{project}/eventThreatDetectionSettings`.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     `ListDescendantEventThreatDetectionCustomModules` call. Provide this to
            #     retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListDescendantEventThreatDetectionCustomModules` must match the call that
            #     provided the page token.
            #   @param page_size [::Integer]
            #     The maximum number of modules to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_descendant_event_threat_detection_custom_modules method.
            #   result = client.list_descendant_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_descendant_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListDescendantEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_descendant_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_descendant_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_descendant_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_descendant_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_descendant_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all Event Threat Detection custom modules for the given
            # Resource Manager parent. This includes resident modules defined at the
            # scope of the parent along with modules inherited from ancestors.
            #
            # @overload list_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_event_threat_detection_custom_modules(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent to list custom modules under.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings`.
            #       * `folders/{folder}/eventThreatDetectionSettings`.
            #       * `projects/{project}/eventThreatDetectionSettings`.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListEventThreatDetectionCustomModules` must match the call that provided
            #     the page token.
            #   @param page_size [::Integer]
            #     The maximum number of modules to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_event_threat_detection_custom_modules method.
            #   result = client.list_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the Event Threat Detection custom module with the given name based
            # on the given update mask. Updating the enablement state is supported for
            # both resident and inherited modules (though resident modules cannot have an
            # enablement state of "inherited"). Updating the display name or
            # configuration of a module is supported for resident modules only. The type
            # of a module cannot be changed.
            #
            # @overload update_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `update_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_event_threat_detection_custom_module(event_threat_detection_custom_module: nil, update_mask: nil)
            #   Pass arguments to `update_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param event_threat_detection_custom_module [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule, ::Hash]
            #     Required. The module being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the update_event_threat_detection_custom_module method.
            #   result = client.update_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::EventThreatDetectionCustomModule.
            #   p result
            #
            def update_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.event_threat_detection_custom_module&.name
                header_params["event_threat_detection_custom_module.name"] = request.event_threat_detection_custom_module.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Validates the given Event Threat Detection custom module.
            #
            # @overload validate_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `validate_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload validate_event_threat_detection_custom_module(parent: nil, raw_text: nil, type: nil)
            #   Pass arguments to `validate_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent to validate the Custom Module under.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings`.
            #       * `folders/{folder}/eventThreatDetectionSettings`.
            #       * `projects/{project}/eventThreatDetectionSettings`.
            #   @param raw_text [::String]
            #     Required. The raw text of the module's contents. Used to generate error
            #     messages.
            #   @param type [::String]
            #     Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the validate_event_threat_detection_custom_module method.
            #   result = client.validate_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleResponse.
            #   p result
            #
            def validate_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ValidateEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.validate_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.validate_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.validate_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :validate_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an effective Event Threat Detection custom module at the given level.
            #
            # @overload get_effective_event_threat_detection_custom_module(request, options = nil)
            #   Pass arguments to `get_effective_event_threat_detection_custom_module` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_effective_event_threat_detection_custom_module(name: nil)
            #   Pass arguments to `get_effective_event_threat_detection_custom_module` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the effective Event Threat Detection custom
            #     module.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
            #       * `folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
            #       * `projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest.new
            #
            #   # Call the get_effective_event_threat_detection_custom_module method.
            #   result = client.get_effective_event_threat_detection_custom_module request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule.
            #   p result
            #
            def get_effective_event_threat_detection_custom_module request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetEffectiveEventThreatDetectionCustomModuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_effective_event_threat_detection_custom_module.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_effective_event_threat_detection_custom_module.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_effective_event_threat_detection_custom_module.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_effective_event_threat_detection_custom_module, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all effective Event Threat Detection custom modules for the
            # given parent. This includes resident modules defined at the scope of the
            # parent along with modules inherited from its ancestors.
            #
            # @overload list_effective_event_threat_detection_custom_modules(request, options = nil)
            #   Pass arguments to `list_effective_event_threat_detection_custom_modules` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_effective_event_threat_detection_custom_modules(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_effective_event_threat_detection_custom_modules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the parent to list custom modules for.
            #
            #     Its format is:
            #
            #       * `organizations/{organization}/eventThreatDetectionSettings`.
            #       * `folders/{folder}/eventThreatDetectionSettings`.
            #       * `projects/{project}/eventThreatDetectionSettings`.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     `ListEffectiveEventThreatDetectionCustomModules` call. Provide this to
            #     retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListEffectiveEventThreatDetectionCustomModules` must match the call that
            #     provided the page token.
            #   @param page_size [::Integer]
            #     The maximum number of modules to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest.new
            #
            #   # Call the list_effective_event_threat_detection_custom_modules method.
            #   result = client.list_effective_event_threat_detection_custom_modules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::EffectiveEventThreatDetectionCustomModule.
            #     p item
            #   end
            #
            def list_effective_event_threat_detection_custom_modules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListEffectiveEventThreatDetectionCustomModulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_effective_event_threat_detection_custom_modules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_effective_event_threat_detection_custom_modules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_effective_event_threat_detection_custom_modules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_effective_event_threat_detection_custom_modules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_effective_event_threat_detection_custom_modules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a ResourceValueConfig for an organization. Maps user's tags to
            # difference resource values for use by the attack path simulation.
            #
            # @overload batch_create_resource_value_configs(request, options = nil)
            #   Pass arguments to `batch_create_resource_value_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_resource_value_configs(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_resource_value_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the new ResourceValueConfig's parent.
            #     The parent field in the CreateResourceValueConfigRequest
            #     messages must either be empty or match this field.
            #   @param requests [::Array<::Google::Cloud::SecurityCenter::V1::CreateResourceValueConfigRequest, ::Hash>]
            #     Required. The resource value configs to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest.new
            #
            #   # Call the batch_create_resource_value_configs method.
            #   result = client.batch_create_resource_value_configs request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsResponse.
            #   p result
            #
            def batch_create_resource_value_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::BatchCreateResourceValueConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_resource_value_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_resource_value_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_resource_value_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :batch_create_resource_value_configs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a ResourceValueConfig.
            #
            # @overload delete_resource_value_config(request, options = nil)
            #   Pass arguments to `delete_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_resource_value_config(name: nil)
            #   Pass arguments to `delete_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ResourceValueConfig to delete
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest.new
            #
            #   # Call the delete_resource_value_config method.
            #   result = client.delete_resource_value_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::DeleteResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :delete_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a ResourceValueConfig.
            #
            # @overload get_resource_value_config(request, options = nil)
            #   Pass arguments to `get_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource_value_config(name: nil)
            #   Pass arguments to `get_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource value config to retrieve. Its format is
            #     `organizations/{organization}/resourceValueConfigs/{config_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest.new
            #
            #   # Call the get_resource_value_config method.
            #   result = client.get_resource_value_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::ResourceValueConfig.
            #   p result
            #
            def get_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::GetResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :get_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all ResourceValueConfigs.
            #
            # @overload list_resource_value_configs(request, options = nil)
            #   Pass arguments to `list_resource_value_configs` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resource_value_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_resource_value_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns the collection of resource value configs.
            #     Its format is
            #     `organizations/[organization_id]`
            #   @param page_size [::Integer]
            #     The number of results to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 10 configs will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListResourceValueConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListResourceValueConfigs` must match the call that provided the
            #     page token.
            #
            #     page_size can be specified, and the new page_size will be used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ResourceValueConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ResourceValueConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest.new
            #
            #   # Call the list_resource_value_configs method.
            #   result = client.list_resource_value_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::ResourceValueConfig.
            #     p item
            #   end
            #
            def list_resource_value_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListResourceValueConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resource_value_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resource_value_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resource_value_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_resource_value_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_resource_value_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing ResourceValueConfigs with new rules.
            #
            # @overload update_resource_value_config(request, options = nil)
            #   Pass arguments to `update_resource_value_config` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_resource_value_config(resource_value_config: nil, update_mask: nil)
            #   Pass arguments to `update_resource_value_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource_value_config [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig, ::Hash]
            #     Required. The resource value config being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     If empty all mutable fields will be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecurityCenter::V1::ResourceValueConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest.new
            #
            #   # Call the update_resource_value_config method.
            #   result = client.update_resource_value_config request
            #
            #   # The returned object is of type Google::Cloud::SecurityCenter::V1::ResourceValueConfig.
            #   p result
            #
            def update_resource_value_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::UpdateResourceValueConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_resource_value_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource_value_config&.name
                header_params["resource_value_config.name"] = request.resource_value_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_resource_value_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_resource_value_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :update_resource_value_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the valued resources for a set of simulation results and filter.
            #
            # @overload list_valued_resources(request, options = nil)
            #   Pass arguments to `list_valued_resources` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_valued_resources(parent: nil, filter: nil, page_token: nil, page_size: nil, order_by: nil)
            #   Pass arguments to `list_valued_resources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list valued resources.
            #
            #     Valid formats:
            #     `organizations/{organization}`,
            #     `organizations/{organization}/simulations/{simulation}`
            #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
            #   @param filter [::String]
            #     The filter expression that filters the valued resources in the response.
            #     Supported fields:
            #
            #       * `resource_value` supports =
            #       * `resource_type` supports =
            #   @param page_token [::String]
            #     The value returned by the last `ListValuedResourcesResponse`; indicates
            #     that this is a continuation of a prior `ListValuedResources` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #   @param order_by [::String]
            #     Optional. The fields by which to order the valued resources response.
            #
            #     Supported fields:
            #
            #       * `exposed_score`
            #
            #       * `resource_value`
            #
            #       * `resource_type`
            #
            #       * `resource`
            #
            #       * `display_name`
            #
            #     Values should be a comma separated list of fields. For example:
            #     `exposed_score,resource_value`.
            #
            #     The default sorting order is descending. To specify ascending or descending
            #     order for a field, append a ` ASC` or a ` DESC` suffix, respectively; for
            #     example: `exposed_score DESC`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ValuedResource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::ValuedResource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest.new
            #
            #   # Call the list_valued_resources method.
            #   result = client.list_valued_resources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::ValuedResource.
            #     p item
            #   end
            #
            def list_valued_resources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListValuedResourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_valued_resources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_valued_resources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_valued_resources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_valued_resources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_valued_resources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the attack paths for a set of simulation results or valued resources
            # and filter.
            #
            # @overload list_attack_paths(request, options = nil)
            #   Pass arguments to `list_attack_paths` via a request object, either of type
            #   {::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_attack_paths(parent: nil, filter: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_attack_paths` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of parent to list attack paths.
            #
            #     Valid formats:
            #     `organizations/{organization}`,
            #     `organizations/{organization}/simulations/{simulation}`
            #     `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
            #     `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
            #   @param filter [::String]
            #     The filter expression that filters the attack path in the response.
            #     Supported fields:
            #
            #       * `valued_resources` supports =
            #   @param page_token [::String]
            #     The value returned by the last `ListAttackPathsResponse`; indicates
            #     that this is a continuation of a prior `ListAttackPaths` call, and
            #     that the system should return the next page of data.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. Default is
            #     10, minimum is 1, maximum is 1000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::AttackPath>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecurityCenter::V1::AttackPath>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/security_center/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest.new
            #
            #   # Call the list_attack_paths method.
            #   result = client.list_attack_paths request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecurityCenter::V1::AttackPath.
            #     p item
            #   end
            #
            def list_attack_paths request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecurityCenter::V1::ListAttackPathsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_attack_paths.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecurityCenter::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_attack_paths.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_attack_paths.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @security_center_stub.call_rpc :list_attack_paths, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @security_center_stub, :list_attack_paths, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SecurityCenter API.
            #
            # This class represents the configuration for SecurityCenter,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # bulk_mute_findings to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.bulk_mute_findings.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.bulk_mute_findings.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::SecurityCenter::V1::SecurityCenter::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "securitycenter.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SecurityCenter API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `bulk_mute_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :bulk_mute_findings
                ##
                # RPC-specific configuration for `create_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `create_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_source
                ##
                # RPC-specific configuration for `create_finding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_finding
                ##
                # RPC-specific configuration for `create_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_mute_config
                ##
                # RPC-specific configuration for `create_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_notification_config
                ##
                # RPC-specific configuration for `delete_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_mute_config
                ##
                # RPC-specific configuration for `delete_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_notification_config
                ##
                # RPC-specific configuration for `delete_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `get_simulation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_simulation
                ##
                # RPC-specific configuration for `get_valued_resource`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_valued_resource
                ##
                # RPC-specific configuration for `get_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_big_query_export
                ##
                # RPC-specific configuration for `get_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_iam_policy
                ##
                # RPC-specific configuration for `get_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_mute_config
                ##
                # RPC-specific configuration for `get_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_notification_config
                ##
                # RPC-specific configuration for `get_organization_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_organization_settings
                ##
                # RPC-specific configuration for `get_effective_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_effective_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `get_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `get_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_source
                ##
                # RPC-specific configuration for `group_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :group_assets
                ##
                # RPC-specific configuration for `group_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :group_findings
                ##
                # RPC-specific configuration for `list_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_assets
                ##
                # RPC-specific configuration for `list_descendant_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_descendant_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `list_findings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_findings
                ##
                # RPC-specific configuration for `list_mute_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_mute_configs
                ##
                # RPC-specific configuration for `list_notification_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_notification_configs
                ##
                # RPC-specific configuration for `list_effective_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_effective_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `list_security_health_analytics_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_security_health_analytics_custom_modules
                ##
                # RPC-specific configuration for `list_sources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_sources
                ##
                # RPC-specific configuration for `run_asset_discovery`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_asset_discovery
                ##
                # RPC-specific configuration for `set_finding_state`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_finding_state
                ##
                # RPC-specific configuration for `set_mute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_mute
                ##
                # RPC-specific configuration for `set_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_iam_policy
                ##
                # RPC-specific configuration for `test_iam_permissions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :test_iam_permissions
                ##
                # RPC-specific configuration for `simulate_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :simulate_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `update_external_system`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_external_system
                ##
                # RPC-specific configuration for `update_finding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_finding
                ##
                # RPC-specific configuration for `update_mute_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_mute_config
                ##
                # RPC-specific configuration for `update_notification_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_notification_config
                ##
                # RPC-specific configuration for `update_organization_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_organization_settings
                ##
                # RPC-specific configuration for `update_security_health_analytics_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_security_health_analytics_custom_module
                ##
                # RPC-specific configuration for `update_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_source
                ##
                # RPC-specific configuration for `update_security_marks`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_security_marks
                ##
                # RPC-specific configuration for `create_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_big_query_export
                ##
                # RPC-specific configuration for `delete_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_big_query_export
                ##
                # RPC-specific configuration for `update_big_query_export`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_big_query_export
                ##
                # RPC-specific configuration for `list_big_query_exports`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_big_query_exports
                ##
                # RPC-specific configuration for `create_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `delete_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `get_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `list_descendant_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_descendant_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `list_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `update_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `validate_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :validate_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `get_effective_event_threat_detection_custom_module`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_effective_event_threat_detection_custom_module
                ##
                # RPC-specific configuration for `list_effective_event_threat_detection_custom_modules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_effective_event_threat_detection_custom_modules
                ##
                # RPC-specific configuration for `batch_create_resource_value_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_resource_value_configs
                ##
                # RPC-specific configuration for `delete_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_resource_value_config
                ##
                # RPC-specific configuration for `get_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource_value_config
                ##
                # RPC-specific configuration for `list_resource_value_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resource_value_configs
                ##
                # RPC-specific configuration for `update_resource_value_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_resource_value_config
                ##
                # RPC-specific configuration for `list_valued_resources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_valued_resources
                ##
                # RPC-specific configuration for `list_attack_paths`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_attack_paths

                # @private
                def initialize parent_rpcs = nil
                  bulk_mute_findings_config = parent_rpcs.bulk_mute_findings if parent_rpcs.respond_to? :bulk_mute_findings
                  @bulk_mute_findings = ::Gapic::Config::Method.new bulk_mute_findings_config
                  create_security_health_analytics_custom_module_config = parent_rpcs.create_security_health_analytics_custom_module if parent_rpcs.respond_to? :create_security_health_analytics_custom_module
                  @create_security_health_analytics_custom_module = ::Gapic::Config::Method.new create_security_health_analytics_custom_module_config
                  create_source_config = parent_rpcs.create_source if parent_rpcs.respond_to? :create_source
                  @create_source = ::Gapic::Config::Method.new create_source_config
                  create_finding_config = parent_rpcs.create_finding if parent_rpcs.respond_to? :create_finding
                  @create_finding = ::Gapic::Config::Method.new create_finding_config
                  create_mute_config_config = parent_rpcs.create_mute_config if parent_rpcs.respond_to? :create_mute_config
                  @create_mute_config = ::Gapic::Config::Method.new create_mute_config_config
                  create_notification_config_config = parent_rpcs.create_notification_config if parent_rpcs.respond_to? :create_notification_config
                  @create_notification_config = ::Gapic::Config::Method.new create_notification_config_config
                  delete_mute_config_config = parent_rpcs.delete_mute_config if parent_rpcs.respond_to? :delete_mute_config
                  @delete_mute_config = ::Gapic::Config::Method.new delete_mute_config_config
                  delete_notification_config_config = parent_rpcs.delete_notification_config if parent_rpcs.respond_to? :delete_notification_config
                  @delete_notification_config = ::Gapic::Config::Method.new delete_notification_config_config
                  delete_security_health_analytics_custom_module_config = parent_rpcs.delete_security_health_analytics_custom_module if parent_rpcs.respond_to? :delete_security_health_analytics_custom_module
                  @delete_security_health_analytics_custom_module = ::Gapic::Config::Method.new delete_security_health_analytics_custom_module_config
                  get_simulation_config = parent_rpcs.get_simulation if parent_rpcs.respond_to? :get_simulation
                  @get_simulation = ::Gapic::Config::Method.new get_simulation_config
                  get_valued_resource_config = parent_rpcs.get_valued_resource if parent_rpcs.respond_to? :get_valued_resource
                  @get_valued_resource = ::Gapic::Config::Method.new get_valued_resource_config
                  get_big_query_export_config = parent_rpcs.get_big_query_export if parent_rpcs.respond_to? :get_big_query_export
                  @get_big_query_export = ::Gapic::Config::Method.new get_big_query_export_config
                  get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                  @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                  get_mute_config_config = parent_rpcs.get_mute_config if parent_rpcs.respond_to? :get_mute_config
                  @get_mute_config = ::Gapic::Config::Method.new get_mute_config_config
                  get_notification_config_config = parent_rpcs.get_notification_config if parent_rpcs.respond_to? :get_notification_config
                  @get_notification_config = ::Gapic::Config::Method.new get_notification_config_config
                  get_organization_settings_config = parent_rpcs.get_organization_settings if parent_rpcs.respond_to? :get_organization_settings
                  @get_organization_settings = ::Gapic::Config::Method.new get_organization_settings_config
                  get_effective_security_health_analytics_custom_module_config = parent_rpcs.get_effective_security_health_analytics_custom_module if parent_rpcs.respond_to? :get_effective_security_health_analytics_custom_module
                  @get_effective_security_health_analytics_custom_module = ::Gapic::Config::Method.new get_effective_security_health_analytics_custom_module_config
                  get_security_health_analytics_custom_module_config = parent_rpcs.get_security_health_analytics_custom_module if parent_rpcs.respond_to? :get_security_health_analytics_custom_module
                  @get_security_health_analytics_custom_module = ::Gapic::Config::Method.new get_security_health_analytics_custom_module_config
                  get_source_config = parent_rpcs.get_source if parent_rpcs.respond_to? :get_source
                  @get_source = ::Gapic::Config::Method.new get_source_config
                  group_assets_config = parent_rpcs.group_assets if parent_rpcs.respond_to? :group_assets
                  @group_assets = ::Gapic::Config::Method.new group_assets_config
                  group_findings_config = parent_rpcs.group_findings if parent_rpcs.respond_to? :group_findings
                  @group_findings = ::Gapic::Config::Method.new group_findings_config
                  list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                  @list_assets = ::Gapic::Config::Method.new list_assets_config
                  list_descendant_security_health_analytics_custom_modules_config = parent_rpcs.list_descendant_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_descendant_security_health_analytics_custom_modules
                  @list_descendant_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_descendant_security_health_analytics_custom_modules_config
                  list_findings_config = parent_rpcs.list_findings if parent_rpcs.respond_to? :list_findings
                  @list_findings = ::Gapic::Config::Method.new list_findings_config
                  list_mute_configs_config = parent_rpcs.list_mute_configs if parent_rpcs.respond_to? :list_mute_configs
                  @list_mute_configs = ::Gapic::Config::Method.new list_mute_configs_config
                  list_notification_configs_config = parent_rpcs.list_notification_configs if parent_rpcs.respond_to? :list_notification_configs
                  @list_notification_configs = ::Gapic::Config::Method.new list_notification_configs_config
                  list_effective_security_health_analytics_custom_modules_config = parent_rpcs.list_effective_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_effective_security_health_analytics_custom_modules
                  @list_effective_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_effective_security_health_analytics_custom_modules_config
                  list_security_health_analytics_custom_modules_config = parent_rpcs.list_security_health_analytics_custom_modules if parent_rpcs.respond_to? :list_security_health_analytics_custom_modules
                  @list_security_health_analytics_custom_modules = ::Gapic::Config::Method.new list_security_health_analytics_custom_modules_config
                  list_sources_config = parent_rpcs.list_sources if parent_rpcs.respond_to? :list_sources
                  @list_sources = ::Gapic::Config::Method.new list_sources_config
                  run_asset_discovery_config = parent_rpcs.run_asset_discovery if parent_rpcs.respond_to? :run_asset_discovery
                  @run_asset_discovery = ::Gapic::Config::Method.new run_asset_discovery_config
                  set_finding_state_config = parent_rpcs.set_finding_state if parent_rpcs.respond_to? :set_finding_state
                  @set_finding_state = ::Gapic::Config::Method.new set_finding_state_config
                  set_mute_config = parent_rpcs.set_mute if parent_rpcs.respond_to? :set_mute
                  @set_mute = ::Gapic::Config::Method.new set_mute_config
                  set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                  @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                  test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                  @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                  simulate_security_health_analytics_custom_module_config = parent_rpcs.simulate_security_health_analytics_custom_module if parent_rpcs.respond_to? :simulate_security_health_analytics_custom_module
                  @simulate_security_health_analytics_custom_module = ::Gapic::Config::Method.new simulate_security_health_analytics_custom_module_config
                  update_external_system_config = parent_rpcs.update_external_system if parent_rpcs.respond_to? :update_external_system
                  @update_external_system = ::Gapic::Config::Method.new update_external_system_config
                  update_finding_config = parent_rpcs.update_finding if parent_rpcs.respond_to? :update_finding
                  @update_finding = ::Gapic::Config::Method.new update_finding_config
                  update_mute_config_config = parent_rpcs.update_mute_config if parent_rpcs.respond_to? :update_mute_config
                  @update_mute_config = ::Gapic::Config::Method.new update_mute_config_config
                  update_notification_config_config = parent_rpcs.update_notification_config if parent_rpcs.respond_to? :update_notification_config
                  @update_notification_config = ::Gapic::Config::Method.new update_notification_config_config
                  update_organization_settings_config = parent_rpcs.update_organization_settings if parent_rpcs.respond_to? :update_organization_settings
                  @update_organization_settings = ::Gapic::Config::Method.new update_organization_settings_config
                  update_security_health_analytics_custom_module_config = parent_rpcs.update_security_health_analytics_custom_module if parent_rpcs.respond_to? :update_security_health_analytics_custom_module
                  @update_security_health_analytics_custom_module = ::Gapic::Config::Method.new update_security_health_analytics_custom_module_config
                  update_source_config = parent_rpcs.update_source if parent_rpcs.respond_to? :update_source
                  @update_source = ::Gapic::Config::Method.new update_source_config
                  update_security_marks_config = parent_rpcs.update_security_marks if parent_rpcs.respond_to? :update_security_marks
                  @update_security_marks = ::Gapic::Config::Method.new update_security_marks_config
                  create_big_query_export_config = parent_rpcs.create_big_query_export if parent_rpcs.respond_to? :create_big_query_export
                  @create_big_query_export = ::Gapic::Config::Method.new create_big_query_export_config
                  delete_big_query_export_config = parent_rpcs.delete_big_query_export if parent_rpcs.respond_to? :delete_big_query_export
                  @delete_big_query_export = ::Gapic::Config::Method.new delete_big_query_export_config
                  update_big_query_export_config = parent_rpcs.update_big_query_export if parent_rpcs.respond_to? :update_big_query_export
                  @update_big_query_export = ::Gapic::Config::Method.new update_big_query_export_config
                  list_big_query_exports_config = parent_rpcs.list_big_query_exports if parent_rpcs.respond_to? :list_big_query_exports
                  @list_big_query_exports = ::Gapic::Config::Method.new list_big_query_exports_config
                  create_event_threat_detection_custom_module_config = parent_rpcs.create_event_threat_detection_custom_module if parent_rpcs.respond_to? :create_event_threat_detection_custom_module
                  @create_event_threat_detection_custom_module = ::Gapic::Config::Method.new create_event_threat_detection_custom_module_config
                  delete_event_threat_detection_custom_module_config = parent_rpcs.delete_event_threat_detection_custom_module if parent_rpcs.respond_to? :delete_event_threat_detection_custom_module
                  @delete_event_threat_detection_custom_module = ::Gapic::Config::Method.new delete_event_threat_detection_custom_module_config
                  get_event_threat_detection_custom_module_config = parent_rpcs.get_event_threat_detection_custom_module if parent_rpcs.respond_to? :get_event_threat_detection_custom_module
                  @get_event_threat_detection_custom_module = ::Gapic::Config::Method.new get_event_threat_detection_custom_module_config
                  list_descendant_event_threat_detection_custom_modules_config = parent_rpcs.list_descendant_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_descendant_event_threat_detection_custom_modules
                  @list_descendant_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_descendant_event_threat_detection_custom_modules_config
                  list_event_threat_detection_custom_modules_config = parent_rpcs.list_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_event_threat_detection_custom_modules
                  @list_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_event_threat_detection_custom_modules_config
                  update_event_threat_detection_custom_module_config = parent_rpcs.update_event_threat_detection_custom_module if parent_rpcs.respond_to? :update_event_threat_detection_custom_module
                  @update_event_threat_detection_custom_module = ::Gapic::Config::Method.new update_event_threat_detection_custom_module_config
                  validate_event_threat_detection_custom_module_config = parent_rpcs.validate_event_threat_detection_custom_module if parent_rpcs.respond_to? :validate_event_threat_detection_custom_module
                  @validate_event_threat_detection_custom_module = ::Gapic::Config::Method.new validate_event_threat_detection_custom_module_config
                  get_effective_event_threat_detection_custom_module_config = parent_rpcs.get_effective_event_threat_detection_custom_module if parent_rpcs.respond_to? :get_effective_event_threat_detection_custom_module
                  @get_effective_event_threat_detection_custom_module = ::Gapic::Config::Method.new get_effective_event_threat_detection_custom_module_config
                  list_effective_event_threat_detection_custom_modules_config = parent_rpcs.list_effective_event_threat_detection_custom_modules if parent_rpcs.respond_to? :list_effective_event_threat_detection_custom_modules
                  @list_effective_event_threat_detection_custom_modules = ::Gapic::Config::Method.new list_effective_event_threat_detection_custom_modules_config
                  batch_create_resource_value_configs_config = parent_rpcs.batch_create_resource_value_configs if parent_rpcs.respond_to? :batch_create_resource_value_configs
                  @batch_create_resource_value_configs = ::Gapic::Config::Method.new batch_create_resource_value_configs_config
                  delete_resource_value_config_config = parent_rpcs.delete_resource_value_config if parent_rpcs.respond_to? :delete_resource_value_config
                  @delete_resource_value_config = ::Gapic::Config::Method.new delete_resource_value_config_config
                  get_resource_value_config_config = parent_rpcs.get_resource_value_config if parent_rpcs.respond_to? :get_resource_value_config
                  @get_resource_value_config = ::Gapic::Config::Method.new get_resource_value_config_config
                  list_resource_value_configs_config = parent_rpcs.list_resource_value_configs if parent_rpcs.respond_to? :list_resource_value_configs
                  @list_resource_value_configs = ::Gapic::Config::Method.new list_resource_value_configs_config
                  update_resource_value_config_config = parent_rpcs.update_resource_value_config if parent_rpcs.respond_to? :update_resource_value_config
                  @update_resource_value_config = ::Gapic::Config::Method.new update_resource_value_config_config
                  list_valued_resources_config = parent_rpcs.list_valued_resources if parent_rpcs.respond_to? :list_valued_resources
                  @list_valued_resources = ::Gapic::Config::Method.new list_valued_resources_config
                  list_attack_paths_config = parent_rpcs.list_attack_paths if parent_rpcs.respond_to? :list_attack_paths
                  @list_attack_paths = ::Gapic::Config::Method.new list_attack_paths_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
