# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/security/privateca/v1beta1/service_pb"
require "google/cloud/security/private_ca/v1beta1/certificate_authority_service/rest"


class ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_id = "hello world"
    certificate = {}
    request_id = "hello world"

    create_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate ::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate(::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_client_stub.call_count
      end
    end
  end

  def test_get_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate(::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_client_stub.call_count
      end
    end
  end

  def test_list_certificates
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificates_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificates ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificates(::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificates_client_stub.call_count
      end
    end
  end

  def test_revoke_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = :REVOCATION_REASON_UNSPECIFIED
    request_id = "hello world"

    revoke_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_revoke_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, revoke_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.revoke_certificate({ name: name, reason: reason, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.revoke_certificate name: name, reason: reason, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.revoke_certificate ::Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.revoke_certificate({ name: name, reason: reason, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.revoke_certificate(::Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, revoke_certificate_client_stub.call_count
      end
    end
  end

  def test_update_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate certificate: certificate, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate(::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_client_stub.call_count
      end
    end
  end

  def test_activate_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    pem_ca_certificate = "hello world"
    subordinate_config = {}
    request_id = "hello world"

    activate_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_activate_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, activate_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.activate_certificate_authority name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.activate_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.activate_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, activate_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_create_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_authority_id = "hello world"
    certificate_authority = {}
    request_id = "hello world"

    create_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_authority parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_disable_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    disable_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_disable_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_enable_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    enable_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_enable_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_fetch_certificate_authority_csr
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_certificate_authority_csr_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_fetch_certificate_authority_csr_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_certificate_authority_csr_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_certificate_authority_csr({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_certificate_authority_csr name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_certificate_authority_csr ::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_certificate_authority_csr({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_certificate_authority_csr(::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_certificate_authority_csr_client_stub.call_count
      end
    end
  end

  def test_get_certificate_authority
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_authority({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_authority name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_authority({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_list_certificate_authorities
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_authorities_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificate_authorities_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_authorities_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_authorities parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_authorities ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_authorities(::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_authorities_client_stub.call_count
      end
    end
  end

  def test_restore_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    restore_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_restore_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_schedule_delete_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    schedule_delete_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_schedule_delete_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, schedule_delete_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.schedule_delete_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.schedule_delete_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.schedule_delete_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.schedule_delete_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.schedule_delete_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, schedule_delete_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_update_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_authority = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_authority certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_authority ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_authority(::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_get_certificate_revocation_list
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_revocation_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_revocation_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_revocation_list_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_revocation_list({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_revocation_list name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_revocation_list({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_revocation_list_client_stub.call_count
      end
    end
  end

  def test_list_certificate_revocation_lists
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_revocation_lists_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificate_revocation_lists_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_revocation_lists_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_revocation_lists parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_revocation_lists ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_revocation_lists(::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_revocation_lists_client_stub.call_count
      end
    end
  end

  def test_update_certificate_revocation_list
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_revocation_list = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_revocation_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_revocation_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_revocation_list_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_revocation_list certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_revocation_list_client_stub.call_count
      end
    end
  end

  def test_get_reusable_config
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reusable_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_reusable_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reusable_config_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reusable_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reusable_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reusable_config ::Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reusable_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reusable_config(::Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reusable_config_client_stub.call_count
      end
    end
  end

  def test_list_reusable_configs
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_reusable_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_reusable_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reusable_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reusable_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reusable_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reusable_configs ::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reusable_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reusable_configs(::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reusable_configs_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Rest::Client::Configuration, config
  end
end
