# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Security
      module PrivateCA
        module V1beta1
          # Request message for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#create_certificate CertificateAuthorityService.CreateCertificate}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location and {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
          #     associated with the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}, in the format
          #     `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] certificate_id
          #   @return [::String]
          #     Optional. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`. This field is required when using a
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the Enterprise {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Tier CertificateAuthority.Tier},
          #     but is optional and its value is ignored otherwise.
          # @!attribute [rw] certificate
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
          #     Required. A {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} with initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#get_certificate CertificateAuthorityService.GetCertificate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate#name name} of the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} to get.
          class GetCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificates CertificateAuthorityService.ListCertificates}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}, in the format
          #     `projects/*/locations/*/certificateauthorities/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} to include in the
          #     response. Further {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} can subsequently be obtained
          #     by including the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token} in a subsequent
          #     request. If unspecified, the server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response. For details
          #     on supported filters and syntax, see [Certificates Filtering
          #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#filtering_support).
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted. For details on supported fields
          #     and syntax, see [Certificates Sorting
          #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#sorting_support).
          class ListCertificatesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificates CertificateAuthorityService.ListCertificates}.
          # @!attribute [rw] certificates
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::Certificate>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     [ListCertificatesRequest.next_page_token][] to retrieve the
          #     next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificatesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#revoke_certificate CertificateAuthorityService.RevokeCertificate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} in the
          #     format `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
          # @!attribute [rw] reason
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason RevocationReason} for revoking this certificate.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class RevokeCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#update_certificate CertificateAuthorityService.UpdateCertificate}.
          # @!attribute [rw] certificate
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
          #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#activate_certificate_authority CertificateAuthorityService.ActivateCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] pem_ca_certificate
          #   @return [::String]
          #     Required. The signed CA certificate issued from
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse#pem_csr FetchCertificateAuthorityCsrResponse.pem_csr}.
          # @!attribute [rw] subordinate_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::SubordinateConfig]
          #     Required. Must include information about the issuer of 'pem_ca_certificate', and any
          #     further issuers until the self-signed CA.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class ActivateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#create_certificate_authority CertificateAuthorityService.CreateCertificateAuthority}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}, in the format
          #     `projects/*/locations/*`.
          # @!attribute [rw] certificate_authority_id
          #   @return [::String]
          #     Required. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`
          # @!attribute [rw] certificate_authority
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority]
          #     Required. A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} with initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#disable_certificate_authority CertificateAuthorityService.DisableCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DisableCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#enable_certificate_authority CertificateAuthorityService.EnableCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class EnableCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#fetch_certificate_authority_csr CertificateAuthorityService.FetchCertificateAuthorityCsr}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          class FetchCertificateAuthorityCsrRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#fetch_certificate_authority_csr CertificateAuthorityService.FetchCertificateAuthorityCsr}.
          # @!attribute [r] pem_csr
          #   @return [::String]
          #     Output only. The PEM-encoded signed certificate signing request (CSR).
          class FetchCertificateAuthorityCsrResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#get_certificate_authority CertificateAuthorityService.GetCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority#name name} of the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} to
          #     get.
          class GetCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificate_authorities CertificateAuthorityService.ListCertificateAuthorities}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}, in the format
          #     `projects/*/locations/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities} to
          #     include in the response.
          #     Further {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities} can subsequently be
          #     obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token} in a subsequent
          #     request. If unspecified, the server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCertificateAuthoritiesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificate_authorities CertificateAuthorityService.ListCertificateAuthorities}.
          # @!attribute [rw] certificate_authorities
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     [ListCertificateAuthoritiesRequest.next_page_token][] to retrieve the next
          #     page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificateAuthoritiesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#restore_certificate_authority CertificateAuthorityService.RestoreCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class RestoreCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#schedule_delete_certificate_authority CertificateAuthorityService.ScheduleDeleteCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class ScheduleDeleteCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#update_certificate_authority CertificateAuthorityService.UpdateCertificateAuthority}.
          # @!attribute [rw] certificate_authority
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority]
          #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#get_certificate_revocation_list CertificateAuthorityService.GetCertificateRevocationList}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList#name name} of the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} to get.
          class GetCertificateRevocationListRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificate_revocation_lists CertificateAuthorityService.ListCertificateRevocationLists}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}, in the format
          #     `projects/*/locations/*/certificateauthorities/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists} to include in the
          #     response. Further {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}
          #     can subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token} in a subsequent
          #     request. If unspecified, the server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCertificateRevocationListsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_certificate_revocation_lists CertificateAuthorityService.ListCertificateRevocationLists}.
          # @!attribute [rw] certificate_revocation_lists
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     [ListCertificateRevocationListsRequest.next_page_token][] to retrieve the
          #     next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificateRevocationListsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#update_certificate_revocation_list CertificateAuthorityService.UpdateCertificateRevocationList}.
          # @!attribute [rw] certificate_revocation_list
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList]
          #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
          #     retry your request, the server will know to ignore the request if it has
          #     already been completed. The server will guarantee that for at least 60
          #     minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and t
          #     he request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateRevocationListRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#get_reusable_config CertificateAuthorityService.GetReusableConfig}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The [name][ReusableConfigs.name] of the [ReusableConfigs][] to get.
          class GetReusableConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_reusable_configs CertificateAuthorityService.ListReusableConfigs}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs}, in the format
          #     `projects/*/locations/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs} to include in the response.
          #     Further {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs} can subsequently be
          #     obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsResponse#next_page_token ListReusableConfigsResponse.next_page_token} in a subsequent request. If
          #     unspecified, the server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsResponse#next_page_token ListReusableConfigsResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListReusableConfigsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#list_reusable_configs CertificateAuthorityService.ListReusableConfigs}.
          # @!attribute [rw] reusable_configs
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     [ListReusableConfigsRequest.next_page_token][] to retrieve
          #     the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListReusableConfigsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have [Operation.error][] value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
          #     corresponding to `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class OperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
