# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Security
      module PrivateCA
        module V1beta1
          # A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} represents an individual Certificate Authority.
          # A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} can be used to create {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
          #     format `projects/*/locations/*/certificateAuthorities/*`.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Type]
          #     Required. Immutable. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Type Type} of this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] tier
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Tier]
          #     Required. Immutable. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Tier Tier} of this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateConfig]
          #     Required. Immutable. The config used to create a self-signed X.509 certificate or CSR.
          # @!attribute [rw] lifetime
          #   @return [::Google::Protobuf::Duration]
          #     Required. The desired lifetime of the CA certificate. Used to create the
          #     "not_before_time" and "not_after_time" fields inside an X.509
          #     certificate.
          # @!attribute [rw] key_spec
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::KeyVersionSpec]
          #     Required. Immutable. Used when issuing certificates for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}. If this
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} is a self-signed CertificateAuthority, this key
          #     is also used to sign the self-signed CA certificate. Otherwise, it
          #     is used to sign a CSR.
          # @!attribute [rw] certificate_policy
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy]
          #     Optional. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy CertificateAuthorityPolicy} to enforce when issuing
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} from this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] issuing_options
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::IssuingOptions]
          #     Optional. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::IssuingOptions IssuingOptions} to follow when issuing {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}
          #     from this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] subordinate_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::SubordinateConfig]
          #     Optional. If this is a subordinate {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, this field will be set
          #     with the subordinate configuration, which describes its issuers. This may
          #     be updated, but this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} must continue to validate.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::State]
          #     Output only. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::State State} for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [r] pem_ca_certificates
          #   @return [::Array<::String>]
          #     Output only. This {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s certificate chain, including the current
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s certificate. Ordered such that the root issuer
          #     is the final element (consistent with RFC 5246). For a self-signed CA, this
          #     will only list the current {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s certificate.
          # @!attribute [r] ca_certificate_descriptions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription>]
          #     Output only. A structured description of this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s CA certificate
          #     and its issuers. Ordered as self-to-root.
          # @!attribute [rw] gcs_bucket
          #   @return [::String]
          #     Immutable. The name of a Cloud Storage bucket where this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} will
          #     publish content, such as the CA certificate and CRLs. This must be a bucket
          #     name, without any prefixes (such as `gs://`) or suffixes (such as
          #     `.googleapis.com`). For example, to use a bucket named `my-bucket`, you
          #     would simply specify `my-bucket`. If not specified, a managed bucket will
          #     be created.
          # @!attribute [r] access_urls
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::AccessUrls]
          #     Output only. URLs for accessing content published by this CA, such as the CA certificate
          #     and CRLs.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} was updated.
          # @!attribute [r] delete_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} will be deleted, if
          #     scheduled for deletion.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class CertificateAuthority
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Options that affect all certificates issued by a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
            # @!attribute [rw] include_ca_cert_url
            #   @return [::Boolean]
            #     Required. When true, includes a URL to the issuing CA certificate in the
            #     "authority information access" X.509 extension.
            # @!attribute [rw] include_crl_access_url
            #   @return [::Boolean]
            #     Required. When true, includes a URL to the CRL corresponding to certificates
            #     issued from a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
            #     CRLs will expire 7 days from their creation. However, we will rebuild
            #     daily. CRLs are also rebuilt shortly after a certificate is revoked.
            class IssuingOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The issuing policy for a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
            # {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} will not be successfully issued from this
            # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} if they violate the policy.
            # @!attribute [rw] allowed_config_list
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedConfigList]
            #     Optional. All {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
            #     must match at least one listed {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper ReusableConfigWrapper} in the list.
            #
            #     Note: The following fields are mutually exclusive: `allowed_config_list`, `overwrite_config_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] overwrite_config_values
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper]
            #     Optional. All {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
            #     will use the provided configuration values, overwriting any requested
            #     configuration values.
            #
            #     Note: The following fields are mutually exclusive: `overwrite_config_values`, `allowed_config_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] allowed_locations_and_organizations
            #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::Subject>]
            #     Optional. If any {::Google::Cloud::Security::PrivateCA::V1beta1::Subject Subject} is specified here, then all
            #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} must
            #     match at least one listed {::Google::Cloud::Security::PrivateCA::V1beta1::Subject Subject}. If a {::Google::Cloud::Security::PrivateCA::V1beta1::Subject Subject} has an empty
            #     field, any value will be allowed for that field.
            # @!attribute [rw] allowed_common_names
            #   @return [::Array<::String>]
            #     Optional. If any value is specified here, then all
            #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} must
            #     match at least one listed value. If no value is specified, all values
            #     will be allowed for this fied. Glob patterns are also supported.
            # @!attribute [rw] allowed_sans
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames]
            #     Optional. If a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames AllowedSubjectAltNames} is specified here, then all
            #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} must
            #     match {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames AllowedSubjectAltNames}. If no value or an empty value
            #     is specified, any value will be allowed for the {::Google::Cloud::Security::PrivateCA::V1beta1::SubjectAltNames SubjectAltNames}
            #     field.
            # @!attribute [rw] maximum_lifetime
            #   @return [::Google::Protobuf::Duration]
            #     Optional. The maximum lifetime allowed by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}. Note that
            #     if the any part if the issuing chain expires before a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}'s
            #     requested maximum_lifetime, the effective lifetime will be explicitly
            #     truncated.
            # @!attribute [rw] allowed_issuance_modes
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::IssuanceModes]
            #     Optional. If specified, then only methods allowed in the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::IssuanceModes IssuanceModes} may be
            #     used to issue {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}.
            class CertificateAuthorityPolicy
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # @!attribute [rw] allowed_config_values
              #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper>]
              #     Required. All {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} issued by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
              #     must match at least one listed {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper ReusableConfigWrapper}. If a
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper ReusableConfigWrapper} has an empty field, any value will be
              #     allowed for that field.
              class AllowedConfigList
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames AllowedSubjectAltNames} specifies the allowed values for
              # {::Google::Cloud::Security::PrivateCA::V1beta1::SubjectAltNames SubjectAltNames} by the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} when issuing
              # {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}.
              # @!attribute [rw] allowed_dns_names
              #   @return [::Array<::String>]
              #     Optional. Contains valid, fully-qualified host names. Glob patterns are also
              #     supported. To allow an explicit wildcard certificate, escape with
              #     backlash (i.e. `\*`).
              #     E.g. for globbed entries: `*bar.com` will allow `foo.bar.com`, but not
              #     `*.bar.com`, unless the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames#allow_globbing_dns_wildcards allow_globbing_dns_wildcards} field is set.
              #     E.g. for wildcard entries: `\*.bar.com` will allow `*.bar.com`, but not
              #     `foo.bar.com`.
              # @!attribute [rw] allowed_uris
              #   @return [::Array<::String>]
              #     Optional. Contains valid RFC 3986 URIs. Glob patterns are also supported. To
              #     match across path seperators (i.e. '/') use the double star glob
              #     pattern (i.e. '**').
              # @!attribute [rw] allowed_email_addresses
              #   @return [::Array<::String>]
              #     Optional. Contains valid RFC 2822 E-mail addresses. Glob patterns are also
              #     supported.
              # @!attribute [rw] allowed_ips
              #   @return [::Array<::String>]
              #     Optional. Contains valid 32-bit IPv4 addresses and subnet ranges or RFC 4291 IPv6
              #     addresses and subnet ranges. Subnet ranges are specified using the
              #     '/' notation (e.g. 10.0.0.0/8, 2001:700:300:1800::/64). Glob patterns
              #     are supported only for ip address entries (i.e. not for subnet ranges).
              # @!attribute [rw] allow_globbing_dns_wildcards
              #   @return [::Boolean]
              #     Optional. Specifies if glob patterns used for {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::AllowedSubjectAltNames#allowed_dns_names allowed_dns_names} allows
              #     wildcard certificates.
              # @!attribute [rw] allow_custom_sans
              #   @return [::Boolean]
              #     Optional. Specifies if to allow custom X509Extension values.
              class AllowedSubjectAltNames
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::CertificateAuthorityPolicy::IssuanceModes IssuanceModes} specifies the allowed ways in which
              # {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} may be requested from this
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              # @!attribute [rw] allow_csr_based_issuance
              #   @return [::Boolean]
              #     Required. When true, allows callers to create {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} by
              #     specifying a CSR.
              # @!attribute [rw] allow_config_based_issuance
              #   @return [::Boolean]
              #     Required. When true, allows callers to create {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} by
              #     specifying a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateConfig CertificateConfig}.
              class IssuanceModes
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # URLs where a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} will publish content.
            # @!attribute [rw] ca_certificate_access_url
            #   @return [::String]
            #     The URL where this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s CA certificate is
            #     published. This will only be set for CAs that have been activated.
            # @!attribute [rw] crl_access_url
            #   @return [::String]
            #     The URL where this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}'s CRLs are published. This
            #     will only be set for CAs that have been activated.
            class AccessUrls
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A Cloud KMS key configuration that a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} will use.
            # @!attribute [rw] cloud_kms_key_version
            #   @return [::String]
            #     Required. The resource name for an existing Cloud KMS CryptoKeyVersion in the
            #     format
            #     `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
            #     This option enables full flexibility in the key's capabilities and
            #     properties.
            #
            #     Note: The following fields are mutually exclusive: `cloud_kms_key_version`, `algorithm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] algorithm
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::SignHashAlgorithm]
            #     Required. The algorithm to use for creating a managed Cloud KMS key for a for a
            #     simplified experience. All managed keys will be have their
            #     [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] as `HSM`.
            #
            #     Note: The following fields are mutually exclusive: `algorithm`, `cloud_kms_key_version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class KeyVersionSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The type of a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, indicating its issuing chain.
            module Type
              # Not specified.
              TYPE_UNSPECIFIED = 0

              # Self-signed CA.
              SELF_SIGNED = 1

              # Subordinate CA. Could be issued by a Private CA {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
              # or an unmanaged CA.
              SUBORDINATE = 2
            end

            # The tier of a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, indicating its supported
            # functionality and/or billing SKU.
            module Tier
              # Not specified.
              TIER_UNSPECIFIED = 0

              # Enterprise tier.
              ENTERPRISE = 1

              # DevOps tier.
              DEVOPS = 2
            end

            # The state of a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, indicating if it can be used.
            module State
              # Not specified.
              STATE_UNSPECIFIED = 0

              # Certificates can be issued from this CA. CRLs will be generated for this
              # CA.
              ENABLED = 1

              # Certificates cannot be issued from this CA. CRLs will still be generated.
              DISABLED = 2

              # Certificates cannot be issued from this CA. CRLs will not be generated.
              PENDING_ACTIVATION = 3

              # Certificates cannot be issued from this CA. CRLs will not be generated.
              PENDING_DELETION = 4
            end

            # The algorithm of a Cloud KMS CryptoKeyVersion of a
            # [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
            # [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
            # `ASYMMETRIC_SIGN`. These values correspond to the
            # [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
            # values. For RSA signing algorithms, the PSS algorithms should be preferred,
            # use PKCS1 algorithms if required for compatibility. For further
            # recommandations, see
            # https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
            module SignHashAlgorithm
              # Not specified.
              SIGN_HASH_ALGORITHM_UNSPECIFIED = 0

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256
              RSA_PSS_2048_SHA256 = 1

              # maps to CryptoKeyVersionAlgorithm. RSA_SIGN_PSS_3072_SHA256
              RSA_PSS_3072_SHA256 = 2

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_4096_SHA256
              RSA_PSS_4096_SHA256 = 3

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_2048_SHA256
              RSA_PKCS1_2048_SHA256 = 6

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_3072_SHA256
              RSA_PKCS1_3072_SHA256 = 7

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_4096_SHA256
              RSA_PKCS1_4096_SHA256 = 8

              # maps to CryptoKeyVersionAlgorithm.EC_SIGN_P256_SHA256
              EC_P256_SHA256 = 4

              # maps to CryptoKeyVersionAlgorithm.EC_SIGN_P384_SHA384
              EC_P384_SHA384 = 5
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} corresponds to a signed X.509 certificate
          # Revocation List (CRL). A CRL contains the serial numbers of certificates that
          # should no longer be trusted.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource path for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} in
          #     the format
          #     `projects/*/locations/*/certificateAuthorities/*/
          #        certificateRevocationLists/*`.
          # @!attribute [r] sequence_number
          #   @return [::Integer]
          #     Output only. The CRL sequence number that appears in pem_crl.
          # @!attribute [r] revoked_certificates
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList::RevokedCertificate>]
          #     Output only. The revoked serial numbers that appear in pem_crl.
          # @!attribute [r] pem_crl
          #   @return [::String]
          #     Output only. The PEM-encoded X.509 CRL.
          # @!attribute [r] access_url
          #   @return [::String]
          #     Output only. The location where 'pem_crl' can be accessed.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList::State]
          #     Output only. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList::State State} for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList}.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} was updated.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class CertificateRevocationList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes a revoked {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}.
            # @!attribute [rw] certificate
            #   @return [::String]
            #     The resource path for the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} in the format
            #     `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
            # @!attribute [rw] hex_serial_number
            #   @return [::String]
            #     The serial number of the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}.
            # @!attribute [rw] revocation_reason
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason]
            #     The reason the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} was revoked.
            class RevokedCertificate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The state of a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList}, indicating if it is current.
            module State
              # Not specified.
              STATE_UNSPECIFIED = 0

              # The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} is up to date.
              ACTIVE = 1

              # The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} is no longer current.
              SUPERSEDED = 2
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} corresponds to a signed X.509 certificate issued by a
          # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource path for this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} in the format
          #     `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
          # @!attribute [rw] pem_csr
          #   @return [::String]
          #     Immutable. A pem-encoded X.509 certificate signing request (CSR).
          #
          #     Note: The following fields are mutually exclusive: `pem_csr`, `config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateConfig]
          #     Immutable. A description of the certificate and key that does not require X.509 or
          #     ASN.1.
          #
          #     Note: The following fields are mutually exclusive: `config`, `pem_csr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] lifetime
          #   @return [::Google::Protobuf::Duration]
          #     Required. Immutable. The desired lifetime of a certificate. Used to create the
          #     "not_before_time" and "not_after_time" fields inside an X.509
          #     certificate. Note that the lifetime may be truncated if it would extend
          #     past the life of any certificate authority in the issuing chain.
          # @!attribute [r] revocation_details
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate::RevocationDetails]
          #     Output only. Details regarding the revocation of this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}. This
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} is considered revoked if and only if this field is present.
          # @!attribute [r] pem_certificate
          #   @return [::String]
          #     Output only. The pem-encoded, signed X.509 certificate.
          # @!attribute [r] certificate_description
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription]
          #     Output only. A structured description of the issued X.509 certificate.
          # @!attribute [r] pem_certificate_chain
          #   @return [::Array<::String>]
          #     Output only. The chain that may be used to verify the X.509 certificate. Expected to be
          #     in issuer-to-root order according to RFC 5246.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} was updated.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class Certificate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes fields that are relavent to the revocation of a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}.
            # @!attribute [rw] revocation_state
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason]
            #     Indicates why a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} was revoked.
            # @!attribute [rw] revocation_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} was revoked.
            class RevocationDetails
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig} refers to a managed {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues ReusableConfigValues}. Those, in
          # turn, are used to describe certain fields of an X.509 certificate, such as
          # the key usage fields, fields specific to CA certificates, certificate policy
          # extensions and custom extensions.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource path for this {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig} in the format
          #     `projects/*/locations/*/reusableConfigs/*`.
          # @!attribute [rw] values
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues]
          #     Required. The config values.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. A human-readable description of scenarios these ReusableConfigValues may be
          #     compatible with.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig} was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig} was updated.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class ReusableConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues ReusableConfigValues} is used to describe certain fields of an
          # X.509 certificate, such as the key usage fields, fields specific to CA
          # certificates, certificate policy extensions and custom extensions.
          # @!attribute [rw] key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage]
          #     Optional. Indicates the intended use for keys that correspond to a certificate.
          # @!attribute [rw] ca_options
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues::CaOptions]
          #     Optional. Describes options in this {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues ReusableConfigValues} that are
          #     relevant in a CA certificate.
          # @!attribute [rw] policy_ids
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::ObjectId>]
          #     Optional. Describes the X.509 certificate policy object identifiers, per
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
          # @!attribute [rw] aia_ocsp_servers
          #   @return [::Array<::String>]
          #     Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses
          #     that appear in the "Authority Information Access" extension in the
          #     certificate.
          # @!attribute [rw] additional_extensions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::X509Extension>]
          #     Optional. Describes custom X.509 extensions.
          class ReusableConfigValues
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes values that are relevant in a CA certificate.
            # @!attribute [rw] is_ca
            #   @return [::Google::Protobuf::BoolValue]
            #     Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
            #     value is missing, the extension will be omitted from the CA certificate.
            # @!attribute [rw] max_issuer_path_length
            #   @return [::Google::Protobuf::Int32Value]
            #     Optional. Refers to the path length restriction X.509 extension. For a CA
            #     certificate, this value describes the depth of subordinate CA
            #     certificates that are allowed.
            #     If this value is less than 0, the request will fail.
            #     If this value is missing, the max path length will be omitted from the
            #     CA certificate.
            class CaOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper ReusableConfigWrapper} describes values that may assist in creating an
          # X.509 certificate, or a reference to a pre-defined set of values.
          # @!attribute [rw] reusable_config
          #   @return [::String]
          #     Required. A resource path to a {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig} in the format
          #     `projects/*/locations/*/reusableConfigs/*`.
          #
          #     Note: The following fields are mutually exclusive: `reusable_config`, `reusable_config_values`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] reusable_config_values
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues]
          #     Required. A user-specified inline {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues ReusableConfigValues}.
          #
          #     Note: The following fields are mutually exclusive: `reusable_config_values`, `reusable_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ReusableConfigWrapper
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes a subordinate CA's issuers. This is either a resource path to a
          # known issuing {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, or a PEM issuer certificate chain.
          # @!attribute [rw] certificate_authority
          #   @return [::String]
          #     Required. This can refer to a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the same project that
          #     was used to create a subordinate {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}. This field
          #     is used for information and usability purposes only. The resource name
          #     is in the format `projects/*/locations/*/certificateAuthorities/*`.
          #
          #     Note: The following fields are mutually exclusive: `certificate_authority`, `pem_issuer_chain`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pem_issuer_chain
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::SubordinateConfig::SubordinateConfigChain]
          #     Required. Contains the PEM certificate chain for the issuers of this
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}, but not pem certificate for this CA itself.
          #
          #     Note: The following fields are mutually exclusive: `pem_issuer_chain`, `certificate_authority`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SubordinateConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # This message describes a subordinate CA's issuer certificate chain. This
            # wrapper exists for compatibility reasons.
            # @!attribute [rw] pem_certificates
            #   @return [::Array<::String>]
            #     Required. Expected to be in leaf-to-root order according to RFC 5246.
            class SubordinateConfigChain
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::PublicKey PublicKey} describes a public key.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::PublicKey::KeyType]
          #     Required. The type of public key.
          # @!attribute [rw] key
          #   @return [::String]
          #     Required. A public key. Padding and encoding varies by 'KeyType' and is described
          #     along with the KeyType values.
          class PublicKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Types of public keys that are supported.
            # At a minimum, we support RSA and ECDSA, for the key sizes or curves listed:
            # https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
            module KeyType
              # Default unspecified value.
              KEY_TYPE_UNSPECIFIED = 0

              # A PEM-encoded PKCS#1/RFC 3447 RSAPrivateKey structure.
              PEM_RSA_KEY = 1

              # A PEM-encoded compressed NIST P-256/secp256r1/prime256v1 or P-384 key.
              PEM_EC_KEY = 2
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateConfig CertificateConfig} describes an X.509 certificate or CSR that is to be
          # created, as an alternative to using ASN.1.
          # @!attribute [rw] subject_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateConfig::SubjectConfig]
          #     Required. Specifies some of the values in a certificate that are related to the
          #     subject.
          # @!attribute [rw] reusable_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigWrapper]
          #     Required. Describes how some of the technical fields in a certificate should be
          #     populated.
          # @!attribute [rw] public_key
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::PublicKey]
          #     Optional. The public key that corresponds to this config. This is, for example, used
          #     when issuing {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}, but not when creating a
          #     self-signed {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} or {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} CSR.
          class CertificateConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # These values are used to create the distinguished name and subject
            # alternative name fields in an X.509 certificate.
            # @!attribute [rw] subject
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::Subject]
            #     Required. Contains distinguished name fields such as the location and organization.
            # @!attribute [rw] common_name
            #   @return [::String]
            #     Optional. The "common name" of the distinguished name.
            # @!attribute [rw] subject_alt_name
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::SubjectAltNames]
            #     Optional. The subject alternative name fields.
            class SubjectConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription CertificateDescription} describes an X.509 certificate or CSR that has
          # been issued, as an alternative to using ASN.1 / X.509.
          # @!attribute [rw] subject_description
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription::SubjectDescription]
          #     Describes some of the values in a certificate that are related to the
          #     subject and lifetime.
          # @!attribute [rw] config_values
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfigValues]
          #     Describes some of the technical fields in a certificate.
          # @!attribute [rw] public_key
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::PublicKey]
          #     The public key that corresponds to an issued certificate.
          # @!attribute [rw] subject_key_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription::KeyId]
          #     Provides a means of identifiying certificates that contain a particular
          #     public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
          # @!attribute [rw] authority_key_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription::KeyId]
          #     Identifies the subject_key_id of the parent certificate, per
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.1
          # @!attribute [rw] crl_distribution_points
          #   @return [::Array<::String>]
          #     Describes a list of locations to obtain CRL information, i.e.
          #     the DistributionPoint.fullName described by
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.13
          # @!attribute [rw] aia_issuing_certificate_urls
          #   @return [::Array<::String>]
          #     Describes lists of issuer CA certificate URLs that appear in the
          #     "Authority Information Access" extension in the certificate.
          # @!attribute [rw] cert_fingerprint
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateDescription::CertificateFingerprint]
          #     The hash of the x.509 certificate.
          class CertificateDescription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # These values describe fields in an issued X.509 certificate such as the
            # distinguished name, subject alternative names, serial number, and lifetime.
            # @!attribute [rw] subject
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::Subject]
            #     Contains distinguished name fields such as the location and organization.
            # @!attribute [rw] common_name
            #   @return [::String]
            #     The "common name" of the distinguished name.
            # @!attribute [rw] subject_alt_name
            #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::SubjectAltNames]
            #     The subject alternative name fields.
            # @!attribute [rw] hex_serial_number
            #   @return [::String]
            #     The serial number encoded in lowercase hexadecimal.
            # @!attribute [rw] lifetime
            #   @return [::Google::Protobuf::Duration]
            #     For convenience, the actual lifetime of an issued certificate.
            #     Corresponds to 'not_after_time' - 'not_before_time'.
            # @!attribute [rw] not_before_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which the certificate becomes valid.
            # @!attribute [rw] not_after_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which the certificate expires.
            class SubjectDescription
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A KeyId identifies a specific public key, usually by hashing the public
            # key.
            # @!attribute [rw] key_id
            #   @return [::String]
            #     Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most
            #     likely the 160 bit SHA-1 hash of the public key.
            class KeyId
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A group of fingerprints for the x509 certificate.
            # @!attribute [rw] sha256_hash
            #   @return [::String]
            #     The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
            class CertificateFingerprint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # An {::Google::Cloud::Security::PrivateCA::V1beta1::ObjectId ObjectId} specifies an object identifier (OID). These provide context
          # and describe types in ASN.1 messages.
          # @!attribute [rw] object_id_path
          #   @return [::Array<::Integer>]
          #     Required. The parts of an OID path. The most significant parts of the path come
          #     first.
          class ObjectId
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An {::Google::Cloud::Security::PrivateCA::V1beta1::X509Extension X509Extension} specifies an X.509 extension, which may be used in
          # different parts of X.509 objects like certificates, CSRs, and CRLs.
          # @!attribute [rw] object_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::ObjectId]
          #     Required. The OID for this X.509 extension.
          # @!attribute [rw] critical
          #   @return [::Boolean]
          #     Required. Indicates whether or not this extension is critical (i.e., if the client
          #     does not know how to handle this extension, the client should consider this
          #     to be an error).
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. The value of this X.509 extension.
          class X509Extension
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage KeyUsage} describes key usage values that may appear in an X.509
          # certificate.
          # @!attribute [rw] base_key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage::KeyUsageOptions]
          #     Describes high-level ways in which a key may be used.
          # @!attribute [rw] extended_key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage::ExtendedKeyUsageOptions]
          #     Detailed scenarios in which a key may be used.
          # @!attribute [rw] unknown_extended_key_usages
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::ObjectId>]
          #     Used to describe extended key usages that are not listed in the
          #     {::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage::ExtendedKeyUsageOptions KeyUsage.ExtendedKeyUsageOptions} message.
          class KeyUsage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # {::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage::KeyUsageOptions KeyUsage.KeyUsageOptions} corresponds to the key usage values
            # described in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
            # @!attribute [rw] digital_signature
            #   @return [::Boolean]
            #     The key may be used for digital signatures.
            # @!attribute [rw] content_commitment
            #   @return [::Boolean]
            #     The key may be used for cryptographic commitments. Note that this may
            #     also be referred to as "non-repudiation".
            # @!attribute [rw] key_encipherment
            #   @return [::Boolean]
            #     The key may be used to encipher other keys.
            # @!attribute [rw] data_encipherment
            #   @return [::Boolean]
            #     The key may be used to encipher data.
            # @!attribute [rw] key_agreement
            #   @return [::Boolean]
            #     The key may be used in a key agreement protocol.
            # @!attribute [rw] cert_sign
            #   @return [::Boolean]
            #     The key may be used to sign certificates.
            # @!attribute [rw] crl_sign
            #   @return [::Boolean]
            #     The key may be used sign certificate revocation lists.
            # @!attribute [rw] encipher_only
            #   @return [::Boolean]
            #     The key may be used to encipher only.
            # @!attribute [rw] decipher_only
            #   @return [::Boolean]
            #     The key may be used to decipher only.
            class KeyUsageOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # {::Google::Cloud::Security::PrivateCA::V1beta1::KeyUsage::ExtendedKeyUsageOptions KeyUsage.ExtendedKeyUsageOptions} has fields that correspond to
            # certain common OIDs that could be specified as an extended key usage value.
            # @!attribute [rw] server_auth
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW
            #     server authentication", though regularly used for non-WWW TLS.
            # @!attribute [rw] client_auth
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW
            #     client authentication", though regularly used for non-WWW TLS.
            # @!attribute [rw] code_signing
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of
            #     downloadable executable code client authentication".
            # @!attribute [rw] email_protection
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email
            #     protection".
            # @!attribute [rw] time_stamping
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding
            #     the hash of an object to a time".
            # @!attribute [rw] ocsp_signing
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing
            #     OCSP responses".
            class ExtendedKeyUsageOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # {::Google::Cloud::Security::PrivateCA::V1beta1::Subject Subject} describes parts of a distinguished name that, in turn,
          # describes the subject of the certificate.
          # @!attribute [rw] country_code
          #   @return [::String]
          #     The country code of the subject.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization of the subject.
          # @!attribute [rw] organizational_unit
          #   @return [::String]
          #     The organizational_unit of the subject.
          # @!attribute [rw] locality
          #   @return [::String]
          #     The locality or city of the subject.
          # @!attribute [rw] province
          #   @return [::String]
          #     The province, territory, or regional state of the subject.
          # @!attribute [rw] street_address
          #   @return [::String]
          #     The street address of the subject.
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     The postal code of the subject.
          class Subject
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Security::PrivateCA::V1beta1::SubjectAltNames SubjectAltNames} corresponds to a more modern way of listing what
          # the asserted identity is in a certificate (i.e., compared to the "common
          # name" in the distinguished name).
          # @!attribute [rw] dns_names
          #   @return [::Array<::String>]
          #     Contains only valid, fully-qualified host names.
          # @!attribute [rw] uris
          #   @return [::Array<::String>]
          #     Contains only valid RFC 3986 URIs.
          # @!attribute [rw] email_addresses
          #   @return [::Array<::String>]
          #     Contains only valid RFC 2822 E-mail addresses.
          # @!attribute [rw] ip_addresses
          #   @return [::Array<::String>]
          #     Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
          # @!attribute [rw] custom_sans
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1beta1::X509Extension>]
          #     Contains additional subject alternative name values.
          class SubjectAltNames
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A {::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason RevocationReason} indicates whether a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} has been revoked,
          # and the reason for revocation. These correspond to standard revocation
          # reasons from RFC 5280. Note that the enum labels and values in this
          # definition are not the same ASN.1 values defined in RFC 5280. These values
          # will be translated to the correct ASN.1 values when a CRL is created.
          module RevocationReason
            # Default unspecified value. This value does indicate that a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}
            # has been revoked, but that a reason has not been recorded.
            REVOCATION_REASON_UNSPECIFIED = 0

            # Key material for this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} may have leaked.
            KEY_COMPROMISE = 1

            # The key material for a certificate authority in the issuing path may have
            # leaked.
            CERTIFICATE_AUTHORITY_COMPROMISE = 2

            # The subject or other attributes in this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} have changed.
            AFFILIATION_CHANGED = 3

            # This {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} has been superseded.
            SUPERSEDED = 4

            # This {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} or entities in the issuing path have ceased to
            # operate.
            CESSATION_OF_OPERATION = 5

            # This {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} should not be considered valid, it is expected that it
            # may become valid in the future.
            CERTIFICATE_HOLD = 6

            # This {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} no longer has permission to assert the listed
            # attributes.
            PRIVILEGE_WITHDRAWN = 7

            # The authority which determines appropriate attributes for a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}
            # may have been compromised.
            ATTRIBUTE_AUTHORITY_COMPROMISE = 8
          end
        end
      end
    end
  end
end
