# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/security/privateca/v1beta1/service_pb"

module Google
  module Cloud
    module Security
      module PrivateCA
        module V1beta1
          module CertificateAuthorityService
            ##
            # Client for the CertificateAuthorityService service.
            #
            # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client Certificate Authority Service} manages private
            # certificate authorities and issued certificates.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "privateca.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :certificate_authority_service_stub

              ##
              # Configure the CertificateAuthorityService Client class.
              #
              # See {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CertificateAuthorityService clients
              #   ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Security", "PrivateCA", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CertificateAuthorityService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @certificate_authority_service_stub.universe_domain
              end

              ##
              # Create a new CertificateAuthorityService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CertificateAuthorityService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/security/privateca/v1beta1/service_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @certificate_authority_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @certificate_authority_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @certificate_authority_service_stub.logger
              end

              # Service calls

              ##
              # Create a new {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} in a given Project, Location from a particular
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              #
              # @overload create_certificate(request, options = nil)
              #   Pass arguments to `create_certificate` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_certificate(parent: nil, certificate_id: nil, certificate: nil, request_id: nil)
              #   Pass arguments to `create_certificate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location and {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
              #     associated with the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}, in the format
              #     `projects/*/locations/*/certificateAuthorities/*`.
              #   @param certificate_id [::String]
              #     Optional. It must be unique within a location and match the regular
              #     expression `[a-zA-Z0-9_-]{1,63}`. This field is required when using a
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the Enterprise {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Tier CertificateAuthority.Tier},
              #     but is optional and its value is ignored otherwise.
              #   @param certificate [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate, ::Hash]
              #     Required. A {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} with initial field values.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest.new
              #
              #   # Call the create_certificate method.
              #   result = client.create_certificate request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::Certificate.
              #   p result
              #
              def create_certificate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_certificate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_certificate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_certificate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :create_certificate, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}.
              #
              # @overload get_certificate(request, options = nil)
              #   Pass arguments to `get_certificate` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_certificate(name: nil)
              #   Pass arguments to `get_certificate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate#name name} of the {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest.new
              #
              #   # Call the get_certificate method.
              #   result = client.get_certificate request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::Certificate.
              #   p result
              #
              def get_certificate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_certificate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_certificate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_certificate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :get_certificate, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}.
              #
              # @overload list_certificates(request, options = nil)
              #   Pass arguments to `list_certificates` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_certificates(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_certificates` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location associated with the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates}, in the format
              #     `projects/*/locations/*/certificateauthorities/*`.
              #   @param page_size [::Integer]
              #     Optional. Limit on the number of
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} to include in the
              #     response. Further {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificates} can subsequently be obtained
              #     by including the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token} in a subsequent
              #     request. If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. Pagination token, returned earlier via
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}.
              #   @param filter [::String]
              #     Optional. Only include resources that match the filter in the response. For details
              #     on supported filters and syntax, see [Certificates Filtering
              #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#filtering_support).
              #   @param order_by [::String]
              #     Optional. Specify how the results should be sorted. For details on supported fields
              #     and syntax, see [Certificates Sorting
              #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#sorting_support).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::Certificate>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::Certificate>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest.new
              #
              #   # Call the list_certificates method.
              #   result = client.list_certificates request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1beta1::Certificate.
              #     p item
              #   end
              #
              def list_certificates request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificatesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_certificates.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_certificates.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_certificates.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :list_certificates, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @certificate_authority_service_stub, :list_certificates, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Revoke a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}.
              #
              # @overload revoke_certificate(request, options = nil)
              #   Pass arguments to `revoke_certificate` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload revoke_certificate(name: nil, reason: nil, request_id: nil)
              #   Pass arguments to `revoke_certificate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} in the
              #     format `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
              #   @param reason [::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason]
              #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::RevocationReason RevocationReason} for revoking this certificate.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest.new
              #
              #   # Call the revoke_certificate method.
              #   result = client.revoke_certificate request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::Certificate.
              #   p result
              #
              def revoke_certificate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::RevokeCertificateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.revoke_certificate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.revoke_certificate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.revoke_certificate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :revoke_certificate, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate}. Currently, the only field you can update is the
              # {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate#labels labels} field.
              #
              # @overload update_certificate(request, options = nil)
              #   Pass arguments to `update_certificate` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_certificate(certificate: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_certificate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param certificate [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate, ::Hash]
              #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::Certificate Certificate} with updated values.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A list of fields to be updated in this request.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::Certificate]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest.new
              #
              #   # Call the update_certificate method.
              #   result = client.update_certificate request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::Certificate.
              #   p result
              #
              def update_certificate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_certificate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.certificate&.name
                  header_params["certificate.name"] = request.certificate.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_certificate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_certificate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :update_certificate, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Activate a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} that is in state
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::State::PENDING_ACTIVATION PENDING_ACTIVATION} and is
              # of type {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Type::SUBORDINATE SUBORDINATE}. After the
              # parent Certificate Authority signs a certificate signing request from
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#fetch_certificate_authority_csr FetchCertificateAuthorityCsr}, this method can complete the activation
              # process.
              #
              # @overload activate_certificate_authority(request, options = nil)
              #   Pass arguments to `activate_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload activate_certificate_authority(name: nil, pem_ca_certificate: nil, subordinate_config: nil, request_id: nil)
              #   Pass arguments to `activate_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #   @param pem_ca_certificate [::String]
              #     Required. The signed CA certificate issued from
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse#pem_csr FetchCertificateAuthorityCsrResponse.pem_csr}.
              #   @param subordinate_config [::Google::Cloud::Security::PrivateCA::V1beta1::SubordinateConfig, ::Hash]
              #     Required. Must include information about the issuer of 'pem_ca_certificate', and any
              #     further issuers until the self-signed CA.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest.new
              #
              #   # Call the activate_certificate_authority method.
              #   result = client.activate_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def activate_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ActivateCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.activate_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.activate_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.activate_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :activate_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a new {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in a given Project and Location.
              #
              # @overload create_certificate_authority(request, options = nil)
              #   Pass arguments to `create_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_certificate_authority(parent: nil, certificate_authority_id: nil, certificate_authority: nil, request_id: nil)
              #   Pass arguments to `create_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location associated with the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}, in the format
              #     `projects/*/locations/*`.
              #   @param certificate_authority_id [::String]
              #     Required. It must be unique within a location and match the regular
              #     expression `[a-zA-Z0-9_-]{1,63}`
              #   @param certificate_authority [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority, ::Hash]
              #     Required. A {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} with initial field values.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest.new
              #
              #   # Call the create_certificate_authority method.
              #   result = client.create_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::CreateCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :create_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Disable a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              #
              # @overload disable_certificate_authority(request, options = nil)
              #   Pass arguments to `disable_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload disable_certificate_authority(name: nil, request_id: nil)
              #   Pass arguments to `disable_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest.new
              #
              #   # Call the disable_certificate_authority method.
              #   result = client.disable_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def disable_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::DisableCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.disable_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.disable_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.disable_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :disable_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Enable a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              #
              # @overload enable_certificate_authority(request, options = nil)
              #   Pass arguments to `enable_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload enable_certificate_authority(name: nil, request_id: nil)
              #   Pass arguments to `enable_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest.new
              #
              #   # Call the enable_certificate_authority method.
              #   result = client.enable_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def enable_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::EnableCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.enable_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.enable_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.enable_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :enable_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetch a certificate signing request (CSR) from a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}
              # that is in state
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::State::PENDING_ACTIVATION PENDING_ACTIVATION} and is
              # of type {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority::Type::SUBORDINATE SUBORDINATE}. The CSR must
              # then be signed by the desired parent Certificate Authority, which could be
              # another {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} resource, or could be an on-prem
              # certificate authority. See also {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client#activate_certificate_authority ActivateCertificateAuthority}.
              #
              # @overload fetch_certificate_authority_csr(request, options = nil)
              #   Pass arguments to `fetch_certificate_authority_csr` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload fetch_certificate_authority_csr(name: nil)
              #   Pass arguments to `fetch_certificate_authority_csr` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest.new
              #
              #   # Call the fetch_certificate_authority_csr method.
              #   result = client.fetch_certificate_authority_csr request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrResponse.
              #   p result
              #
              def fetch_certificate_authority_csr request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::FetchCertificateAuthorityCsrRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.fetch_certificate_authority_csr.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.fetch_certificate_authority_csr.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.fetch_certificate_authority_csr.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :fetch_certificate_authority_csr, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              #
              # @overload get_certificate_authority(request, options = nil)
              #   Pass arguments to `get_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_certificate_authority(name: nil)
              #   Pass arguments to `get_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority#name name} of the {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} to
              #     get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest.new
              #
              #   # Call the get_certificate_authority method.
              #   result = client.get_certificate_authority request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority.
              #   p result
              #
              def get_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :get_certificate_authority, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}.
              #
              # @overload list_certificate_authorities(request, options = nil)
              #   Pass arguments to `list_certificate_authorities` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_certificate_authorities(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_certificate_authorities` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location associated with the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities}, in the format
              #     `projects/*/locations/*`.
              #   @param page_size [::Integer]
              #     Optional. Limit on the number of {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities} to
              #     include in the response.
              #     Further {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthorities} can subsequently be
              #     obtained by including the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token} in a subsequent
              #     request. If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. Pagination token, returned earlier via
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}.
              #   @param filter [::String]
              #     Optional. Only include resources that match the filter in the response.
              #   @param order_by [::String]
              #     Optional. Specify how the results should be sorted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest.new
              #
              #   # Call the list_certificate_authorities method.
              #   result = client.list_certificate_authorities request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority.
              #     p item
              #   end
              #
              def list_certificate_authorities request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateAuthoritiesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_certificate_authorities.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_certificate_authorities.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_certificate_authorities.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :list_certificate_authorities, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @certificate_authority_service_stub, :list_certificate_authorities, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restore a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} that is scheduled for deletion.
              #
              # @overload restore_certificate_authority(request, options = nil)
              #   Pass arguments to `restore_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload restore_certificate_authority(name: nil, request_id: nil)
              #   Pass arguments to `restore_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest.new
              #
              #   # Call the restore_certificate_authority method.
              #   result = client.restore_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::RestoreCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.restore_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.restore_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.restore_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :restore_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Schedule a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} for deletion.
              #
              # @overload schedule_delete_certificate_authority(request, options = nil)
              #   Pass arguments to `schedule_delete_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload schedule_delete_certificate_authority(name: nil, request_id: nil)
              #   Pass arguments to `schedule_delete_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for this {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} in the
              #     format `projects/*/locations/*/certificateAuthorities/*`.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest.new
              #
              #   # Call the schedule_delete_certificate_authority method.
              #   result = client.schedule_delete_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def schedule_delete_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ScheduleDeleteCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.schedule_delete_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.schedule_delete_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.schedule_delete_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :schedule_delete_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority}.
              #
              # @overload update_certificate_authority(request, options = nil)
              #   Pass arguments to `update_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_certificate_authority(certificate_authority: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param certificate_authority [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority, ::Hash]
              #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthority CertificateAuthority} with updated values.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A list of fields to be updated in this request.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest.new
              #
              #   # Call the update_certificate_authority method.
              #   result = client.update_certificate_authority request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.certificate_authority&.name
                  header_params["certificate_authority.name"] = request.certificate_authority.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :update_certificate_authority, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList}.
              #
              # @overload get_certificate_revocation_list(request, options = nil)
              #   Pass arguments to `get_certificate_revocation_list` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_certificate_revocation_list(name: nil)
              #   Pass arguments to `get_certificate_revocation_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList#name name} of the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest.new
              #
              #   # Call the get_certificate_revocation_list method.
              #   result = client.get_certificate_revocation_list request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList.
              #   p result
              #
              def get_certificate_revocation_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::GetCertificateRevocationListRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_certificate_revocation_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_certificate_revocation_list.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_certificate_revocation_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :get_certificate_revocation_list, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}.
              #
              # @overload list_certificate_revocation_lists(request, options = nil)
              #   Pass arguments to `list_certificate_revocation_lists` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_certificate_revocation_lists(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_certificate_revocation_lists` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location associated with the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}, in the format
              #     `projects/*/locations/*/certificateauthorities/*`.
              #   @param page_size [::Integer]
              #     Optional. Limit on the number of
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists} to include in the
              #     response. Further {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationLists}
              #     can subsequently be obtained by including the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token} in a subsequent
              #     request. If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. Pagination token, returned earlier via
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}.
              #   @param filter [::String]
              #     Optional. Only include resources that match the filter in the response.
              #   @param order_by [::String]
              #     Optional. Specify how the results should be sorted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest.new
              #
              #   # Call the list_certificate_revocation_lists method.
              #   result = client.list_certificate_revocation_lists request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList.
              #     p item
              #   end
              #
              def list_certificate_revocation_lists request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ListCertificateRevocationListsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_certificate_revocation_lists.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_certificate_revocation_lists.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_certificate_revocation_lists.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :list_certificate_revocation_lists, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @certificate_authority_service_stub, :list_certificate_revocation_lists, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList}.
              #
              # @overload update_certificate_revocation_list(request, options = nil)
              #   Pass arguments to `update_certificate_revocation_list` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_certificate_revocation_list(certificate_revocation_list: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_certificate_revocation_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param certificate_revocation_list [::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList, ::Hash]
              #     Required. {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateRevocationList CertificateRevocationList} with updated values.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A list of fields to be updated in this request.
              #   @param request_id [::String]
              #     Optional. An ID to identify requests. Specify a unique request ID so that if you must
              #     retry your request, the server will know to ignore the request if it has
              #     already been completed. The server will guarantee that for at least 60
              #     minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest.new
              #
              #   # Call the update_certificate_revocation_list method.
              #   result = client.update_certificate_revocation_list request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_certificate_revocation_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::UpdateCertificateRevocationListRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_certificate_revocation_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.certificate_revocation_list&.name
                  header_params["certificate_revocation_list.name"] = request.certificate_revocation_list.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_certificate_revocation_list.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_certificate_revocation_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :update_certificate_revocation_list, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfig}.
              #
              # @overload get_reusable_config(request, options = nil)
              #   Pass arguments to `get_reusable_config` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_reusable_config(name: nil)
              #   Pass arguments to `get_reusable_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The [name][ReusableConfigs.name] of the [ReusableConfigs][] to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest.new
              #
              #   # Call the get_reusable_config method.
              #   result = client.get_reusable_config request
              #
              #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig.
              #   p result
              #
              def get_reusable_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::GetReusableConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_reusable_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_reusable_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_reusable_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :get_reusable_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs}.
              #
              # @overload list_reusable_configs(request, options = nil)
              #   Pass arguments to `list_reusable_configs` via a request object, either of type
              #   {::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_reusable_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_reusable_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location associated with the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs}, in the format
              #     `projects/*/locations/*`.
              #   @param page_size [::Integer]
              #     Optional. Limit on the number of
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs} to include in the response.
              #     Further {::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig ReusableConfigs} can subsequently be
              #     obtained by including the
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsResponse#next_page_token ListReusableConfigsResponse.next_page_token} in a subsequent request. If
              #     unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. Pagination token, returned earlier via
              #     {::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsResponse#next_page_token ListReusableConfigsResponse.next_page_token}.
              #   @param filter [::String]
              #     Optional. Only include resources that match the filter in the response.
              #   @param order_by [::String]
              #     Optional. Specify how the results should be sorted.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/security/private_ca/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest.new
              #
              #   # Call the list_reusable_configs method.
              #   result = client.list_reusable_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1beta1::ReusableConfig.
              #     p item
              #   end
              #
              def list_reusable_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1beta1::ListReusableConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_reusable_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Security::PrivateCA::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_reusable_configs.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_reusable_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @certificate_authority_service_stub.call_rpc :list_reusable_configs, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @certificate_authority_service_stub, :list_reusable_configs, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CertificateAuthorityService API.
              #
              # This class represents the configuration for CertificateAuthorityService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_certificate to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_certificate.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_certificate.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Security::PrivateCA::V1beta1::CertificateAuthorityService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "privateca.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the CertificateAuthorityService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_certificate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_certificate
                  ##
                  # RPC-specific configuration for `get_certificate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_certificate
                  ##
                  # RPC-specific configuration for `list_certificates`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_certificates
                  ##
                  # RPC-specific configuration for `revoke_certificate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :revoke_certificate
                  ##
                  # RPC-specific configuration for `update_certificate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_certificate
                  ##
                  # RPC-specific configuration for `activate_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :activate_certificate_authority
                  ##
                  # RPC-specific configuration for `create_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_certificate_authority
                  ##
                  # RPC-specific configuration for `disable_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :disable_certificate_authority
                  ##
                  # RPC-specific configuration for `enable_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :enable_certificate_authority
                  ##
                  # RPC-specific configuration for `fetch_certificate_authority_csr`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_certificate_authority_csr
                  ##
                  # RPC-specific configuration for `get_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_certificate_authority
                  ##
                  # RPC-specific configuration for `list_certificate_authorities`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_certificate_authorities
                  ##
                  # RPC-specific configuration for `restore_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_certificate_authority
                  ##
                  # RPC-specific configuration for `schedule_delete_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :schedule_delete_certificate_authority
                  ##
                  # RPC-specific configuration for `update_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_certificate_authority
                  ##
                  # RPC-specific configuration for `get_certificate_revocation_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_certificate_revocation_list
                  ##
                  # RPC-specific configuration for `list_certificate_revocation_lists`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_certificate_revocation_lists
                  ##
                  # RPC-specific configuration for `update_certificate_revocation_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_certificate_revocation_list
                  ##
                  # RPC-specific configuration for `get_reusable_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reusable_config
                  ##
                  # RPC-specific configuration for `list_reusable_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reusable_configs

                  # @private
                  def initialize parent_rpcs = nil
                    create_certificate_config = parent_rpcs.create_certificate if parent_rpcs.respond_to? :create_certificate
                    @create_certificate = ::Gapic::Config::Method.new create_certificate_config
                    get_certificate_config = parent_rpcs.get_certificate if parent_rpcs.respond_to? :get_certificate
                    @get_certificate = ::Gapic::Config::Method.new get_certificate_config
                    list_certificates_config = parent_rpcs.list_certificates if parent_rpcs.respond_to? :list_certificates
                    @list_certificates = ::Gapic::Config::Method.new list_certificates_config
                    revoke_certificate_config = parent_rpcs.revoke_certificate if parent_rpcs.respond_to? :revoke_certificate
                    @revoke_certificate = ::Gapic::Config::Method.new revoke_certificate_config
                    update_certificate_config = parent_rpcs.update_certificate if parent_rpcs.respond_to? :update_certificate
                    @update_certificate = ::Gapic::Config::Method.new update_certificate_config
                    activate_certificate_authority_config = parent_rpcs.activate_certificate_authority if parent_rpcs.respond_to? :activate_certificate_authority
                    @activate_certificate_authority = ::Gapic::Config::Method.new activate_certificate_authority_config
                    create_certificate_authority_config = parent_rpcs.create_certificate_authority if parent_rpcs.respond_to? :create_certificate_authority
                    @create_certificate_authority = ::Gapic::Config::Method.new create_certificate_authority_config
                    disable_certificate_authority_config = parent_rpcs.disable_certificate_authority if parent_rpcs.respond_to? :disable_certificate_authority
                    @disable_certificate_authority = ::Gapic::Config::Method.new disable_certificate_authority_config
                    enable_certificate_authority_config = parent_rpcs.enable_certificate_authority if parent_rpcs.respond_to? :enable_certificate_authority
                    @enable_certificate_authority = ::Gapic::Config::Method.new enable_certificate_authority_config
                    fetch_certificate_authority_csr_config = parent_rpcs.fetch_certificate_authority_csr if parent_rpcs.respond_to? :fetch_certificate_authority_csr
                    @fetch_certificate_authority_csr = ::Gapic::Config::Method.new fetch_certificate_authority_csr_config
                    get_certificate_authority_config = parent_rpcs.get_certificate_authority if parent_rpcs.respond_to? :get_certificate_authority
                    @get_certificate_authority = ::Gapic::Config::Method.new get_certificate_authority_config
                    list_certificate_authorities_config = parent_rpcs.list_certificate_authorities if parent_rpcs.respond_to? :list_certificate_authorities
                    @list_certificate_authorities = ::Gapic::Config::Method.new list_certificate_authorities_config
                    restore_certificate_authority_config = parent_rpcs.restore_certificate_authority if parent_rpcs.respond_to? :restore_certificate_authority
                    @restore_certificate_authority = ::Gapic::Config::Method.new restore_certificate_authority_config
                    schedule_delete_certificate_authority_config = parent_rpcs.schedule_delete_certificate_authority if parent_rpcs.respond_to? :schedule_delete_certificate_authority
                    @schedule_delete_certificate_authority = ::Gapic::Config::Method.new schedule_delete_certificate_authority_config
                    update_certificate_authority_config = parent_rpcs.update_certificate_authority if parent_rpcs.respond_to? :update_certificate_authority
                    @update_certificate_authority = ::Gapic::Config::Method.new update_certificate_authority_config
                    get_certificate_revocation_list_config = parent_rpcs.get_certificate_revocation_list if parent_rpcs.respond_to? :get_certificate_revocation_list
                    @get_certificate_revocation_list = ::Gapic::Config::Method.new get_certificate_revocation_list_config
                    list_certificate_revocation_lists_config = parent_rpcs.list_certificate_revocation_lists if parent_rpcs.respond_to? :list_certificate_revocation_lists
                    @list_certificate_revocation_lists = ::Gapic::Config::Method.new list_certificate_revocation_lists_config
                    update_certificate_revocation_list_config = parent_rpcs.update_certificate_revocation_list if parent_rpcs.respond_to? :update_certificate_revocation_list
                    @update_certificate_revocation_list = ::Gapic::Config::Method.new update_certificate_revocation_list_config
                    get_reusable_config_config = parent_rpcs.get_reusable_config if parent_rpcs.respond_to? :get_reusable_config
                    @get_reusable_config = ::Gapic::Config::Method.new get_reusable_config_config
                    list_reusable_configs_config = parent_rpcs.list_reusable_configs if parent_rpcs.respond_to? :list_reusable_configs
                    @list_reusable_configs = ::Gapic::Config::Method.new list_reusable_configs_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
