# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/security/privateca/v1/service_pb"
require "google/cloud/security/private_ca/v1/certificate_authority_service"

class ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_id = "hello world"
    certificate = {}
    request_id = "hello world"
    validate_only = true
    issuing_certificate_authority_id = "hello world"

    create_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::Certificate), request["certificate"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["issuing_certificate_authority_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_client_stub.call_rpc_count
    end
  end

  def test_get_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate(::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_client_stub.call_rpc_count
    end
  end

  def test_list_certificates
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificates_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificates, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificates_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificates ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificates(::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificates_client_stub.call_rpc_count
    end
  end

  def test_revoke_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = :REVOCATION_REASON_UNSPECIFIED
    request_id = "hello world"

    revoke_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :revoke_certificate, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :REVOCATION_REASON_UNSPECIFIED, request["reason"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, revoke_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.revoke_certificate({ name: name, reason: reason, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.revoke_certificate name: name, reason: reason, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.revoke_certificate ::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.revoke_certificate({ name: name, reason: reason, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.revoke_certificate(::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, revoke_certificate_client_stub.call_rpc_count
    end
  end

  def test_update_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::Certificate), request["certificate"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate certificate: certificate, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_client_stub.call_rpc_count
    end
  end

  def test_activate_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    pem_ca_certificate = "hello world"
    subordinate_config = {}
    request_id = "hello world"

    activate_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :activate_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["pem_ca_certificate"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::SubordinateConfig), request["subordinate_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, activate_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.activate_certificate_authority name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.activate_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.activate_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, activate_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_create_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_authority_id = "hello world"
    certificate_authority = {}
    request_id = "hello world"

    create_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_authority_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority), request["certificate_authority"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate_authority parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_disable_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_dependent_resources = true

    disable_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :disable_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["ignore_dependent_resources"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, disable_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.disable_certificate_authority({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.disable_certificate_authority name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.disable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.disable_certificate_authority({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.disable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, disable_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_enable_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    enable_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :enable_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, enable_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.enable_certificate_authority({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.enable_certificate_authority name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.enable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.enable_certificate_authority({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.enable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, enable_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_fetch_certificate_authority_csr
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_certificate_authority_csr_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_certificate_authority_csr, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_certificate_authority_csr_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_certificate_authority_csr({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_certificate_authority_csr name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_certificate_authority_csr ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_certificate_authority_csr({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_certificate_authority_csr(::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_certificate_authority_csr_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_authority({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_authority name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_authority({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_authorities
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_authorities_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_authorities, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_authorities_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_authorities parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_authorities ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_authorities(::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_authorities_client_stub.call_rpc_count
    end
  end

  def test_undelete_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undelete_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_certificate_authority({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_certificate_authority name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_certificate_authority({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_active_certificates = true
    skip_grace_period = true
    ignore_dependent_resources = true

    delete_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["ignore_active_certificates"]
      assert_equal true, request["skip_grace_period"]
      assert_equal true, request["ignore_dependent_resources"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate_authority({ name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate_authority name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate_authority({ name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_update_certificate_authority
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate_authority = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_authority_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate_authority, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority), request["certificate_authority"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_authority_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate_authority certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_authority_client_stub.call_rpc_count
    end
  end

  def test_create_ca_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    ca_pool_id = "hello world"
    ca_pool = {}
    request_id = "hello world"

    create_ca_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_ca_pool, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["ca_pool_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CaPool), request["ca_pool"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_ca_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_ca_pool({ parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_ca_pool parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_ca_pool ::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest.new(parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_ca_pool({ parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_ca_pool(::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest.new(parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_ca_pool_client_stub.call_rpc_count
    end
  end

  def test_update_ca_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    ca_pool = {}
    update_mask = {}
    request_id = "hello world"

    update_ca_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_ca_pool, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CaPool), request["ca_pool"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_ca_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_ca_pool({ ca_pool: ca_pool, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_ca_pool ca_pool: ca_pool, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_ca_pool ::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest.new(ca_pool: ca_pool, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_ca_pool({ ca_pool: ca_pool, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_ca_pool(::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest.new(ca_pool: ca_pool, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_ca_pool_client_stub.call_rpc_count
    end
  end

  def test_get_ca_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::CaPool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ca_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_ca_pool, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_ca_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_ca_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_ca_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_ca_pool ::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_ca_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_ca_pool(::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_ca_pool_client_stub.call_rpc_count
    end
  end

  def test_list_ca_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_ca_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_ca_pools, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_ca_pools_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_ca_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_ca_pools parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_ca_pools ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_ca_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_ca_pools(::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_ca_pools_client_stub.call_rpc_count
    end
  end

  def test_delete_ca_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_dependent_resources = true

    delete_ca_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_ca_pool, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["ignore_dependent_resources"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_ca_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_ca_pool({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_ca_pool name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_ca_pool ::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_ca_pool({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_ca_pool(::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_ca_pool_client_stub.call_rpc_count
    end
  end

  def test_fetch_ca_certs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    ca_pool = "hello world"
    request_id = "hello world"

    fetch_ca_certs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_ca_certs, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest, request
      assert_equal "hello world", request["ca_pool"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_ca_certs_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_ca_certs({ ca_pool: ca_pool, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_ca_certs ca_pool: ca_pool, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_ca_certs ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest.new(ca_pool: ca_pool, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_ca_certs({ ca_pool: ca_pool, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_ca_certs(::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest.new(ca_pool: ca_pool, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_ca_certs_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_revocation_list
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_revocation_list_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_revocation_list, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_revocation_list_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_revocation_list({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_revocation_list name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_revocation_list({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_revocation_list_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_revocation_lists
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_revocation_lists_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_revocation_lists, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_revocation_lists_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_revocation_lists parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_revocation_lists ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_revocation_lists(::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_revocation_lists_client_stub.call_rpc_count
    end
  end

  def test_update_certificate_revocation_list
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate_revocation_list = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_revocation_list_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate_revocation_list, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList), request["certificate_revocation_list"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_revocation_list_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate_revocation_list certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_revocation_list_client_stub.call_rpc_count
    end
  end

  def test_create_certificate_template
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_template_id = "hello world"
    certificate_template = {}
    request_id = "hello world"

    create_certificate_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate_template, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_template_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate), request["certificate_template"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_template_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate_template({ parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate_template parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate_template ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest.new(parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate_template({ parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate_template(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest.new(parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_template_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate_template
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_certificate_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate_template, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_template_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate_template({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate_template name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate_template ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate_template({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate_template(::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_template_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_template, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_template_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_template({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_template name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_template ::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_template({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_template(::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_template_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_templates
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_templates_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_templates, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_templates_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_templates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_templates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_templates ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_templates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_templates(::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_templates_client_stub.call_rpc_count
    end
  end

  def test_update_certificate_template
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate_template = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate_template, name
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate), request["certificate_template"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_template_client_stub do
      # Create client
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate_template({ certificate_template: certificate_template, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate_template certificate_template: certificate_template, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate_template ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest.new(certificate_template: certificate_template, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate_template({ certificate_template: certificate_template, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate_template(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest.new(certificate_template: certificate_template, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_template_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Operations, client.operations_client
  end
end
