# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/security/privateca/v1/service_pb"
require "google/cloud/security/private_ca/v1/certificate_authority_service/rest"


class ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_id = "hello world"
    certificate = {}
    request_id = "hello world"
    validate_only = true
    issuing_certificate_authority_id = "hello world"

    create_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate, request_id: request_id, validate_only: validate_only, issuing_certificate_authority_id: issuing_certificate_authority_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_client_stub.call_count
      end
    end
  end

  def test_get_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate(::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_client_stub.call_count
      end
    end
  end

  def test_list_certificates
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificates_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificates ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificates(::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificates_client_stub.call_count
      end
    end
  end

  def test_revoke_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = :REVOCATION_REASON_UNSPECIFIED
    request_id = "hello world"

    revoke_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_revoke_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, revoke_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.revoke_certificate({ name: name, reason: reason, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.revoke_certificate name: name, reason: reason, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.revoke_certificate ::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.revoke_certificate({ name: name, reason: reason, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.revoke_certificate(::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest.new(name: name, reason: reason, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, revoke_certificate_client_stub.call_count
      end
    end
  end

  def test_update_certificate
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate certificate: certificate, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate({ certificate: certificate, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_client_stub.call_count
      end
    end
  end

  def test_activate_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    pem_ca_certificate = "hello world"
    subordinate_config = {}
    request_id = "hello world"

    activate_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_activate_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, activate_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.activate_certificate_authority name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.activate_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.activate_certificate_authority({ name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.activate_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest.new(name: name, pem_ca_certificate: pem_ca_certificate, subordinate_config: subordinate_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, activate_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_create_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_authority_id = "hello world"
    certificate_authority = {}
    request_id = "hello world"

    create_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_authority parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_authority({ parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest.new(parent: parent, certificate_authority_id: certificate_authority_id, certificate_authority: certificate_authority, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_disable_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_dependent_resources = true

    disable_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_disable_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_certificate_authority({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_certificate_authority name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_certificate_authority({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_enable_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    enable_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_enable_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_fetch_certificate_authority_csr
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_certificate_authority_csr_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_fetch_certificate_authority_csr_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_certificate_authority_csr_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_certificate_authority_csr({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_certificate_authority_csr name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_certificate_authority_csr ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_certificate_authority_csr({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_certificate_authority_csr(::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_certificate_authority_csr_client_stub.call_count
      end
    end
  end

  def test_get_certificate_authority
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_authority({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_authority name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_authority({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_list_certificate_authorities
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_authorities_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificate_authorities_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_authorities_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_authorities parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_authorities ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_authorities({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_authorities(::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_authorities_client_stub.call_count
      end
    end
  end

  def test_undelete_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undelete_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_undelete_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_certificate_authority({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_certificate_authority name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_certificate_authority({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_delete_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_active_certificates = true
    skip_grace_period = true
    ignore_dependent_resources = true

    delete_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_delete_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate_authority({ name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate_authority name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate_authority({ name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest.new(name: name, request_id: request_id, ignore_active_certificates: ignore_active_certificates, skip_grace_period: skip_grace_period, ignore_dependent_resources: ignore_dependent_resources), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_update_certificate_authority
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_authority = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_authority_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_authority_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_authority_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_authority certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_authority ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_authority({ certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_authority(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest.new(certificate_authority: certificate_authority, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_authority_client_stub.call_count
      end
    end
  end

  def test_create_ca_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    ca_pool_id = "hello world"
    ca_pool = {}
    request_id = "hello world"

    create_ca_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_ca_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_ca_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_ca_pool({ parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_ca_pool parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_ca_pool ::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest.new(parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_ca_pool({ parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_ca_pool(::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest.new(parent: parent, ca_pool_id: ca_pool_id, ca_pool: ca_pool, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_ca_pool_client_stub.call_count
      end
    end
  end

  def test_update_ca_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    ca_pool = {}
    update_mask = {}
    request_id = "hello world"

    update_ca_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_ca_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_ca_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_ca_pool({ ca_pool: ca_pool, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_ca_pool ca_pool: ca_pool, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_ca_pool ::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest.new(ca_pool: ca_pool, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_ca_pool({ ca_pool: ca_pool, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_ca_pool(::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest.new(ca_pool: ca_pool, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_ca_pool_client_stub.call_count
      end
    end
  end

  def test_get_ca_pool
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::CaPool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ca_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_ca_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_ca_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_ca_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_ca_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_ca_pool ::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_ca_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_ca_pool(::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_ca_pool_client_stub.call_count
      end
    end
  end

  def test_list_ca_pools
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_ca_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_ca_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_ca_pools_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_ca_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_ca_pools parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_ca_pools ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_ca_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_ca_pools(::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_ca_pools_client_stub.call_count
      end
    end
  end

  def test_delete_ca_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    ignore_dependent_resources = true

    delete_ca_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_delete_ca_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_ca_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_ca_pool({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_ca_pool name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_ca_pool ::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_ca_pool({ name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_ca_pool(::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest.new(name: name, request_id: request_id, ignore_dependent_resources: ignore_dependent_resources), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_ca_pool_client_stub.call_count
      end
    end
  end

  def test_fetch_ca_certs
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    ca_pool = "hello world"
    request_id = "hello world"

    fetch_ca_certs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_fetch_ca_certs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_ca_certs_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_ca_certs({ ca_pool: ca_pool, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_ca_certs ca_pool: ca_pool, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_ca_certs ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest.new(ca_pool: ca_pool, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_ca_certs({ ca_pool: ca_pool, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_ca_certs(::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest.new(ca_pool: ca_pool, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_ca_certs_client_stub.call_count
      end
    end
  end

  def test_get_certificate_revocation_list
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_revocation_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_revocation_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_revocation_list_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_revocation_list({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_revocation_list name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_revocation_list({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_revocation_list_client_stub.call_count
      end
    end
  end

  def test_list_certificate_revocation_lists
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_revocation_lists_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificate_revocation_lists_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_revocation_lists_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_revocation_lists parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_revocation_lists ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_revocation_lists({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_revocation_lists(::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_revocation_lists_client_stub.call_count
      end
    end
  end

  def test_update_certificate_revocation_list
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_revocation_list = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_revocation_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_revocation_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_revocation_list_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_revocation_list certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_revocation_list ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_revocation_list({ certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_revocation_list(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest.new(certificate_revocation_list: certificate_revocation_list, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_revocation_list_client_stub.call_count
      end
    end
  end

  def test_create_certificate_template
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_template_id = "hello world"
    certificate_template = {}
    request_id = "hello world"

    create_certificate_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_create_certificate_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_template_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_template({ parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_template parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_template ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest.new(parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_template({ parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_template(::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest.new(parent: parent, certificate_template_id: certificate_template_id, certificate_template: certificate_template, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_template_client_stub.call_count
      end
    end
  end

  def test_delete_certificate_template
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_certificate_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_delete_certificate_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_template_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate_template({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate_template name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate_template ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate_template({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate_template(::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_template_client_stub.call_count
      end
    end
  end

  def test_get_certificate_template
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_get_certificate_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_template_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_template ::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_template(::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_template_client_stub.call_count
      end
    end
  end

  def test_list_certificate_templates
    # Create test objects.
    client_result = ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_templates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_list_certificate_templates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_templates_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_templates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_templates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_templates ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_templates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_templates(::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_templates_client_stub.call_count
      end
    end
  end

  def test_update_certificate_template
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_template = {}
    update_mask = {}
    request_id = "hello world"

    update_certificate_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.stub :transcode_update_certificate_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_template_client_stub do
        # Create client
        client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_template({ certificate_template: certificate_template, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_template certificate_template: certificate_template, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_template ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest.new(certificate_template: certificate_template, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_template({ certificate_template: certificate_template, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_template(::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest.new(certificate_template: certificate_template, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_template_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client::Configuration, config
  end
end
