# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/security/private_ca/v1/certificate_authority_service"

class ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_ca_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.ca_pool_path project: "value0", location: "value1", ca_pool: "value2"
      assert_equal "projects/value0/locations/value1/caPools/value2", path
    end
  end

  def test_certificate_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.certificate_path project: "value0", location: "value1", ca_pool: "value2", certificate: "value3"
      assert_equal "projects/value0/locations/value1/caPools/value2/certificates/value3", path
    end
  end

  def test_certificate_authority_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.certificate_authority_path project: "value0", location: "value1", ca_pool: "value2", certificate_authority: "value3"
      assert_equal "projects/value0/locations/value1/caPools/value2/certificateAuthorities/value3", path
    end
  end

  def test_certificate_revocation_list_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.certificate_revocation_list_path project: "value0", location: "value1", ca_pool: "value2", certificate_authority: "value3", certificate_revocation_list: "value4"
      assert_equal "projects/value0/locations/value1/caPools/value2/certificateAuthorities/value3/certificateRevocationLists/value4", path
    end
  end

  def test_certificate_template_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.certificate_template_path project: "value0", location: "value1", certificate_template: "value2"
      assert_equal "projects/value0/locations/value1/certificateTemplates/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end
end
