# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Security
      module PrivateCA
        module V1
          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#create_certificate CertificateAuthorityService.CreateCertificate}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}, in the
          #     format `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] certificate_id
          #   @return [::String]
          #     Optional. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`. This field is required when using a
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the Enterprise
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority#tier CertificateAuthority.tier},
          #     but is optional and its value is ignored otherwise.
          # @!attribute [rw] certificate
          #   @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
          #     Required. A {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}
          #     with initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     Optional. If this is true, no
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} resource will
          #     be persisted regardless of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool#tier tier}, and the returned
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} will not
          #     contain the
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate#pem_certificate pem_certificate}
          #     field.
          # @!attribute [rw] issuing_certificate_authority_id
          #   @return [::String]
          #     Optional. The resource ID of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     that should issue the certificate.  This optional field will ignore the
          #     load-balancing scheme of the Pool and directly issue the certificate from
          #     the CA with the specified ID, contained in the same
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} referenced by `parent`.
          #     Per-CA quota rules apply. If left empty, a
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     will be chosen from the {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}
          #     by the service. For example, to issue a
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} from a
          #     Certificate Authority with resource name
          #     "projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca",
          #     you can set the
          #     {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest#parent parent}
          #     to "projects/my-project/locations/us-central1/caPools/my-pool" and the
          #     {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest#issuing_certificate_authority_id issuing_certificate_authority_id}
          #     to "my-ca".
          class CreateCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#get_certificate CertificateAuthorityService.GetCertificate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1::Certificate#name name}
          #     of the {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} to
          #     get.
          class GetCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificates CertificateAuthorityService.ListCertificates}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}, in the
          #     format `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} to include
          #     in the response. Further
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} can
          #     subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}
          #     in a subsequent request. If unspecified, the server will pick an
          #     appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response. For
          #     details on supported filters and syntax, see [Certificates Filtering
          #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#filtering_support).
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted. For details on
          #     supported fields and syntax, see [Certificates Sorting
          #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#sorting_support).
          class ListCertificatesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificates CertificateAuthorityService.ListCertificates}.
          # @!attribute [rw] certificates
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::Certificate>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest#page_token ListCertificatesRequest.page_token}
          #     to retrieve the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificatesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#revoke_certificate CertificateAuthorityService.RevokeCertificate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} in the format
          #     `projects/*/locations/*/caPools/*/certificates/*`.
          # @!attribute [rw] reason
          #   @return [::Google::Cloud::Security::PrivateCA::V1::RevocationReason]
          #     Required. The
          #     {::Google::Cloud::Security::PrivateCA::V1::RevocationReason RevocationReason} for
          #     revoking this certificate.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class RevokeCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#update_certificate CertificateAuthorityService.UpdateCertificate}.
          # @!attribute [rw] certificate
          #   @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
          #     Required. {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}
          #     with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#activate_certificate_authority CertificateAuthorityService.ActivateCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] pem_ca_certificate
          #   @return [::String]
          #     Required. The signed CA certificate issued from
          #     {::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse#pem_csr FetchCertificateAuthorityCsrResponse.pem_csr}.
          # @!attribute [rw] subordinate_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::SubordinateConfig]
          #     Required. Must include information about the issuer of
          #     'pem_ca_certificate', and any further issuers until the self-signed CA.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class ActivateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#create_certificate_authority CertificateAuthorityService.CreateCertificateAuthority}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities},
          #     in the format `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] certificate_authority_id
          #   @return [::String]
          #     Required. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`
          # @!attribute [rw] certificate_authority
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority]
          #     Required. A
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     with initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#disable_certificate_authority CertificateAuthorityService.DisableCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] ignore_dependent_resources
          #   @return [::Boolean]
          #     Optional. This field allows this CA to be disabled even if it's being
          #     depended on by another resource. However, doing so may result in unintended
          #     and unrecoverable effects on any dependent resources since the CA will
          #     no longer be able to issue certificates.
          class DisableCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#enable_certificate_authority CertificateAuthorityService.EnableCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class EnableCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#fetch_certificate_authority_csr CertificateAuthorityService.FetchCertificateAuthorityCsr}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          class FetchCertificateAuthorityCsrRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#fetch_certificate_authority_csr CertificateAuthorityService.FetchCertificateAuthorityCsr}.
          # @!attribute [r] pem_csr
          #   @return [::String]
          #     Output only. The PEM-encoded signed certificate signing request (CSR).
          class FetchCertificateAuthorityCsrResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#get_certificate_authority CertificateAuthorityService.GetCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority#name name} of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     to get.
          class GetCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_authorities CertificateAuthorityService.ListCertificateAuthorities}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities},
          #     in the format `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}
          #     to include in the response. Further
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}
          #     can subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}
          #     in a subsequent request. If unspecified, the server will pick an
          #     appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCertificateAuthoritiesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_authorities CertificateAuthorityService.ListCertificateAuthorities}.
          # @!attribute [rw] certificate_authorities
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority>]
          #     The list of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest#page_token ListCertificateAuthoritiesRequest.page_token}
          #     to retrieve the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificateAuthoritiesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#undelete_certificate_authority CertificateAuthorityService.UndeleteCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UndeleteCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#delete_certificate_authority CertificateAuthorityService.DeleteCertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] ignore_active_certificates
          #   @return [::Boolean]
          #     Optional. This field allows the CA to be deleted even if the CA has
          #     active certs. Active certs include both unrevoked and unexpired certs.
          # @!attribute [rw] skip_grace_period
          #   @return [::Boolean]
          #     Optional. If this flag is set, the Certificate Authority will be deleted as
          #     soon as possible without a 30-day grace period where undeletion would have
          #     been allowed. If you proceed, there will be no way to recover this CA.
          # @!attribute [rw] ignore_dependent_resources
          #   @return [::Boolean]
          #     Optional. This field allows this CA to be deleted even if it's being
          #     depended on by another resource. However, doing so may result in unintended
          #     and unrecoverable effects on any dependent resources since the CA will
          #     no longer be able to issue certificates.
          class DeleteCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#update_certificate_authority CertificateAuthorityService.UpdateCertificateAuthority}.
          # @!attribute [rw] certificate_authority
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority]
          #     Required.
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateAuthorityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#create_ca_pool CertificateAuthorityService.CreateCaPool}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}, in the format
          #     `projects/*/locations/*`.
          # @!attribute [rw] ca_pool_id
          #   @return [::String]
          #     Required. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`
          # @!attribute [rw] ca_pool
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool]
          #     Required. A {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} with
          #     initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateCaPoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#update_ca_pool CertificateAuthorityService.UpdateCaPool}.
          # @!attribute [rw] ca_pool
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool]
          #     Required. {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} with updated
          #     values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCaPoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#delete_ca_pool CertificateAuthorityService.DeleteCaPool}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the format
          #     `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] ignore_dependent_resources
          #   @return [::Boolean]
          #     Optional. This field allows this pool to be deleted even if it's being
          #     depended on by another resource. However, doing so may result in unintended
          #     and unrecoverable effects on any dependent resources since the pool will
          #     no longer be able to issue certificates.
          class DeleteCaPoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#fetch_ca_certs CertificateAuthorityService.FetchCaCerts}.
          # @!attribute [rw] ca_pool
          #   @return [::String]
          #     Required. The resource name for the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the format
          #     `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class FetchCaCertsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#fetch_ca_certs CertificateAuthorityService.FetchCaCerts}.
          # @!attribute [rw] ca_certs
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse::CertChain>]
          #     The PEM encoded CA certificate chains of all certificate authorities in
          #     this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the ENABLED,
          #     DISABLED, or STAGED states.
          class FetchCaCertsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] certificates
            #   @return [::Array<::String>]
            #     The certificates that form the CA chain, from leaf to root order.
            class CertChain
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#get_ca_pool CertificateAuthorityService.GetCaPool}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The {::Google::Cloud::Security::PrivateCA::V1::CaPool#name name} of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} to get.
          class GetCaPoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_ca_pools CertificateAuthorityService.ListCaPools}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools}, in the format
          #     `projects/*/locations/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools} to include in the
          #     response. Further {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools} can
          #     subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse#next_page_token ListCaPoolsResponse.next_page_token}
          #     in a subsequent request. If unspecified, the server will pick an
          #     appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse#next_page_token ListCaPoolsResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCaPoolsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_ca_pools CertificateAuthorityService.ListCaPools}.
          # @!attribute [rw] ca_pools
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CaPool>]
          #     The list of {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest#page_token ListCertificateAuthoritiesRequest.page_token}
          #     to retrieve the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCaPoolsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#get_certificate_revocation_list CertificateAuthorityService.GetCertificateRevocationList}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList#name name}
          #     of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          #     to get.
          class GetCertificateRevocationListRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_revocation_lists CertificateAuthorityService.ListCertificateRevocationLists}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists},
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}
          #     to include in the response. Further
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}
          #     can subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}
          #     in a subsequent request. If unspecified, the server will pick an
          #     appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCertificateRevocationListsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_revocation_lists CertificateAuthorityService.ListCertificateRevocationLists}.
          # @!attribute [rw] certificate_revocation_lists
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList>]
          #     The list of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest#page_token ListCertificateRevocationListsRequest.page_token}
          #     to retrieve the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificateRevocationListsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#update_certificate_revocation_list CertificateAuthorityService.UpdateCertificateRevocationList}.
          # @!attribute [rw] certificate_revocation_list
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList]
          #     Required.
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          #     with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateRevocationListRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#create_certificate_template CertificateAuthorityService.CreateCertificateTemplate}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate},
          #     in the format `projects/*/locations/*`.
          # @!attribute [rw] certificate_template_id
          #   @return [::String]
          #     Required. It must be unique within a location and match the regular
          #     expression `[a-zA-Z0-9_-]{1,63}`
          # @!attribute [rw] certificate_template
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate]
          #     Required. A
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     with initial field values.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateCertificateTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#delete_certificate_template CertificateAuthorityService.DeleteCertificateTemplate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     in the format `projects/*/locations/*/certificateTemplates/*`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteCertificateTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#get_certificate_template CertificateAuthorityService.GetCertificateTemplate}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#name name} of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     to get.
          class GetCertificateTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_templates CertificateAuthorityService.ListCertificateTemplates}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the location associated with the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates},
          #     in the format `projects/*/locations/*`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Limit on the number of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}
          #     to include in the response. Further
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}
          #     can subsequently be obtained by including the
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse#next_page_token ListCertificateTemplatesResponse.next_page_token}
          #     in a subsequent request. If unspecified, the server will pick an
          #     appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Pagination token, returned earlier via
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse#next_page_token ListCertificateTemplatesResponse.next_page_token}.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Only include resources that match the filter in the response.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Specify how the results should be sorted.
          class ListCertificateTemplatesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#list_certificate_templates CertificateAuthorityService.ListCertificateTemplates}.
          # @!attribute [rw] certificate_templates
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate>]
          #     The list of
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token to retrieve next page of results. Pass this value in
          #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest#page_token ListCertificateTemplatesRequest.page_token}
          #     to retrieve the next page of results.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     A list of locations (e.g. "us-west1") that could not be reached.
          class ListCertificateTemplatesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#update_certificate_template CertificateAuthorityService.UpdateCertificateTemplate}.
          # @!attribute [rw] certificate_template
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate]
          #     Required.
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     with updated values.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A list of fields to be updated in this request.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An ID to identify requests. Specify a unique request ID so that
          #     if you must retry your request, the server will know to ignore the request
          #     if it has already been completed. The server will guarantee that for at
          #     least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class UpdateCertificateTemplateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] status_message
          #   @return [::String]
          #     Output only. Human-readable status of the operation, if any.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have
          #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
          #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
          #     corresponding to `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class OperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
