# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Security
      module PrivateCA
        module V1
          # A
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          # represents an individual Certificate Authority. A
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          # can be used to create
          # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::Type]
          #     Required. Immutable. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::Type Type} of
          #     this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateConfig]
          #     Required. Immutable. The config used to create a self-signed X.509
          #     certificate or CSR.
          # @!attribute [rw] lifetime
          #   @return [::Google::Protobuf::Duration]
          #     Required. Immutable. The desired lifetime of the CA certificate. Used to
          #     create the "not_before_time" and "not_after_time" fields inside an X.509
          #     certificate.
          # @!attribute [rw] key_spec
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::KeyVersionSpec]
          #     Required. Immutable. Used when issuing certificates for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          #     If this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     is a self-signed CertificateAuthority, this key is also used to sign the
          #     self-signed CA certificate. Otherwise, it is used to sign a CSR.
          # @!attribute [rw] subordinate_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::SubordinateConfig]
          #     Optional. If this is a subordinate
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority},
          #     this field will be set with the subordinate configuration, which describes
          #     its issuers. This may be updated, but this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     must continue to validate.
          # @!attribute [r] tier
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::Tier]
          #     Output only. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::Tier CaPool.Tier} of the
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} that includes this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State]
          #     Output only. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State State} for
          #     this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          # @!attribute [r] pem_ca_certificates
          #   @return [::Array<::String>]
          #     Output only. This
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
          #     certificate chain, including the current
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
          #     certificate. Ordered such that the root issuer is the final element
          #     (consistent with RFC 5246). For a self-signed CA, this will only list the
          #     current
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
          #     certificate.
          # @!attribute [r] ca_certificate_descriptions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateDescription>]
          #     Output only. A structured description of this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
          #     CA certificate and its issuers. Ordered as self-to-root.
          # @!attribute [rw] gcs_bucket
          #   @return [::String]
          #     Immutable. The name of a Cloud Storage bucket where this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     will publish content, such as the CA certificate and CRLs. This must be a
          #     bucket name, without any prefixes (such as `gs://`) or suffixes (such as
          #     `.googleapis.com`). For example, to use a bucket named `my-bucket`, you
          #     would simply specify `my-bucket`. If not specified, a managed bucket will
          #     be created.
          # @!attribute [r] access_urls
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::AccessUrls]
          #     Output only. URLs for accessing content published by this CA, such as the
          #     CA certificate and CRLs.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     was last updated.
          # @!attribute [r] delete_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     was soft deleted, if it is in the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State::DELETED DELETED}
          #     state.
          # @!attribute [r] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     will be permanently purged, if it is in the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State::DELETED DELETED}
          #     state.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          # @!attribute [rw] user_defined_access_urls
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::UserDefinedAccessUrls]
          #     Optional. User-defined URLs for CA certificate and CRLs. The service does
          #     not publish content to these URLs. It is up to the user to mirror content
          #     to these URLs.
          # @!attribute [r] satisfies_pzs
          #   @return [::Boolean]
          #     Output only. Reserved for future use.
          # @!attribute [r] satisfies_pzi
          #   @return [::Boolean]
          #     Output only. Reserved for future use.
          class CertificateAuthority
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # URLs where a
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
            # will publish content.
            # @!attribute [rw] ca_certificate_access_url
            #   @return [::String]
            #     The URL where this
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
            #     CA certificate is published. This will only be set for CAs that have been
            #     activated.
            # @!attribute [rw] crl_access_urls
            #   @return [::Array<::String>]
            #     The URLs where this
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
            #     CRLs are published. This will only be set for CAs that have been
            #     activated.
            class AccessUrls
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A Cloud KMS key configuration that a
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
            # will use.
            # @!attribute [rw] cloud_kms_key_version
            #   @return [::String]
            #     The resource name for an existing Cloud KMS CryptoKeyVersion in the
            #     format
            #     `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
            #     This option enables full flexibility in the key's capabilities and
            #     properties.
            #
            #     Note: The following fields are mutually exclusive: `cloud_kms_key_version`, `algorithm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] algorithm
            #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::SignHashAlgorithm]
            #     The algorithm to use for creating a managed Cloud KMS key for a for a
            #     simplified experience. All managed keys will be have their
            #     [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] as `HSM`.
            #
            #     Note: The following fields are mutually exclusive: `algorithm`, `cloud_kms_key_version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class KeyVersionSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # User-defined URLs for accessing content published by this
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
            # @!attribute [rw] aia_issuing_certificate_urls
            #   @return [::Array<::String>]
            #     Optional. A list of URLs where the issuer CA certificate may be
            #     downloaded, which appears in the "Authority Information Access" extension
            #     in the certificate. If specified, the default [Cloud Storage
            #     URLs][google.cloud.security.privateca.v1.CertificateAuthority.AccessUrls.ca_certificate_access_url]
            #     will be omitted.
            # @!attribute [rw] crl_access_urls
            #   @return [::Array<::String>]
            #     Optional. A list of URLs where to obtain CRL information, i.e.
            #     the DistributionPoint.fullName described by
            #     https://tools.ietf.org/html/rfc5280#section-4.2.1.13.
            #     If specified, the default
            #     [Cloud Storage
            #     URLs][google.cloud.security.privateca.v1.CertificateAuthority.AccessUrls.crl_access_urls]
            #     will be omitted.
            class UserDefinedAccessUrls
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The type of a
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority},
            # indicating its issuing chain.
            module Type
              # Not specified.
              TYPE_UNSPECIFIED = 0

              # Self-signed CA.
              SELF_SIGNED = 1

              # Subordinate CA. Could be issued by a Private CA
              # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
              # or an unmanaged CA.
              SUBORDINATE = 2
            end

            # The state of a
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority},
            # indicating if it can be used.
            module State
              # Not specified.
              STATE_UNSPECIFIED = 0

              # Certificates can be issued from this CA. CRLs will be generated for this
              # CA. The CA will be part of the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s trust anchor, and
              # will be used to issue certificates from the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              ENABLED = 1

              # Certificates cannot be issued from this CA. CRLs will still be generated.
              # The CA will be part of the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s trust anchor, but
              # will not be used to issue certificates from the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              DISABLED = 2

              # Certificates can be issued from this CA. CRLs will be generated for this
              # CA. The CA will be part of the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s trust anchor, but
              # will not be used to issue certificates from the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              STAGED = 3

              # Certificates cannot be issued from this CA. CRLs will not be generated.
              # The CA will not be part of the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s trust anchor, and
              # will not be used to issue certificates from the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              AWAITING_USER_ACTIVATION = 4

              # Certificates cannot be issued from this CA. CRLs will not be generated.
              # The CA may still be recovered by calling
              # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Client#undelete_certificate_authority CertificateAuthorityService.UndeleteCertificateAuthority}
              # before
              # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority#expire_time expire_time}.
              # The CA will not be part of the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s trust anchor, and
              # will not be used to issue certificates from the
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              DELETED = 5
            end

            # The algorithm of a Cloud KMS CryptoKeyVersion of a
            # [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
            # [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
            # `ASYMMETRIC_SIGN`. These values correspond to the
            # [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
            # values. For RSA signing algorithms, the PSS algorithms should be preferred,
            # use PKCS1 algorithms if required for compatibility. For further
            # recommendations, see
            # https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
            module SignHashAlgorithm
              # Not specified.
              SIGN_HASH_ALGORITHM_UNSPECIFIED = 0

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256
              RSA_PSS_2048_SHA256 = 1

              # maps to CryptoKeyVersionAlgorithm. RSA_SIGN_PSS_3072_SHA256
              RSA_PSS_3072_SHA256 = 2

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_4096_SHA256
              RSA_PSS_4096_SHA256 = 3

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_2048_SHA256
              RSA_PKCS1_2048_SHA256 = 6

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_3072_SHA256
              RSA_PKCS1_3072_SHA256 = 7

              # maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_4096_SHA256
              RSA_PKCS1_4096_SHA256 = 8

              # maps to CryptoKeyVersionAlgorithm.EC_SIGN_P256_SHA256
              EC_P256_SHA256 = 4

              # maps to CryptoKeyVersionAlgorithm.EC_SIGN_P384_SHA384
              EC_P384_SHA384 = 5
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} represents a group of
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}
          # that form a trust anchor. A
          # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} can be used to manage
          # issuance policies for one or more
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          # resources and to rotate CA certificates in and out of the trust anchor.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the format
          #     `projects/*/locations/*/caPools/*`.
          # @!attribute [rw] tier
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::Tier]
          #     Required. Immutable. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::Tier Tier} of this
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
          # @!attribute [rw] issuance_policy
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy]
          #     Optional. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy IssuancePolicy}
          #     to control how
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} will be
          #     issued from this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
          # @!attribute [rw] publishing_options
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::PublishingOptions]
          #     Optional. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::PublishingOptions PublishingOptions}
          #     to follow when issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} from any
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class CaPool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Options relating to the publication of each
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
            # CA certificate and CRLs and their inclusion as extensions in issued
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}. The options
            # set here apply to certificates issued by any
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
            # in the {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
            # @!attribute [rw] publish_ca_cert
            #   @return [::Boolean]
            #     Optional. When true, publishes each
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
            #     CA certificate and includes its URL in the "Authority Information Access"
            #     X.509 extension in all issued
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}. If this
            #     is false, the CA certificate will not be published and the corresponding
            #     X.509 extension will not be written in issued certificates.
            # @!attribute [rw] publish_crl
            #   @return [::Boolean]
            #     Optional. When true, publishes each
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
            #     CRL and includes its URL in the "CRL Distribution Points" X.509 extension
            #     in all issued
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}. If this
            #     is false, CRLs will not be published and the corresponding X.509
            #     extension will not be written in issued certificates. CRLs will expire 7
            #     days from their creation. However, we will rebuild daily. CRLs are also
            #     rebuilt shortly after a certificate is revoked.
            # @!attribute [rw] encoding_format
            #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::PublishingOptions::EncodingFormat]
            #     Optional. Specifies the encoding format of each
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
            #     resource's CA certificate and CRLs. If this is omitted, CA certificates
            #     and CRLs will be published in PEM.
            class PublishingOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Supported encoding formats for publishing.
              module EncodingFormat
                # Not specified. By default, PEM format will be used.
                ENCODING_FORMAT_UNSPECIFIED = 0

                # The
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
                # CA certificate and CRLs will be published in PEM format.
                PEM = 1

                # The
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}'s
                # CA certificate and CRLs will be published in DER format.
                DER = 2
              end
            end

            # Defines controls over all certificate issuance within a
            # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
            # @!attribute [rw] allowed_key_types
            #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType>]
            #     Optional. If any
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType AllowedKeyType}
            #     is specified, then the certificate request's public key must match one of
            #     the key types listed here. Otherwise, any key may be used.
            # @!attribute [rw] backdate_duration
            #   @return [::Google::Protobuf::Duration]
            #     Optional. The duration to backdate all certificates issued from this
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}. If not set, the
            #     certificates will be issued with a not_before_time of the issuance time
            #     (i.e. the current time). If set, the certificates will be issued with a
            #     not_before_time of the issuance time minus the backdate_duration. The
            #     not_after_time will be adjusted to preserve the requested lifetime. The
            #     backdate_duration must be less than or equal to 48 hours.
            # @!attribute [rw] maximum_lifetime
            #   @return [::Google::Protobuf::Duration]
            #     Optional. The maximum lifetime allowed for issued
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}. Note that
            #     if the issuing
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
            #     expires before a
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} resource's
            #     requested maximum_lifetime, the effective lifetime will be explicitly
            #     truncated to match it.
            # @!attribute [rw] allowed_issuance_modes
            #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::IssuanceModes]
            #     Optional. If specified, then only methods allowed in the
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::IssuanceModes IssuanceModes}
            #     may be used to issue
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}.
            # @!attribute [rw] baseline_values
            #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters]
            #     Optional. A set of X.509 values that will be applied to all certificates
            #     issued through this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
            #     If a certificate request includes conflicting values for the same
            #     properties, they will be overwritten by the values defined here. If a
            #     certificate request uses a
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
            #     that defines conflicting
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#predefined_values predefined_values}
            #     for the same properties, the certificate issuance request will fail.
            # @!attribute [rw] identity_constraints
            #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateIdentityConstraints]
            #     Optional. Describes constraints on identities that may appear in
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} issued
            #     through this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}. If this
            #     is omitted, then this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}
            #     will not add restrictions on a certificate's identity.
            # @!attribute [rw] passthrough_extensions
            #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateExtensionConstraints]
            #     Optional. Describes the set of X.509 extensions that may appear in a
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued
            #     through this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}. If a
            #     certificate request sets extensions that don't appear in the
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy#passthrough_extensions passthrough_extensions},
            #     those extensions will be dropped. If a certificate request uses a
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
            #     with
            #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#predefined_values predefined_values}
            #     that don't appear here, the certificate issuance request will fail. If
            #     this is omitted, then this
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} will not add
            #     restrictions on a certificate's X.509 extensions. These constraints do
            #     not apply to X.509 extensions set in this
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s
            #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy#baseline_values baseline_values}.
            class IssuancePolicy
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Describes a "type" of key that may be used in a
              # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued from
              # a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}. Note that a single
              # {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType AllowedKeyType}
              # may refer to either a fully-qualified key algorithm, such as RSA 4096, or
              # a family of key algorithms, such as any RSA key.
              # @!attribute [rw] rsa
              #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType::RsaKeyType]
              #     Represents an allowed RSA key type.
              #
              #     Note: The following fields are mutually exclusive: `rsa`, `elliptic_curve`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] elliptic_curve
              #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType::EcKeyType]
              #     Represents an allowed Elliptic Curve key type.
              #
              #     Note: The following fields are mutually exclusive: `elliptic_curve`, `rsa`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class AllowedKeyType
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Describes an RSA key that may be used in a
                # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued
                # from a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                # @!attribute [rw] min_modulus_size
                #   @return [::Integer]
                #     Optional. The minimum allowed RSA modulus size (inclusive), in bits.
                #     If this is not set, or if set to zero, the service-level min RSA
                #     modulus size will continue to apply.
                # @!attribute [rw] max_modulus_size
                #   @return [::Integer]
                #     Optional. The maximum allowed RSA modulus size (inclusive), in bits.
                #     If this is not set, or if set to zero, the service will not enforce
                #     an explicit upper bound on RSA modulus sizes.
                class RsaKeyType
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # Describes an Elliptic Curve key that may be used in a
                # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued
                # from a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                # @!attribute [rw] signature_algorithm
                #   @return [::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::AllowedKeyType::EcKeyType::EcSignatureAlgorithm]
                #     Optional. A signature algorithm that must be used. If this is
                #     omitted, any EC-based signature algorithm will be allowed.
                class EcKeyType
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods

                  # Describes an elliptic curve-based signature algorithm that may be
                  # used in a
                  # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued
                  # from a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                  module EcSignatureAlgorithm
                    # Not specified. Signifies that any signature algorithm may be used.
                    EC_SIGNATURE_ALGORITHM_UNSPECIFIED = 0

                    # Refers to the Elliptic Curve Digital Signature Algorithm over the
                    # NIST P-256 curve.
                    ECDSA_P256 = 1

                    # Refers to the Elliptic Curve Digital Signature Algorithm over the
                    # NIST P-384 curve.
                    ECDSA_P384 = 2

                    # Refers to the Edwards-curve Digital Signature Algorithm over curve
                    # 25519, as described in RFC 8410.
                    EDDSA_25519 = 3
                  end
                end
              end

              # {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy::IssuanceModes IssuanceModes}
              # specifies the allowed ways in which
              # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} may be
              # requested from this {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
              # @!attribute [rw] allow_csr_based_issuance
              #   @return [::Boolean]
              #     Optional. When true, allows callers to create
              #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} by
              #     specifying a CSR.
              # @!attribute [rw] allow_config_based_issuance
              #   @return [::Boolean]
              #     Optional. When true, allows callers to create
              #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} by
              #     specifying a
              #     {::Google::Cloud::Security::PrivateCA::V1::CertificateConfig CertificateConfig}.
              class IssuanceModes
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The tier of a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool},
            # indicating its supported functionality and/or billing SKU.
            module Tier
              # Not specified.
              TIER_UNSPECIFIED = 0

              # Enterprise tier.
              ENTERPRISE = 1

              # DevOps tier.
              DEVOPS = 2
            end
          end

          # A
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          # corresponds to a signed X.509 certificate Revocation List (CRL). A CRL
          # contains the serial numbers of certificates that should no longer be trusted.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          #     in the format `projects/*/locations/*/caPools/*certificateAuthorities/*/
          #        certificateRevocationLists/*`.
          # @!attribute [r] sequence_number
          #   @return [::Integer]
          #     Output only. The CRL sequence number that appears in pem_crl.
          # @!attribute [r] revoked_certificates
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList::RevokedCertificate>]
          #     Output only. The revoked serial numbers that appear in pem_crl.
          # @!attribute [r] pem_crl
          #   @return [::String]
          #     Output only. The PEM-encoded X.509 CRL.
          # @!attribute [r] access_url
          #   @return [::String]
          #     Output only. The location where 'pem_crl' can be accessed.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList::State]
          #     Output only. The
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList::State State}
          #     for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          #     was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
          #     was updated.
          # @!attribute [r] revision_id
          #   @return [::String]
          #     Output only. The revision ID of this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}.
          #     A new revision is committed whenever a new CRL is published. The format is
          #     an 8-character hexadecimal string.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class CertificateRevocationList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes a revoked
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
            # @!attribute [rw] certificate
            #   @return [::String]
            #     The resource name for the
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} in the
            #     format `projects/*/locations/*/caPools/*/certificates/*`.
            # @!attribute [rw] hex_serial_number
            #   @return [::String]
            #     The serial number of the
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
            # @!attribute [rw] revocation_reason
            #   @return [::Google::Cloud::Security::PrivateCA::V1::RevocationReason]
            #     The reason the
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} was
            #     revoked.
            class RevokedCertificate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The state of a
            # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList},
            # indicating if it is current.
            module State
              # Not specified.
              STATE_UNSPECIFIED = 0

              # The
              # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
              # is up to date.
              ACTIVE = 1

              # The
              # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
              # is no longer current.
              SUPERSEDED = 2
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} corresponds
          # to a signed X.509 certificate issued by a
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} in the format
          #     `projects/*/locations/*/caPools/*/certificates/*`.
          # @!attribute [rw] pem_csr
          #   @return [::String]
          #     Immutable. A pem-encoded X.509 certificate signing request (CSR).
          #
          #     Note: The following fields are mutually exclusive: `pem_csr`, `config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateConfig]
          #     Immutable. A description of the certificate and key that does not require
          #     X.509 or ASN.1.
          #
          #     Note: The following fields are mutually exclusive: `config`, `pem_csr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] issuer_certificate_authority
          #   @return [::String]
          #     Output only. The resource name of the issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          # @!attribute [rw] lifetime
          #   @return [::Google::Protobuf::Duration]
          #     Required. Immutable. The desired lifetime of a certificate. Used to create
          #     the "not_before_time" and "not_after_time" fields inside an X.509
          #     certificate. Note that the lifetime may be truncated if it would extend
          #     past the life of any certificate authority in the issuing chain.
          # @!attribute [rw] certificate_template
          #   @return [::String]
          #     Immutable. The resource name for a
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     used to issue this certificate, in the format
          #     `projects/*/locations/*/certificateTemplates/*`.
          #     If this is specified, the caller must have the necessary permission to
          #     use this template. If this is omitted, no template will be used.
          #     This template must be in the same location as the
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
          # @!attribute [rw] subject_mode
          #   @return [::Google::Cloud::Security::PrivateCA::V1::SubjectRequestMode]
          #     Immutable. Specifies how the
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}'s identity
          #     fields are to be decided. If this is omitted, the `DEFAULT` subject mode
          #     will be used.
          # @!attribute [r] revocation_details
          #   @return [::Google::Cloud::Security::PrivateCA::V1::Certificate::RevocationDetails]
          #     Output only. Details regarding the revocation of this
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}. This
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} is considered
          #     revoked if and only if this field is present.
          # @!attribute [r] pem_certificate
          #   @return [::String]
          #     Output only. The pem-encoded, signed X.509 certificate.
          # @!attribute [r] certificate_description
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateDescription]
          #     Output only. A structured description of the issued X.509 certificate.
          # @!attribute [r] pem_certificate_chain
          #   @return [::Array<::String>]
          #     Output only. The chain that may be used to verify the X.509 certificate.
          #     Expected to be in issuer-to-root order according to RFC 5246.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} was updated.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class Certificate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes fields that are relavent to the revocation of a
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
            # @!attribute [rw] revocation_state
            #   @return [::Google::Cloud::Security::PrivateCA::V1::RevocationReason]
            #     Indicates why a
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} was
            #     revoked.
            # @!attribute [rw] revocation_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which this
            #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} was
            #     revoked.
            class RevocationDetails
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          # refers to a managed template for certificate issuance.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name for this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     in the format `projects/*/locations/*/certificateTemplates/*`.
          # @!attribute [rw] maximum_lifetime
          #   @return [::Google::Protobuf::Duration]
          #     Optional. The maximum lifetime allowed for issued
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} that use
          #     this template. If the issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} resource's
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy IssuancePolicy}
          #     specifies a
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy#maximum_lifetime maximum_lifetime}
          #     the minimum of the two durations will be the maximum lifetime for issued
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}. Note that
          #     if the issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     expires before a
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}'s requested
          #     maximum_lifetime, the effective lifetime will be explicitly truncated
          #      to match it.
          # @!attribute [rw] predefined_values
          #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters]
          #     Optional. A set of X.509 values that will be applied to all issued
          #     certificates that use this template. If the certificate request includes
          #     conflicting values for the same properties, they will be overwritten by the
          #     values defined here. If the issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy IssuancePolicy}
          #     defines conflicting
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy#baseline_values baseline_values}
          #     for the same properties, the certificate issuance request will fail.
          # @!attribute [rw] identity_constraints
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateIdentityConstraints]
          #     Optional. Describes constraints on identities that may be appear in
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} issued using
          #     this template. If this is omitted, then this template will not add
          #     restrictions on a certificate's identity.
          # @!attribute [rw] passthrough_extensions
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateExtensionConstraints]
          #     Optional. Describes the set of X.509 extensions that may appear in a
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} issued using
          #     this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}.
          #     If a certificate request sets extensions that don't appear in the
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#passthrough_extensions passthrough_extensions},
          #     those extensions will be dropped. If the issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy IssuancePolicy}
          #     defines
          #     {::Google::Cloud::Security::PrivateCA::V1::CaPool::IssuancePolicy#baseline_values baseline_values}
          #     that don't appear here, the certificate issuance request will fail. If this
          #     is omitted, then this template will not add restrictions on a certificate's
          #     X.509 extensions. These constraints do not apply to X.509 extensions set in
          #     this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}'s
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#predefined_values predefined_values}.
          # @!attribute [rw] description
          #   @return [::String]
          #     Optional. A human-readable description of scenarios this template is
          #     intended for.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
          #     was updated.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Labels with user-defined metadata.
          class CertificateTemplate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # An {::Google::Cloud::Security::PrivateCA::V1::X509Parameters X509Parameters} is
          # used to describe certain fields of an X.509 certificate, such as the key
          # usage fields, fields specific to CA certificates, certificate policy
          # extensions and custom extensions.
          # @!attribute [rw] key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1::KeyUsage]
          #     Optional. Indicates the intended use for keys that correspond to a
          #     certificate.
          # @!attribute [rw] ca_options
          #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters::CaOptions]
          #     Optional. Describes options in this
          #     {::Google::Cloud::Security::PrivateCA::V1::X509Parameters X509Parameters} that
          #     are relevant in a CA certificate. If not specified, a default basic
          #     constraints extension with `is_ca=false` will be added for leaf
          #     certificates.
          # @!attribute [rw] policy_ids
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::ObjectId>]
          #     Optional. Describes the X.509 certificate policy object identifiers, per
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
          # @!attribute [rw] aia_ocsp_servers
          #   @return [::Array<::String>]
          #     Optional. Describes Online Certificate Status Protocol (OCSP) endpoint
          #     addresses that appear in the "Authority Information Access" extension in
          #     the certificate.
          # @!attribute [rw] name_constraints
          #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters::NameConstraints]
          #     Optional. Describes the X.509 name constraints extension.
          # @!attribute [rw] additional_extensions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::X509Extension>]
          #     Optional. Describes custom X.509 extensions.
          class X509Parameters
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes the X.509 basic constraints extension, per [RFC 5280
            # section 4.2.1.9](https://tools.ietf.org/html/rfc5280#section-4.2.1.9)
            # @!attribute [rw] is_ca
            #   @return [::Boolean]
            #     Optional. Refers to the "CA" boolean field in the X.509 extension.
            #     When this value is missing, the basic constraints extension will be
            #     omitted from the certificate.
            # @!attribute [rw] max_issuer_path_length
            #   @return [::Integer]
            #     Optional. Refers to the path length constraint field in the X.509
            #     extension. For a CA certificate, this value describes the depth of
            #     subordinate CA certificates that are allowed. If this value is less than
            #     0, the request will fail. If this value is missing, the max path length
            #     will be omitted from the certificate.
            class CaOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Describes the X.509 name constraints extension, per
            # https://tools.ietf.org/html/rfc5280#section-4.2.1.10
            # @!attribute [rw] critical
            #   @return [::Boolean]
            #     Indicates whether or not the name constraints are marked critical.
            # @!attribute [rw] permitted_dns_names
            #   @return [::Array<::String>]
            #     Contains permitted DNS names. Any DNS name that can be
            #     constructed by simply adding zero or more labels to
            #     the left-hand side of the name satisfies the name constraint.
            #     For example, `example.com`, `www.example.com`, `www.sub.example.com`
            #     would satisfy `example.com` while `example1.com` does not.
            # @!attribute [rw] excluded_dns_names
            #   @return [::Array<::String>]
            #     Contains excluded DNS names. Any DNS name that can be
            #     constructed by simply adding zero or more labels to
            #     the left-hand side of the name satisfies the name constraint.
            #     For example, `example.com`, `www.example.com`, `www.sub.example.com`
            #     would satisfy `example.com` while `example1.com` does not.
            # @!attribute [rw] permitted_ip_ranges
            #   @return [::Array<::String>]
            #     Contains the permitted IP ranges. For IPv4 addresses, the ranges
            #     are expressed using CIDR notation as specified in RFC 4632.
            #     For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
            #     addresses.
            # @!attribute [rw] excluded_ip_ranges
            #   @return [::Array<::String>]
            #     Contains the excluded IP ranges. For IPv4 addresses, the ranges
            #     are expressed using CIDR notation as specified in RFC 4632.
            #     For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
            #     addresses.
            # @!attribute [rw] permitted_email_addresses
            #   @return [::Array<::String>]
            #     Contains the permitted email addresses. The value can be a particular
            #     email address, a hostname to indicate all email addresses on that host or
            #     a domain with a leading period (e.g. `.example.com`) to indicate
            #     all email addresses in that domain.
            # @!attribute [rw] excluded_email_addresses
            #   @return [::Array<::String>]
            #     Contains the excluded email addresses. The value can be a particular
            #     email address, a hostname to indicate all email addresses on that host or
            #     a domain with a leading period (e.g. `.example.com`) to indicate
            #     all email addresses in that domain.
            # @!attribute [rw] permitted_uris
            #   @return [::Array<::String>]
            #     Contains the permitted URIs that apply to the host part of the name.
            #     The value can be a hostname or a domain with a
            #     leading period (like `.example.com`)
            # @!attribute [rw] excluded_uris
            #   @return [::Array<::String>]
            #     Contains the excluded URIs that apply to the host part of the name.
            #     The value can be a hostname or a domain with a
            #     leading period (like `.example.com`)
            class NameConstraints
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Describes a subordinate CA's issuers. This is either a resource name to a
          # known issuing
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority},
          # or a PEM issuer certificate chain.
          # @!attribute [rw] certificate_authority
          #   @return [::String]
          #     Required. This can refer to a
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     that was used to create a subordinate
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
          #     This field is used for information and usability purposes only. The
          #     resource name is in the format
          #     `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
          #
          #     Note: The following fields are mutually exclusive: `certificate_authority`, `pem_issuer_chain`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] pem_issuer_chain
          #   @return [::Google::Cloud::Security::PrivateCA::V1::SubordinateConfig::SubordinateConfigChain]
          #     Required. Contains the PEM certificate chain for the issuers of this
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority},
          #     but not pem certificate for this CA itself.
          #
          #     Note: The following fields are mutually exclusive: `pem_issuer_chain`, `certificate_authority`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SubordinateConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # This message describes a subordinate CA's issuer certificate chain. This
            # wrapper exists for compatibility reasons.
            # @!attribute [rw] pem_certificates
            #   @return [::Array<::String>]
            #     Required. Expected to be in leaf-to-root order according to RFC 5246.
            class SubordinateConfigChain
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::PublicKey PublicKey} describes a
          # public key.
          # @!attribute [rw] key
          #   @return [::String]
          #     Required. A public key. The padding and encoding
          #     must match with the `KeyFormat` value specified for the `format` field.
          # @!attribute [rw] format
          #   @return [::Google::Cloud::Security::PrivateCA::V1::PublicKey::KeyFormat]
          #     Required. The format of the public key.
          class PublicKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Types of public keys formats that are supported. Currently, only `PEM`
            # format is supported.
            module KeyFormat
              # Default unspecified value.
              KEY_FORMAT_UNSPECIFIED = 0

              # The key is PEM-encoded as defined in [RFC
              # 7468](https://tools.ietf.org/html/rfc7468). It can be any of the
              # following: a PEM-encoded PKCS#1/RFC 3447 RSAPublicKey
              # structure, an RFC 5280
              # [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
              # or a PEM-encoded X.509 certificate signing request (CSR). If a
              # [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
              # is specified, it can contain a A PEM-encoded PKCS#1/RFC 3447 RSAPublicKey
              # or a NIST P-256/secp256r1/prime256v1 or P-384 key. If a CSR is specified,
              # it will used solely for the purpose of extracting the public key. When
              # generated by the service, it will always be an RFC 5280
              # [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1)
              # structure containing an algorithm identifier and a key.
              PEM = 1
            end
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::CertificateConfig CertificateConfig}
          # describes an X.509 certificate or CSR that is to be created, as an
          # alternative to using ASN.1.
          # @!attribute [rw] subject_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateConfig::SubjectConfig]
          #     Required. Specifies some of the values in a certificate that are related to
          #     the subject.
          # @!attribute [rw] x509_config
          #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters]
          #     Required. Describes how some of the technical X.509 fields in a certificate
          #     should be populated.
          # @!attribute [rw] public_key
          #   @return [::Google::Cloud::Security::PrivateCA::V1::PublicKey]
          #     Optional. The public key that corresponds to this config. This is, for
          #     example, used when issuing
          #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}, but not
          #     when creating a self-signed
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     or
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
          #     CSR.
          # @!attribute [rw] subject_key_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateConfig::KeyId]
          #     Optional. When specified this provides a custom SKI to be used in the
          #     certificate. This should only be used to maintain a SKI of an existing CA
          #     originally created outside CA service, which was not generated using method
          #     (1) described in RFC 5280 section 4.2.1.2.
          class CertificateConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # These values are used to create the distinguished name and subject
            # alternative name fields in an X.509 certificate.
            # @!attribute [rw] subject
            #   @return [::Google::Cloud::Security::PrivateCA::V1::Subject]
            #     Optional. Contains distinguished name fields such as the common name,
            #     location and organization.
            # @!attribute [rw] subject_alt_name
            #   @return [::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames]
            #     Optional. The subject alternative name fields.
            class SubjectConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A KeyId identifies a specific public key, usually by hashing the public
            # key.
            # @!attribute [rw] key_id
            #   @return [::String]
            #     Required. The value of this KeyId encoded in lowercase hexadecimal. This
            #     is most likely the 160 bit SHA-1 hash of the public key.
            class KeyId
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A
          # {::Google::Cloud::Security::PrivateCA::V1::CertificateDescription CertificateDescription}
          # describes an X.509 certificate or CSR that has been issued, as an alternative
          # to using ASN.1 / X.509.
          # @!attribute [rw] subject_description
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateDescription::SubjectDescription]
          #     Describes some of the values in a certificate that are related to the
          #     subject and lifetime.
          # @!attribute [rw] x509_description
          #   @return [::Google::Cloud::Security::PrivateCA::V1::X509Parameters]
          #     Describes some of the technical X.509 fields in a certificate.
          # @!attribute [rw] public_key
          #   @return [::Google::Cloud::Security::PrivateCA::V1::PublicKey]
          #     The public key that corresponds to an issued certificate.
          # @!attribute [rw] subject_key_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateDescription::KeyId]
          #     Provides a means of identifiying certificates that contain a particular
          #     public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
          # @!attribute [rw] authority_key_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateDescription::KeyId]
          #     Identifies the subject_key_id of the parent certificate, per
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.1
          # @!attribute [rw] crl_distribution_points
          #   @return [::Array<::String>]
          #     Describes a list of locations to obtain CRL information, i.e.
          #     the DistributionPoint.fullName described by
          #     https://tools.ietf.org/html/rfc5280#section-4.2.1.13
          # @!attribute [rw] aia_issuing_certificate_urls
          #   @return [::Array<::String>]
          #     Describes lists of issuer CA certificate URLs that appear in the
          #     "Authority Information Access" extension in the certificate.
          # @!attribute [rw] cert_fingerprint
          #   @return [::Google::Cloud::Security::PrivateCA::V1::CertificateDescription::CertificateFingerprint]
          #     The hash of the x.509 certificate.
          # @!attribute [rw] tbs_certificate_digest
          #   @return [::String]
          #     The hash of the pre-signed certificate, which will be signed by the CA.
          #     Corresponds to the TBS Certificate in
          #     https://tools.ietf.org/html/rfc5280#section-4.1.2. The field will always be
          #     populated.
          class CertificateDescription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # These values describe fields in an issued X.509 certificate such as the
            # distinguished name, subject alternative names, serial number, and lifetime.
            # @!attribute [rw] subject
            #   @return [::Google::Cloud::Security::PrivateCA::V1::Subject]
            #     Contains distinguished name fields such as the common name, location and
            #     / organization.
            # @!attribute [rw] subject_alt_name
            #   @return [::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames]
            #     The subject alternative name fields.
            # @!attribute [rw] hex_serial_number
            #   @return [::String]
            #     The serial number encoded in lowercase hexadecimal.
            # @!attribute [rw] lifetime
            #   @return [::Google::Protobuf::Duration]
            #     For convenience, the actual lifetime of an issued certificate.
            # @!attribute [rw] not_before_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time at which the certificate becomes valid.
            # @!attribute [rw] not_after_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The time after which the certificate is expired.
            #     Per RFC 5280, the validity period for a certificate is the period of time
            #     from not_before_time through not_after_time, inclusive.
            #     Corresponds to 'not_before_time' + 'lifetime' - 1 second.
            class SubjectDescription
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A KeyId identifies a specific public key, usually by hashing the public
            # key.
            # @!attribute [rw] key_id
            #   @return [::String]
            #     Optional. The value of this KeyId encoded in lowercase hexadecimal. This
            #     is most likely the 160 bit SHA-1 hash of the public key.
            class KeyId
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A group of fingerprints for the x509 certificate.
            # @!attribute [rw] sha256_hash
            #   @return [::String]
            #     The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
            class CertificateFingerprint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # An {::Google::Cloud::Security::PrivateCA::V1::ObjectId ObjectId} specifies an
          # object identifier (OID). These provide context and describe types in ASN.1
          # messages.
          # @!attribute [rw] object_id_path
          #   @return [::Array<::Integer>]
          #     Required. The parts of an OID path. The most significant parts of the path
          #     come first.
          class ObjectId
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An {::Google::Cloud::Security::PrivateCA::V1::X509Extension X509Extension}
          # specifies an X.509 extension, which may be used in different parts of X.509
          # objects like certificates, CSRs, and CRLs.
          # @!attribute [rw] object_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1::ObjectId]
          #     Required. The OID for this X.509 extension.
          # @!attribute [rw] critical
          #   @return [::Boolean]
          #     Optional. Indicates whether or not this extension is critical (i.e., if the
          #     client does not know how to handle this extension, the client should
          #     consider this to be an error).
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. The value of this X.509 extension.
          class X509Extension
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::KeyUsage KeyUsage} describes key usage
          # values that may appear in an X.509 certificate.
          # @!attribute [rw] base_key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1::KeyUsage::KeyUsageOptions]
          #     Describes high-level ways in which a key may be used.
          # @!attribute [rw] extended_key_usage
          #   @return [::Google::Cloud::Security::PrivateCA::V1::KeyUsage::ExtendedKeyUsageOptions]
          #     Detailed scenarios in which a key may be used.
          # @!attribute [rw] unknown_extended_key_usages
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::ObjectId>]
          #     Used to describe extended key usages that are not listed in the
          #     {::Google::Cloud::Security::PrivateCA::V1::KeyUsage::ExtendedKeyUsageOptions KeyUsage.ExtendedKeyUsageOptions}
          #     message.
          class KeyUsage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # {::Google::Cloud::Security::PrivateCA::V1::KeyUsage::KeyUsageOptions KeyUsage.KeyUsageOptions}
            # corresponds to the key usage values described in
            # https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
            # @!attribute [rw] digital_signature
            #   @return [::Boolean]
            #     The key may be used for digital signatures.
            # @!attribute [rw] content_commitment
            #   @return [::Boolean]
            #     The key may be used for cryptographic commitments. Note that this may
            #     also be referred to as "non-repudiation".
            # @!attribute [rw] key_encipherment
            #   @return [::Boolean]
            #     The key may be used to encipher other keys.
            # @!attribute [rw] data_encipherment
            #   @return [::Boolean]
            #     The key may be used to encipher data.
            # @!attribute [rw] key_agreement
            #   @return [::Boolean]
            #     The key may be used in a key agreement protocol.
            # @!attribute [rw] cert_sign
            #   @return [::Boolean]
            #     The key may be used to sign certificates.
            # @!attribute [rw] crl_sign
            #   @return [::Boolean]
            #     The key may be used sign certificate revocation lists.
            # @!attribute [rw] encipher_only
            #   @return [::Boolean]
            #     The key may be used to encipher only.
            # @!attribute [rw] decipher_only
            #   @return [::Boolean]
            #     The key may be used to decipher only.
            class KeyUsageOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # {::Google::Cloud::Security::PrivateCA::V1::KeyUsage::ExtendedKeyUsageOptions KeyUsage.ExtendedKeyUsageOptions}
            # has fields that correspond to certain common OIDs that could be specified
            # as an extended key usage value.
            # @!attribute [rw] server_auth
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW
            #     server authentication", though regularly used for non-WWW TLS.
            # @!attribute [rw] client_auth
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW
            #     client authentication", though regularly used for non-WWW TLS.
            # @!attribute [rw] code_signing
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of
            #     downloadable executable code client authentication".
            # @!attribute [rw] email_protection
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email
            #     protection".
            # @!attribute [rw] time_stamping
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding
            #     the hash of an object to a time".
            # @!attribute [rw] ocsp_signing
            #   @return [::Boolean]
            #     Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing
            #     OCSP responses".
            class ExtendedKeyUsageOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # {::Google::Cloud::Security::PrivateCA::V1::AttributeTypeAndValue AttributeTypeAndValue}
          # specifies an attribute type and value. It can use either a OID or enum value
          # to specify the attribute type.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Security::PrivateCA::V1::AttributeType]
          #     The attribute type of the attribute and value pair.
          #
          #     Note: The following fields are mutually exclusive: `type`, `object_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] object_id
          #   @return [::Google::Cloud::Security::PrivateCA::V1::ObjectId]
          #     Object ID for an attribute type of an attribute and value pair.
          #
          #     Note: The following fields are mutually exclusive: `object_id`, `type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] value
          #   @return [::String]
          #     The value for the attribute type.
          class AttributeTypeAndValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Security::PrivateCA::V1::RelativeDistinguishedName RelativeDistinguishedName}
          # specifies a relative distinguished name which will be used to build a
          # distinguished name.
          # @!attribute [rw] attributes
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::AttributeTypeAndValue>]
          #     Attributes describes the attribute value assertions in the RDN.
          class RelativeDistinguishedName
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} describes parts of a
          # distinguished name that, in turn, describes the subject of the certificate.
          # @!attribute [rw] common_name
          #   @return [::String]
          #     The "common name" of the subject.
          # @!attribute [rw] country_code
          #   @return [::String]
          #     The country code of the subject.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization of the subject.
          # @!attribute [rw] organizational_unit
          #   @return [::String]
          #     The organizational_unit of the subject.
          # @!attribute [rw] locality
          #   @return [::String]
          #     The locality or city of the subject.
          # @!attribute [rw] province
          #   @return [::String]
          #     The province, territory, or regional state of the subject.
          # @!attribute [rw] street_address
          #   @return [::String]
          #     The street address of the subject.
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     The postal code of the subject.
          # @!attribute [rw] rdn_sequence
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::RelativeDistinguishedName>]
          #     This field can be used in place of the named subject fields.
          class Subject
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames}
          # corresponds to a more modern way of listing what the asserted identity is in
          # a certificate (i.e., compared to the "common name" in the distinguished
          # name).
          # @!attribute [rw] dns_names
          #   @return [::Array<::String>]
          #     Contains only valid, fully-qualified host names.
          # @!attribute [rw] uris
          #   @return [::Array<::String>]
          #     Contains only valid RFC 3986 URIs.
          # @!attribute [rw] email_addresses
          #   @return [::Array<::String>]
          #     Contains only valid RFC 2822 E-mail addresses.
          # @!attribute [rw] ip_addresses
          #   @return [::Array<::String>]
          #     Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
          # @!attribute [rw] custom_sans
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::X509Extension>]
          #     Contains additional subject alternative name values.
          #     For each custom_san, the `value` field must contain an ASN.1 encoded
          #     UTF8String.
          class SubjectAltNames
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes constraints on a
          # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}'s
          # {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} and
          # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames}.
          # @!attribute [rw] cel_expression
          #   @return [::Google::Type::Expr]
          #     Optional. A CEL expression that may be used to validate the resolved X.509
          #     Subject and/or Subject Alternative Name before a certificate is signed. To
          #     see the full allowed syntax and some examples, see
          #     https://cloud.google.com/certificate-authority-service/docs/using-cel
          # @!attribute [rw] allow_subject_passthrough
          #   @return [::Boolean]
          #     Required. If this is true, the
          #     {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} field may be copied
          #     from a certificate request into the signed certificate. Otherwise, the
          #     requested {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} will be
          #     discarded.
          # @!attribute [rw] allow_subject_alt_names_passthrough
          #   @return [::Boolean]
          #     Required. If this is true, the
          #     {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames}
          #     extension may be copied from a certificate request into the signed
          #     certificate. Otherwise, the requested
          #     {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} will
          #     be discarded.
          class CertificateIdentityConstraints
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes a set of X.509 extensions that may be part of some certificate
          # issuance controls.
          # @!attribute [rw] known_extensions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::CertificateExtensionConstraints::KnownCertificateExtension>]
          #     Optional. A set of named X.509 extensions. Will be combined with
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateExtensionConstraints#additional_extensions additional_extensions}
          #     to determine the full set of X.509 extensions.
          # @!attribute [rw] additional_extensions
          #   @return [::Array<::Google::Cloud::Security::PrivateCA::V1::ObjectId>]
          #     Optional. A set of {::Google::Cloud::Security::PrivateCA::V1::ObjectId ObjectIds}
          #     identifying custom X.509 extensions. Will be combined with
          #     {::Google::Cloud::Security::PrivateCA::V1::CertificateExtensionConstraints#known_extensions known_extensions}
          #     to determine the full set of X.509 extensions.
          class CertificateExtensionConstraints
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes well-known X.509 extensions that can appear in a
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}, not
            # including the
            # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames}
            # extension.
            module KnownCertificateExtension
              # Not specified.
              KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED = 0

              # Refers to a certificate's Key Usage extension, as described in [RFC 5280
              # section 4.2.1.3](https://tools.ietf.org/html/rfc5280#section-4.2.1.3).
              # This corresponds to the
              # {::Google::Cloud::Security::PrivateCA::V1::KeyUsage#base_key_usage KeyUsage.base_key_usage}
              # field.
              BASE_KEY_USAGE = 1

              # Refers to a certificate's Extended Key Usage extension, as described in
              # [RFC 5280
              # section 4.2.1.12](https://tools.ietf.org/html/rfc5280#section-4.2.1.12).
              # This corresponds to the
              # {::Google::Cloud::Security::PrivateCA::V1::KeyUsage#extended_key_usage KeyUsage.extended_key_usage}
              # message.
              EXTENDED_KEY_USAGE = 2

              # Refers to a certificate's Basic Constraints extension, as described in
              # [RFC 5280
              # section 4.2.1.9](https://tools.ietf.org/html/rfc5280#section-4.2.1.9).
              # This corresponds to the
              # {::Google::Cloud::Security::PrivateCA::V1::X509Parameters#ca_options X509Parameters.ca_options}
              # field.
              CA_OPTIONS = 3

              # Refers to a certificate's Policy object identifiers, as described in
              # [RFC 5280
              # section 4.2.1.4](https://tools.ietf.org/html/rfc5280#section-4.2.1.4).
              # This corresponds to the
              # {::Google::Cloud::Security::PrivateCA::V1::X509Parameters#policy_ids X509Parameters.policy_ids}
              # field.
              POLICY_IDS = 4

              # Refers to OCSP servers in a certificate's Authority Information Access
              # extension, as described in
              # [RFC 5280
              # section 4.2.2.1](https://tools.ietf.org/html/rfc5280#section-4.2.2.1),
              # This corresponds to the
              # {::Google::Cloud::Security::PrivateCA::V1::X509Parameters#aia_ocsp_servers X509Parameters.aia_ocsp_servers}
              # field.
              AIA_OCSP_SERVERS = 5

              # Refers to Name Constraints extension as described in
              # [RFC 5280
              # section 4.2.1.10](https://tools.ietf.org/html/rfc5280#section-4.2.1.10)
              NAME_CONSTRAINTS = 6
            end
          end

          # {::Google::Cloud::Security::PrivateCA::V1::AttributeType AttributeType} specifies
          # the type of Attribute in a relative distinguished name.
          module AttributeType
            # Attribute type is unspecified.
            ATTRIBUTE_TYPE_UNSPECIFIED = 0

            # The "common name" of the subject.
            COMMON_NAME = 1

            # The country code of the subject.
            COUNTRY_CODE = 2

            # The organization of the subject.
            ORGANIZATION = 3

            # The organizational unit of the subject.
            ORGANIZATIONAL_UNIT = 4

            # The locality or city of the subject.
            LOCALITY = 5

            # The province, territory, or regional state of the subject.
            PROVINCE = 6

            # The street address of the subject.
            STREET_ADDRESS = 7

            # The postal code of the subject.
            POSTAL_CODE = 8
          end

          # A {::Google::Cloud::Security::PrivateCA::V1::RevocationReason RevocationReason}
          # indicates whether a
          # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} has been
          # revoked, and the reason for revocation. These correspond to standard
          # revocation reasons from RFC 5280. Note that the enum labels and values in
          # this definition are not the same ASN.1 values defined in RFC 5280. These
          # values will be translated to the correct ASN.1 values when a CRL is created.
          module RevocationReason
            # Default unspecified value. This value does indicate that a
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} has been
            # revoked, but that a reason has not been recorded.
            REVOCATION_REASON_UNSPECIFIED = 0

            # Key material for this
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} may have
            # leaked.
            KEY_COMPROMISE = 1

            # The key material for a certificate authority in the issuing path may have
            # leaked.
            CERTIFICATE_AUTHORITY_COMPROMISE = 2

            # The subject or other attributes in this
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} have changed.
            AFFILIATION_CHANGED = 3

            # This {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} has been
            # superseded.
            SUPERSEDED = 4

            # This {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} or
            # entities in the issuing path have ceased to operate.
            CESSATION_OF_OPERATION = 5

            # This {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} should
            # not be considered valid, it is expected that it may become valid in the
            # future.
            CERTIFICATE_HOLD = 6

            # This {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} no
            # longer has permission to assert the listed attributes.
            PRIVILEGE_WITHDRAWN = 7

            # The authority which determines appropriate attributes for a
            # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} may have been
            # compromised.
            ATTRIBUTE_AUTHORITY_COMPROMISE = 8
          end

          # Describes the way in which a
          # {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}'s
          # {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} and/or
          # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} will be
          # resolved.
          module SubjectRequestMode
            # Not specified.
            SUBJECT_REQUEST_MODE_UNSPECIFIED = 0

            # The default mode used in most cases. Indicates that the certificate's
            # {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} and/or
            # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} are
            # specified in the certificate request. This mode requires the caller to have
            # the `privateca.certificates.create` permission.
            DEFAULT = 1

            # A mode used to get an accurate representation of the Subject
            # field's distinguished name. Indicates that the certificate's
            # {::Google::Cloud::Security::PrivateCA::V1::Subject Subject} and/or
            # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} are
            # specified in the certificate request. When parsing a PEM CSR this mode will
            # maintain the sequence of RDNs found in the CSR's subject field in the
            # issued {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}. This
            # mode requires the caller to have the `privateca.certificates.create`
            # permission.
            RDN_SEQUENCE = 3

            # A mode reserved for special cases. Indicates that the certificate should
            # have one SPIFFE
            # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} set
            # by the service based on the caller's identity. This mode will ignore any
            # explicitly specified {::Google::Cloud::Security::PrivateCA::V1::Subject Subject}
            # and/or
            # {::Google::Cloud::Security::PrivateCA::V1::SubjectAltNames SubjectAltNames} in
            # the certificate request. This mode requires the caller to have the
            # `privateca.certificates.createForSelf` permission.
            REFLECTED_SPIFFE = 2
          end
        end
      end
    end
  end
end
