# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/security/privateca/v1/service_pb"
require "google/cloud/security/private_ca/v1/certificate_authority_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Security
      module PrivateCA
        module V1
          module CertificateAuthorityService
            module Rest
              ##
              # REST client for the CertificateAuthorityService service.
              #
              # [Certificate Authority
              # Service][google.cloud.security.privateca.v1.CertificateAuthorityService]
              # manages private certificate authorities and issued certificates.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "privateca.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :certificate_authority_service_stub

                ##
                # Configure the CertificateAuthorityService Client class.
                #
                # See {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all CertificateAuthorityService clients
                #   ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Security", "PrivateCA", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0
                    default_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [2, 14, 4]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the CertificateAuthorityService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @certificate_authority_service_stub.universe_domain
                end

                ##
                # Create a new CertificateAuthorityService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the CertificateAuthorityService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @certificate_authority_service_stub = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @certificate_authority_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @certificate_authority_service_stub.endpoint
                    config.universe_domain = @certificate_authority_service_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @certificate_authority_service_stub.logger if config.respond_to? :logger=
                  end

                  @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @certificate_authority_service_stub.endpoint
                    config.universe_domain = @certificate_authority_service_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @certificate_authority_service_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # Get the associated client for mix-in of the IAMPolicy.
                #
                # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
                #
                attr_reader :iam_policy_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @certificate_authority_service_stub.logger
                end

                # Service calls

                ##
                # Create a new {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}
                # in a given Project, Location from a particular
                # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                #
                # @overload create_certificate(request, options = nil)
                #   Pass arguments to `create_certificate` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_certificate(parent: nil, certificate_id: nil, certificate: nil, request_id: nil, validate_only: nil, issuing_certificate_authority_id: nil)
                #   Pass arguments to `create_certificate` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}, in the
                #     format `projects/*/locations/*/caPools/*`.
                #   @param certificate_id [::String]
                #     Optional. It must be unique within a location and match the regular
                #     expression `[a-zA-Z0-9_-]{1,63}`. This field is required when using a
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the Enterprise
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority#tier CertificateAuthority.tier},
                #     but is optional and its value is ignored otherwise.
                #   @param certificate [::Google::Cloud::Security::PrivateCA::V1::Certificate, ::Hash]
                #     Required. A {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}
                #     with initial field values.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request ID,
                #     the server can check if original operation with the same request ID was
                #     received, and if so, will ignore the second request. This prevents clients
                #     from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param validate_only [::Boolean]
                #     Optional. If this is true, no
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} resource will
                #     be persisted regardless of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}'s
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool#tier tier}, and the returned
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} will not
                #     contain the
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate#pem_certificate pem_certificate}
                #     field.
                #   @param issuing_certificate_authority_id [::String]
                #     Optional. The resource ID of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     that should issue the certificate.  This optional field will ignore the
                #     load-balancing scheme of the Pool and directly issue the certificate from
                #     the CA with the specified ID, contained in the same
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} referenced by `parent`.
                #     Per-CA quota rules apply. If left empty, a
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     will be chosen from the {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}
                #     by the service. For example, to issue a
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} from a
                #     Certificate Authority with resource name
                #     "projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca",
                #     you can set the
                #     {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest#parent parent}
                #     to "projects/my-project/locations/us-central1/caPools/my-pool" and the
                #     {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest#issuing_certificate_authority_id issuing_certificate_authority_id}
                #     to "my-ca".
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest.new
                #
                #   # Call the create_certificate method.
                #   result = client.create_certificate request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::Certificate.
                #   p result
                #
                def create_certificate request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_certificate.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_certificate.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_certificate.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.create_certificate request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns a {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
                #
                # @overload get_certificate(request, options = nil)
                #   Pass arguments to `get_certificate` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_certificate(name: nil)
                #   Pass arguments to `get_certificate` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The {::Google::Cloud::Security::PrivateCA::V1::Certificate#name name}
                #     of the {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} to
                #     get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest.new
                #
                #   # Call the get_certificate method.
                #   result = client.get_certificate request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::Certificate.
                #   p result
                #
                def get_certificate request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_certificate.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_certificate.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_certificate.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.get_certificate request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}.
                #
                # @overload list_certificates(request, options = nil)
                #   Pass arguments to `list_certificates` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_certificates(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_certificates` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates}, in the
                #     format `projects/*/locations/*/caPools/*`.
                #   @param page_size [::Integer]
                #     Optional. Limit on the number of
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} to include
                #     in the response. Further
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificates} can
                #     subsequently be obtained by including the
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}
                #     in a subsequent request. If unspecified, the server will pick an
                #     appropriate default.
                #   @param page_token [::String]
                #     Optional. Pagination token, returned earlier via
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificatesResponse#next_page_token ListCertificatesResponse.next_page_token}.
                #   @param filter [::String]
                #     Optional. Only include resources that match the filter in the response. For
                #     details on supported filters and syntax, see [Certificates Filtering
                #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#filtering_support).
                #   @param order_by [::String]
                #     Optional. Specify how the results should be sorted. For details on
                #     supported fields and syntax, see [Certificates Sorting
                #     documentation](https://cloud.google.com/certificate-authority-service/docs/sorting-filtering-certificates#sorting_support).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::Certificate>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::Certificate>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest.new
                #
                #   # Call the list_certificates method.
                #   result = client.list_certificates request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1::Certificate.
                #     p item
                #   end
                #
                def list_certificates request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ListCertificatesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_certificates.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_certificates.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_certificates.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.list_certificates request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @certificate_authority_service_stub, :list_certificates, "certificates", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Revoke a {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
                #
                # @overload revoke_certificate(request, options = nil)
                #   Pass arguments to `revoke_certificate` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload revoke_certificate(name: nil, reason: nil, request_id: nil)
                #   Pass arguments to `revoke_certificate` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate} in the format
                #     `projects/*/locations/*/caPools/*/certificates/*`.
                #   @param reason [::Google::Cloud::Security::PrivateCA::V1::RevocationReason]
                #     Required. The
                #     {::Google::Cloud::Security::PrivateCA::V1::RevocationReason RevocationReason} for
                #     revoking this certificate.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest.new
                #
                #   # Call the revoke_certificate method.
                #   result = client.revoke_certificate request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::Certificate.
                #   p result
                #
                def revoke_certificate request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::RevokeCertificateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.revoke_certificate.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.revoke_certificate.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.revoke_certificate.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.revoke_certificate request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}.
                # Currently, the only field you can update is the
                # {::Google::Cloud::Security::PrivateCA::V1::Certificate#labels labels} field.
                #
                # @overload update_certificate(request, options = nil)
                #   Pass arguments to `update_certificate` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_certificate(certificate: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_certificate` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param certificate [::Google::Cloud::Security::PrivateCA::V1::Certificate, ::Hash]
                #     Required. {::Google::Cloud::Security::PrivateCA::V1::Certificate Certificate}
                #     with updated values.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A list of fields to be updated in this request.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::Certificate]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest.new
                #
                #   # Call the update_certificate method.
                #   result = client.update_certificate request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::Certificate.
                #   p result
                #
                def update_certificate request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_certificate.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_certificate.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_certificate.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.update_certificate request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Activate a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                # that is in state
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State::AWAITING_USER_ACTIVATION AWAITING_USER_ACTIVATION}
                # and is of type
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::Type::SUBORDINATE SUBORDINATE}.
                # After the parent Certificate Authority signs a certificate signing request
                # from
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client#fetch_certificate_authority_csr FetchCertificateAuthorityCsr},
                # this method can complete the activation process.
                #
                # @overload activate_certificate_authority(request, options = nil)
                #   Pass arguments to `activate_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload activate_certificate_authority(name: nil, pem_ca_certificate: nil, subordinate_config: nil, request_id: nil)
                #   Pass arguments to `activate_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param pem_ca_certificate [::String]
                #     Required. The signed CA certificate issued from
                #     {::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse#pem_csr FetchCertificateAuthorityCsrResponse.pem_csr}.
                #   @param subordinate_config [::Google::Cloud::Security::PrivateCA::V1::SubordinateConfig, ::Hash]
                #     Required. Must include information about the issuer of
                #     'pem_ca_certificate', and any further issuers until the self-signed CA.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest.new
                #
                #   # Call the activate_certificate_authority method.
                #   result = client.activate_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def activate_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ActivateCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.activate_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.activate_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.activate_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.activate_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                # in a given Project and Location.
                #
                # @overload create_certificate_authority(request, options = nil)
                #   Pass arguments to `create_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_certificate_authority(parent: nil, certificate_authority_id: nil, certificate_authority: nil, request_id: nil)
                #   Pass arguments to `create_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities},
                #     in the format `projects/*/locations/*/caPools/*`.
                #   @param certificate_authority_id [::String]
                #     Required. It must be unique within a location and match the regular
                #     expression `[a-zA-Z0-9_-]{1,63}`
                #   @param certificate_authority [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority, ::Hash]
                #     Required. A
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     with initial field values.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest.new
                #
                #   # Call the create_certificate_authority method.
                #   result = client.create_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.create_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Disable a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
                #
                # @overload disable_certificate_authority(request, options = nil)
                #   Pass arguments to `disable_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload disable_certificate_authority(name: nil, request_id: nil, ignore_dependent_resources: nil)
                #   Pass arguments to `disable_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param ignore_dependent_resources [::Boolean]
                #     Optional. This field allows this CA to be disabled even if it's being
                #     depended on by another resource. However, doing so may result in unintended
                #     and unrecoverable effects on any dependent resources since the CA will
                #     no longer be able to issue certificates.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest.new
                #
                #   # Call the disable_certificate_authority method.
                #   result = client.disable_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def disable_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::DisableCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.disable_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.disable_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.disable_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.disable_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Enable a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
                #
                # @overload enable_certificate_authority(request, options = nil)
                #   Pass arguments to `enable_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload enable_certificate_authority(name: nil, request_id: nil)
                #   Pass arguments to `enable_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest.new
                #
                #   # Call the enable_certificate_authority method.
                #   result = client.enable_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def enable_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::EnableCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.enable_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.enable_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.enable_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.enable_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Fetch a certificate signing request (CSR) from a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                # that is in state
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::State::AWAITING_USER_ACTIVATION AWAITING_USER_ACTIVATION}
                # and is of type
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority::Type::SUBORDINATE SUBORDINATE}.
                # The CSR must then be signed by the desired parent Certificate Authority,
                # which could be another
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                # resource, or could be an on-prem certificate authority. See also
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client#activate_certificate_authority ActivateCertificateAuthority}.
                #
                # @overload fetch_certificate_authority_csr(request, options = nil)
                #   Pass arguments to `fetch_certificate_authority_csr` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload fetch_certificate_authority_csr(name: nil)
                #   Pass arguments to `fetch_certificate_authority_csr` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest.new
                #
                #   # Call the fetch_certificate_authority_csr method.
                #   result = client.fetch_certificate_authority_csr request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrResponse.
                #   p result
                #
                def fetch_certificate_authority_csr request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::FetchCertificateAuthorityCsrRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.fetch_certificate_authority_csr.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.fetch_certificate_authority_csr.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.fetch_certificate_authority_csr.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.fetch_certificate_authority_csr request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
                #
                # @overload get_certificate_authority(request, options = nil)
                #   Pass arguments to `get_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_certificate_authority(name: nil)
                #   Pass arguments to `get_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority#name name} of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     to get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest.new
                #
                #   # Call the get_certificate_authority method.
                #   result = client.get_certificate_authority request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::CertificateAuthority.
                #   p result
                #
                def get_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::GetCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.get_certificate_authority request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}.
                #
                # @overload list_certificate_authorities(request, options = nil)
                #   Pass arguments to `list_certificate_authorities` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_certificate_authorities(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_certificate_authorities` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities},
                #     in the format `projects/*/locations/*/caPools/*`.
                #   @param page_size [::Integer]
                #     Optional. Limit on the number of
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}
                #     to include in the response. Further
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthorities}
                #     can subsequently be obtained by including the
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}
                #     in a subsequent request. If unspecified, the server will pick an
                #     appropriate default.
                #   @param page_token [::String]
                #     Optional. Pagination token, returned earlier via
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesResponse#next_page_token ListCertificateAuthoritiesResponse.next_page_token}.
                #   @param filter [::String]
                #     Optional. Only include resources that match the filter in the response.
                #   @param order_by [::String]
                #     Optional. Specify how the results should be sorted.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest.new
                #
                #   # Call the list_certificate_authorities method.
                #   result = client.list_certificate_authorities request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority.
                #     p item
                #   end
                #
                def list_certificate_authorities request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ListCertificateAuthoritiesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_certificate_authorities.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_certificate_authorities.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_certificate_authorities.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.list_certificate_authorities request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @certificate_authority_service_stub, :list_certificate_authorities, "certificate_authorities", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Undelete a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                # that has been deleted.
                #
                # @overload undelete_certificate_authority(request, options = nil)
                #   Pass arguments to `undelete_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload undelete_certificate_authority(name: nil, request_id: nil)
                #   Pass arguments to `undelete_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest.new
                #
                #   # Call the undelete_certificate_authority method.
                #   result = client.undelete_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def undelete_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UndeleteCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.undelete_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.undelete_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.undelete_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.undelete_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
                #
                # @overload delete_certificate_authority(request, options = nil)
                #   Pass arguments to `delete_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_certificate_authority(name: nil, request_id: nil, ignore_active_certificates: nil, skip_grace_period: nil, ignore_dependent_resources: nil)
                #   Pass arguments to `delete_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param ignore_active_certificates [::Boolean]
                #     Optional. This field allows the CA to be deleted even if the CA has
                #     active certs. Active certs include both unrevoked and unexpired certs.
                #   @param skip_grace_period [::Boolean]
                #     Optional. If this flag is set, the Certificate Authority will be deleted as
                #     soon as possible without a 30-day grace period where undeletion would have
                #     been allowed. If you proceed, there will be no way to recover this CA.
                #   @param ignore_dependent_resources [::Boolean]
                #     Optional. This field allows this CA to be deleted even if it's being
                #     depended on by another resource. However, doing so may result in unintended
                #     and unrecoverable effects on any dependent resources since the CA will
                #     no longer be able to issue certificates.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest.new
                #
                #   # Call the delete_certificate_authority method.
                #   result = client.delete_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.delete_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}.
                #
                # @overload update_certificate_authority(request, options = nil)
                #   Pass arguments to `update_certificate_authority` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_certificate_authority(certificate_authority: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_certificate_authority` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param certificate_authority [::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority, ::Hash]
                #     Required.
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthority CertificateAuthority}
                #     with updated values.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A list of fields to be updated in this request.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest.new
                #
                #   # Call the update_certificate_authority method.
                #   result = client.update_certificate_authority request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_certificate_authority request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateAuthorityRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_certificate_authority.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_certificate_authority.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_certificate_authority.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.update_certificate_authority request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                #
                # @overload create_ca_pool(request, options = nil)
                #   Pass arguments to `create_ca_pool` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_ca_pool(parent: nil, ca_pool_id: nil, ca_pool: nil, request_id: nil)
                #   Pass arguments to `create_ca_pool` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}, in the format
                #     `projects/*/locations/*`.
                #   @param ca_pool_id [::String]
                #     Required. It must be unique within a location and match the regular
                #     expression `[a-zA-Z0-9_-]{1,63}`
                #   @param ca_pool [::Google::Cloud::Security::PrivateCA::V1::CaPool, ::Hash]
                #     Required. A {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} with
                #     initial field values.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest.new
                #
                #   # Call the create_ca_pool method.
                #   result = client.create_ca_pool request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_ca_pool request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::CreateCaPoolRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_ca_pool.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_ca_pool.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_ca_pool.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.create_ca_pool request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                #
                # @overload update_ca_pool(request, options = nil)
                #   Pass arguments to `update_ca_pool` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_ca_pool(ca_pool: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_ca_pool` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param ca_pool [::Google::Cloud::Security::PrivateCA::V1::CaPool, ::Hash]
                #     Required. {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} with updated
                #     values.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A list of fields to be updated in this request.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest.new
                #
                #   # Call the update_ca_pool method.
                #   result = client.update_ca_pool request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_ca_pool request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UpdateCaPoolRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_ca_pool.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_ca_pool.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_ca_pool.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.update_ca_pool request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                #
                # @overload get_ca_pool(request, options = nil)
                #   Pass arguments to `get_ca_pool` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_ca_pool(name: nil)
                #   Pass arguments to `get_ca_pool` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The {::Google::Cloud::Security::PrivateCA::V1::CaPool#name name} of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} to get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::CaPool]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::CaPool]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest.new
                #
                #   # Call the get_ca_pool method.
                #   result = client.get_ca_pool request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::CaPool.
                #   p result
                #
                def get_ca_pool request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::GetCaPoolRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_ca_pool.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_ca_pool.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_ca_pool.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.get_ca_pool request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools}.
                #
                # @overload list_ca_pools(request, options = nil)
                #   Pass arguments to `list_ca_pools` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_ca_pools(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_ca_pools` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools}, in the format
                #     `projects/*/locations/*`.
                #   @param page_size [::Integer]
                #     Optional. Limit on the number of
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools} to include in the
                #     response. Further {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPools} can
                #     subsequently be obtained by including the
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse#next_page_token ListCaPoolsResponse.next_page_token}
                #     in a subsequent request. If unspecified, the server will pick an
                #     appropriate default.
                #   @param page_token [::String]
                #     Optional. Pagination token, returned earlier via
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsResponse#next_page_token ListCaPoolsResponse.next_page_token}.
                #   @param filter [::String]
                #     Optional. Only include resources that match the filter in the response.
                #   @param order_by [::String]
                #     Optional. Specify how the results should be sorted.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CaPool>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CaPool>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest.new
                #
                #   # Call the list_ca_pools method.
                #   result = client.list_ca_pools request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1::CaPool.
                #     p item
                #   end
                #
                def list_ca_pools request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ListCaPoolsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_ca_pools.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_ca_pools.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_ca_pools.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.list_ca_pools request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @certificate_authority_service_stub, :list_ca_pools, "ca_pools", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}.
                #
                # @overload delete_ca_pool(request, options = nil)
                #   Pass arguments to `delete_ca_pool` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_ca_pool(name: nil, request_id: nil, ignore_dependent_resources: nil)
                #   Pass arguments to `delete_ca_pool` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the format
                #     `projects/*/locations/*/caPools/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param ignore_dependent_resources [::Boolean]
                #     Optional. This field allows this pool to be deleted even if it's being
                #     depended on by another resource. However, doing so may result in unintended
                #     and unrecoverable effects on any dependent resources since the pool will
                #     no longer be able to issue certificates.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest.new
                #
                #   # Call the delete_ca_pool method.
                #   result = client.delete_ca_pool request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_ca_pool request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::DeleteCaPoolRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_ca_pool.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_ca_pool.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_ca_pool.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.delete_ca_pool request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # FetchCaCerts returns the current trust anchor for the
                # {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool}. This will include CA
                # certificate chains for all certificate authorities in the ENABLED,
                # DISABLED, or STAGED states.
                #
                # @overload fetch_ca_certs(request, options = nil)
                #   Pass arguments to `fetch_ca_certs` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload fetch_ca_certs(ca_pool: nil, request_id: nil)
                #   Pass arguments to `fetch_ca_certs` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param ca_pool [::String]
                #     Required. The resource name for the
                #     {::Google::Cloud::Security::PrivateCA::V1::CaPool CaPool} in the format
                #     `projects/*/locations/*/caPools/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest.new
                #
                #   # Call the fetch_ca_certs method.
                #   result = client.fetch_ca_certs request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::FetchCaCertsResponse.
                #   p result
                #
                def fetch_ca_certs request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::FetchCaCertsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.fetch_ca_certs.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.fetch_ca_certs.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.fetch_ca_certs.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.fetch_ca_certs request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}.
                #
                # @overload get_certificate_revocation_list(request, options = nil)
                #   Pass arguments to `get_certificate_revocation_list` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_certificate_revocation_list(name: nil)
                #   Pass arguments to `get_certificate_revocation_list` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList#name name}
                #     of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
                #     to get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest.new
                #
                #   # Call the get_certificate_revocation_list method.
                #   result = client.get_certificate_revocation_list request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList.
                #   p result
                #
                def get_certificate_revocation_list request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::GetCertificateRevocationListRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_certificate_revocation_list.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_certificate_revocation_list.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_certificate_revocation_list.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.get_certificate_revocation_list request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}.
                #
                # @overload list_certificate_revocation_lists(request, options = nil)
                #   Pass arguments to `list_certificate_revocation_lists` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_certificate_revocation_lists(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_certificate_revocation_lists` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists},
                #     in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
                #   @param page_size [::Integer]
                #     Optional. Limit on the number of
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}
                #     to include in the response. Further
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationLists}
                #     can subsequently be obtained by including the
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}
                #     in a subsequent request. If unspecified, the server will pick an
                #     appropriate default.
                #   @param page_token [::String]
                #     Optional. Pagination token, returned earlier via
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsResponse#next_page_token ListCertificateRevocationListsResponse.next_page_token}.
                #   @param filter [::String]
                #     Optional. Only include resources that match the filter in the response.
                #   @param order_by [::String]
                #     Optional. Specify how the results should be sorted.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest.new
                #
                #   # Call the list_certificate_revocation_lists method.
                #   result = client.list_certificate_revocation_lists request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList.
                #     p item
                #   end
                #
                def list_certificate_revocation_lists request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ListCertificateRevocationListsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_certificate_revocation_lists.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_certificate_revocation_lists.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_certificate_revocation_lists.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.list_certificate_revocation_lists request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @certificate_authority_service_stub, :list_certificate_revocation_lists, "certificate_revocation_lists", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}.
                #
                # @overload update_certificate_revocation_list(request, options = nil)
                #   Pass arguments to `update_certificate_revocation_list` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_certificate_revocation_list(certificate_revocation_list: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_certificate_revocation_list` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param certificate_revocation_list [::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList, ::Hash]
                #     Required.
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateRevocationList CertificateRevocationList}
                #     with updated values.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A list of fields to be updated in this request.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest.new
                #
                #   # Call the update_certificate_revocation_list method.
                #   result = client.update_certificate_revocation_list request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_certificate_revocation_list request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateRevocationListRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_certificate_revocation_list.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_certificate_revocation_list.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_certificate_revocation_list.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.update_certificate_revocation_list request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
                # in a given Project and Location.
                #
                # @overload create_certificate_template(request, options = nil)
                #   Pass arguments to `create_certificate_template` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_certificate_template(parent: nil, certificate_template_id: nil, certificate_template: nil, request_id: nil)
                #   Pass arguments to `create_certificate_template` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate},
                #     in the format `projects/*/locations/*`.
                #   @param certificate_template_id [::String]
                #     Required. It must be unique within a location and match the regular
                #     expression `[a-zA-Z0-9_-]{1,63}`
                #   @param certificate_template [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate, ::Hash]
                #     Required. A
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
                #     with initial field values.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest.new
                #
                #   # Call the create_certificate_template method.
                #   result = client.create_certificate_template request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_certificate_template request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::CreateCertificateTemplateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_certificate_template.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_certificate_template.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_certificate_template.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.create_certificate_template request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # DeleteCertificateTemplate deletes a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}.
                #
                # @overload delete_certificate_template(request, options = nil)
                #   Pass arguments to `delete_certificate_template` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_certificate_template(name: nil, request_id: nil)
                #   Pass arguments to `delete_certificate_template` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name for this
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
                #     in the format `projects/*/locations/*/certificateTemplates/*`.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest.new
                #
                #   # Call the delete_certificate_template method.
                #   result = client.delete_certificate_template request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_certificate_template request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::DeleteCertificateTemplateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_certificate_template.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_certificate_template.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_certificate_template.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.delete_certificate_template request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}.
                #
                # @overload get_certificate_template(request, options = nil)
                #   Pass arguments to `get_certificate_template` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_certificate_template(name: nil)
                #   Pass arguments to `get_certificate_template` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate#name name} of the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
                #     to get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest.new
                #
                #   # Call the get_certificate_template method.
                #   result = client.get_certificate_template request
                #
                #   # The returned object is of type Google::Cloud::Security::PrivateCA::V1::CertificateTemplate.
                #   p result
                #
                def get_certificate_template request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::GetCertificateTemplateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_certificate_template.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_certificate_template.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_certificate_template.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.get_certificate_template request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}.
                #
                # @overload list_certificate_templates(request, options = nil)
                #   Pass arguments to `list_certificate_templates` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_certificate_templates(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_certificate_templates` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the location associated with the
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates},
                #     in the format `projects/*/locations/*`.
                #   @param page_size [::Integer]
                #     Optional. Limit on the number of
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}
                #     to include in the response. Further
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplates}
                #     can subsequently be obtained by including the
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse#next_page_token ListCertificateTemplatesResponse.next_page_token}
                #     in a subsequent request. If unspecified, the server will pick an
                #     appropriate default.
                #   @param page_token [::String]
                #     Optional. Pagination token, returned earlier via
                #     {::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesResponse#next_page_token ListCertificateTemplatesResponse.next_page_token}.
                #   @param filter [::String]
                #     Optional. Only include resources that match the filter in the response.
                #   @param order_by [::String]
                #     Optional. Specify how the results should be sorted.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest.new
                #
                #   # Call the list_certificate_templates method.
                #   result = client.list_certificate_templates request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate.
                #     p item
                #   end
                #
                def list_certificate_templates request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::ListCertificateTemplatesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_certificate_templates.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_certificate_templates.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_certificate_templates.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.list_certificate_templates request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @certificate_authority_service_stub, :list_certificate_templates, "certificate_templates", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}.
                #
                # @overload update_certificate_template(request, options = nil)
                #   Pass arguments to `update_certificate_template` via a request object, either of type
                #   {::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_certificate_template(certificate_template: nil, update_mask: nil, request_id: nil)
                #   Pass arguments to `update_certificate_template` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param certificate_template [::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate, ::Hash]
                #     Required.
                #     {::Google::Cloud::Security::PrivateCA::V1::CertificateTemplate CertificateTemplate}
                #     with updated values.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A list of fields to be updated in this request.
                #   @param request_id [::String]
                #     Optional. An ID to identify requests. Specify a unique request ID so that
                #     if you must retry your request, the server will know to ignore the request
                #     if it has already been completed. The server will guarantee that for at
                #     least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and
                #     the request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/security/private_ca/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest.new
                #
                #   # Call the update_certificate_template method.
                #   result = client.update_certificate_template request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def update_certificate_template request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Security::PrivateCA::V1::UpdateCertificateTemplateRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_certificate_template.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Security::PrivateCA::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_certificate_template.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_certificate_template.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @certificate_authority_service_stub.update_certificate_template request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the CertificateAuthorityService REST API.
                #
                # This class represents the configuration for CertificateAuthorityService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_certificate to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_certificate.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Security::PrivateCA::V1::CertificateAuthorityService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_certificate.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "privateca.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the CertificateAuthorityService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_certificate`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_certificate
                    ##
                    # RPC-specific configuration for `get_certificate`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_certificate
                    ##
                    # RPC-specific configuration for `list_certificates`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_certificates
                    ##
                    # RPC-specific configuration for `revoke_certificate`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :revoke_certificate
                    ##
                    # RPC-specific configuration for `update_certificate`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_certificate
                    ##
                    # RPC-specific configuration for `activate_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :activate_certificate_authority
                    ##
                    # RPC-specific configuration for `create_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_certificate_authority
                    ##
                    # RPC-specific configuration for `disable_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :disable_certificate_authority
                    ##
                    # RPC-specific configuration for `enable_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :enable_certificate_authority
                    ##
                    # RPC-specific configuration for `fetch_certificate_authority_csr`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :fetch_certificate_authority_csr
                    ##
                    # RPC-specific configuration for `get_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_certificate_authority
                    ##
                    # RPC-specific configuration for `list_certificate_authorities`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_certificate_authorities
                    ##
                    # RPC-specific configuration for `undelete_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :undelete_certificate_authority
                    ##
                    # RPC-specific configuration for `delete_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_certificate_authority
                    ##
                    # RPC-specific configuration for `update_certificate_authority`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_certificate_authority
                    ##
                    # RPC-specific configuration for `create_ca_pool`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_ca_pool
                    ##
                    # RPC-specific configuration for `update_ca_pool`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_ca_pool
                    ##
                    # RPC-specific configuration for `get_ca_pool`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_ca_pool
                    ##
                    # RPC-specific configuration for `list_ca_pools`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_ca_pools
                    ##
                    # RPC-specific configuration for `delete_ca_pool`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_ca_pool
                    ##
                    # RPC-specific configuration for `fetch_ca_certs`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :fetch_ca_certs
                    ##
                    # RPC-specific configuration for `get_certificate_revocation_list`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_certificate_revocation_list
                    ##
                    # RPC-specific configuration for `list_certificate_revocation_lists`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_certificate_revocation_lists
                    ##
                    # RPC-specific configuration for `update_certificate_revocation_list`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_certificate_revocation_list
                    ##
                    # RPC-specific configuration for `create_certificate_template`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_certificate_template
                    ##
                    # RPC-specific configuration for `delete_certificate_template`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_certificate_template
                    ##
                    # RPC-specific configuration for `get_certificate_template`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_certificate_template
                    ##
                    # RPC-specific configuration for `list_certificate_templates`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_certificate_templates
                    ##
                    # RPC-specific configuration for `update_certificate_template`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_certificate_template

                    # @private
                    def initialize parent_rpcs = nil
                      create_certificate_config = parent_rpcs.create_certificate if parent_rpcs.respond_to? :create_certificate
                      @create_certificate = ::Gapic::Config::Method.new create_certificate_config
                      get_certificate_config = parent_rpcs.get_certificate if parent_rpcs.respond_to? :get_certificate
                      @get_certificate = ::Gapic::Config::Method.new get_certificate_config
                      list_certificates_config = parent_rpcs.list_certificates if parent_rpcs.respond_to? :list_certificates
                      @list_certificates = ::Gapic::Config::Method.new list_certificates_config
                      revoke_certificate_config = parent_rpcs.revoke_certificate if parent_rpcs.respond_to? :revoke_certificate
                      @revoke_certificate = ::Gapic::Config::Method.new revoke_certificate_config
                      update_certificate_config = parent_rpcs.update_certificate if parent_rpcs.respond_to? :update_certificate
                      @update_certificate = ::Gapic::Config::Method.new update_certificate_config
                      activate_certificate_authority_config = parent_rpcs.activate_certificate_authority if parent_rpcs.respond_to? :activate_certificate_authority
                      @activate_certificate_authority = ::Gapic::Config::Method.new activate_certificate_authority_config
                      create_certificate_authority_config = parent_rpcs.create_certificate_authority if parent_rpcs.respond_to? :create_certificate_authority
                      @create_certificate_authority = ::Gapic::Config::Method.new create_certificate_authority_config
                      disable_certificate_authority_config = parent_rpcs.disable_certificate_authority if parent_rpcs.respond_to? :disable_certificate_authority
                      @disable_certificate_authority = ::Gapic::Config::Method.new disable_certificate_authority_config
                      enable_certificate_authority_config = parent_rpcs.enable_certificate_authority if parent_rpcs.respond_to? :enable_certificate_authority
                      @enable_certificate_authority = ::Gapic::Config::Method.new enable_certificate_authority_config
                      fetch_certificate_authority_csr_config = parent_rpcs.fetch_certificate_authority_csr if parent_rpcs.respond_to? :fetch_certificate_authority_csr
                      @fetch_certificate_authority_csr = ::Gapic::Config::Method.new fetch_certificate_authority_csr_config
                      get_certificate_authority_config = parent_rpcs.get_certificate_authority if parent_rpcs.respond_to? :get_certificate_authority
                      @get_certificate_authority = ::Gapic::Config::Method.new get_certificate_authority_config
                      list_certificate_authorities_config = parent_rpcs.list_certificate_authorities if parent_rpcs.respond_to? :list_certificate_authorities
                      @list_certificate_authorities = ::Gapic::Config::Method.new list_certificate_authorities_config
                      undelete_certificate_authority_config = parent_rpcs.undelete_certificate_authority if parent_rpcs.respond_to? :undelete_certificate_authority
                      @undelete_certificate_authority = ::Gapic::Config::Method.new undelete_certificate_authority_config
                      delete_certificate_authority_config = parent_rpcs.delete_certificate_authority if parent_rpcs.respond_to? :delete_certificate_authority
                      @delete_certificate_authority = ::Gapic::Config::Method.new delete_certificate_authority_config
                      update_certificate_authority_config = parent_rpcs.update_certificate_authority if parent_rpcs.respond_to? :update_certificate_authority
                      @update_certificate_authority = ::Gapic::Config::Method.new update_certificate_authority_config
                      create_ca_pool_config = parent_rpcs.create_ca_pool if parent_rpcs.respond_to? :create_ca_pool
                      @create_ca_pool = ::Gapic::Config::Method.new create_ca_pool_config
                      update_ca_pool_config = parent_rpcs.update_ca_pool if parent_rpcs.respond_to? :update_ca_pool
                      @update_ca_pool = ::Gapic::Config::Method.new update_ca_pool_config
                      get_ca_pool_config = parent_rpcs.get_ca_pool if parent_rpcs.respond_to? :get_ca_pool
                      @get_ca_pool = ::Gapic::Config::Method.new get_ca_pool_config
                      list_ca_pools_config = parent_rpcs.list_ca_pools if parent_rpcs.respond_to? :list_ca_pools
                      @list_ca_pools = ::Gapic::Config::Method.new list_ca_pools_config
                      delete_ca_pool_config = parent_rpcs.delete_ca_pool if parent_rpcs.respond_to? :delete_ca_pool
                      @delete_ca_pool = ::Gapic::Config::Method.new delete_ca_pool_config
                      fetch_ca_certs_config = parent_rpcs.fetch_ca_certs if parent_rpcs.respond_to? :fetch_ca_certs
                      @fetch_ca_certs = ::Gapic::Config::Method.new fetch_ca_certs_config
                      get_certificate_revocation_list_config = parent_rpcs.get_certificate_revocation_list if parent_rpcs.respond_to? :get_certificate_revocation_list
                      @get_certificate_revocation_list = ::Gapic::Config::Method.new get_certificate_revocation_list_config
                      list_certificate_revocation_lists_config = parent_rpcs.list_certificate_revocation_lists if parent_rpcs.respond_to? :list_certificate_revocation_lists
                      @list_certificate_revocation_lists = ::Gapic::Config::Method.new list_certificate_revocation_lists_config
                      update_certificate_revocation_list_config = parent_rpcs.update_certificate_revocation_list if parent_rpcs.respond_to? :update_certificate_revocation_list
                      @update_certificate_revocation_list = ::Gapic::Config::Method.new update_certificate_revocation_list_config
                      create_certificate_template_config = parent_rpcs.create_certificate_template if parent_rpcs.respond_to? :create_certificate_template
                      @create_certificate_template = ::Gapic::Config::Method.new create_certificate_template_config
                      delete_certificate_template_config = parent_rpcs.delete_certificate_template if parent_rpcs.respond_to? :delete_certificate_template
                      @delete_certificate_template = ::Gapic::Config::Method.new delete_certificate_template_config
                      get_certificate_template_config = parent_rpcs.get_certificate_template if parent_rpcs.respond_to? :get_certificate_template
                      @get_certificate_template = ::Gapic::Config::Method.new get_certificate_template_config
                      list_certificate_templates_config = parent_rpcs.list_certificate_templates if parent_rpcs.respond_to? :list_certificate_templates
                      @list_certificate_templates = ::Gapic::Config::Method.new list_certificate_templates_config
                      update_certificate_template_config = parent_rpcs.update_certificate_template if parent_rpcs.respond_to? :update_certificate_template
                      @update_certificate_template = ::Gapic::Config::Method.new update_certificate_template_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
