# Changelog

### 2.4.1 (2025-10-27)

#### Documentation

* add warning about loading unvalidated credentials 

### 2.4.0 (2025-10-08)

#### Features

* add ListOperations partial success flag ([#31581](https://github.com/googleapis/google-cloud-ruby/issues/31581)) 
* add ListOperations unreachable resources 

### 2.3.0 (2025-09-11)

#### Features

* update gapic-common dependency for generated libraries to 1.2 which requires google-protobuf v4.26+ ([#31011](https://github.com/googleapis/google-cloud-ruby/issues/31011)) 

### 2.2.0 (2025-07-15)

#### Features

* Support for backdating certificates 
* Support for the relative distinguished names 
* Support for the TBS Certificate digest 
* Support for user-defined URLs for certificate authorities 

### 2.1.0 (2025-05-12)

#### Features

* Updated core dependencies including gapic-common 
* Updated required Ruby version to 3.1 

### 2.0.1 (2025-04-29)

#### Bug Fixes

* Fixed several issues with validating credential configs 

### 2.0.0 (2025-02-07)

### ⚠ BREAKING CHANGES

* Fixed incorrect pagination on certain REST RPC methods ([#28826](https://github.com/googleapis/google-cloud-ruby/issues/28826))

#### Bug Fixes

* Fixed incorrect pagination on certain REST RPC methods ([#28826](https://github.com/googleapis/google-cloud-ruby/issues/28826)) 

### 1.2.0 (2025-01-28)

#### Features

* Update Ruby version requirement to 3.0 
#### Documentation

* Clarify behavior of protobuf message fields that are part of mutually-exclusive sets 
* Include note about validating externally-provided credentials 

### 1.1.0 (2024-12-10)

#### Features

* Provide opt-in debug logging 

### 1.0.1 (2024-08-30)

#### Documentation

* Add field `experimental_features` to message `PythonSettings` ([#27012](https://github.com/googleapis/google-cloud-ruby/issues/27012)) 

### 1.0.0 (2024-07-10)

#### Features

* Bump version to 1.0.0 

### 0.13.0 (2024-04-19)

#### Features

* Support encoding format in CaPool resource ([#25465](https://github.com/googleapis/google-cloud-ruby/issues/25465)) 

### 0.12.0 (2024-03-18)

#### Features

* Add support for fine-grained maximum certificate lifetime controls ([#25372](https://github.com/googleapis/google-cloud-ruby/issues/25372)) 
#### Documentation

* Improve documentation ([#25372](https://github.com/googleapis/google-cloud-ruby/issues/25372)) 

### 0.11.0 (2024-02-26)

#### Features

* Updated minimum Ruby version to 2.7 ([#24876](https://github.com/googleapis/google-cloud-ruby/issues/24876)) 

### 0.10.2 (2024-02-01)

#### Bug Fixes

* Eliminated a harmless but annoying warning in the protobuf class files 

### 0.10.1 (2024-01-12)

#### Bug Fixes

* Ensure endpoints are correct for mixin clients ([#24032](https://github.com/googleapis/google-cloud-ruby/issues/24032)) 

### 0.10.0 (2024-01-11)

#### Features

* Support for universe_domain ([#23785](https://github.com/googleapis/google-cloud-ruby/issues/23785)) 

### 0.9.0 (2023-09-12)

#### Features

* Support for channel pool configuration ([#22923](https://github.com/googleapis/google-cloud-ruby/issues/22923)) 

### 0.8.1 (2023-06-06)

#### Bug Fixes

* Don't use self-signed JWT credentials if the global configuration endpoint has been modified 

### 0.8.0 (2023-05-31)

#### Features

* Uses binary protobuf definitions for better forward compatibility ([#21678](https://github.com/googleapis/google-cloud-ruby/issues/21678)) 

### 0.7.0 (2023-04-10)

#### Features

* added ignore_dependent_resources to DeleteCaPoolRequest, DeleteCertificateAuthorityRequest, DisableCertificateAuthorityRequest ([#21052](https://github.com/googleapis/google-cloud-ruby/issues/21052)) 

### 0.6.0 (2023-03-08)

#### Features

* Support REST transport ([#20628](https://github.com/googleapis/google-cloud-ruby/issues/20628)) 

### 0.5.0 (2023-02-14)

#### Features

* Support for X.509 name constraints ([#20406](https://github.com/googleapis/google-cloud-ruby/issues/20406)) 

### 0.4.0 (2022-07-07)

#### Features

* Updated minimum Ruby version to 2.6 ([#18443](https://github.com/googleapis/google-cloud-ruby/issues/18443)) 
#### Bug Fixes

* Fixed a crash when making certain long-running-operations status calls ([#18441](https://github.com/googleapis/google-cloud-ruby/issues/18441)) 

### 0.3.0 (2022-05-13)

#### Features

* Provide interfaces for location and IAM policy calls

### 0.2.1 (2022-04-20)

#### Bug Fixes

* Update grpc-google-iam-v1 dependency to 1.1

### 0.2.0 / 2022-03-24

#### Features

* Support to skip grace period to delete Certificate Authority

### 0.1.6 / 2022-02-15

#### Bug Fixes

* Set quota project on long-running operations calls

### 0.1.5 / 2022-01-11

#### Documentation

* Fix titles of documentation pages
* Remove some broken images and fix outdated content in authentication documentation

### 0.1.4 / 2021-11-08

#### Documentation

* Added simple code snippets to RPC method documentation

### 0.1.3 / 2021-08-11

#### Bug Fixes

* Honor client-level timeout configuration

### 0.1.2 / 2021-07-21

#### Documentation

* Various corrections to data type field documentation

### 0.1.1 / 2021-07-12

#### Documentation

* Clarify some language around authentication configuration

### 0.1.0 / 2021-06-21

#### Features

* Initial generation of google-cloud-security-private_ca-v1
