# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/securesourcemanager/v1/secure_source_manager_pb"
require "google/cloud/secure_source_manager/v1/secure_source_manager"

class ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_create_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"

    create_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_instance, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Instance), request["instance"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_instance_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_instance ::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_instance(::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_instance_client_stub.call_rpc_count
    end
  end

  def test_delete_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_instance, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_instance_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_instance({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_instance name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_instance ::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_instance({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_instance(::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_instance_client_stub.call_rpc_count
    end
  end

  def test_list_repositories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    instance = "hello world"

    list_repositories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_repositories, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["instance"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_repositories_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_repositories parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_repositories ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_repositories(::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_repositories_client_stub.call_rpc_count
    end
  end

  def test_get_repository
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::Repository.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_repository, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_repository_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_repository({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_repository name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_repository ::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_repository({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_repository(::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_repository_client_stub.call_rpc_count
    end
  end

  def test_create_repository
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository = {}
    repository_id = "hello world"

    create_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_repository, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Repository), request["repository"]
      assert_equal "hello world", request["repository_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_repository_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_repository parent: parent, repository: repository, repository_id: repository_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_repository ::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_repository(::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_repository_client_stub.call_rpc_count
    end
  end

  def test_update_repository
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    repository = {}
    validate_only = true

    update_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_repository, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Repository), request["repository"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_repository_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_repository({ update_mask: update_mask, repository: repository, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_repository update_mask: update_mask, repository: repository, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_repository ::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_repository({ update_mask: update_mask, repository: repository, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_repository(::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_repository_client_stub.call_rpc_count
    end
  end

  def test_delete_repository
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_repository, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_repository_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_repository({ name: name, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_repository name: name, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_repository ::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest.new(name: name, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_repository({ name: name, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_repository(::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest.new(name: name, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_repository_client_stub.call_rpc_count
    end
  end

  def test_list_hooks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListHooksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hooks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hooks, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListHooksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hooks_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hooks({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hooks parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hooks ::Google::Cloud::SecureSourceManager::V1::ListHooksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hooks({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hooks(::Google::Cloud::SecureSourceManager::V1::ListHooksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hooks_client_stub.call_rpc_count
    end
  end

  def test_get_hook
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::Hook.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hook_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hook, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetHookRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hook_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hook({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hook name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hook ::Google::Cloud::SecureSourceManager::V1::GetHookRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hook({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hook(::Google::Cloud::SecureSourceManager::V1::GetHookRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hook_client_stub.call_rpc_count
    end
  end

  def test_create_hook
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hook = {}
    hook_id = "hello world"

    create_hook_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hook, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateHookRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Hook), request["hook"]
      assert_equal "hello world", request["hook_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hook_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hook({ parent: parent, hook: hook, hook_id: hook_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hook parent: parent, hook: hook, hook_id: hook_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hook ::Google::Cloud::SecureSourceManager::V1::CreateHookRequest.new(parent: parent, hook: hook, hook_id: hook_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hook({ parent: parent, hook: hook, hook_id: hook_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hook(::Google::Cloud::SecureSourceManager::V1::CreateHookRequest.new(parent: parent, hook: hook, hook_id: hook_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hook_client_stub.call_rpc_count
    end
  end

  def test_update_hook
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hook = {}

    update_hook_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_hook, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Hook), request["hook"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_hook_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_hook({ update_mask: update_mask, hook: hook }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_hook update_mask: update_mask, hook: hook do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_hook ::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest.new(update_mask: update_mask, hook: hook) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_hook({ update_mask: update_mask, hook: hook }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_hook(::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest.new(update_mask: update_mask, hook: hook), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_hook_client_stub.call_rpc_count
    end
  end

  def test_delete_hook
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_hook_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_hook, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_hook_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_hook({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_hook name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_hook ::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_hook({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_hook(::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_hook_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy_repo
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_repo_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy_repo, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_repo_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy_repo({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy_repo resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy_repo ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy_repo({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy_repo(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_repo_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy_repo
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_repo_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy_repo, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_repo_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy_repo({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy_repo resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy_repo ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy_repo({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy_repo(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_repo_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions_repo
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_repo_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions_repo, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_repo_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions_repo({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions_repo resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions_repo ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions_repo({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions_repo(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_repo_client_stub.call_rpc_count
    end
  end

  def test_create_branch_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    branch_rule = {}
    branch_rule_id = "hello world"

    create_branch_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_branch_rule, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::BranchRule), request["branch_rule"]
      assert_equal "hello world", request["branch_rule_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_branch_rule_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_branch_rule({ parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_branch_rule parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_branch_rule ::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest.new(parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_branch_rule({ parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_branch_rule(::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest.new(parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_branch_rule_client_stub.call_rpc_count
    end
  end

  def test_list_branch_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_branch_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_branch_rules, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_branch_rules_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_branch_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_branch_rules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_branch_rules ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_branch_rules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_branch_rules(::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_branch_rules_client_stub.call_rpc_count
    end
  end

  def test_get_branch_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::BranchRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_branch_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_branch_rule, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_branch_rule_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_branch_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_branch_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_branch_rule ::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_branch_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_branch_rule(::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_branch_rule_client_stub.call_rpc_count
    end
  end

  def test_update_branch_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    branch_rule = {}
    validate_only = true
    update_mask = {}

    update_branch_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_branch_rule, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::BranchRule), request["branch_rule"]
      assert_equal true, request["validate_only"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_branch_rule_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_branch_rule({ branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_branch_rule branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_branch_rule ::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest.new(branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_branch_rule({ branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_branch_rule(::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest.new(branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_branch_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_branch_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_branch_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_branch_rule, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_branch_rule_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_branch_rule({ name: name, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_branch_rule name: name, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_branch_rule ::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest.new(name: name, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_branch_rule({ name: name, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_branch_rule(::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest.new(name: name, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_branch_rule_client_stub.call_rpc_count
    end
  end

  def test_create_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pull_request = {}

    create_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::PullRequest), request["pull_request"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_pull_request({ parent: parent, pull_request: pull_request }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_pull_request parent: parent, pull_request: pull_request do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_pull_request ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest.new(parent: parent, pull_request: pull_request) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_pull_request({ parent: parent, pull_request: pull_request }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_pull_request(::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest.new(parent: parent, pull_request: pull_request), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_pull_request_client_stub.call_rpc_count
    end
  end

  def test_get_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::PullRequest.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_pull_request({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_pull_request name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_pull_request ::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_pull_request({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_pull_request(::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_pull_request_client_stub.call_rpc_count
    end
  end

  def test_list_pull_requests
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_requests_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_pull_requests, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_pull_requests_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_pull_requests({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_pull_requests parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_pull_requests ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_pull_requests({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_pull_requests(::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_pull_requests_client_stub.call_rpc_count
    end
  end

  def test_update_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    pull_request = {}
    update_mask = {}

    update_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::PullRequest), request["pull_request"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_pull_request({ pull_request: pull_request, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_pull_request pull_request: pull_request, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_pull_request ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest.new(pull_request: pull_request, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_pull_request({ pull_request: pull_request, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_pull_request(::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest.new(pull_request: pull_request, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_pull_request_client_stub.call_rpc_count
    end
  end

  def test_merge_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    merge_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :merge_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, merge_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.merge_pull_request({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.merge_pull_request name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.merge_pull_request ::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.merge_pull_request({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.merge_pull_request(::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, merge_pull_request_client_stub.call_rpc_count
    end
  end

  def test_open_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    open_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :open_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, open_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.open_pull_request({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.open_pull_request name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.open_pull_request ::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.open_pull_request({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.open_pull_request(::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, open_pull_request_client_stub.call_rpc_count
    end
  end

  def test_close_pull_request
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    close_pull_request_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :close_pull_request, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, close_pull_request_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.close_pull_request({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.close_pull_request name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.close_pull_request ::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.close_pull_request({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.close_pull_request(::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, close_pull_request_client_stub.call_rpc_count
    end
  end

  def test_list_pull_request_file_diffs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_request_file_diffs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_pull_request_file_diffs, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_pull_request_file_diffs_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_pull_request_file_diffs({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_pull_request_file_diffs name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_pull_request_file_diffs ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_pull_request_file_diffs({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_pull_request_file_diffs(::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_pull_request_file_diffs_client_stub.call_rpc_count
    end
  end

  def test_fetch_tree
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::FetchTreeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    repository = "hello world"
    ref = "hello world"
    recursive = true
    page_size = 42
    page_token = "hello world"

    fetch_tree_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_tree, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest, request
      assert_equal "hello world", request["repository"]
      assert_equal "hello world", request["ref"]
      assert_equal true, request["recursive"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_tree_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_tree({ repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_tree repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_tree ::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest.new(repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_tree({ repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_tree(::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest.new(repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_tree_client_stub.call_rpc_count
    end
  end

  def test_fetch_blob
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::FetchBlobResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    repository = "hello world"
    sha = "hello world"

    fetch_blob_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_blob, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest, request
      assert_equal "hello world", request["repository"]
      assert_equal "hello world", request["sha"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_blob_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_blob({ repository: repository, sha: sha }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_blob repository: repository, sha: sha do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_blob ::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest.new(repository: repository, sha: sha) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_blob({ repository: repository, sha: sha }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_blob(::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest.new(repository: repository, sha: sha), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_blob_client_stub.call_rpc_count
    end
  end

  def test_create_issue
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue = {}

    create_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Issue), request["issue"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_issue({ parent: parent, issue: issue }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_issue parent: parent, issue: issue do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_issue ::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest.new(parent: parent, issue: issue) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_issue({ parent: parent, issue: issue }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_issue(::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest.new(parent: parent, issue: issue), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_issue_client_stub.call_rpc_count
    end
  end

  def test_get_issue
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::Issue.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetIssueRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_issue({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_issue name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_issue ::Google::Cloud::SecureSourceManager::V1::GetIssueRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_issue({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_issue(::Google::Cloud::SecureSourceManager::V1::GetIssueRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_issue_client_stub.call_rpc_count
    end
  end

  def test_list_issues
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListIssuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_issues_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_issues, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_issues_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_issues({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_issues parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_issues ::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_issues({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_issues(::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_issues_client_stub.call_rpc_count
    end
  end

  def test_update_issue
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    issue = {}
    update_mask = {}

    update_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::Issue), request["issue"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_issue({ issue: issue, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_issue issue: issue, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_issue ::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_issue({ issue: issue, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_issue(::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_issue_client_stub.call_rpc_count
    end
  end

  def test_delete_issue
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_issue({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_issue name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_issue ::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_issue({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_issue(::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_issue_client_stub.call_rpc_count
    end
  end

  def test_open_issue
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    open_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :open_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, open_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.open_issue({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.open_issue name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.open_issue ::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.open_issue({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.open_issue(::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, open_issue_client_stub.call_rpc_count
    end
  end

  def test_close_issue
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    close_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :close_issue, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, close_issue_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.close_issue({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.close_issue name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.close_issue ::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.close_issue({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.close_issue(::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, close_issue_client_stub.call_rpc_count
    end
  end

  def test_get_pull_request_comment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::PullRequestComment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pull_request_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_pull_request_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_pull_request_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_pull_request_comment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_pull_request_comment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_pull_request_comment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_pull_request_comment_client_stub.call_rpc_count
    end
  end

  def test_list_pull_request_comments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_request_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_pull_request_comments, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_pull_request_comments_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_pull_request_comments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_pull_request_comments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_pull_request_comments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_pull_request_comments_client_stub.call_rpc_count
    end
  end

  def test_create_pull_request_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pull_request_comment = {}

    create_pull_request_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_pull_request_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::PullRequestComment), request["pull_request_comment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_pull_request_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_pull_request_comment({ parent: parent, pull_request_comment: pull_request_comment }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_pull_request_comment parent: parent, pull_request_comment: pull_request_comment do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest.new(parent: parent, pull_request_comment: pull_request_comment) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_pull_request_comment({ parent: parent, pull_request_comment: pull_request_comment }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest.new(parent: parent, pull_request_comment: pull_request_comment), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_pull_request_comment_client_stub.call_rpc_count
    end
  end

  def test_update_pull_request_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    pull_request_comment = {}
    update_mask = {}

    update_pull_request_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_pull_request_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::PullRequestComment), request["pull_request_comment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_pull_request_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_pull_request_comment({ pull_request_comment: pull_request_comment, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_pull_request_comment pull_request_comment: pull_request_comment, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest.new(pull_request_comment: pull_request_comment, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_pull_request_comment({ pull_request_comment: pull_request_comment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest.new(pull_request_comment: pull_request_comment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_pull_request_comment_client_stub.call_rpc_count
    end
  end

  def test_delete_pull_request_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_pull_request_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_pull_request_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_pull_request_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_pull_request_comment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_pull_request_comment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_pull_request_comment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_pull_request_comment_client_stub.call_rpc_count
    end
  end

  def test_batch_create_pull_request_comments
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_pull_request_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_pull_request_comments, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_pull_request_comments_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_pull_request_comments({ parent: parent, requests: requests }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_pull_request_comments parent: parent, requests: requests do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_pull_request_comments({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_pull_request_comments_client_stub.call_rpc_count
    end
  end

  def test_resolve_pull_request_comments
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    auto_fill = true

    resolve_pull_request_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resolve_pull_request_comments, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["names"]
      assert_equal true, request["auto_fill"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resolve_pull_request_comments_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resolve_pull_request_comments parent: parent, names: names, auto_fill: auto_fill do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resolve_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resolve_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resolve_pull_request_comments_client_stub.call_rpc_count
    end
  end

  def test_unresolve_pull_request_comments
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    auto_fill = true

    unresolve_pull_request_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :unresolve_pull_request_comments, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["names"]
      assert_equal true, request["auto_fill"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, unresolve_pull_request_comments_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.unresolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.unresolve_pull_request_comments parent: parent, names: names, auto_fill: auto_fill do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.unresolve_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.unresolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.unresolve_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, unresolve_pull_request_comments_client_stub.call_rpc_count
    end
  end

  def test_create_issue_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue_comment = {}

    create_issue_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_issue_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::IssueComment), request["issue_comment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_issue_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_issue_comment({ parent: parent, issue_comment: issue_comment }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_issue_comment parent: parent, issue_comment: issue_comment do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_issue_comment ::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest.new(parent: parent, issue_comment: issue_comment) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_issue_comment({ parent: parent, issue_comment: issue_comment }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_issue_comment(::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest.new(parent: parent, issue_comment: issue_comment), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_issue_comment_client_stub.call_rpc_count
    end
  end

  def test_get_issue_comment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::IssueComment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_issue_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_issue_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_issue_comment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_issue_comment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_issue_comment ::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_issue_comment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_issue_comment(::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_issue_comment_client_stub.call_rpc_count
    end
  end

  def test_list_issue_comments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_issue_comments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_issue_comments, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_issue_comments_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_issue_comments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_issue_comments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_issue_comments ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_issue_comments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_issue_comments(::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_issue_comments_client_stub.call_rpc_count
    end
  end

  def test_update_issue_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    issue_comment = {}
    update_mask = {}

    update_issue_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_issue_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SecureSourceManager::V1::IssueComment), request["issue_comment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_issue_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_issue_comment({ issue_comment: issue_comment, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_issue_comment issue_comment: issue_comment, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_issue_comment ::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest.new(issue_comment: issue_comment, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_issue_comment({ issue_comment: issue_comment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_issue_comment(::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest.new(issue_comment: issue_comment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_issue_comment_client_stub.call_rpc_count
    end
  end

  def test_delete_issue_comment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_comment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_issue_comment, name
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_issue_comment_client_stub do
      # Create client
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_issue_comment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_issue_comment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_issue_comment ::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_issue_comment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_issue_comment(::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_issue_comment_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Operations, client.operations_client
  end
end
