# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/securesourcemanager/v1/secure_source_manager_pb"
require "google/cloud/secure_source_manager/v1/secure_source_manager/rest"


class ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_create_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}
    request_id = "hello world"

    create_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_instance_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_instance parent: parent, instance_id: instance_id, instance: instance, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_instance ::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_instance(::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_instance_client_stub.call_count
      end
    end
  end

  def test_delete_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_instance_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_instance({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_instance name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_instance ::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_instance({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_instance(::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_instance_client_stub.call_count
      end
    end
  end

  def test_list_repositories
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    instance = "hello world"

    list_repositories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_repositories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_repositories_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_repositories parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_repositories ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_repositories(::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, instance: instance), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_repositories_client_stub.call_count
      end
    end
  end

  def test_get_repository
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_repository_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_repository ::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_repository(::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_repository_client_stub.call_count
      end
    end
  end

  def test_create_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository = {}
    repository_id = "hello world"

    create_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_repository_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_repository parent: parent, repository: repository, repository_id: repository_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_repository ::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_repository(::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_repository_client_stub.call_count
      end
    end
  end

  def test_update_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    repository = {}
    validate_only = true

    update_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_repository_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_repository({ update_mask: update_mask, repository: repository, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_repository update_mask: update_mask, repository: repository, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_repository ::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_repository({ update_mask: update_mask, repository: repository, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_repository(::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_repository_client_stub.call_count
      end
    end
  end

  def test_delete_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_repository_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_repository({ name: name, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_repository name: name, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_repository ::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest.new(name: name, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_repository({ name: name, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_repository(::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest.new(name: name, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_repository_client_stub.call_count
      end
    end
  end

  def test_list_hooks
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListHooksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hooks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_hooks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hooks_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hooks({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hooks parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hooks ::Google::Cloud::SecureSourceManager::V1::ListHooksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hooks({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hooks(::Google::Cloud::SecureSourceManager::V1::ListHooksRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hooks_client_stub.call_count
      end
    end
  end

  def test_get_hook
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::Hook.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hook_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_hook_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hook_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hook({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hook name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hook ::Google::Cloud::SecureSourceManager::V1::GetHookRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hook({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hook(::Google::Cloud::SecureSourceManager::V1::GetHookRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hook_client_stub.call_count
      end
    end
  end

  def test_create_hook
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hook = {}
    hook_id = "hello world"

    create_hook_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_hook_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_hook_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_hook({ parent: parent, hook: hook, hook_id: hook_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_hook parent: parent, hook: hook, hook_id: hook_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_hook ::Google::Cloud::SecureSourceManager::V1::CreateHookRequest.new(parent: parent, hook: hook, hook_id: hook_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_hook({ parent: parent, hook: hook, hook_id: hook_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_hook(::Google::Cloud::SecureSourceManager::V1::CreateHookRequest.new(parent: parent, hook: hook, hook_id: hook_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_hook_client_stub.call_count
      end
    end
  end

  def test_update_hook
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hook = {}

    update_hook_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_hook_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_hook_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_hook({ update_mask: update_mask, hook: hook }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_hook update_mask: update_mask, hook: hook do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_hook ::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest.new(update_mask: update_mask, hook: hook) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_hook({ update_mask: update_mask, hook: hook }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_hook(::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest.new(update_mask: update_mask, hook: hook), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_hook_client_stub.call_count
      end
    end
  end

  def test_delete_hook
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_hook_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_hook_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_hook_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_hook({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_hook name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_hook ::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_hook({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_hook(::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_hook_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy_repo
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_repo_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_iam_policy_repo_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_repo_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy_repo({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy_repo resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy_repo ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy_repo({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy_repo(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_repo_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy_repo
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_repo_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_set_iam_policy_repo_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_repo_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy_repo({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy_repo resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy_repo ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy_repo({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy_repo(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_repo_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions_repo
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_repo_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_test_iam_permissions_repo_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_repo_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions_repo({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions_repo resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions_repo ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions_repo({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions_repo(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_repo_client_stub.call_count
      end
    end
  end

  def test_create_branch_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    branch_rule = {}
    branch_rule_id = "hello world"

    create_branch_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_branch_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_branch_rule_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_branch_rule({ parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_branch_rule parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_branch_rule ::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest.new(parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_branch_rule({ parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_branch_rule(::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest.new(parent: parent, branch_rule: branch_rule, branch_rule_id: branch_rule_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_branch_rule_client_stub.call_count
      end
    end
  end

  def test_list_branch_rules
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_branch_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_branch_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_branch_rules_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_branch_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_branch_rules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_branch_rules ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_branch_rules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_branch_rules(::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_branch_rules_client_stub.call_count
      end
    end
  end

  def test_get_branch_rule
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::BranchRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_branch_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_branch_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_branch_rule_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_branch_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_branch_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_branch_rule ::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_branch_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_branch_rule(::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_branch_rule_client_stub.call_count
      end
    end
  end

  def test_update_branch_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    branch_rule = {}
    validate_only = true
    update_mask = {}

    update_branch_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_branch_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_branch_rule_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_branch_rule({ branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_branch_rule branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_branch_rule ::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest.new(branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_branch_rule({ branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_branch_rule(::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest.new(branch_rule: branch_rule, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_branch_rule_client_stub.call_count
      end
    end
  end

  def test_delete_branch_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_branch_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_branch_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_branch_rule_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_branch_rule({ name: name, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_branch_rule name: name, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_branch_rule ::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest.new(name: name, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_branch_rule({ name: name, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_branch_rule(::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest.new(name: name, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_branch_rule_client_stub.call_count
      end
    end
  end

  def test_create_pull_request
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pull_request = {}

    create_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_pull_request({ parent: parent, pull_request: pull_request }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_pull_request parent: parent, pull_request: pull_request do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_pull_request ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest.new(parent: parent, pull_request: pull_request) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_pull_request({ parent: parent, pull_request: pull_request }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_pull_request(::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest.new(parent: parent, pull_request: pull_request), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_pull_request_client_stub.call_count
      end
    end
  end

  def test_get_pull_request
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::PullRequest.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pull_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pull_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pull_request ::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pull_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pull_request(::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pull_request_client_stub.call_count
      end
    end
  end

  def test_list_pull_requests
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_requests_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_pull_requests_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pull_requests_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pull_requests({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pull_requests parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pull_requests ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pull_requests({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pull_requests(::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pull_requests_client_stub.call_count
      end
    end
  end

  def test_update_pull_request
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    pull_request = {}
    update_mask = {}

    update_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_pull_request({ pull_request: pull_request, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_pull_request pull_request: pull_request, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_pull_request ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest.new(pull_request: pull_request, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_pull_request({ pull_request: pull_request, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_pull_request(::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest.new(pull_request: pull_request, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_pull_request_client_stub.call_count
      end
    end
  end

  def test_merge_pull_request
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    merge_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_merge_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, merge_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.merge_pull_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.merge_pull_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.merge_pull_request ::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.merge_pull_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.merge_pull_request(::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, merge_pull_request_client_stub.call_count
      end
    end
  end

  def test_open_pull_request
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    open_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_open_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, open_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.open_pull_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.open_pull_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.open_pull_request ::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.open_pull_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.open_pull_request(::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, open_pull_request_client_stub.call_count
      end
    end
  end

  def test_close_pull_request
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    close_pull_request_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_close_pull_request_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, close_pull_request_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.close_pull_request({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.close_pull_request name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.close_pull_request ::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.close_pull_request({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.close_pull_request(::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, close_pull_request_client_stub.call_count
      end
    end
  end

  def test_list_pull_request_file_diffs
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_request_file_diffs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_pull_request_file_diffs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pull_request_file_diffs_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pull_request_file_diffs({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pull_request_file_diffs name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pull_request_file_diffs ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pull_request_file_diffs({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pull_request_file_diffs(::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pull_request_file_diffs_client_stub.call_count
      end
    end
  end

  def test_fetch_tree
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::FetchTreeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    repository = "hello world"
    ref = "hello world"
    recursive = true
    page_size = 42
    page_token = "hello world"

    fetch_tree_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_fetch_tree_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_tree_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_tree({ repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_tree repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_tree ::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest.new(repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_tree({ repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_tree(::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest.new(repository: repository, ref: ref, recursive: recursive, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_tree_client_stub.call_count
      end
    end
  end

  def test_fetch_blob
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::FetchBlobResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    repository = "hello world"
    sha = "hello world"

    fetch_blob_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_fetch_blob_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_blob_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_blob({ repository: repository, sha: sha }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_blob repository: repository, sha: sha do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_blob ::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest.new(repository: repository, sha: sha) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_blob({ repository: repository, sha: sha }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_blob(::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest.new(repository: repository, sha: sha), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_blob_client_stub.call_count
      end
    end
  end

  def test_create_issue
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue = {}

    create_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_issue({ parent: parent, issue: issue }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_issue parent: parent, issue: issue do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_issue ::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest.new(parent: parent, issue: issue) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_issue({ parent: parent, issue: issue }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_issue(::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest.new(parent: parent, issue: issue), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_issue_client_stub.call_count
      end
    end
  end

  def test_get_issue
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::Issue.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_issue({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_issue name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_issue ::Google::Cloud::SecureSourceManager::V1::GetIssueRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_issue({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_issue(::Google::Cloud::SecureSourceManager::V1::GetIssueRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_issue_client_stub.call_count
      end
    end
  end

  def test_list_issues
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListIssuesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_issues_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_issues_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_issues_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_issues({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_issues parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_issues ::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_issues({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_issues(::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_issues_client_stub.call_count
      end
    end
  end

  def test_update_issue
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    issue = {}
    update_mask = {}

    update_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_issue({ issue: issue, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_issue issue: issue, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_issue ::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_issue({ issue: issue, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_issue(::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_issue_client_stub.call_count
      end
    end
  end

  def test_delete_issue
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_issue({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_issue name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_issue ::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_issue({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_issue(::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_issue_client_stub.call_count
      end
    end
  end

  def test_open_issue
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    open_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_open_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, open_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.open_issue({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.open_issue name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.open_issue ::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.open_issue({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.open_issue(::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, open_issue_client_stub.call_count
      end
    end
  end

  def test_close_issue
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    close_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_close_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, close_issue_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.close_issue({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.close_issue name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.close_issue ::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.close_issue({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.close_issue(::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, close_issue_client_stub.call_count
      end
    end
  end

  def test_get_pull_request_comment
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::PullRequestComment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pull_request_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_pull_request_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pull_request_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pull_request_comment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pull_request_comment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pull_request_comment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pull_request_comment_client_stub.call_count
      end
    end
  end

  def test_list_pull_request_comments
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_pull_request_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_pull_request_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pull_request_comments_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pull_request_comments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pull_request_comments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pull_request_comments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pull_request_comments_client_stub.call_count
      end
    end
  end

  def test_create_pull_request_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pull_request_comment = {}

    create_pull_request_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_pull_request_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_pull_request_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_pull_request_comment({ parent: parent, pull_request_comment: pull_request_comment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_pull_request_comment parent: parent, pull_request_comment: pull_request_comment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest.new(parent: parent, pull_request_comment: pull_request_comment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_pull_request_comment({ parent: parent, pull_request_comment: pull_request_comment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest.new(parent: parent, pull_request_comment: pull_request_comment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_pull_request_comment_client_stub.call_count
      end
    end
  end

  def test_update_pull_request_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    pull_request_comment = {}
    update_mask = {}

    update_pull_request_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_pull_request_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_pull_request_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_pull_request_comment({ pull_request_comment: pull_request_comment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_pull_request_comment pull_request_comment: pull_request_comment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest.new(pull_request_comment: pull_request_comment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_pull_request_comment({ pull_request_comment: pull_request_comment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest.new(pull_request_comment: pull_request_comment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_pull_request_comment_client_stub.call_count
      end
    end
  end

  def test_delete_pull_request_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_pull_request_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_pull_request_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_pull_request_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_pull_request_comment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_pull_request_comment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_pull_request_comment ::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_pull_request_comment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_pull_request_comment(::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_pull_request_comment_client_stub.call_count
      end
    end
  end

  def test_batch_create_pull_request_comments
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_pull_request_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_batch_create_pull_request_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_pull_request_comments_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_pull_request_comments({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_pull_request_comments parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_pull_request_comments({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_pull_request_comments_client_stub.call_count
      end
    end
  end

  def test_resolve_pull_request_comments
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    auto_fill = true

    resolve_pull_request_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_resolve_pull_request_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resolve_pull_request_comments_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resolve_pull_request_comments parent: parent, names: names, auto_fill: auto_fill do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resolve_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resolve_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resolve_pull_request_comments_client_stub.call_count
      end
    end
  end

  def test_unresolve_pull_request_comments
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    auto_fill = true

    unresolve_pull_request_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_unresolve_pull_request_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unresolve_pull_request_comments_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unresolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unresolve_pull_request_comments parent: parent, names: names, auto_fill: auto_fill do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unresolve_pull_request_comments ::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unresolve_pull_request_comments({ parent: parent, names: names, auto_fill: auto_fill }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unresolve_pull_request_comments(::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest.new(parent: parent, names: names, auto_fill: auto_fill), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unresolve_pull_request_comments_client_stub.call_count
      end
    end
  end

  def test_create_issue_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue_comment = {}

    create_issue_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_create_issue_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_issue_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_issue_comment({ parent: parent, issue_comment: issue_comment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_issue_comment parent: parent, issue_comment: issue_comment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_issue_comment ::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest.new(parent: parent, issue_comment: issue_comment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_issue_comment({ parent: parent, issue_comment: issue_comment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_issue_comment(::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest.new(parent: parent, issue_comment: issue_comment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_issue_comment_client_stub.call_count
      end
    end
  end

  def test_get_issue_comment
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::IssueComment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_get_issue_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_issue_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_issue_comment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_issue_comment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_issue_comment ::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_issue_comment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_issue_comment(::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_issue_comment_client_stub.call_count
      end
    end
  end

  def test_list_issue_comments
    # Create test objects.
    client_result = ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_issue_comments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_list_issue_comments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_issue_comments_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_issue_comments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_issue_comments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_issue_comments ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_issue_comments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_issue_comments(::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_issue_comments_client_stub.call_count
      end
    end
  end

  def test_update_issue_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    issue_comment = {}
    update_mask = {}

    update_issue_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_update_issue_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_issue_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_issue_comment({ issue_comment: issue_comment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_issue_comment issue_comment: issue_comment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_issue_comment ::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest.new(issue_comment: issue_comment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_issue_comment({ issue_comment: issue_comment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_issue_comment(::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest.new(issue_comment: issue_comment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_issue_comment_client_stub.call_count
      end
    end
  end

  def test_delete_issue_comment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_comment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.stub :transcode_delete_issue_comment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_issue_comment_client_stub do
        # Create client
        client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_issue_comment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_issue_comment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_issue_comment ::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_issue_comment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_issue_comment(::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_issue_comment_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client::Configuration, config
  end
end
