# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/secure_source_manager/v1/secure_source_manager"

class ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_branch_rule_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.branch_rule_path project: "value0", location: "value1", repository: "value2", branch_rule: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/branchRules/value3", path
    end
  end

  def test_ca_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.ca_pool_path project: "value0", location: "value1", ca_pool: "value2"
      assert_equal "projects/value0/locations/value1/caPools/value2", path
    end
  end

  def test_crypto_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_path project: "value0", location: "value1", key_ring: "value2", crypto_key: "value3"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3", path
    end
  end

  def test_hook_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.hook_path project: "value0", location: "value1", repository: "value2", hook: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/hooks/value3", path
    end
  end

  def test_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instance_path project: "value0", location: "value1", instance: "value2"
      assert_equal "projects/value0/locations/value1/instances/value2", path
    end
  end

  def test_issue_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.issue_path project: "value0", location: "value1", repository: "value2", issue: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/issues/value3", path
    end
  end

  def test_issue_comment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.issue_comment_path project: "value0", location: "value1", repository: "value2", issue: "value3", comment: "value4"
      assert_equal "projects/value0/locations/value1/repositories/value2/issues/value3/issueComments/value4", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_pull_request_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.pull_request_path project: "value0", location: "value1", repository: "value2", pull_request: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/pullRequests/value3", path
    end
  end

  def test_pull_request_comment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.pull_request_comment_path project: "value0", location: "value1", repository: "value2", pull_request: "value3", comment: "value4"
      assert_equal "projects/value0/locations/value1/repositories/value2/pullRequests/value3/pullRequestComments/value4", path
    end
  end

  def test_repository_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.repository_path project: "value0", location: "value1", repository: "value2"
      assert_equal "projects/value0/locations/value1/repositories/value2", path
    end
  end

  def test_service_attachment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_attachment_path project: "value0", region: "value1", service_attachment: "value2"
      assert_equal "projects/value0/regions/value1/serviceAttachments/value2", path
    end
  end
end
