# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecureSourceManager
      module V1
        # A resource that represents a Secure Source Manager instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. A unique identifier for an instance. The name should be of the
        #     format:
        #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
        #
        #     `project_number`: Maps to a unique int64 id assigned to each project.
        #
        #     `location_id`: Refers to the region where the instance will be deployed.
        #     Since Secure Source Manager is a regional service, it must be one of the
        #     valid GCP regions.
        #
        #     `instance_id`: User provided name for the instance, must be unique for a
        #     project_number and location_id combination.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] private_config
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance::PrivateConfig]
        #     Optional. Private settings for private instance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance::State]
        #     Output only. Current state of the instance.
        # @!attribute [r] state_note
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance::StateNote]
        #     Output only. An optional field providing information about the current
        #     instance state.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Optional. Immutable. Customer-managed encryption key name, in the format
        #     projects/*/locations/*/keyRings/*/cryptoKeys/*.
        # @!attribute [r] host_config
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance::HostConfig]
        #     Output only. A list of hostnames for this instance.
        # @!attribute [rw] workforce_identity_federation_config
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance::WorkforceIdentityFederationConfig]
        #     Optional. Configuration for Workforce Identity Federation to support
        #     third party identity provider. If unset, defaults to the Google OIDC IdP.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # HostConfig has different instance endpoints.
          # @!attribute [r] html
          #   @return [::String]
          #     Output only. HTML hostname.
          # @!attribute [r] api
          #   @return [::String]
          #     Output only. API hostname.
          # @!attribute [r] git_http
          #   @return [::String]
          #     Output only. Git HTTP hostname.
          # @!attribute [r] git_ssh
          #   @return [::String]
          #     Output only. Git SSH hostname.
          class HostConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PrivateConfig includes settings for private instance.
          # @!attribute [rw] is_private
          #   @return [::Boolean]
          #     Required. Immutable. Indicate if it's private instance.
          # @!attribute [rw] ca_pool
          #   @return [::String]
          #     Optional. Immutable. CA pool resource, resource must in the format of
          #     `projects/{project}/locations/{location}/caPools/{ca_pool}`.
          # @!attribute [r] http_service_attachment
          #   @return [::String]
          #     Output only. Service Attachment for HTTP, resource is in the format of
          #     `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
          # @!attribute [r] ssh_service_attachment
          #   @return [::String]
          #     Output only. Service Attachment for SSH, resource is in the format of
          #     `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
          # @!attribute [rw] psc_allowed_projects
          #   @return [::Array<::String>]
          #     Optional. Additional allowed projects for setting up PSC connections.
          #     Instance host project is automatically allowed and does not need to be
          #     included in this list.
          class PrivateConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # WorkforceIdentityFederationConfig allows this instance to support users
          # from external identity providers.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. Immutable. Whether Workforce Identity Federation is enabled.
          class WorkforceIdentityFederationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Secure Source Manager instance state.
          module State
            # Not set. This should only be the case for incoming requests.
            STATE_UNSPECIFIED = 0

            # Instance is being created.
            CREATING = 1

            # Instance is ready.
            ACTIVE = 2

            # Instance is being deleted.
            DELETING = 3

            # Instance is paused.
            PAUSED = 4

            # Instance is unknown, we are not sure if it's functioning.
            UNKNOWN = 6
          end

          # Provides information about the current instance state.
          module StateNote
            # STATE_NOTE_UNSPECIFIED as the first value of State.
            STATE_NOTE_UNSPECIFIED = 0

            # CMEK access is unavailable.
            PAUSED_CMEK_UNAVAILABLE = 1

            # INSTANCE_RESUMING indicates that the instance was previously paused
            # and is under the process of being brought back.
            INSTANCE_RESUMING = 2
          end
        end

        # Metadata of a Secure Source Manager repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. A unique identifier for a repository. The name should be of the
        #     format:
        #     `projects/{project}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the repository, which cannot exceed 500
        #     characters.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Optional. The name of the instance in which the repository is hosted,
        #     formatted as
        #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
        #     When creating repository via securesourcemanager.googleapis.com, this field
        #     is used as input. When creating repository via *.sourcemanager.dev, this
        #     field is output only.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the repository.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] uris
        #   @return [::Google::Cloud::SecureSourceManager::V1::Repository::URIs]
        #     Output only. URIs for the repository.
        # @!attribute [rw] initial_config
        #   @return [::Google::Cloud::SecureSourceManager::V1::Repository::InitialConfig]
        #     Input only. Initial configurations for the repository.
        class Repository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # URIs for the repository.
          # @!attribute [r] html
          #   @return [::String]
          #     Output only. HTML is the URI for user to view the repository in a
          #     browser.
          # @!attribute [r] git_https
          #   @return [::String]
          #     Output only. git_https is the git HTTPS URI for git operations.
          # @!attribute [r] api
          #   @return [::String]
          #     Output only. API is the URI for API access.
          class URIs
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Repository initialization configuration.
          # @!attribute [rw] default_branch
          #   @return [::String]
          #     Default branch name of the repository.
          # @!attribute [rw] gitignores
          #   @return [::Array<::String>]
          #     List of gitignore template names user can choose from.
          #     Valid values: actionscript, ada, agda, android,
          #     anjuta, ansible, appcelerator-titanium, app-engine, archives,
          #     arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
          #     bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
          #     clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
          #     common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
          #     cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
          #     drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
          #     emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
          #     expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
          #     fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
          #     gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
          #     infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
          #     jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
          #     kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
          #     lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
          #     logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
          #     mercurial, mercury, metals, meta-programming-system, meteor,
          #     microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
          #     nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
          #     opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
          #     phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
          #     psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
          #     rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
          #     sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
          #     slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
          #     sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
          #     terraform, tex, text-mate, textpattern, think-php, tortoise-git,
          #     turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
          #     virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
          #     web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
          #     yeoman, yii, zend-framework, zephir.
          # @!attribute [rw] license
          #   @return [::String]
          #     License template name user can choose from.
          #     Valid values: license-0bsd, license-389-exception, aal, abstyles,
          #     adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
          #     afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
          #     agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
          #     antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
          #     apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
          #     artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
          #     autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
          #     bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
          #     bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
          #     bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
          #     bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
          #     bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
          #     bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
          #     bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
          #     bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
          #     bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
          #     catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
          #     cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
          #     cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
          #     cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
          #     cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
          #     cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
          #     cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
          #     cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
          #     cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
          #     cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
          #     classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
          #     cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
          #     copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
          #     crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
          #     digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
          #     ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
          #     epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
          #     eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
          #     font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
          #     freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
          #     gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
          #     gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
          #     gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
          #     gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
          #     gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
          #     gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
          #     gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
          #     gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
          #     giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
          #     gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
          #     gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
          #     gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
          #     hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
          #     i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
          #     info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
          #     jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
          #     lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
          #     lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
          #     libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
          #     liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
          #     linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
          #     lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
          #     mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
          #     mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
          #     mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
          #     mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
          #     naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
          #     nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
          #     nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
          #     ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
          #     odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
          #     ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
          #     ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
          #     oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
          #     oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
          #     openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
          #     opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
          #     o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
          #     plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
          #     postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
          #     python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
          #     qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
          #     ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
          #     sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
          #     sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
          #     spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
          #     swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
          #     tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
          #     unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
          #     universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
          #     w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
          #     wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
          #     xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
          #     zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
          # @!attribute [rw] readme
          #   @return [::String]
          #     README template name.
          #     Valid template name(s) are: default.
          class InitialConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata of a Secure Source Manager Hook.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. A unique identifier for a Hook. The name should be of the
        #     format:
        #     `projects/{project}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`
        # @!attribute [rw] target_uri
        #   @return [::String]
        #     Required. The target URI to which the payloads will be delivered.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. Determines if the hook disabled or not.
        #     Set to true to stop sending traffic.
        # @!attribute [rw] events
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::Hook::HookEventType>]
        #     Optional. The events that trigger hook on.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the hook.
        # @!attribute [rw] push_option
        #   @return [::Google::Cloud::SecureSourceManager::V1::Hook::PushOption]
        #     Optional. The trigger option for push events.
        # @!attribute [rw] sensitive_query_string
        #   @return [::String]
        #     Optional. The sensitive query string to be appended to the target URI.
        class Hook
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] branch_filter
          #   @return [::String]
          #     Optional. Trigger hook for matching branches only.
          #     Specified as glob pattern. If empty or *, events for all branches are
          #     reported. Examples: main, \\{main,release*}.
          #     See https://pkg.go.dev/github.com/gobwas/glob documentation.
          class PushOption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          module HookEventType
            # Unspecified.
            UNSPECIFIED = 0

            # Push events are triggered when pushing to the repository.
            PUSH = 1

            # Pull request events are triggered when a pull request is opened, closed,
            # reopened, or edited.
            PULL_REQUEST = 2
          end
        end

        # Metadata of a BranchRule. BranchRule is the protection rule to enforce
        # pre-defined rules on designated branches within a repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. A unique identifier for a BranchRule. The name should be of the
        #     format:
        #     `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the repository.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user. See https://google.aip.dev/128#annotations for more details such
        #     as format and size limitations.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] include_pattern
        #   @return [::String]
        #     Optional. The pattern of the branch that can match to this BranchRule.
        #     Specified as regex.
        #     .* for all branches. Examples: main, (main|release.*).
        #     Current MVP phase only support `.*` for wildcard.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. Determines if the branch rule is disabled or not.
        # @!attribute [rw] require_pull_request
        #   @return [::Boolean]
        #     Optional. Determines if the branch rule requires a pull request or not.
        # @!attribute [rw] minimum_reviews_count
        #   @return [::Integer]
        #     Optional. The minimum number of reviews required for the branch rule to be
        #     matched.
        # @!attribute [rw] minimum_approvals_count
        #   @return [::Integer]
        #     Optional. The minimum number of approvals required for the branch rule to
        #     be matched.
        # @!attribute [rw] require_comments_resolved
        #   @return [::Boolean]
        #     Optional. Determines if require comments resolved before merging to the
        #     branch.
        # @!attribute [rw] allow_stale_reviews
        #   @return [::Boolean]
        #     Optional. Determines if allow stale reviews or approvals before merging to
        #     the branch.
        # @!attribute [rw] require_linear_history
        #   @return [::Boolean]
        #     Optional. Determines if require linear history before merging to the
        #     branch.
        # @!attribute [rw] required_status_checks
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::BranchRule::Check>]
        #     Optional. List of required status checks before merging to the branch.
        class BranchRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Check is a type for status check.
          # @!attribute [rw] context
          #   @return [::String]
          #     Required. The context of the check.
          class Check
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata of a PullRequest. PullRequest is the request
        # from a user to merge a branch (head) into another branch (base).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. A unique identifier for a PullRequest. The number appended at
        #     the end is generated by the server. Format:
        #     `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request_id}`
        # @!attribute [rw] title
        #   @return [::String]
        #     Required. The pull request title.
        # @!attribute [rw] body
        #   @return [::String]
        #     Optional. The pull request body. Provides a detailed description of the
        #     changes.
        # @!attribute [rw] base
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequest::Branch]
        #     Required. The branch to merge changes in.
        # @!attribute [rw] head
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequest::Branch]
        #     Immutable. The branch containing the changes to be merged.
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequest::State]
        #     Output only. State of the pull request (open, closed or merged).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last updated timestamp.
        # @!attribute [r] close_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Close timestamp (if closed or merged). Cleared when pull
        #     request is re-opened.
        class PullRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Branch represents a branch involved in a pull request.
          # @!attribute [rw] ref
          #   @return [::String]
          #     Required. Name of the branch.
          # @!attribute [r] sha
          #   @return [::String]
          #     Output only. The commit at the tip of the branch.
          class Branch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the pull request.
          module State
            # Unspecified.
            STATE_UNSPECIFIED = 0

            # An open pull request.
            OPEN = 1

            # A closed pull request.
            CLOSED = 2

            # A merged pull request.
            MERGED = 3
          end
        end

        # Metadata of a FileDiff. FileDiff represents a single file diff in a pull
        # request.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the file.
        # @!attribute [r] action
        #   @return [::Google::Cloud::SecureSourceManager::V1::FileDiff::Action]
        #     Output only. The action taken on the file (eg. added, modified, deleted).
        # @!attribute [r] sha
        #   @return [::String]
        #     Output only. The commit pointing to the file changes.
        # @!attribute [r] patch
        #   @return [::String]
        #     Output only. The git patch containing the file changes.
        class FileDiff
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Action taken on the file.
          module Action
            # Unspecified.
            ACTION_UNSPECIFIED = 0

            # The file was added.
            ADDED = 1

            # The file was modified.
            MODIFIED = 2

            # The file was deleted.
            DELETED = 3
          end
        end

        # Metadata of an Issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Unique identifier for an issue. The issue id is generated by
        #     the server. Format:
        #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue_id}`
        # @!attribute [rw] title
        #   @return [::String]
        #     Required. Issue title.
        # @!attribute [rw] body
        #   @return [::String]
        #     Optional. Issue body. Provides a detailed description of the issue.
        # @!attribute [r] state
        #   @return [::Google::Cloud::SecureSourceManager::V1::Issue::State]
        #     Output only. State of the issue.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last updated timestamp.
        # @!attribute [r] close_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Close timestamp (if closed). Cleared when is re-opened.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class Issue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of an issue.
          module State
            # Unspecified.
            STATE_UNSPECIFIED = 0

            # An open issue.
            OPEN = 1

            # A closed issue.
            CLOSED = 2
          end
        end

        # IssueComment represents a comment on an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Unique identifier for an issue comment. The comment id is
        #     generated by the server. Format:
        #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}/issueComments/{comment_id}`
        # @!attribute [rw] body
        #   @return [::String]
        #     Required. The comment body.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last updated timestamp.
        class IssueComment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PullRequestComment represents a comment on a pull request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Unique identifier for the pull request comment. The comment id
        #     is generated by the server. Format:
        #     `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}/pullRequestComments/{comment_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last updated timestamp.
        # @!attribute [rw] review
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment::Review]
        #     Optional. The review summary comment.
        #
        #     Note: The following fields are mutually exclusive: `review`, `comment`, `code`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] comment
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment::Comment]
        #     Optional. The general pull request comment.
        #
        #     Note: The following fields are mutually exclusive: `comment`, `review`, `code`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] code
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment::Code]
        #     Optional. The comment on a code line.
        #
        #     Note: The following fields are mutually exclusive: `code`, `review`, `comment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PullRequestComment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The review summary comment.
          # @!attribute [rw] action_type
          #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment::Review::ActionType]
          #     Required. The review action type.
          # @!attribute [rw] body
          #   @return [::String]
          #     Optional. The comment body.
          # @!attribute [r] effective_commit_sha
          #   @return [::String]
          #     Output only. The effective commit sha this review is pointing to.
          class Review
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The review action type.
            module ActionType
              # Unspecified.
              ACTION_TYPE_UNSPECIFIED = 0

              # A general review comment.
              COMMENT = 1

              # Change required from this review.
              CHANGE_REQUESTED = 2

              # Change approved from this review.
              APPROVED = 3
            end
          end

          # The general pull request comment.
          # @!attribute [rw] body
          #   @return [::String]
          #     Required. The comment body.
          class Comment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The comment on a code line.
          # @!attribute [rw] body
          #   @return [::String]
          #     Required. The comment body.
          # @!attribute [rw] reply
          #   @return [::String]
          #     Optional. Input only. The PullRequestComment resource name that this
          #     comment is replying to.
          # @!attribute [rw] position
          #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment::Position]
          #     Optional. The position of the comment.
          # @!attribute [r] effective_root_comment
          #   @return [::String]
          #     Output only. The root comment of the conversation, derived from the reply
          #     field.
          # @!attribute [r] resolved
          #   @return [::Boolean]
          #     Output only. Boolean indicator if the comment is resolved.
          # @!attribute [r] effective_commit_sha
          #   @return [::String]
          #     Output only. The effective commit sha this code comment is pointing to.
          class Code
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The position of the code comment.
          # @!attribute [rw] path
          #   @return [::String]
          #     Required. The path of the file.
          # @!attribute [rw] line
          #   @return [::Integer]
          #     Required. The line number of the comment. Positive value means it's on
          #     the new side of the diff, negative value means it's on the old side.
          class Position
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # ListInstancesRequest is the request to list instances.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListInstancesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter for filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::Instance>]
        #     The list of instances.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetInstanceRequest is the request for getting an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateInstanceRequest is the request for creating an instance.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. ID of the instance to be created.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::SecureSourceManager::V1::Instance]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteInstanceRequest is the request for deleting an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have {::Google::Longrunning::Operation#error Operation.error} value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListRepositoriesRequest is request to list repositories.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListRepositoriesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter results.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Optional. The name of the instance in which the repository is hosted,
        #     formatted as
        #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
        #     When listing repositories via securesourcemanager.googleapis.com, this
        #     field is required. When listing repositories via *.sourcemanager.dev, this
        #     field is ignored.
        class ListRepositoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] repositories
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::Repository>]
        #     The list of repositories.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListRepositoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetRepositoryRequest is the request for getting a repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the repository to retrieve.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
        class GetRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateRepositoryRequest is the request for creating a repository.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project in which to create the repository. Values are of the
        #     form `projects/{project_number}/locations/{location_id}`
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::SecureSourceManager::V1::Repository]
        #     Required. The resource being created.
        # @!attribute [rw] repository_id
        #   @return [::String]
        #     Required. The ID to use for the repository, which will become the final
        #     component of the repository's resource name. This value should be 4-63
        #     characters, and valid characters are /[a-z][0-9]-/.
        class CreateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateRepositoryRequest is the request to update a repository.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     repository resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::SecureSourceManager::V1::Repository]
        #     Required. The repository being updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. False by default. If set to true, the request is validated and
        #     the user is provided with an expected result, but no actual change is made.
        class UpdateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteRepositoryRequest is the request to delete a repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the repository to delete.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and the repository is not found, the request will
        #     succeed but no action will be taken on the server.
        class DeleteRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListHooksRequest is request to list hooks.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListHooksRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListHooksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListHooksResponse is response to list hooks.
        # @!attribute [rw] hooks
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::Hook>]
        #     The list of hooks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListHooksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetHookRequest is the request for getting a hook.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the hook to retrieve.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`.
        class GetHookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateHookRequest is the request for creating a hook.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the hook. Values are of the
        #     form
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] hook
        #   @return [::Google::Cloud::SecureSourceManager::V1::Hook]
        #     Required. The resource being created.
        # @!attribute [rw] hook_id
        #   @return [::String]
        #     Required. The ID to use for the hook, which will become the final component
        #     of the hook's resource name. This value restricts to lower-case letters,
        #     numbers, and hyphen, with the first character a letter, the last a letter
        #     or a number, and a 63 character maximum.
        class CreateHookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateHookRequest is the request to update a hook.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     hook resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     The special value "*" means full replacement.
        # @!attribute [rw] hook
        #   @return [::Google::Cloud::SecureSourceManager::V1::Hook]
        #     Required. The hook being updated.
        class UpdateHookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteHookRequest is the request to delete a hook.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the hook to delete.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`.
        class DeleteHookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetBranchRuleRequest is the request for getting a branch rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the repository to retrieve.
        #     The format is
        #     `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`.
        class GetBranchRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateBranchRuleRequest is the request to create a branch rule.
        # @!attribute [rw] parent
        #   @return [::String]
        # @!attribute [rw] branch_rule
        #   @return [::Google::Cloud::SecureSourceManager::V1::BranchRule]
        # @!attribute [rw] branch_rule_id
        #   @return [::String]
        class CreateBranchRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBranchRulesRequest is the request to list branch rules.
        # @!attribute [rw] parent
        #   @return [::String]
        # @!attribute [rw] page_size
        #   @return [::Integer]
        # @!attribute [rw] page_token
        #   @return [::String]
        class ListBranchRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteBranchRuleRequest is the request to delete a branch rule.
        # @!attribute [rw] name
        #   @return [::String]
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and the branch rule is not found, the request
        #     will succeed but no action will be taken on the server.
        class DeleteBranchRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateBranchRuleRequest is the request to update a branchRule.
        # @!attribute [rw] branch_rule
        #   @return [::Google::Cloud::SecureSourceManager::V1::BranchRule]
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually post it.  (https://google.aip.dev/163, for declarative friendly)
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     branchRule resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     The special value "*" means full replacement.
        class UpdateBranchRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBranchRulesResponse is the response to listing branchRules.
        # @!attribute [rw] branch_rules
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::BranchRule>]
        #     The list of branch rules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListBranchRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreatePullRequestRequest is the request to create a pull request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository that the pull request is created from. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] pull_request
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequest]
        #     Required. The pull request to create.
        class CreatePullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetPullRequestRequest is the request to get a pull request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the pull request to retrieve.
        #     The format is
        #     `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}`.
        class GetPullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListPullRequestsRequest is the request to list pull requests.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list pull requests. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListPullRequestsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListPullRequestsResponse is the response to list pull requests.
        # @!attribute [rw] pull_requests
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::PullRequest>]
        #     The list of pull requests.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListPullRequestsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdatePullRequestRequest is the request to update a pull request.
        # @!attribute [rw] pull_request
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequest]
        #     Required. The pull request to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     pull request resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     The special value "*" means full replacement.
        class UpdatePullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MergePullRequestRequest is the request to merge a pull request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The pull request to merge.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        class MergePullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OpenPullRequestRequest is the request to open a pull request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The pull request to open.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        class OpenPullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ClosePullRequestRequest is the request to close a pull request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The pull request to close.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        class ClosePullRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListPullRequestFileDiffsRequest is the request to list pull request file
        # diffs.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The pull request to list file diffs for.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListPullRequestFileDiffsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListPullRequestFileDiffsResponse is the response containing file diffs
        # returned from ListPullRequestFileDiffs.
        # @!attribute [rw] file_diffs
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::FileDiff>]
        #     The list of pull request file diffs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListPullRequestFileDiffsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create an issue.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the issue. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] issue
        #   @return [::Google::Cloud::SecureSourceManager::V1::Issue]
        #     Required. The issue to create.
        class CreateIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue to retrieve.
        #     The format is
        #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue_id}`.
        class GetIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list issues.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list issues. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Used to filter the resulting issues list.
        class ListIssuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to list issues.
        # @!attribute [rw] issues
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::Issue>]
        #     The list of issues.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListIssuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update an issue.
        # @!attribute [rw] issue
        #   @return [::Google::Cloud::SecureSourceManager::V1::Issue]
        #     Required. The issue to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     issue resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     The special value "*" means full replacement.
        class UpdateIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue to delete.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the issue.
        #     If the etag is provided and does not match the current etag of the issue,
        #     deletion will be blocked and an ABORTED error will be returned.
        class DeleteIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to close an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue to close.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the issue.
        #     If the etag is provided and does not match the current etag of the issue,
        #     closing will be blocked and an ABORTED error will be returned.
        class CloseIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to open an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue to open.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the issue.
        #     If the etag is provided and does not match the current etag of the issue,
        #     opening will be blocked and an ABORTED error will be returned.
        class OpenIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an entry within a tree structure (like a Git tree).
        # @!attribute [r] type
        #   @return [::Google::Cloud::SecureSourceManager::V1::TreeEntry::ObjectType]
        #     Output only. The type of the object (TREE, BLOB, COMMIT).  Output-only.
        # @!attribute [r] sha
        #   @return [::String]
        #     Output only. The SHA-1 hash of the object (unique identifier). Output-only.
        # @!attribute [r] path
        #   @return [::String]
        #     Output only. The path of the file or directory within the tree (e.g.,
        #     "src/main/java/MyClass.java"). Output-only.
        # @!attribute [r] mode
        #   @return [::String]
        #     Output only. The file mode as a string (e.g., "100644"). Indicates file
        #     type. Output-only.
        # @!attribute [r] size
        #   @return [::Integer]
        #     Output only. The size of the object in bytes (only for blobs). Output-only.
        class TreeEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the type of object the TreeEntry represents.
          module ObjectType
            # Default value, indicating the object type is unspecified.
            OBJECT_TYPE_UNSPECIFIED = 0

            # Represents a directory (folder).
            TREE = 1

            # Represents a file (contains file data).
            BLOB = 2

            # Represents a pointer to another repository (submodule).
            COMMIT = 3
          end
        end

        # Request message for fetching a tree structure from a repository.
        # @!attribute [rw] repository
        #   @return [::String]
        #     Required. The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
        #     Specifies the repository to fetch the tree from.
        # @!attribute [rw] ref
        #   @return [::String]
        #     Optional. `ref` can be a SHA-1 hash, a branch name, or a tag. Specifies
        #     which tree to fetch. If not specified, the default branch will be used.
        # @!attribute [rw] recursive
        #   @return [::Boolean]
        #     Optional. If true, include all subfolders and their files in the response.
        #     If false, only the immediate children are returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size.  Server may return fewer items than
        #     requested. If unspecified, at most 10,000 items will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class FetchTreeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing a list of TreeEntry objects.
        # @!attribute [rw] tree_entries
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::TreeEntry>]
        #     The list of TreeEntry objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class FetchTreeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for fetching a blob (file content) from a repository.
        # @!attribute [rw] repository
        #   @return [::String]
        #     Required. The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
        #     Specifies the repository containing the blob.
        # @!attribute [rw] sha
        #   @return [::String]
        #     Required. The SHA-1 hash of the blob to retrieve.
        class FetchBlobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing the content of a blob.
        # @!attribute [rw] sha
        #   @return [::String]
        #     The SHA-1 hash of the blob.
        # @!attribute [rw] content
        #   @return [::String]
        #     The content of the blob, encoded as base64.
        class FetchBlobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list pull request comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The pull request in which to list pull request comments. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. If unspecified, at most 100 pull request
        #     comments will be returned. The maximum value is 100; values above 100 will
        #     be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListPullRequestCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to list pull request comments.
        # @!attribute [rw] pull_request_comments
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
        #     The list of pull request comments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to set as page_token to retrieve the next page. If this field is
        #     omitted, there are no subsequent pages.
        class ListPullRequestCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a pull request comment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The pull request in which to create the pull request comment.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] pull_request_comment
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment]
        #     Required. The pull request comment to create.
        class CreatePullRequestCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to batch create pull request comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The pull request in which to create the pull request comments.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest>]
        #     Required. The request message specifying the resources to create. There
        #     should be exactly one CreatePullRequestCommentRequest with CommentDetail
        #     being REVIEW in the list, and no more than 100
        #     CreatePullRequestCommentRequests with CommentDetail being CODE in the list
        class BatchCreatePullRequestCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to batch create pull request comments.
        # @!attribute [rw] pull_request_comments
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
        #     The list of pull request comments created.
        class BatchCreatePullRequestCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a pull request comment.
        # @!attribute [rw] pull_request_comment
        #   @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment]
        #     Required. The pull request comment to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     pull request comment resource by the update. Updatable fields are
        #     `body`.
        class UpdatePullRequestCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a pull request comment. A Review PullRequestComment
        # cannot be deleted.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the pull request comment to delete.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`.
        class DeletePullRequestCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get a pull request comment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the pull request comment to retrieve.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`.
        class GetPullRequestCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to resolve multiple pull request comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The pull request in which to resolve the pull request comments.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the pull request comments to resolve. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`
        #     Only comments from the same threads are allowed in the same request.
        # @!attribute [rw] auto_fill
        #   @return [::Boolean]
        #     Optional. If set, at least one comment in a thread is required, rest of the
        #     comments in the same thread will be automatically updated to resolved. If
        #     unset, all comments in the same thread need be present.
        class ResolvePullRequestCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to resolve multiple pull request comments.
        # @!attribute [rw] pull_request_comments
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
        #     The list of pull request comments resolved.
        class ResolvePullRequestCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to unresolve multiple pull request comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The pull request in which to resolve the pull request comments.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names of the pull request comments to unresolve. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`
        #     Only comments from the same threads are allowed in the same request.
        # @!attribute [rw] auto_fill
        #   @return [::Boolean]
        #     Optional. If set, at least one comment in a thread is required, rest of the
        #     comments in the same thread will be automatically updated to unresolved. If
        #     unset, all comments in the same thread need be present.
        class UnresolvePullRequestCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to unresolve multiple pull request comments.
        # @!attribute [rw] pull_request_comments
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
        #     The list of pull request comments unresolved.
        class UnresolvePullRequestCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create an issue comment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The issue in which to create the issue comment. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`
        # @!attribute [rw] issue_comment
        #   @return [::Google::Cloud::SecureSourceManager::V1::IssueComment]
        #     Required. The issue comment to create.
        class CreateIssueCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get an issue comment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue comment to retrieve.
        #     The format is
        #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue_id}/issueComments/{comment_id}`.
        class GetIssueCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list issue comments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The issue in which to list the comments. Format:
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        class ListIssueCommentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to list issue comments.
        # @!attribute [rw] issue_comments
        #   @return [::Array<::Google::Cloud::SecureSourceManager::V1::IssueComment>]
        #     The list of issue comments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListIssueCommentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update an issue comment.
        # @!attribute [rw] issue_comment
        #   @return [::Google::Cloud::SecureSourceManager::V1::IssueComment]
        #     Required. The issue comment to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     issue comment resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     The special value "*" means full replacement.
        class UpdateIssueCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an issue comment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the issue comment to delete.
        #     The format is
        #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}/issueComments/{comment_id}`.
        class DeleteIssueCommentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
