# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/securesourcemanager/v1/secure_source_manager_pb"
require "google/cloud/secure_source_manager/v1/secure_source_manager/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module SecureSourceManager
      module V1
        module SecureSourceManager
          module Rest
            ##
            # REST client for the SecureSourceManager service.
            #
            # Secure Source Manager API
            #
            # Access Secure Source Manager instances, resources, and repositories.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "securesourcemanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :secure_source_manager_stub

              ##
              # Configure the SecureSourceManager Client class.
              #
              # See {::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all SecureSourceManager clients
              #   ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "SecureSourceManager", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_instances.timeout = 60.0
                  default_config.rpcs.list_instances.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_instance.timeout = 60.0
                  default_config.rpcs.get_instance.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_repositories.timeout = 60.0
                  default_config.rpcs.list_repositories.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_repository.timeout = 60.0
                  default_config.rpcs.get_repository.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_iam_policy_repo.timeout = 60.0
                  default_config.rpcs.get_iam_policy_repo.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the SecureSourceManager Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @secure_source_manager_stub.universe_domain
              end

              ##
              # Create a new SecureSourceManager REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the SecureSourceManager client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @secure_source_manager_stub = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @secure_source_manager_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @secure_source_manager_stub.endpoint
                  config.universe_domain = @secure_source_manager_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @secure_source_manager_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @secure_source_manager_stub.endpoint
                  config.universe_domain = @secure_source_manager_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @secure_source_manager_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @secure_source_manager_stub.logger
              end

              # Service calls

              ##
              # Lists Instances in a given project and location.
              #
              # @overload list_instances(request, options = nil)
              #   Pass arguments to `list_instances` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_instances(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListInstancesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filter for filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Instance>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Instance>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListInstancesRequest.new
              #
              #   # Call the list_instances method.
              #   result = client.list_instances request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::Instance.
              #     p item
              #   end
              #
              def list_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_instances request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_instances, "instances", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single instance.
              #
              # @overload get_instance(request, options = nil)
              #   Pass arguments to `get_instance` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_instance(name: nil)
              #   Pass arguments to `get_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetInstanceRequest.new
              #
              #   # Call the get_instance method.
              #   result = client.get_instance request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::Instance.
              #   p result
              #
              def get_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_instance request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new instance in a given project and location.
              #
              # @overload create_instance(request, options = nil)
              #   Pass arguments to `create_instance` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_instance(parent: nil, instance_id: nil, instance: nil, request_id: nil)
              #   Pass arguments to `create_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param instance_id [::String]
              #     Required. ID of the instance to be created.
              #   @param instance [::Google::Cloud::SecureSourceManager::V1::Instance, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest.new
              #
              #   # Call the create_instance method.
              #   result = client.create_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single instance.
              #
              # @overload delete_instance(request, options = nil)
              #   Pass arguments to `delete_instance` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_instance(name: nil, request_id: nil)
              #   Pass arguments to `delete_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest.new
              #
              #   # Call the delete_instance method.
              #   result = client.delete_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Repositories in a given project and location.
              #
              # The instance field is required in the query parameter for requests using
              # the securesourcemanager.googleapis.com endpoint.
              #
              # @overload list_repositories(request, options = nil)
              #   Pass arguments to `list_repositories` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_repositories(parent: nil, page_size: nil, page_token: nil, filter: nil, instance: nil)
              #   Pass arguments to `list_repositories` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListRepositoriesRequest.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filter results.
              #   @param instance [::String]
              #     Optional. The name of the instance in which the repository is hosted,
              #     formatted as
              #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
              #     When listing repositories via securesourcemanager.googleapis.com, this
              #     field is required. When listing repositories via *.sourcemanager.dev, this
              #     field is ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Repository>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Repository>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest.new
              #
              #   # Call the list_repositories method.
              #   result = client.list_repositories request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::Repository.
              #     p item
              #   end
              #
              def list_repositories request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListRepositoriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_repositories.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_repositories.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_repositories.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_repositories request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_repositories, "repositories", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata of a repository.
              #
              # @overload get_repository(request, options = nil)
              #   Pass arguments to `get_repository` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_repository(name: nil)
              #   Pass arguments to `get_repository` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the repository to retrieve.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::Repository]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::Repository]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest.new
              #
              #   # Call the get_repository method.
              #   result = client.get_repository request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::Repository.
              #   p result
              #
              def get_repository request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetRepositoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_repository.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_repository.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_repository.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_repository request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new repository in a given project and location.
              #
              # The Repository.Instance field is required in the request body for requests
              # using the securesourcemanager.googleapis.com endpoint.
              #
              # @overload create_repository(request, options = nil)
              #   Pass arguments to `create_repository` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_repository(parent: nil, repository: nil, repository_id: nil)
              #   Pass arguments to `create_repository` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which to create the repository. Values are of the
              #     form `projects/{project_number}/locations/{location_id}`
              #   @param repository [::Google::Cloud::SecureSourceManager::V1::Repository, ::Hash]
              #     Required. The resource being created.
              #   @param repository_id [::String]
              #     Required. The ID to use for the repository, which will become the final
              #     component of the repository's resource name. This value should be 4-63
              #     characters, and valid characters are /[a-z][0-9]-/.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest.new
              #
              #   # Call the create_repository method.
              #   result = client.create_repository request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_repository request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateRepositoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_repository.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_repository.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_repository.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_repository request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the metadata of a repository.
              #
              # @overload update_repository(request, options = nil)
              #   Pass arguments to `update_repository` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_repository(update_mask: nil, repository: nil, validate_only: nil)
              #   Pass arguments to `update_repository` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     repository resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param repository [::Google::Cloud::SecureSourceManager::V1::Repository, ::Hash]
              #     Required. The repository being updated.
              #   @param validate_only [::Boolean]
              #     Optional. False by default. If set to true, the request is validated and
              #     the user is provided with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest.new
              #
              #   # Call the update_repository method.
              #   result = client.update_repository request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_repository request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdateRepositoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_repository.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_repository.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_repository.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_repository request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Repository.
              #
              # @overload delete_repository(request, options = nil)
              #   Pass arguments to `delete_repository` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_repository(name: nil, allow_missing: nil)
              #   Pass arguments to `delete_repository` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the repository to delete.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, and the repository is not found, the request will
              #     succeed but no action will be taken on the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest.new
              #
              #   # Call the delete_repository method.
              #   result = client.delete_repository request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_repository request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteRepositoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_repository.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_repository.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_repository.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_repository request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists hooks in a given repository.
              #
              # @overload list_hooks(request, options = nil)
              #   Pass arguments to `list_hooks` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListHooksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListHooksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_hooks(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_hooks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListHooksRequest.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Hook>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Hook>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListHooksRequest.new
              #
              #   # Call the list_hooks method.
              #   result = client.list_hooks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::Hook.
              #     p item
              #   end
              #
              def list_hooks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListHooksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_hooks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_hooks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_hooks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_hooks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_hooks, "hooks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets metadata of a hook.
              #
              # @overload get_hook(request, options = nil)
              #   Pass arguments to `get_hook` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetHookRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetHookRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_hook(name: nil)
              #   Pass arguments to `get_hook` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the hook to retrieve.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::Hook]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::Hook]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetHookRequest.new
              #
              #   # Call the get_hook method.
              #   result = client.get_hook request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::Hook.
              #   p result
              #
              def get_hook request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetHookRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_hook.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_hook.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_hook.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_hook request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new hook in a given repository.
              #
              # @overload create_hook(request, options = nil)
              #   Pass arguments to `create_hook` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateHookRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateHookRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_hook(parent: nil, hook: nil, hook_id: nil)
              #   Pass arguments to `create_hook` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The repository in which to create the hook. Values are of the
              #     form
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
              #   @param hook [::Google::Cloud::SecureSourceManager::V1::Hook, ::Hash]
              #     Required. The resource being created.
              #   @param hook_id [::String]
              #     Required. The ID to use for the hook, which will become the final component
              #     of the hook's resource name. This value restricts to lower-case letters,
              #     numbers, and hyphen, with the first character a letter, the last a letter
              #     or a number, and a 63 character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateHookRequest.new
              #
              #   # Call the create_hook method.
              #   result = client.create_hook request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_hook request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateHookRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_hook.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_hook.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_hook.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_hook request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the metadata of a hook.
              #
              # @overload update_hook(request, options = nil)
              #   Pass arguments to `update_hook` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_hook(update_mask: nil, hook: nil)
              #   Pass arguments to `update_hook` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     hook resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     The special value "*" means full replacement.
              #   @param hook [::Google::Cloud::SecureSourceManager::V1::Hook, ::Hash]
              #     Required. The hook being updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdateHookRequest.new
              #
              #   # Call the update_hook method.
              #   result = client.update_hook request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_hook request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdateHookRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_hook.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_hook.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_hook.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_hook request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Hook.
              #
              # @overload delete_hook(request, options = nil)
              #   Pass arguments to `delete_hook` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_hook(name: nil)
              #   Pass arguments to `delete_hook` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the hook to delete.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteHookRequest.new
              #
              #   # Call the delete_hook method.
              #   result = client.delete_hook request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_hook request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteHookRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_hook.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_hook.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_hook.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_hook request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get IAM policy for a repository.
              #
              # @overload get_iam_policy_repo(request, options = nil)
              #   Pass arguments to `get_iam_policy_repo` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy_repo(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy_repo` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy_repo method.
              #   result = client.get_iam_policy_repo request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy_repo request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy_repo.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy_repo.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy_repo.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_iam_policy_repo request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Set IAM policy on a repository.
              #
              # @overload set_iam_policy_repo(request, options = nil)
              #   Pass arguments to `set_iam_policy_repo` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy_repo(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy_repo` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy_repo method.
              #   result = client.set_iam_policy_repo request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy_repo request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy_repo.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy_repo.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy_repo.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.set_iam_policy_repo request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Test IAM permissions on a repository.
              # IAM permission checks are not required on this method.
              #
              # @overload test_iam_permissions_repo(request, options = nil)
              #   Pass arguments to `test_iam_permissions_repo` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions_repo(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions_repo` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions_repo method.
              #   result = client.test_iam_permissions_repo request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions_repo request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions_repo.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions_repo.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions_repo.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.test_iam_permissions_repo request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # CreateBranchRule creates a branch rule in a given repository.
              #
              # @overload create_branch_rule(request, options = nil)
              #   Pass arguments to `create_branch_rule` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_branch_rule(parent: nil, branch_rule: nil, branch_rule_id: nil)
              #   Pass arguments to `create_branch_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #   @param branch_rule [::Google::Cloud::SecureSourceManager::V1::BranchRule, ::Hash]
              #   @param branch_rule_id [::String]
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest.new
              #
              #   # Call the create_branch_rule method.
              #   result = client.create_branch_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_branch_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateBranchRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_branch_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_branch_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_branch_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_branch_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # ListBranchRules lists branch rules in a given repository.
              #
              # @overload list_branch_rules(request, options = nil)
              #   Pass arguments to `list_branch_rules` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_branch_rules(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_branch_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #   @param page_size [::Integer]
              #   @param page_token [::String]
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::BranchRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::BranchRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest.new
              #
              #   # Call the list_branch_rules method.
              #   result = client.list_branch_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::BranchRule.
              #     p item
              #   end
              #
              def list_branch_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListBranchRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_branch_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_branch_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_branch_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_branch_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_branch_rules, "branch_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # GetBranchRule gets a branch rule.
              #
              # @overload get_branch_rule(request, options = nil)
              #   Pass arguments to `get_branch_rule` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_branch_rule(name: nil)
              #   Pass arguments to `get_branch_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the repository to retrieve.
              #     The format is
              #     `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::BranchRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::BranchRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest.new
              #
              #   # Call the get_branch_rule method.
              #   result = client.get_branch_rule request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::BranchRule.
              #   p result
              #
              def get_branch_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetBranchRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_branch_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_branch_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_branch_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_branch_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # UpdateBranchRule updates a branch rule.
              #
              # @overload update_branch_rule(request, options = nil)
              #   Pass arguments to `update_branch_rule` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_branch_rule(branch_rule: nil, validate_only: nil, update_mask: nil)
              #   Pass arguments to `update_branch_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param branch_rule [::Google::Cloud::SecureSourceManager::V1::BranchRule, ::Hash]
              #   @param validate_only [::Boolean]
              #     Optional. If set, validate the request and preview the review, but do not
              #     actually post it.  (https://google.aip.dev/163, for declarative friendly)
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     branchRule resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     The special value "*" means full replacement.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest.new
              #
              #   # Call the update_branch_rule method.
              #   result = client.update_branch_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_branch_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdateBranchRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_branch_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_branch_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_branch_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_branch_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # DeleteBranchRule deletes a branch rule.
              #
              # @overload delete_branch_rule(request, options = nil)
              #   Pass arguments to `delete_branch_rule` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_branch_rule(name: nil, allow_missing: nil)
              #   Pass arguments to `delete_branch_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, and the branch rule is not found, the request
              #     will succeed but no action will be taken on the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest.new
              #
              #   # Call the delete_branch_rule method.
              #   result = client.delete_branch_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_branch_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteBranchRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_branch_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_branch_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_branch_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_branch_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a pull request.
              #
              # @overload create_pull_request(request, options = nil)
              #   Pass arguments to `create_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_pull_request(parent: nil, pull_request: nil)
              #   Pass arguments to `create_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The repository that the pull request is created from. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
              #   @param pull_request [::Google::Cloud::SecureSourceManager::V1::PullRequest, ::Hash]
              #     Required. The pull request to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest.new
              #
              #   # Call the create_pull_request method.
              #   result = client.create_pull_request request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_pull_request request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a pull request.
              #
              # @overload get_pull_request(request, options = nil)
              #   Pass arguments to `get_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_pull_request(name: nil)
              #   Pass arguments to `get_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the pull request to retrieve.
              #     The format is
              #     `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::PullRequest]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::PullRequest]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest.new
              #
              #   # Call the get_pull_request method.
              #   result = client.get_pull_request request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::PullRequest.
              #   p result
              #
              def get_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetPullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_pull_request request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists pull requests in a repository.
              #
              # @overload list_pull_requests(request, options = nil)
              #   Pass arguments to `list_pull_requests` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_pull_requests(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_pull_requests` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The repository in which to list pull requests. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::PullRequest>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::PullRequest>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest.new
              #
              #   # Call the list_pull_requests method.
              #   result = client.list_pull_requests request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::PullRequest.
              #     p item
              #   end
              #
              def list_pull_requests request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListPullRequestsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_pull_requests.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_pull_requests.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_pull_requests.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_pull_requests request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_pull_requests, "pull_requests", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a pull request.
              #
              # @overload update_pull_request(request, options = nil)
              #   Pass arguments to `update_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_pull_request(pull_request: nil, update_mask: nil)
              #   Pass arguments to `update_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param pull_request [::Google::Cloud::SecureSourceManager::V1::PullRequest, ::Hash]
              #     Required. The pull request to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     pull request resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     The special value "*" means full replacement.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest.new
              #
              #   # Call the update_pull_request method.
              #   result = client.update_pull_request request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_pull_request request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Merges a pull request.
              #
              # @overload merge_pull_request(request, options = nil)
              #   Pass arguments to `merge_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload merge_pull_request(name: nil)
              #   Pass arguments to `merge_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The pull request to merge.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest.new
              #
              #   # Call the merge_pull_request method.
              #   result = client.merge_pull_request request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def merge_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::MergePullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.merge_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.merge_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.merge_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.merge_pull_request request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Opens a pull request.
              #
              # @overload open_pull_request(request, options = nil)
              #   Pass arguments to `open_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload open_pull_request(name: nil)
              #   Pass arguments to `open_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The pull request to open.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest.new
              #
              #   # Call the open_pull_request method.
              #   result = client.open_pull_request request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def open_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::OpenPullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.open_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.open_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.open_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.open_pull_request request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Closes a pull request without merging.
              #
              # @overload close_pull_request(request, options = nil)
              #   Pass arguments to `close_pull_request` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload close_pull_request(name: nil)
              #   Pass arguments to `close_pull_request` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The pull request to close.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest.new
              #
              #   # Call the close_pull_request method.
              #   result = client.close_pull_request request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def close_pull_request request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ClosePullRequestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.close_pull_request.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.close_pull_request.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.close_pull_request.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.close_pull_request request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists a pull request's file diffs.
              #
              # @overload list_pull_request_file_diffs(request, options = nil)
              #   Pass arguments to `list_pull_request_file_diffs` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_pull_request_file_diffs(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_pull_request_file_diffs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The pull request to list file diffs for.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::FileDiff>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::FileDiff>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest.new
              #
              #   # Call the list_pull_request_file_diffs method.
              #   result = client.list_pull_request_file_diffs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::FileDiff.
              #     p item
              #   end
              #
              def list_pull_request_file_diffs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListPullRequestFileDiffsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_pull_request_file_diffs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_pull_request_file_diffs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_pull_request_file_diffs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_pull_request_file_diffs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_pull_request_file_diffs, "file_diffs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches a tree from a repository.
              #
              # @overload fetch_tree(request, options = nil)
              #   Pass arguments to `fetch_tree` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_tree(repository: nil, ref: nil, recursive: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_tree` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param repository [::String]
              #     Required. The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
              #     Specifies the repository to fetch the tree from.
              #   @param ref [::String]
              #     Optional. `ref` can be a SHA-1 hash, a branch name, or a tag. Specifies
              #     which tree to fetch. If not specified, the default branch will be used.
              #   @param recursive [::Boolean]
              #     Optional. If true, include all subfolders and their files in the response.
              #     If false, only the immediate children are returned.
              #   @param page_size [::Integer]
              #     Optional. Requested page size.  Server may return fewer items than
              #     requested. If unspecified, at most 10,000 items will be returned.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::TreeEntry>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::TreeEntry>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::FetchTreeRequest.new
              #
              #   # Call the fetch_tree method.
              #   result = client.fetch_tree request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::TreeEntry.
              #     p item
              #   end
              #
              def fetch_tree request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::FetchTreeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_tree.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_tree.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_tree.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.fetch_tree request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :fetch_tree, "tree_entries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches a blob from a repository.
              #
              # @overload fetch_blob(request, options = nil)
              #   Pass arguments to `fetch_blob` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_blob(repository: nil, sha: nil)
              #   Pass arguments to `fetch_blob` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param repository [::String]
              #     Required. The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`.
              #     Specifies the repository containing the blob.
              #   @param sha [::String]
              #     Required. The SHA-1 hash of the blob to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::FetchBlobResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::FetchBlobResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::FetchBlobRequest.new
              #
              #   # Call the fetch_blob method.
              #   result = client.fetch_blob request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::FetchBlobResponse.
              #   p result
              #
              def fetch_blob request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::FetchBlobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_blob.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_blob.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_blob.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.fetch_blob request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an issue.
              #
              # @overload create_issue(request, options = nil)
              #   Pass arguments to `create_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_issue(parent: nil, issue: nil)
              #   Pass arguments to `create_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The repository in which to create the issue. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
              #   @param issue [::Google::Cloud::SecureSourceManager::V1::Issue, ::Hash]
              #     Required. The issue to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateIssueRequest.new
              #
              #   # Call the create_issue method.
              #   result = client.create_issue request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_issue request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an issue.
              #
              # @overload get_issue(request, options = nil)
              #   Pass arguments to `get_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_issue(name: nil)
              #   Pass arguments to `get_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue to retrieve.
              #     The format is
              #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::Issue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::Issue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetIssueRequest.new
              #
              #   # Call the get_issue method.
              #   result = client.get_issue request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::Issue.
              #   p result
              #
              def get_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_issue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists issues in a repository.
              #
              # @overload list_issues(request, options = nil)
              #   Pass arguments to `list_issues` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_issues(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_issues` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The repository in which to list issues. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Used to filter the resulting issues list.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Issue>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::Issue>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListIssuesRequest.new
              #
              #   # Call the list_issues method.
              #   result = client.list_issues request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::Issue.
              #     p item
              #   end
              #
              def list_issues request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListIssuesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_issues.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_issues.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_issues.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_issues request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_issues, "issues", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a issue.
              #
              # @overload update_issue(request, options = nil)
              #   Pass arguments to `update_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_issue(issue: nil, update_mask: nil)
              #   Pass arguments to `update_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param issue [::Google::Cloud::SecureSourceManager::V1::Issue, ::Hash]
              #     Required. The issue to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     issue resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     The special value "*" means full replacement.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest.new
              #
              #   # Call the update_issue method.
              #   result = client.update_issue request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdateIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_issue request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an issue.
              #
              # @overload delete_issue(request, options = nil)
              #   Pass arguments to `delete_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_issue(name: nil, etag: nil)
              #   Pass arguments to `delete_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue to delete.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
              #   @param etag [::String]
              #     Optional. The current etag of the issue.
              #     If the etag is provided and does not match the current etag of the issue,
              #     deletion will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest.new
              #
              #   # Call the delete_issue method.
              #   result = client.delete_issue request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_issue request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Opens an issue.
              #
              # @overload open_issue(request, options = nil)
              #   Pass arguments to `open_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload open_issue(name: nil, etag: nil)
              #   Pass arguments to `open_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue to open.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
              #   @param etag [::String]
              #     Optional. The current etag of the issue.
              #     If the etag is provided and does not match the current etag of the issue,
              #     opening will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::OpenIssueRequest.new
              #
              #   # Call the open_issue method.
              #   result = client.open_issue request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def open_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::OpenIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.open_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.open_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.open_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.open_issue request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Closes an issue.
              #
              # @overload close_issue(request, options = nil)
              #   Pass arguments to `close_issue` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload close_issue(name: nil, etag: nil)
              #   Pass arguments to `close_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue to close.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`.
              #   @param etag [::String]
              #     Optional. The current etag of the issue.
              #     If the etag is provided and does not match the current etag of the issue,
              #     closing will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CloseIssueRequest.new
              #
              #   # Call the close_issue method.
              #   result = client.close_issue request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def close_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CloseIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.close_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.close_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.close_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.close_issue request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a pull request comment.
              #
              # @overload get_pull_request_comment(request, options = nil)
              #   Pass arguments to `get_pull_request_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_pull_request_comment(name: nil)
              #   Pass arguments to `get_pull_request_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the pull request comment to retrieve.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::PullRequestComment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::PullRequestComment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest.new
              #
              #   # Call the get_pull_request_comment method.
              #   result = client.get_pull_request_comment request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::PullRequestComment.
              #   p result
              #
              def get_pull_request_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetPullRequestCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_pull_request_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_pull_request_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_pull_request_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_pull_request_comment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists pull request comments.
              #
              # @overload list_pull_request_comments(request, options = nil)
              #   Pass arguments to `list_pull_request_comments` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_pull_request_comments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_pull_request_comments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The pull request in which to list pull request comments. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. If unspecified, at most 100 pull request
              #     comments will be returned. The maximum value is 100; values above 100 will
              #     be coerced to 100.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::PullRequestComment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest.new
              #
              #   # Call the list_pull_request_comments method.
              #   result = client.list_pull_request_comments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::PullRequestComment.
              #     p item
              #   end
              #
              def list_pull_request_comments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListPullRequestCommentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_pull_request_comments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_pull_request_comments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_pull_request_comments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_pull_request_comments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_pull_request_comments, "pull_request_comments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a pull request comment. This function is used to create a single
              # PullRequestComment of type Comment, or a single PullRequestComment of type
              # Code that's replying to another PullRequestComment of type Code. Use
              # BatchCreatePullRequestComments to create multiple PullRequestComments for
              # code reviews.
              #
              # @overload create_pull_request_comment(request, options = nil)
              #   Pass arguments to `create_pull_request_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_pull_request_comment(parent: nil, pull_request_comment: nil)
              #   Pass arguments to `create_pull_request_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The pull request in which to create the pull request comment.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param pull_request_comment [::Google::Cloud::SecureSourceManager::V1::PullRequestComment, ::Hash]
              #     Required. The pull request comment to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest.new
              #
              #   # Call the create_pull_request_comment method.
              #   result = client.create_pull_request_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_pull_request_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_pull_request_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_pull_request_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_pull_request_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_pull_request_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a pull request comment.
              #
              # @overload update_pull_request_comment(request, options = nil)
              #   Pass arguments to `update_pull_request_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_pull_request_comment(pull_request_comment: nil, update_mask: nil)
              #   Pass arguments to `update_pull_request_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param pull_request_comment [::Google::Cloud::SecureSourceManager::V1::PullRequestComment, ::Hash]
              #     Required. The pull request comment to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     pull request comment resource by the update. Updatable fields are
              #     `body`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest.new
              #
              #   # Call the update_pull_request_comment method.
              #   result = client.update_pull_request_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_pull_request_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdatePullRequestCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_pull_request_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_pull_request_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_pull_request_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_pull_request_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a pull request comment.
              #
              # @overload delete_pull_request_comment(request, options = nil)
              #   Pass arguments to `delete_pull_request_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_pull_request_comment(name: nil)
              #   Pass arguments to `delete_pull_request_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the pull request comment to delete.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest.new
              #
              #   # Call the delete_pull_request_comment method.
              #   result = client.delete_pull_request_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_pull_request_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeletePullRequestCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_pull_request_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_pull_request_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_pull_request_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_pull_request_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Batch creates pull request comments. This function is used to create
              # multiple PullRequestComments for code review. There needs to be exactly one
              # PullRequestComment of type Review, and at most 100 PullRequestComments of
              # type Code per request. The Postition of the code comments must be unique
              # within the request.
              #
              # @overload batch_create_pull_request_comments(request, options = nil)
              #   Pass arguments to `batch_create_pull_request_comments` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_create_pull_request_comments(parent: nil, requests: nil)
              #   Pass arguments to `batch_create_pull_request_comments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The pull request in which to create the pull request comments.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param requests [::Array<::Google::Cloud::SecureSourceManager::V1::CreatePullRequestCommentRequest, ::Hash>]
              #     Required. The request message specifying the resources to create. There
              #     should be exactly one CreatePullRequestCommentRequest with CommentDetail
              #     being REVIEW in the list, and no more than 100
              #     CreatePullRequestCommentRequests with CommentDetail being CODE in the list
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest.new
              #
              #   # Call the batch_create_pull_request_comments method.
              #   result = client.batch_create_pull_request_comments request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_create_pull_request_comments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::BatchCreatePullRequestCommentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_create_pull_request_comments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_create_pull_request_comments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_create_pull_request_comments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.batch_create_pull_request_comments request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resolves pull request comments. A list of PullRequestComment names must be
              # provided. The PullRequestComment names must be in the same conversation
              # thread. If auto_fill is set, all comments in the conversation thread will
              # be resolved.
              #
              # @overload resolve_pull_request_comments(request, options = nil)
              #   Pass arguments to `resolve_pull_request_comments` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resolve_pull_request_comments(parent: nil, names: nil, auto_fill: nil)
              #   Pass arguments to `resolve_pull_request_comments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The pull request in which to resolve the pull request comments.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param names [::Array<::String>]
              #     Required. The names of the pull request comments to resolve. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`
              #     Only comments from the same threads are allowed in the same request.
              #   @param auto_fill [::Boolean]
              #     Optional. If set, at least one comment in a thread is required, rest of the
              #     comments in the same thread will be automatically updated to resolved. If
              #     unset, all comments in the same thread need be present.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest.new
              #
              #   # Call the resolve_pull_request_comments method.
              #   result = client.resolve_pull_request_comments request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def resolve_pull_request_comments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ResolvePullRequestCommentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resolve_pull_request_comments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resolve_pull_request_comments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resolve_pull_request_comments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.resolve_pull_request_comments request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Unresolves pull request comments. A list of PullRequestComment names must
              # be provided. The PullRequestComment names must be in the same conversation
              # thread. If auto_fill is set, all comments in the conversation thread will
              # be unresolved.
              #
              # @overload unresolve_pull_request_comments(request, options = nil)
              #   Pass arguments to `unresolve_pull_request_comments` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload unresolve_pull_request_comments(parent: nil, names: nil, auto_fill: nil)
              #   Pass arguments to `unresolve_pull_request_comments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The pull request in which to resolve the pull request comments.
              #     Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}`
              #   @param names [::Array<::String>]
              #     Required. The names of the pull request comments to unresolve. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/pullRequests/{pull_request_id}/pullRequestComments/{comment_id}`
              #     Only comments from the same threads are allowed in the same request.
              #   @param auto_fill [::Boolean]
              #     Optional. If set, at least one comment in a thread is required, rest of the
              #     comments in the same thread will be automatically updated to unresolved. If
              #     unset, all comments in the same thread need be present.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest.new
              #
              #   # Call the unresolve_pull_request_comments method.
              #   result = client.unresolve_pull_request_comments request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def unresolve_pull_request_comments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UnresolvePullRequestCommentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.unresolve_pull_request_comments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.unresolve_pull_request_comments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.unresolve_pull_request_comments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.unresolve_pull_request_comments request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an issue comment.
              #
              # @overload create_issue_comment(request, options = nil)
              #   Pass arguments to `create_issue_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_issue_comment(parent: nil, issue_comment: nil)
              #   Pass arguments to `create_issue_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The issue in which to create the issue comment. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`
              #   @param issue_comment [::Google::Cloud::SecureSourceManager::V1::IssueComment, ::Hash]
              #     Required. The issue comment to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest.new
              #
              #   # Call the create_issue_comment method.
              #   result = client.create_issue_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_issue_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::CreateIssueCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_issue_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_issue_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_issue_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.create_issue_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an issue comment.
              #
              # @overload get_issue_comment(request, options = nil)
              #   Pass arguments to `get_issue_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_issue_comment(name: nil)
              #   Pass arguments to `get_issue_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue comment to retrieve.
              #     The format is
              #     `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue_id}/issueComments/{comment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::SecureSourceManager::V1::IssueComment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::SecureSourceManager::V1::IssueComment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest.new
              #
              #   # Call the get_issue_comment method.
              #   result = client.get_issue_comment request
              #
              #   # The returned object is of type Google::Cloud::SecureSourceManager::V1::IssueComment.
              #   p result
              #
              def get_issue_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::GetIssueCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_issue_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_issue_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_issue_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.get_issue_comment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists comments in an issue.
              #
              # @overload list_issue_comments(request, options = nil)
              #   Pass arguments to `list_issue_comments` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_issue_comments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_issue_comments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The issue in which to list the comments. Format:
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::IssueComment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SecureSourceManager::V1::IssueComment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest.new
              #
              #   # Call the list_issue_comments method.
              #   result = client.list_issue_comments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::SecureSourceManager::V1::IssueComment.
              #     p item
              #   end
              #
              def list_issue_comments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::ListIssueCommentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_issue_comments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_issue_comments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_issue_comments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.list_issue_comments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @secure_source_manager_stub, :list_issue_comments, "issue_comments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an issue comment.
              #
              # @overload update_issue_comment(request, options = nil)
              #   Pass arguments to `update_issue_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_issue_comment(issue_comment: nil, update_mask: nil)
              #   Pass arguments to `update_issue_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param issue_comment [::Google::Cloud::SecureSourceManager::V1::IssueComment, ::Hash]
              #     Required. The issue comment to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     issue comment resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     The special value "*" means full replacement.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest.new
              #
              #   # Call the update_issue_comment method.
              #   result = client.update_issue_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_issue_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::UpdateIssueCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_issue_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_issue_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_issue_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.update_issue_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an issue comment.
              #
              # @overload delete_issue_comment(request, options = nil)
              #   Pass arguments to `delete_issue_comment` via a request object, either of type
              #   {::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_issue_comment(name: nil)
              #   Pass arguments to `delete_issue_comment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the issue comment to delete.
              #     The format is
              #     `projects/{project_number}/locations/{location_id}/repositories/{repository_id}/issues/{issue_id}/issueComments/{comment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/secure_source_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest.new
              #
              #   # Call the delete_issue_comment method.
              #   result = client.delete_issue_comment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_issue_comment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecureSourceManager::V1::DeleteIssueCommentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_issue_comment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::SecureSourceManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_issue_comment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_issue_comment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @secure_source_manager_stub.delete_issue_comment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the SecureSourceManager REST API.
              #
              # This class represents the configuration for SecureSourceManager REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_instances to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "securesourcemanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the SecureSourceManager API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_instances
                  ##
                  # RPC-specific configuration for `get_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance
                  ##
                  # RPC-specific configuration for `create_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_instance
                  ##
                  # RPC-specific configuration for `delete_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_instance
                  ##
                  # RPC-specific configuration for `list_repositories`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_repositories
                  ##
                  # RPC-specific configuration for `get_repository`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_repository
                  ##
                  # RPC-specific configuration for `create_repository`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_repository
                  ##
                  # RPC-specific configuration for `update_repository`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_repository
                  ##
                  # RPC-specific configuration for `delete_repository`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_repository
                  ##
                  # RPC-specific configuration for `list_hooks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_hooks
                  ##
                  # RPC-specific configuration for `get_hook`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_hook
                  ##
                  # RPC-specific configuration for `create_hook`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_hook
                  ##
                  # RPC-specific configuration for `update_hook`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_hook
                  ##
                  # RPC-specific configuration for `delete_hook`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_hook
                  ##
                  # RPC-specific configuration for `get_iam_policy_repo`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy_repo
                  ##
                  # RPC-specific configuration for `set_iam_policy_repo`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy_repo
                  ##
                  # RPC-specific configuration for `test_iam_permissions_repo`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions_repo
                  ##
                  # RPC-specific configuration for `create_branch_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_branch_rule
                  ##
                  # RPC-specific configuration for `list_branch_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_branch_rules
                  ##
                  # RPC-specific configuration for `get_branch_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_branch_rule
                  ##
                  # RPC-specific configuration for `update_branch_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_branch_rule
                  ##
                  # RPC-specific configuration for `delete_branch_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_branch_rule
                  ##
                  # RPC-specific configuration for `create_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_pull_request
                  ##
                  # RPC-specific configuration for `get_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_pull_request
                  ##
                  # RPC-specific configuration for `list_pull_requests`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_pull_requests
                  ##
                  # RPC-specific configuration for `update_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_pull_request
                  ##
                  # RPC-specific configuration for `merge_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :merge_pull_request
                  ##
                  # RPC-specific configuration for `open_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :open_pull_request
                  ##
                  # RPC-specific configuration for `close_pull_request`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :close_pull_request
                  ##
                  # RPC-specific configuration for `list_pull_request_file_diffs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_pull_request_file_diffs
                  ##
                  # RPC-specific configuration for `fetch_tree`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_tree
                  ##
                  # RPC-specific configuration for `fetch_blob`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_blob
                  ##
                  # RPC-specific configuration for `create_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_issue
                  ##
                  # RPC-specific configuration for `get_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_issue
                  ##
                  # RPC-specific configuration for `list_issues`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_issues
                  ##
                  # RPC-specific configuration for `update_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_issue
                  ##
                  # RPC-specific configuration for `delete_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_issue
                  ##
                  # RPC-specific configuration for `open_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :open_issue
                  ##
                  # RPC-specific configuration for `close_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :close_issue
                  ##
                  # RPC-specific configuration for `get_pull_request_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_pull_request_comment
                  ##
                  # RPC-specific configuration for `list_pull_request_comments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_pull_request_comments
                  ##
                  # RPC-specific configuration for `create_pull_request_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_pull_request_comment
                  ##
                  # RPC-specific configuration for `update_pull_request_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_pull_request_comment
                  ##
                  # RPC-specific configuration for `delete_pull_request_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_pull_request_comment
                  ##
                  # RPC-specific configuration for `batch_create_pull_request_comments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_create_pull_request_comments
                  ##
                  # RPC-specific configuration for `resolve_pull_request_comments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resolve_pull_request_comments
                  ##
                  # RPC-specific configuration for `unresolve_pull_request_comments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :unresolve_pull_request_comments
                  ##
                  # RPC-specific configuration for `create_issue_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_issue_comment
                  ##
                  # RPC-specific configuration for `get_issue_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_issue_comment
                  ##
                  # RPC-specific configuration for `list_issue_comments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_issue_comments
                  ##
                  # RPC-specific configuration for `update_issue_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_issue_comment
                  ##
                  # RPC-specific configuration for `delete_issue_comment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_issue_comment

                  # @private
                  def initialize parent_rpcs = nil
                    list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                    @list_instances = ::Gapic::Config::Method.new list_instances_config
                    get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                    @get_instance = ::Gapic::Config::Method.new get_instance_config
                    create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                    @create_instance = ::Gapic::Config::Method.new create_instance_config
                    delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                    @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                    list_repositories_config = parent_rpcs.list_repositories if parent_rpcs.respond_to? :list_repositories
                    @list_repositories = ::Gapic::Config::Method.new list_repositories_config
                    get_repository_config = parent_rpcs.get_repository if parent_rpcs.respond_to? :get_repository
                    @get_repository = ::Gapic::Config::Method.new get_repository_config
                    create_repository_config = parent_rpcs.create_repository if parent_rpcs.respond_to? :create_repository
                    @create_repository = ::Gapic::Config::Method.new create_repository_config
                    update_repository_config = parent_rpcs.update_repository if parent_rpcs.respond_to? :update_repository
                    @update_repository = ::Gapic::Config::Method.new update_repository_config
                    delete_repository_config = parent_rpcs.delete_repository if parent_rpcs.respond_to? :delete_repository
                    @delete_repository = ::Gapic::Config::Method.new delete_repository_config
                    list_hooks_config = parent_rpcs.list_hooks if parent_rpcs.respond_to? :list_hooks
                    @list_hooks = ::Gapic::Config::Method.new list_hooks_config
                    get_hook_config = parent_rpcs.get_hook if parent_rpcs.respond_to? :get_hook
                    @get_hook = ::Gapic::Config::Method.new get_hook_config
                    create_hook_config = parent_rpcs.create_hook if parent_rpcs.respond_to? :create_hook
                    @create_hook = ::Gapic::Config::Method.new create_hook_config
                    update_hook_config = parent_rpcs.update_hook if parent_rpcs.respond_to? :update_hook
                    @update_hook = ::Gapic::Config::Method.new update_hook_config
                    delete_hook_config = parent_rpcs.delete_hook if parent_rpcs.respond_to? :delete_hook
                    @delete_hook = ::Gapic::Config::Method.new delete_hook_config
                    get_iam_policy_repo_config = parent_rpcs.get_iam_policy_repo if parent_rpcs.respond_to? :get_iam_policy_repo
                    @get_iam_policy_repo = ::Gapic::Config::Method.new get_iam_policy_repo_config
                    set_iam_policy_repo_config = parent_rpcs.set_iam_policy_repo if parent_rpcs.respond_to? :set_iam_policy_repo
                    @set_iam_policy_repo = ::Gapic::Config::Method.new set_iam_policy_repo_config
                    test_iam_permissions_repo_config = parent_rpcs.test_iam_permissions_repo if parent_rpcs.respond_to? :test_iam_permissions_repo
                    @test_iam_permissions_repo = ::Gapic::Config::Method.new test_iam_permissions_repo_config
                    create_branch_rule_config = parent_rpcs.create_branch_rule if parent_rpcs.respond_to? :create_branch_rule
                    @create_branch_rule = ::Gapic::Config::Method.new create_branch_rule_config
                    list_branch_rules_config = parent_rpcs.list_branch_rules if parent_rpcs.respond_to? :list_branch_rules
                    @list_branch_rules = ::Gapic::Config::Method.new list_branch_rules_config
                    get_branch_rule_config = parent_rpcs.get_branch_rule if parent_rpcs.respond_to? :get_branch_rule
                    @get_branch_rule = ::Gapic::Config::Method.new get_branch_rule_config
                    update_branch_rule_config = parent_rpcs.update_branch_rule if parent_rpcs.respond_to? :update_branch_rule
                    @update_branch_rule = ::Gapic::Config::Method.new update_branch_rule_config
                    delete_branch_rule_config = parent_rpcs.delete_branch_rule if parent_rpcs.respond_to? :delete_branch_rule
                    @delete_branch_rule = ::Gapic::Config::Method.new delete_branch_rule_config
                    create_pull_request_config = parent_rpcs.create_pull_request if parent_rpcs.respond_to? :create_pull_request
                    @create_pull_request = ::Gapic::Config::Method.new create_pull_request_config
                    get_pull_request_config = parent_rpcs.get_pull_request if parent_rpcs.respond_to? :get_pull_request
                    @get_pull_request = ::Gapic::Config::Method.new get_pull_request_config
                    list_pull_requests_config = parent_rpcs.list_pull_requests if parent_rpcs.respond_to? :list_pull_requests
                    @list_pull_requests = ::Gapic::Config::Method.new list_pull_requests_config
                    update_pull_request_config = parent_rpcs.update_pull_request if parent_rpcs.respond_to? :update_pull_request
                    @update_pull_request = ::Gapic::Config::Method.new update_pull_request_config
                    merge_pull_request_config = parent_rpcs.merge_pull_request if parent_rpcs.respond_to? :merge_pull_request
                    @merge_pull_request = ::Gapic::Config::Method.new merge_pull_request_config
                    open_pull_request_config = parent_rpcs.open_pull_request if parent_rpcs.respond_to? :open_pull_request
                    @open_pull_request = ::Gapic::Config::Method.new open_pull_request_config
                    close_pull_request_config = parent_rpcs.close_pull_request if parent_rpcs.respond_to? :close_pull_request
                    @close_pull_request = ::Gapic::Config::Method.new close_pull_request_config
                    list_pull_request_file_diffs_config = parent_rpcs.list_pull_request_file_diffs if parent_rpcs.respond_to? :list_pull_request_file_diffs
                    @list_pull_request_file_diffs = ::Gapic::Config::Method.new list_pull_request_file_diffs_config
                    fetch_tree_config = parent_rpcs.fetch_tree if parent_rpcs.respond_to? :fetch_tree
                    @fetch_tree = ::Gapic::Config::Method.new fetch_tree_config
                    fetch_blob_config = parent_rpcs.fetch_blob if parent_rpcs.respond_to? :fetch_blob
                    @fetch_blob = ::Gapic::Config::Method.new fetch_blob_config
                    create_issue_config = parent_rpcs.create_issue if parent_rpcs.respond_to? :create_issue
                    @create_issue = ::Gapic::Config::Method.new create_issue_config
                    get_issue_config = parent_rpcs.get_issue if parent_rpcs.respond_to? :get_issue
                    @get_issue = ::Gapic::Config::Method.new get_issue_config
                    list_issues_config = parent_rpcs.list_issues if parent_rpcs.respond_to? :list_issues
                    @list_issues = ::Gapic::Config::Method.new list_issues_config
                    update_issue_config = parent_rpcs.update_issue if parent_rpcs.respond_to? :update_issue
                    @update_issue = ::Gapic::Config::Method.new update_issue_config
                    delete_issue_config = parent_rpcs.delete_issue if parent_rpcs.respond_to? :delete_issue
                    @delete_issue = ::Gapic::Config::Method.new delete_issue_config
                    open_issue_config = parent_rpcs.open_issue if parent_rpcs.respond_to? :open_issue
                    @open_issue = ::Gapic::Config::Method.new open_issue_config
                    close_issue_config = parent_rpcs.close_issue if parent_rpcs.respond_to? :close_issue
                    @close_issue = ::Gapic::Config::Method.new close_issue_config
                    get_pull_request_comment_config = parent_rpcs.get_pull_request_comment if parent_rpcs.respond_to? :get_pull_request_comment
                    @get_pull_request_comment = ::Gapic::Config::Method.new get_pull_request_comment_config
                    list_pull_request_comments_config = parent_rpcs.list_pull_request_comments if parent_rpcs.respond_to? :list_pull_request_comments
                    @list_pull_request_comments = ::Gapic::Config::Method.new list_pull_request_comments_config
                    create_pull_request_comment_config = parent_rpcs.create_pull_request_comment if parent_rpcs.respond_to? :create_pull_request_comment
                    @create_pull_request_comment = ::Gapic::Config::Method.new create_pull_request_comment_config
                    update_pull_request_comment_config = parent_rpcs.update_pull_request_comment if parent_rpcs.respond_to? :update_pull_request_comment
                    @update_pull_request_comment = ::Gapic::Config::Method.new update_pull_request_comment_config
                    delete_pull_request_comment_config = parent_rpcs.delete_pull_request_comment if parent_rpcs.respond_to? :delete_pull_request_comment
                    @delete_pull_request_comment = ::Gapic::Config::Method.new delete_pull_request_comment_config
                    batch_create_pull_request_comments_config = parent_rpcs.batch_create_pull_request_comments if parent_rpcs.respond_to? :batch_create_pull_request_comments
                    @batch_create_pull_request_comments = ::Gapic::Config::Method.new batch_create_pull_request_comments_config
                    resolve_pull_request_comments_config = parent_rpcs.resolve_pull_request_comments if parent_rpcs.respond_to? :resolve_pull_request_comments
                    @resolve_pull_request_comments = ::Gapic::Config::Method.new resolve_pull_request_comments_config
                    unresolve_pull_request_comments_config = parent_rpcs.unresolve_pull_request_comments if parent_rpcs.respond_to? :unresolve_pull_request_comments
                    @unresolve_pull_request_comments = ::Gapic::Config::Method.new unresolve_pull_request_comments_config
                    create_issue_comment_config = parent_rpcs.create_issue_comment if parent_rpcs.respond_to? :create_issue_comment
                    @create_issue_comment = ::Gapic::Config::Method.new create_issue_comment_config
                    get_issue_comment_config = parent_rpcs.get_issue_comment if parent_rpcs.respond_to? :get_issue_comment
                    @get_issue_comment = ::Gapic::Config::Method.new get_issue_comment_config
                    list_issue_comments_config = parent_rpcs.list_issue_comments if parent_rpcs.respond_to? :list_issue_comments
                    @list_issue_comments = ::Gapic::Config::Method.new list_issue_comments_config
                    update_issue_comment_config = parent_rpcs.update_issue_comment if parent_rpcs.respond_to? :update_issue_comment
                    @update_issue_comment = ::Gapic::Config::Method.new update_issue_comment_config
                    delete_issue_comment_config = parent_rpcs.delete_issue_comment if parent_rpcs.respond_to? :delete_issue_comment
                    @delete_issue_comment = ::Gapic::Config::Method.new delete_issue_comment_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
