# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecureSourceManager
      module V1
        module SecureSourceManager
          # Path helper methods for the SecureSourceManager API.
          module Paths
            ##
            # Create a fully-qualified BranchRule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param branch_rule [String]
            #
            # @return [::String]
            def branch_rule_path project:, location:, repository:, branch_rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/branchRules/#{branch_rule}"
            end

            ##
            # Create a fully-qualified CaPool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/caPools/{ca_pool}`
            #
            # @param project [String]
            # @param location [String]
            # @param ca_pool [String]
            #
            # @return [::String]
            def ca_pool_path project:, location:, ca_pool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/caPools/#{ca_pool}"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified Hook resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/hooks/{hook}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param hook [String]
            #
            # @return [::String]
            def hook_path project:, location:, repository:, hook:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/hooks/#{hook}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Issue resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param issue [String]
            #
            # @return [::String]
            def issue_path project:, location:, repository:, issue:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/issues/#{issue}"
            end

            ##
            # Create a fully-qualified IssueComment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}/issueComments/{comment}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param issue [String]
            # @param comment [String]
            #
            # @return [::String]
            def issue_comment_path project:, location:, repository:, issue:, comment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"
              raise ::ArgumentError, "issue cannot contain /" if issue.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/issues/#{issue}/issueComments/#{comment}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified PullRequest resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param pull_request [String]
            #
            # @return [::String]
            def pull_request_path project:, location:, repository:, pull_request:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/pullRequests/#{pull_request}"
            end

            ##
            # Create a fully-qualified PullRequestComment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}/pullRequestComments/{comment}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param pull_request [String]
            # @param comment [String]
            #
            # @return [::String]
            def pull_request_comment_path project:, location:, repository:, pull_request:, comment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"
              raise ::ArgumentError, "pull_request cannot contain /" if pull_request.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/pullRequests/#{pull_request}/pullRequestComments/#{comment}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified ServiceAttachment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`
            #
            # @param project [String]
            # @param region [String]
            # @param service_attachment [String]
            #
            # @return [::String]
            def service_attachment_path project:, region:, service_attachment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/serviceAttachments/#{service_attachment}"
            end

            extend self
          end
        end
      end
    end
  end
end
