# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/secure_source_manager/v1/version"

require "google/cloud/secure_source_manager/v1/secure_source_manager/credentials"
require "google/cloud/secure_source_manager/v1/secure_source_manager/paths"
require "google/cloud/secure_source_manager/v1/secure_source_manager/operations"
require "google/cloud/secure_source_manager/v1/secure_source_manager/client"
require "google/cloud/secure_source_manager/v1/secure_source_manager/rest"

module Google
  module Cloud
    module SecureSourceManager
      module V1
        ##
        # Secure Source Manager API
        #
        # Access Secure Source Manager instances, resources, and repositories.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/secure_source_manager/v1/secure_source_manager"
        #     client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/secure_source_manager/v1/secure_source_manager/rest"
        #     client = ::Google::Cloud::SecureSourceManager::V1::SecureSourceManager::Rest::Client.new
        #
        module SecureSourceManager
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "secure_source_manager", "helpers.rb"
require "google/cloud/secure_source_manager/v1/secure_source_manager/helpers" if ::File.file? helper_path
