# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# [START secretmanager_v1beta2_generated_SecretManagerService_AccessSecretVersion_sync]
require "google/cloud/secret_manager/v1beta2"

##
# Snippet for the access_secret_version call in the SecretManagerService service
#
# This snippet has been automatically generated and should be regarded as a code
# template only. It will require modifications to work:
# - It may require correct/in-range values for request initialization.
# - It may require specifying regional endpoints when creating the service
# client as shown in https://cloud.google.com/ruby/docs/reference.
#
# This is an auto-generated example demonstrating basic usage of
# Google::Cloud::SecretManager::V1beta2::SecretManagerService::Client#access_secret_version.
#
def access_secret_version
  # Create a client object. The client can be reused for multiple calls.
  client = Google::Cloud::SecretManager::V1beta2::SecretManagerService::Client.new

  # Create a request. To set request fields, pass in keyword arguments.
  request = Google::Cloud::SecretManager::V1beta2::AccessSecretVersionRequest.new

  # Call the access_secret_version method.
  result = client.access_secret_version request

  # The returned object is of type Google::Cloud::SecretManager::V1beta2::AccessSecretVersionResponse.
  p result
end
# [END secretmanager_v1beta2_generated_SecretManagerService_AccessSecretVersion_sync]
