# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SecretManager
      module V1beta2
        module SecretManagerService
          # Path helper methods for the SecretManagerService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Secret resource string.
            #
            # @overload secret_path(project:, secret:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/secrets/{secret}`
            #
            #   @param project [String]
            #   @param secret [String]
            #
            # @overload secret_path(project:, location:, secret:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/secrets/{secret}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param secret [String]
            #
            # @return [::String]
            def secret_path **args
              resources = {
                "project:secret" => (proc do |project:, secret:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/secrets/#{secret}"
                end),
                "location:project:secret" => (proc do |project:, location:, secret:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/secrets/#{secret}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # @overload secret_version_path(project:, secret:, secret_version:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            #   @param project [String]
            #   @param secret [String]
            #   @param secret_version [String]
            #
            # @overload secret_version_path(project:, location:, secret:, secret_version:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/secrets/{secret}/versions/{secret_version}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param secret [String]
            #   @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path **args
              resources = {
                "project:secret:secret_version" => (proc do |project:, secret:, secret_version:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

                  "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
                end),
                "location:project:secret:secret_version" => (proc do |project:, location:, secret:, secret_version:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/secrets/#{secret}/versions/#{secret_version}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Topic resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/topics/{topic}`
            #
            # @param project [String]
            # @param topic [String]
            #
            # @return [::String]
            def topic_path project:, topic:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/topics/#{topic}"
            end

            extend self
          end
        end
      end
    end
  end
end
