# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/secrets/v1beta1/service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module SecretManager
      module V1beta1
        module SecretManagerService
          ##
          # Client for the SecretManagerService service.
          #
          # Secret Manager Service
          #
          # Manages secrets and operations using those secrets. Implements a REST
          # model with the following objects:
          #
          # * {::Google::Cloud::SecretManager::V1beta1::Secret Secret}
          # * {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "secretmanager.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :secret_manager_service_stub

            ##
            # Configure the SecretManagerService Client class.
            #
            # See {::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all SecretManagerService clients
            #   ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "SecretManager", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_secrets.timeout = 60.0

                default_config.rpcs.create_secret.timeout = 60.0

                default_config.rpcs.add_secret_version.timeout = 60.0

                default_config.rpcs.get_secret.timeout = 60.0

                default_config.rpcs.update_secret.timeout = 60.0

                default_config.rpcs.delete_secret.timeout = 60.0

                default_config.rpcs.list_secret_versions.timeout = 60.0

                default_config.rpcs.get_secret_version.timeout = 60.0

                default_config.rpcs.access_secret_version.timeout = 60.0
                default_config.rpcs.access_secret_version.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.disable_secret_version.timeout = 60.0

                default_config.rpcs.enable_secret_version.timeout = 60.0

                default_config.rpcs.destroy_secret_version.timeout = 60.0

                default_config.rpcs.set_iam_policy.timeout = 60.0

                default_config.rpcs.get_iam_policy.timeout = 60.0

                default_config.rpcs.test_iam_permissions.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the SecretManagerService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @secret_manager_service_stub.universe_domain
            end

            ##
            # Create a new SecretManagerService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the SecretManagerService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/secrets/v1beta1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @secret_manager_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @secret_manager_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @secret_manager_service_stub.endpoint
                config.universe_domain = @secret_manager_service_stub.universe_domain
                config.logger = @secret_manager_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @secret_manager_service_stub.logger
            end

            # Service calls

            ##
            # Lists {::Google::Cloud::SecretManager::V1beta1::Secret Secrets}.
            #
            # @overload list_secrets(request, options = nil)
            #   Pass arguments to `list_secrets` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::ListSecretsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::ListSecretsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_secrets(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_secrets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the project associated with the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secrets}, in the format `projects/*`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to be returned in a single page. If
            #     set to 0, the server decides the number of results to return. If the
            #     number is greater than 25000, it is capped at 25000.
            #   @param page_token [::String]
            #     Optional. Pagination token, returned earlier via
            #     {::Google::Cloud::SecretManager::V1beta1::ListSecretsResponse#next_page_token ListSecretsResponse.next_page_token}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecretManager::V1beta1::Secret>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecretManager::V1beta1::Secret>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::ListSecretsRequest.new
            #
            #   # Call the list_secrets method.
            #   result = client.list_secrets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecretManager::V1beta1::Secret.
            #     p item
            #   end
            #
            def list_secrets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::ListSecretsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_secrets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_secrets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_secrets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :list_secrets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @secret_manager_service_stub, :list_secrets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new {::Google::Cloud::SecretManager::V1beta1::Secret Secret} containing no
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersions}.
            #
            # @overload create_secret(request, options = nil)
            #   Pass arguments to `create_secret` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::CreateSecretRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::CreateSecretRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_secret(parent: nil, secret_id: nil, secret: nil)
            #   Pass arguments to `create_secret` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the project to associate with the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secret}, in the format `projects/*`.
            #   @param secret_id [::String]
            #     Required. This must be unique within the project.
            #
            #     A secret ID is a string with a maximum length of 255 characters and can
            #     contain uppercase and lowercase letters, numerals, and the hyphen (`-`) and
            #     underscore (`_`) characters.
            #   @param secret [::Google::Cloud::SecretManager::V1beta1::Secret, ::Hash]
            #     Required. A {::Google::Cloud::SecretManager::V1beta1::Secret Secret} with initial
            #     field values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::Secret]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::Secret]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::CreateSecretRequest.new
            #
            #   # Call the create_secret method.
            #   result = client.create_secret request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::Secret.
            #   p result
            #
            def create_secret request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::CreateSecretRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_secret.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_secret.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_secret.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :create_secret, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}
            # containing secret data and attaches it to an existing
            # {::Google::Cloud::SecretManager::V1beta1::Secret Secret}.
            #
            # @overload add_secret_version(request, options = nil)
            #   Pass arguments to `add_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::AddSecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::AddSecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_secret_version(parent: nil, payload: nil)
            #   Pass arguments to `add_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secret} to associate with the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} in the format
            #     `projects/*/secrets/*`.
            #   @param payload [::Google::Cloud::SecretManager::V1beta1::SecretPayload, ::Hash]
            #     Required. The secret payload of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::AddSecretVersionRequest.new
            #
            #   # Call the add_secret_version method.
            #   result = client.add_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #   p result
            #
            def add_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::AddSecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :add_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets metadata for a given {::Google::Cloud::SecretManager::V1beta1::Secret Secret}.
            #
            # @overload get_secret(request, options = nil)
            #   Pass arguments to `get_secret` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::GetSecretRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::GetSecretRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_secret(name: nil)
            #   Pass arguments to `get_secret` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secret}, in the format
            #     `projects/*/secrets/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::Secret]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::Secret]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::GetSecretRequest.new
            #
            #   # Call the get_secret method.
            #   result = client.get_secret request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::Secret.
            #   p result
            #
            def get_secret request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::GetSecretRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_secret.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_secret.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_secret.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :get_secret, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates metadata of an existing
            # {::Google::Cloud::SecretManager::V1beta1::Secret Secret}.
            #
            # @overload update_secret(request, options = nil)
            #   Pass arguments to `update_secret` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::UpdateSecretRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::UpdateSecretRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_secret(secret: nil, update_mask: nil)
            #   Pass arguments to `update_secret` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param secret [::Google::Cloud::SecretManager::V1beta1::Secret, ::Hash]
            #     Required. {::Google::Cloud::SecretManager::V1beta1::Secret Secret} with updated field
            #     values.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Specifies the fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::Secret]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::Secret]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::UpdateSecretRequest.new
            #
            #   # Call the update_secret method.
            #   result = client.update_secret request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::Secret.
            #   p result
            #
            def update_secret request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::UpdateSecretRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_secret.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.secret&.name
                header_params["secret.name"] = request.secret.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_secret.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_secret.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :update_secret, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::SecretManager::V1beta1::Secret Secret}.
            #
            # @overload delete_secret(request, options = nil)
            #   Pass arguments to `delete_secret` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::DeleteSecretRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::DeleteSecretRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_secret(name: nil)
            #   Pass arguments to `delete_secret` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secret} to delete in the format
            #     `projects/*/secrets/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::DeleteSecretRequest.new
            #
            #   # Call the delete_secret method.
            #   result = client.delete_secret request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_secret request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::DeleteSecretRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_secret.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_secret.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_secret.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :delete_secret, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersions}. This
            # call does not return secret data.
            #
            # @overload list_secret_versions(request, options = nil)
            #   Pass arguments to `list_secret_versions` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::ListSecretVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::ListSecretVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_secret_versions(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_secret_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::Secret Secret} associated with the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersions} to list, in
            #     the format `projects/*/secrets/*`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to be returned in a single page. If
            #     set to 0, the server decides the number of results to return. If the
            #     number is greater than 25000, it is capped at 25000.
            #   @param page_token [::String]
            #     Optional. Pagination token, returned earlier via
            #     ListSecretVersionsResponse.next_page_token][].
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::SecretManager::V1beta1::SecretVersion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::SecretManager::V1beta1::SecretVersion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::ListSecretVersionsRequest.new
            #
            #   # Call the list_secret_versions method.
            #   result = client.list_secret_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #     p item
            #   end
            #
            def list_secret_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::ListSecretVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_secret_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_secret_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_secret_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :list_secret_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @secret_manager_service_stub, :list_secret_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets metadata for a
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # `projects/*/secrets/*/versions/latest` is an alias to the `latest`
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # @overload get_secret_version(request, options = nil)
            #   Pass arguments to `get_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::GetSecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::GetSecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_secret_version(name: nil)
            #   Pass arguments to `get_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} in the format
            #     `projects/*/secrets/*/versions/*`.
            #     `projects/*/secrets/*/versions/latest` is an alias to the `latest`
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::GetSecretVersionRequest.new
            #
            #   # Call the get_secret_version method.
            #   result = client.get_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #   p result
            #
            def get_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::GetSecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :get_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Accesses a {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            # This call returns the secret data.
            #
            # `projects/*/secrets/*/versions/latest` is an alias to the `latest`
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # @overload access_secret_version(request, options = nil)
            #   Pass arguments to `access_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::AccessSecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::AccessSecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload access_secret_version(name: nil)
            #   Pass arguments to `access_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} in the format
            #     `projects/*/secrets/*/versions/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::AccessSecretVersionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::AccessSecretVersionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::AccessSecretVersionRequest.new
            #
            #   # Call the access_secret_version method.
            #   result = client.access_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::AccessSecretVersionResponse.
            #   p result
            #
            def access_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::AccessSecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.access_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.access_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.access_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :access_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Disables a {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # Sets the {::Google::Cloud::SecretManager::V1beta1::SecretVersion#state state} of the
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion::State::DISABLED DISABLED}.
            #
            # @overload disable_secret_version(request, options = nil)
            #   Pass arguments to `disable_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::DisableSecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::DisableSecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload disable_secret_version(name: nil)
            #   Pass arguments to `disable_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to disable in
            #     the format `projects/*/secrets/*/versions/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::DisableSecretVersionRequest.new
            #
            #   # Call the disable_secret_version method.
            #   result = client.disable_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #   p result
            #
            def disable_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::DisableSecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.disable_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.disable_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.disable_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :disable_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Enables a {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # Sets the {::Google::Cloud::SecretManager::V1beta1::SecretVersion#state state} of the
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion::State::ENABLED ENABLED}.
            #
            # @overload enable_secret_version(request, options = nil)
            #   Pass arguments to `enable_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::EnableSecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::EnableSecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload enable_secret_version(name: nil)
            #   Pass arguments to `enable_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to enable in
            #     the format `projects/*/secrets/*/versions/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::EnableSecretVersionRequest.new
            #
            #   # Call the enable_secret_version method.
            #   result = client.enable_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #   p result
            #
            def enable_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::EnableSecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.enable_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.enable_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.enable_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :enable_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Destroys a {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion}.
            #
            # Sets the {::Google::Cloud::SecretManager::V1beta1::SecretVersion#state state} of the
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to
            # {::Google::Cloud::SecretManager::V1beta1::SecretVersion::State::DESTROYED DESTROYED} and
            # irrevocably destroys the secret data.
            #
            # @overload destroy_secret_version(request, options = nil)
            #   Pass arguments to `destroy_secret_version` via a request object, either of type
            #   {::Google::Cloud::SecretManager::V1beta1::DestroySecretVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::SecretManager::V1beta1::DestroySecretVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload destroy_secret_version(name: nil)
            #   Pass arguments to `destroy_secret_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersion} to destroy in
            #     the format `projects/*/secrets/*/versions/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::SecretManager::V1beta1::SecretVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::SecretManager::V1beta1::DestroySecretVersionRequest.new
            #
            #   # Call the destroy_secret_version method.
            #   result = client.destroy_secret_version request
            #
            #   # The returned object is of type Google::Cloud::SecretManager::V1beta1::SecretVersion.
            #   p result
            #
            def destroy_secret_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SecretManager::V1beta1::DestroySecretVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.destroy_secret_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.destroy_secret_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.destroy_secret_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :destroy_secret_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the access control policy on the specified secret. Replaces any
            # existing policy.
            #
            # Permissions on {::Google::Cloud::SecretManager::V1beta1::SecretVersion SecretVersions}
            # are enforced according to the policy set on the associated
            # {::Google::Cloud::SecretManager::V1beta1::Secret Secret}.
            #
            # @overload set_iam_policy(request, options = nil)
            #   Pass arguments to `set_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
            #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being specified.
            #     See the operation documentation for the appropriate value for this field.
            #   @param policy [::Google::Iam::V1::Policy, ::Hash]
            #     REQUIRED: The complete policy to be applied to the `resource`. The size of
            #     the policy is limited to a few 10s of KB. An empty policy is a
            #     valid policy but certain Cloud Platform services (such as Projects)
            #     might reject them.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
            #     the fields in the mask will be modified. If no mask is provided, the
            #     following default mask is used:
            #
            #     `paths: "bindings, etag"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::SetIamPolicyRequest.new
            #
            #   # Call the set_iam_policy method.
            #   result = client.set_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def set_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the access control policy for a secret.
            # Returns empty policy if the secret exists and does not have a policy set.
            #
            # @overload get_iam_policy(request, options = nil)
            #   Pass arguments to `get_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_iam_policy(resource: nil, options: nil)
            #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
            #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
            #     `GetIamPolicy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::GetIamPolicyRequest.new
            #
            #   # Call the get_iam_policy method.
            #   result = client.get_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def get_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns permissions that a caller has for the specified secret.
            # If the secret does not exist, this call returns an empty set of
            # permissions, not a NOT_FOUND error.
            #
            # Note: This operation is designed to be used for building permission-aware
            # UIs and command-line tools, not for authorization checking. This operation
            # may "fail open" without warning.
            #
            # @overload test_iam_permissions(request, options = nil)
            #   Pass arguments to `test_iam_permissions` via a request object, either of type
            #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload test_iam_permissions(resource: nil, permissions: nil)
            #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy detail is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param permissions [::Array<::String>]
            #     The set of permissions to check for the `resource`. Permissions with
            #     wildcards (such as '*' or 'storage.*') are not allowed. For more
            #     information see
            #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::TestIamPermissionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/secret_manager/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::TestIamPermissionsRequest.new
            #
            #   # Call the test_iam_permissions method.
            #   result = client.test_iam_permissions request
            #
            #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
            #   p result
            #
            def test_iam_permissions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.test_iam_permissions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::SecretManager::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.test_iam_permissions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @secret_manager_service_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the SecretManagerService API.
            #
            # This class represents the configuration for SecretManagerService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_secrets to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_secrets.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_secrets.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::SecretManager::V1beta1::SecretManagerService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "secretmanager.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the SecretManagerService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_secrets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_secrets
                ##
                # RPC-specific configuration for `create_secret`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_secret
                ##
                # RPC-specific configuration for `add_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_secret_version
                ##
                # RPC-specific configuration for `get_secret`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_secret
                ##
                # RPC-specific configuration for `update_secret`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_secret
                ##
                # RPC-specific configuration for `delete_secret`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_secret
                ##
                # RPC-specific configuration for `list_secret_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_secret_versions
                ##
                # RPC-specific configuration for `get_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_secret_version
                ##
                # RPC-specific configuration for `access_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :access_secret_version
                ##
                # RPC-specific configuration for `disable_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :disable_secret_version
                ##
                # RPC-specific configuration for `enable_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :enable_secret_version
                ##
                # RPC-specific configuration for `destroy_secret_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :destroy_secret_version
                ##
                # RPC-specific configuration for `set_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_iam_policy
                ##
                # RPC-specific configuration for `get_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_iam_policy
                ##
                # RPC-specific configuration for `test_iam_permissions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :test_iam_permissions

                # @private
                def initialize parent_rpcs = nil
                  list_secrets_config = parent_rpcs.list_secrets if parent_rpcs.respond_to? :list_secrets
                  @list_secrets = ::Gapic::Config::Method.new list_secrets_config
                  create_secret_config = parent_rpcs.create_secret if parent_rpcs.respond_to? :create_secret
                  @create_secret = ::Gapic::Config::Method.new create_secret_config
                  add_secret_version_config = parent_rpcs.add_secret_version if parent_rpcs.respond_to? :add_secret_version
                  @add_secret_version = ::Gapic::Config::Method.new add_secret_version_config
                  get_secret_config = parent_rpcs.get_secret if parent_rpcs.respond_to? :get_secret
                  @get_secret = ::Gapic::Config::Method.new get_secret_config
                  update_secret_config = parent_rpcs.update_secret if parent_rpcs.respond_to? :update_secret
                  @update_secret = ::Gapic::Config::Method.new update_secret_config
                  delete_secret_config = parent_rpcs.delete_secret if parent_rpcs.respond_to? :delete_secret
                  @delete_secret = ::Gapic::Config::Method.new delete_secret_config
                  list_secret_versions_config = parent_rpcs.list_secret_versions if parent_rpcs.respond_to? :list_secret_versions
                  @list_secret_versions = ::Gapic::Config::Method.new list_secret_versions_config
                  get_secret_version_config = parent_rpcs.get_secret_version if parent_rpcs.respond_to? :get_secret_version
                  @get_secret_version = ::Gapic::Config::Method.new get_secret_version_config
                  access_secret_version_config = parent_rpcs.access_secret_version if parent_rpcs.respond_to? :access_secret_version
                  @access_secret_version = ::Gapic::Config::Method.new access_secret_version_config
                  disable_secret_version_config = parent_rpcs.disable_secret_version if parent_rpcs.respond_to? :disable_secret_version
                  @disable_secret_version = ::Gapic::Config::Method.new disable_secret_version_config
                  enable_secret_version_config = parent_rpcs.enable_secret_version if parent_rpcs.respond_to? :enable_secret_version
                  @enable_secret_version = ::Gapic::Config::Method.new enable_secret_version_config
                  destroy_secret_version_config = parent_rpcs.destroy_secret_version if parent_rpcs.respond_to? :destroy_secret_version
                  @destroy_secret_version = ::Gapic::Config::Method.new destroy_secret_version_config
                  set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                  @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                  get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                  @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                  test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                  @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
