# Release History

### 0.19.1 (2025-10-27)

#### Documentation

* add warning about loading unvalidated credentials 

### 0.19.0 (2025-09-11)

#### Features

* update gapic-common dependency for generated libraries to 1.2 which requires google-protobuf v4.26+ ([#31011](https://github.com/googleapis/google-cloud-ruby/issues/31011)) 

### 0.18.0 (2025-05-12)

#### Features

* Updated core dependencies including gapic-common 
* Updated required Ruby version to 3.1 

### 0.17.2 (2025-04-29)

#### Bug Fixes

* Fixed several issues with validating credential configs 

### 0.17.1 (2025-04-21)

#### Documentation

* various documentation clarifications ([#29446](https://github.com/googleapis/google-cloud-ruby/issues/29446)) 

### 0.17.0 (2025-01-28)

#### Features

* Update Ruby version requirement to 3.0 
#### Documentation

* Clarify behavior of protobuf message fields that are part of mutually-exclusive sets 
* Include note about validating externally-provided credentials 

### 0.16.0 (2024-12-10)

#### Features

* Provide opt-in debug logging 

### 0.15.1 (2024-08-30)

#### Documentation

* Add field `experimental_features` to message `PythonSettings` ([#27011](https://github.com/googleapis/google-cloud-ruby/issues/27011)) 

### 0.15.0 (2024-02-26)

#### Features

* Updated minimum Ruby version to 2.7 ([#24876](https://github.com/googleapis/google-cloud-ruby/issues/24876)) 

### 0.14.2 (2024-02-01)

#### Bug Fixes

* Eliminated a harmless but annoying warning in the protobuf class files 

### 0.14.1 (2024-01-12)

#### Bug Fixes

* Ensure endpoints are correct for mixin clients ([#24032](https://github.com/googleapis/google-cloud-ruby/issues/24032)) 

### 0.14.0 (2024-01-11)

#### Features

* Support for universe_domain ([#23785](https://github.com/googleapis/google-cloud-ruby/issues/23785)) 

### 0.13.0 (2023-09-12)

#### Features

* Support for channel pool configuration ([#22923](https://github.com/googleapis/google-cloud-ruby/issues/22923)) 

### 0.12.2 (2023-08-04)

#### Documentation

* Improve documentation format ([#22684](https://github.com/googleapis/google-cloud-ruby/issues/22684)) 

### 0.12.1 (2023-06-06)

#### Bug Fixes

* Don't use self-signed JWT credentials if the global configuration endpoint has been modified 

### 0.12.0 (2023-05-31)

#### Features

* Uses binary protobuf definitions for better forward compatibility ([#21678](https://github.com/googleapis/google-cloud-ruby/issues/21678)) 

### 0.11.0 (2023-03-08)

#### Features

* Support REST transport ([#20628](https://github.com/googleapis/google-cloud-ruby/issues/20628)) 

### 0.10.0 (2022-07-07)

#### Features

* Updated minimum Ruby version to 2.6 ([#18443](https://github.com/googleapis/google-cloud-ruby/issues/18443)) 

### 0.9.0 (2022-04-20)

#### Features

* Support for update masks when setting IAM policies

### 0.8.5 / 2022-01-11

#### Documentation

* Fix titles of documentation pages
* Remove some broken images and fix outdated content in authentication documentation

### 0.8.4 / 2021-11-08

#### Documentation

* Added simple code snippets to RPC method documentation

### 0.8.3 / 2021-08-11

#### Bug Fixes

* Honor client-level timeout configuration

### 0.8.2 / 2021-07-12

#### Documentation

* Clarify some language around authentication configuration

### 0.8.1 / 2021-06-17

#### Bug Fixes

* Support future 1.x versions of gapic-common

### 0.8.0 / 2021-03-08

#### Features

* Drop support for Ruby 2.4 and add support for Ruby 3.0

### 0.7.0 / 2021-02-03

#### Features

* Use self-signed JWT credentials when possible

### 0.6.6 / 2021-01-19

#### Documentation

* Timeout config description correctly gives the units as seconds.

### 0.6.5 / 2020-08-10

#### Bug Fixes

* Allow special symbolic credentials in client configs

### 0.6.4 / 2020-08-06

#### Bug Fixes

* Fix retry logic by checking the correct numeric error codes

### 0.6.3 / 2020-06-18

#### Documentation

* Add documentation and API enablement links to the readme

### 0.6.2 / 2020-06-05

#### Bug Fixes

* Eliminate a Ruby warning that appeared in some cases when accessing rpc-scoped configs

### 0.6.1 / 2020-05-26

#### Bug Fixes

* Removed unused google/cloud/common_resources_pb file

### 0.6.0 / 2020-05-20

#### Features

* The quota_project can be set via configuration

### 0.5.2 / 2020-05-07

#### Documentation

* Annotate several additional fields/arguments as required.

### 0.5.1 / 2020-05-05

#### Documentation

* Clarify that timeouts are in seconds.

### 0.5.0 / 2020-04-13

#### Features

* Support additional IAM features, and other updates.
  * Added support for IAM policy options.
  * Added support for IAM policy binding conditions.
  * Added support for IAM audit config deltas.
  * Expanded the readme to include quickstart and logging information.
  * Added documentation for package and service modules.
  * Fixed and expanded documentation for the two method calling conventions.
  * Fixed some circular require warnings.

### 0.4.1 / 2020-04-01

#### Documentation

* Update documentation for core proto types.

### 0.4.0 / 2020-03-25

#### Features

* Path helpers can be called as module functions

#### Documentation

* Expansion and cleanup of service description text

### 0.3.0 / 2020-03-18

* Support separate project setting for quota/billing
* Include the correct default timeout and retry settings
* Eliminate some Ruby 2.7 keyword argument warnings
* Fix some formatting issues in the inline documentation

### 0.2.3 / 2020-03-04

#### Documentation

* Add Configuration docs and update enum return types

### 0.2.2 / 2020-02-24

#### Documentation

* Update homepage in README and gemspec

### 0.2.1 / 2020-02-06

#### Documentation

* Fix type declarations for repeated fields
* Update docs for common FieldMask and Timestamp types

### 0.2.0 / 2020-01-17

#### Features

* Provide resource path helpers

### 0.1.0 / 2020-01-09

* Initial release.
