# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/scheduler/v1/cloudscheduler_pb"
require "google/cloud/scheduler/v1/cloud_scheduler/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Scheduler
      module V1
        module CloudScheduler
          module Rest
            ##
            # REST client for the CloudScheduler service.
            #
            # The Cloud Scheduler API allows external entities to reliably
            # schedule asynchronous jobs.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudscheduler.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_scheduler_stub

              ##
              # Configure the CloudScheduler Client class.
              #
              # See {::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudScheduler clients
              #   ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Scheduler", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_jobs.timeout = 600.0
                  default_config.rpcs.list_jobs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_job.timeout = 600.0
                  default_config.rpcs.get_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_job.timeout = 600.0

                  default_config.rpcs.update_job.timeout = 600.0

                  default_config.rpcs.delete_job.timeout = 600.0
                  default_config.rpcs.delete_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.pause_job.timeout = 600.0

                  default_config.rpcs.resume_job.timeout = 600.0

                  default_config.rpcs.run_job.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudScheduler Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_scheduler_stub.universe_domain
              end

              ##
              # Create a new CloudScheduler REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudScheduler client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @cloud_scheduler_stub = ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_scheduler_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_scheduler_stub.endpoint
                  config.universe_domain = @cloud_scheduler_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cloud_scheduler_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_scheduler_stub.logger
              end

              # Service calls

              ##
              # Lists jobs.
              #
              # @overload list_jobs(request, options = nil)
              #   Pass arguments to `list_jobs` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::ListJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::ListJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_jobs(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID`.
              #   @param page_size [::Integer]
              #     Requested page size.
              #
              #     The maximum page size is 500. If unspecified, the page size will
              #     be the maximum. Fewer jobs than requested might be returned,
              #     even if more jobs exist; use next_page_token to determine if more
              #     jobs exist.
              #   @param page_token [::String]
              #     A token identifying a page of results the server will return. To
              #     request the first page results, page_token must be empty. To
              #     request the next page of results, page_token must be the value of
              #     {::Google::Cloud::Scheduler::V1::ListJobsResponse#next_page_token next_page_token}
              #     returned from the previous call to
              #     {::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client#list_jobs ListJobs}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Scheduler::V1::Job>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Scheduler::V1::Job>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::ListJobsRequest.new
              #
              #   # Call the list_jobs method.
              #   result = client.list_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Scheduler::V1::Job.
              #     p item
              #   end
              #
              def list_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::ListJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.list_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_scheduler_stub, :list_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a job.
              #
              # @overload get_job(request, options = nil)
              #   Pass arguments to `get_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::GetJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::GetJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job(name: nil)
              #   Pass arguments to `get_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The job name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::GetJobRequest.new
              #
              #   # Call the get_job method.
              #   result = client.get_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def get_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::GetJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.get_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a job.
              #
              # @overload create_job(request, options = nil)
              #   Pass arguments to `create_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::CreateJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::CreateJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_job(parent: nil, job: nil)
              #   Pass arguments to `create_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID`.
              #   @param job [::Google::Cloud::Scheduler::V1::Job, ::Hash]
              #     Required. The job to add. The user can optionally specify a name for the
              #     job in {::Google::Cloud::Scheduler::V1::Job#name name}.
              #     {::Google::Cloud::Scheduler::V1::Job#name name} cannot be the same as an
              #     existing job. If a name is not specified then the system will
              #     generate a random unique name that will be returned
              #     ({::Google::Cloud::Scheduler::V1::Job#name name}) in the response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::CreateJobRequest.new
              #
              #   # Call the create_job method.
              #   result = client.create_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def create_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::CreateJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.create_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a job.
              #
              # If successful, the updated {::Google::Cloud::Scheduler::V1::Job Job} is
              # returned. If the job does not exist, `NOT_FOUND` is returned.
              #
              # If UpdateJob does not successfully return, it is possible for the
              # job to be in an
              # {::Google::Cloud::Scheduler::V1::Job::State::UPDATE_FAILED Job.State.UPDATE_FAILED}
              # state. A job in this state may not be executed. If this happens, retry the
              # UpdateJob request until a successful response is received.
              #
              # @overload update_job(request, options = nil)
              #   Pass arguments to `update_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::UpdateJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::UpdateJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_job(job: nil, update_mask: nil)
              #   Pass arguments to `update_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param job [::Google::Cloud::Scheduler::V1::Job, ::Hash]
              #     Required. The new job properties.
              #     {::Google::Cloud::Scheduler::V1::Job#name name} must be specified.
              #
              #     Output only fields cannot be modified using UpdateJob.
              #     Any value specified for an output only field will be ignored.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     A  mask used to specify which fields of the job are being updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::UpdateJobRequest.new
              #
              #   # Call the update_job method.
              #   result = client.update_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def update_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::UpdateJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.update_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a job.
              #
              # @overload delete_job(request, options = nil)
              #   Pass arguments to `delete_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::DeleteJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::DeleteJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_job(name: nil)
              #   Pass arguments to `delete_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The job name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::DeleteJobRequest.new
              #
              #   # Call the delete_job method.
              #   result = client.delete_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::DeleteJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.delete_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses a job.
              #
              # If a job is paused then the system will stop executing the job
              # until it is re-enabled via
              # {::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client#resume_job ResumeJob}. The state
              # of the job is stored in {::Google::Cloud::Scheduler::V1::Job#state state}; if
              # paused it will be set to
              # {::Google::Cloud::Scheduler::V1::Job::State::PAUSED Job.State.PAUSED}. A job must
              # be in {::Google::Cloud::Scheduler::V1::Job::State::ENABLED Job.State.ENABLED} to
              # be paused.
              #
              # @overload pause_job(request, options = nil)
              #   Pass arguments to `pause_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::PauseJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::PauseJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_job(name: nil)
              #   Pass arguments to `pause_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The job name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::PauseJobRequest.new
              #
              #   # Call the pause_job method.
              #   result = client.pause_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def pause_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::PauseJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.pause_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resume a job.
              #
              # This method reenables a job after it has been
              # {::Google::Cloud::Scheduler::V1::Job::State::PAUSED Job.State.PAUSED}. The state
              # of a job is stored in {::Google::Cloud::Scheduler::V1::Job#state Job.state};
              # after calling this method it will be set to
              # {::Google::Cloud::Scheduler::V1::Job::State::ENABLED Job.State.ENABLED}. A job
              # must be in {::Google::Cloud::Scheduler::V1::Job::State::PAUSED Job.State.PAUSED}
              # to be resumed.
              #
              # @overload resume_job(request, options = nil)
              #   Pass arguments to `resume_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::ResumeJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::ResumeJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_job(name: nil)
              #   Pass arguments to `resume_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The job name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::ResumeJobRequest.new
              #
              #   # Call the resume_job method.
              #   result = client.resume_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def resume_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::ResumeJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.resume_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Forces a job to run now.
              #
              # When this method is called, Cloud Scheduler will dispatch the job, even
              # if the job is already running.
              #
              # @overload run_job(request, options = nil)
              #   Pass arguments to `run_job` via a request object, either of type
              #   {::Google::Cloud::Scheduler::V1::RunJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Scheduler::V1::RunJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_job(name: nil)
              #   Pass arguments to `run_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The job name. For example:
              #     `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Scheduler::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Scheduler::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/scheduler/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Scheduler::V1::RunJobRequest.new
              #
              #   # Call the run_job method.
              #   result = client.run_job request
              #
              #   # The returned object is of type Google::Cloud::Scheduler::V1::Job.
              #   p result
              #
              def run_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Scheduler::V1::RunJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Scheduler::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_scheduler_stub.run_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudScheduler REST API.
              #
              # This class represents the configuration for CloudScheduler REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_jobs to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_jobs.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Scheduler::V1::CloudScheduler::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_jobs.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudscheduler.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudScheduler API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_jobs
                  ##
                  # RPC-specific configuration for `get_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job
                  ##
                  # RPC-specific configuration for `create_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_job
                  ##
                  # RPC-specific configuration for `update_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_job
                  ##
                  # RPC-specific configuration for `delete_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_job
                  ##
                  # RPC-specific configuration for `pause_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_job
                  ##
                  # RPC-specific configuration for `resume_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_job
                  ##
                  # RPC-specific configuration for `run_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_job

                  # @private
                  def initialize parent_rpcs = nil
                    list_jobs_config = parent_rpcs.list_jobs if parent_rpcs.respond_to? :list_jobs
                    @list_jobs = ::Gapic::Config::Method.new list_jobs_config
                    get_job_config = parent_rpcs.get_job if parent_rpcs.respond_to? :get_job
                    @get_job = ::Gapic::Config::Method.new get_job_config
                    create_job_config = parent_rpcs.create_job if parent_rpcs.respond_to? :create_job
                    @create_job = ::Gapic::Config::Method.new create_job_config
                    update_job_config = parent_rpcs.update_job if parent_rpcs.respond_to? :update_job
                    @update_job = ::Gapic::Config::Method.new update_job_config
                    delete_job_config = parent_rpcs.delete_job if parent_rpcs.respond_to? :delete_job
                    @delete_job = ::Gapic::Config::Method.new delete_job_config
                    pause_job_config = parent_rpcs.pause_job if parent_rpcs.respond_to? :pause_job
                    @pause_job = ::Gapic::Config::Method.new pause_job_config
                    resume_job_config = parent_rpcs.resume_job if parent_rpcs.respond_to? :resume_job
                    @resume_job = ::Gapic::Config::Method.new resume_job_config
                    run_job_config = parent_rpcs.run_job if parent_rpcs.respond_to? :run_job
                    @run_job = ::Gapic::Config::Method.new run_job_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
