# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/saas_platform/saas_service_mgmt"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::SaasPlatform::SaasServiceMgmt::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_saas_deployments_grpc
    skip unless Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_deployments_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_deployments transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client, client
    end
  end

  def test_saas_deployments_rest
    skip unless Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_deployments_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_deployments transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client, client
    end
  end

  def test_saas_rollouts_grpc
    skip unless Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_rollouts_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_rollouts transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client, client
    end
  end

  def test_saas_rollouts_rest
    skip unless Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_rollouts_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::SaasPlatform::SaasServiceMgmt.saas_rollouts transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client, client
    end
  end
end
