# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/saasplatform/saasservicemgmt/v1beta1/rollouts_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_rollouts"

class ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_rollouts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rollouts, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rollouts_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rollouts ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rollouts(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rollouts_client_stub.call_rpc_count
    end
  end

  def test_get_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rollout, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rollout({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rollout name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rollout({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rollout_client_stub.call_rpc_count
    end
  end

  def test_create_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_id = "hello world"
    rollout = {}
    validate_only = true
    request_id = "hello world"

    create_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rollout, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["rollout_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout), request["rollout"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rollout parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rollout_client_stub.call_rpc_count
    end
  end

  def test_update_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rollout = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rollout, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout), request["rollout"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rollout({ rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rollout rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest.new(rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rollout({ rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest.new(rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rollout_client_stub.call_rpc_count
    end
  end

  def test_delete_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rollout, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rollout({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rollout name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rollout({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rollout_client_stub.call_rpc_count
    end
  end

  def test_list_rollout_kinds
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollout_kinds_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rollout_kinds, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rollout_kinds_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rollout_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rollout_kinds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rollout_kinds ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rollout_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rollout_kinds(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rollout_kinds_client_stub.call_rpc_count
    end
  end

  def test_get_rollout_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rollout_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rollout_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rollout_kind({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rollout_kind name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rollout_kind({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rollout_kind_client_stub.call_rpc_count
    end
  end

  def test_create_rollout_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_kind_id = "hello world"
    rollout_kind = {}
    validate_only = true
    request_id = "hello world"

    create_rollout_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rollout_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["rollout_kind_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind), request["rollout_kind"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rollout_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rollout_kind({ parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rollout_kind parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest.new(parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rollout_kind({ parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest.new(parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rollout_kind_client_stub.call_rpc_count
    end
  end

  def test_update_rollout_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rollout_kind = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_rollout_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rollout_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind), request["rollout_kind"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rollout_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rollout_kind({ rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rollout_kind rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest.new(rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rollout_kind({ rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest.new(rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rollout_kind_client_stub.call_rpc_count
    end
  end

  def test_delete_rollout_kind
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_rollout_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rollout_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rollout_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rollout_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rollout_kind name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rollout_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rollout_kind_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
