# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/saasplatform/saasservicemgmt/v1beta1/rollouts_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_rollouts/rest"


class ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_rollouts
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_list_rollouts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rollouts_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rollouts ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rollouts(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rollouts_client_stub.call_count
      end
    end
  end

  def test_get_rollout
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_get_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rollout({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rollout name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rollout({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rollout_client_stub.call_count
      end
    end
  end

  def test_create_rollout
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_id = "hello world"
    rollout = {}
    validate_only = true
    request_id = "hello world"

    create_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_create_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rollout parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rollout_client_stub.call_count
      end
    end
  end

  def test_update_rollout
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rollout = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_update_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_rollout({ rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_rollout rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest.new(rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_rollout({ rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest.new(rollout: rollout, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_rollout_client_stub.call_count
      end
    end
  end

  def test_delete_rollout
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_delete_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rollout({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rollout name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rollout ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rollout({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rollout(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rollout_client_stub.call_count
      end
    end
  end

  def test_list_rollout_kinds
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollout_kinds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_list_rollout_kinds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rollout_kinds_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rollout_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rollout_kinds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rollout_kinds ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rollout_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rollout_kinds(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rollout_kinds_client_stub.call_count
      end
    end
  end

  def test_get_rollout_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_get_rollout_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rollout_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rollout_kind({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rollout_kind name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rollout_kind({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rollout_kind_client_stub.call_count
      end
    end
  end

  def test_create_rollout_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_kind_id = "hello world"
    rollout_kind = {}
    validate_only = true
    request_id = "hello world"

    create_rollout_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_create_rollout_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rollout_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rollout_kind({ parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rollout_kind parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest.new(parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rollout_kind({ parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest.new(parent: parent, rollout_kind_id: rollout_kind_id, rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rollout_kind_client_stub.call_count
      end
    end
  end

  def test_update_rollout_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rollout_kind = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_rollout_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_update_rollout_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_rollout_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_rollout_kind({ rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_rollout_kind rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest.new(rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_rollout_kind({ rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest.new(rollout_kind: rollout_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_rollout_kind_client_stub.call_count
      end
    end
  end

  def test_delete_rollout_kind
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_rollout_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.stub :transcode_delete_rollout_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rollout_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rollout_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rollout_kind name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rollout_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rollout_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rollout_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rollout_kind_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client::Configuration, config
  end
end
