# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_rollouts"

class ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_release_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.release_path project: "value0", location: "value1", release: "value2"
      assert_equal "projects/value0/locations/value1/releases/value2", path
    end
  end

  def test_rollout_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.rollout_path project: "value0", location: "value1", rollout_id: "value2"
      assert_equal "projects/value0/locations/value1/rollouts/value2", path
    end
  end

  def test_rollout_kind_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.rollout_kind_path project: "value0", location: "value1", rollout_kind_id: "value2"
      assert_equal "projects/value0/locations/value1/rolloutKinds/value2", path
    end
  end

  def test_unit_kind_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.unit_kind_path project: "value0", location: "value1", unit_kind: "value2"
      assert_equal "projects/value0/locations/value1/unitKinds/value2", path
    end
  end
end
