# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/saasplatform/saasservicemgmt/v1beta1/deployments_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments"

class ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_saas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_saas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_saas, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_saas_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_saas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_saas parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_saas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_saas_client_stub.call_rpc_count
    end
  end

  def test_get_saas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_saas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_saas, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_saas_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_saas({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_saas name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_saas({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_saas_client_stub.call_rpc_count
    end
  end

  def test_create_saas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    saas_id = "hello world"
    saas = {}
    validate_only = true
    request_id = "hello world"

    create_saas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_saas, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["saas_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas), request["saas"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_saas_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_saas({ parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_saas parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest.new(parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_saas({ parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest.new(parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_saas_client_stub.call_rpc_count
    end
  end

  def test_update_saas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    saas = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_saas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_saas, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas), request["saas"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_saas_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_saas({ saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_saas saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest.new(saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_saas({ saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest.new(saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_saas_client_stub.call_rpc_count
    end
  end

  def test_delete_saas
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_saas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_saas, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_saas_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_saas({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_saas name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_saas({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_saas_client_stub.call_rpc_count
    end
  end

  def test_list_tenants
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_tenants_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tenants, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tenants_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tenants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tenants parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tenants ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tenants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tenants(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tenants_client_stub.call_rpc_count
    end
  end

  def test_get_tenant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tenant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tenant, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tenant_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tenant({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tenant name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tenant({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tenant_client_stub.call_rpc_count
    end
  end

  def test_create_tenant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tenant_id = "hello world"
    tenant = {}
    validate_only = true
    request_id = "hello world"

    create_tenant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tenant, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["tenant_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant), request["tenant"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tenant_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tenant({ parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tenant parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest.new(parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tenant({ parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest.new(parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tenant_client_stub.call_rpc_count
    end
  end

  def test_update_tenant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tenant = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_tenant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tenant, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant), request["tenant"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tenant_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tenant({ tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tenant tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest.new(tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tenant({ tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest.new(tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tenant_client_stub.call_rpc_count
    end
  end

  def test_delete_tenant
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_tenant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tenant, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tenant_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tenant({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tenant name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tenant({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tenant_client_stub.call_rpc_count
    end
  end

  def test_list_unit_kinds
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_unit_kinds_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_unit_kinds, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_unit_kinds_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_unit_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_unit_kinds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_unit_kinds ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_unit_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_unit_kinds(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_unit_kinds_client_stub.call_rpc_count
    end
  end

  def test_get_unit_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_unit_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_unit_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_unit_kind({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_unit_kind name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_unit_kind({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_unit_kind_client_stub.call_rpc_count
    end
  end

  def test_create_unit_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_kind_id = "hello world"
    unit_kind = {}
    validate_only = true
    request_id = "hello world"

    create_unit_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_unit_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["unit_kind_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind), request["unit_kind"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_unit_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_unit_kind({ parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_unit_kind parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest.new(parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_unit_kind({ parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest.new(parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_unit_kind_client_stub.call_rpc_count
    end
  end

  def test_update_unit_kind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    unit_kind = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_unit_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind), request["unit_kind"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_unit_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_unit_kind({ unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_unit_kind unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest.new(unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_unit_kind({ unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest.new(unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_unit_kind_client_stub.call_rpc_count
    end
  end

  def test_delete_unit_kind
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_kind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_unit_kind, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_unit_kind_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_unit_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_unit_kind name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_unit_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_unit_kind_client_stub.call_rpc_count
    end
  end

  def test_list_units
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_units_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_units, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_units_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_units({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_units parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_units ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_units({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_units(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_units_client_stub.call_rpc_count
    end
  end

  def test_get_unit
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_unit, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_unit_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_unit({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_unit name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_unit({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_unit_client_stub.call_rpc_count
    end
  end

  def test_create_unit
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_id = "hello world"
    unit = {}
    validate_only = true
    request_id = "hello world"

    create_unit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_unit, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["unit_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit), request["unit"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_unit_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_unit({ parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_unit parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest.new(parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_unit({ parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest.new(parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_unit_client_stub.call_rpc_count
    end
  end

  def test_update_unit
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    unit = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_unit, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit), request["unit"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_unit_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_unit({ unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_unit unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest.new(unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_unit({ unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest.new(unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_unit_client_stub.call_rpc_count
    end
  end

  def test_delete_unit
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_unit, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_unit_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_unit({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_unit name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_unit({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_unit_client_stub.call_rpc_count
    end
  end

  def test_list_unit_operations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_unit_operations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_unit_operations, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_unit_operations_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_unit_operations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_unit_operations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_unit_operations ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_unit_operations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_unit_operations(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_unit_operations_client_stub.call_rpc_count
    end
  end

  def test_get_unit_operation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_unit_operation, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_unit_operation_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_unit_operation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_unit_operation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_unit_operation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_unit_operation_client_stub.call_rpc_count
    end
  end

  def test_create_unit_operation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_operation_id = "hello world"
    unit_operation = {}
    validate_only = true
    request_id = "hello world"

    create_unit_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_unit_operation, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["unit_operation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation), request["unit_operation"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_unit_operation_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_unit_operation({ parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_unit_operation parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest.new(parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_unit_operation({ parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest.new(parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_unit_operation_client_stub.call_rpc_count
    end
  end

  def test_update_unit_operation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    unit_operation = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_unit_operation, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation), request["unit_operation"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_unit_operation_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_unit_operation({ unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_unit_operation unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest.new(unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_unit_operation({ unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest.new(unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_unit_operation_client_stub.call_rpc_count
    end
  end

  def test_delete_unit_operation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_operation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_unit_operation, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_unit_operation_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_unit_operation({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_unit_operation name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_unit_operation({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_unit_operation_client_stub.call_rpc_count
    end
  end

  def test_list_releases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_releases, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_releases_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_releases ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_releases(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_releases_client_stub.call_rpc_count
    end
  end

  def test_get_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_release, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_release_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_release({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_release name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_release({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_release_client_stub.call_rpc_count
    end
  end

  def test_create_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    validate_only = true
    request_id = "hello world"

    create_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_release, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["release_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release), request["release"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_release_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_release({ parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_release parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_release({ parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_release_client_stub.call_rpc_count
    end
  end

  def test_update_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    release = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_release, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release), request["release"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_release_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_release({ release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_release release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest.new(release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_release({ release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest.new(release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_release_client_stub.call_rpc_count
    end
  end

  def test_delete_release
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_release, name
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_release_client_stub do
      # Create client
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_release({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_release name: name, etag: etag, validate_only: validate_only, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_release({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_release_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
