# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/saasplatform/saasservicemgmt/v1beta1/deployments_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/rest"


class ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_saas
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_saas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_saas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_saas_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_saas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_saas parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_saas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_saas_client_stub.call_count
      end
    end
  end

  def test_get_saas
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_saas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_saas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_saas_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_saas({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_saas name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_saas({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_saas_client_stub.call_count
      end
    end
  end

  def test_create_saas
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    saas_id = "hello world"
    saas = {}
    validate_only = true
    request_id = "hello world"

    create_saas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_saas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_saas_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_saas({ parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_saas parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest.new(parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_saas({ parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest.new(parent: parent, saas_id: saas_id, saas: saas, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_saas_client_stub.call_count
      end
    end
  end

  def test_update_saas
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    saas = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_saas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_saas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_saas_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_saas({ saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_saas saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest.new(saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_saas({ saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest.new(saas: saas, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_saas_client_stub.call_count
      end
    end
  end

  def test_delete_saas
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_saas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_saas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_saas_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_saas({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_saas name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_saas ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_saas({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_saas(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_saas_client_stub.call_count
      end
    end
  end

  def test_list_tenants
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_tenants_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_tenants_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tenants_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tenants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tenants parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tenants ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tenants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tenants(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tenants_client_stub.call_count
      end
    end
  end

  def test_get_tenant
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tenant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_tenant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tenant_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tenant({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tenant name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tenant({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tenant_client_stub.call_count
      end
    end
  end

  def test_create_tenant
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tenant_id = "hello world"
    tenant = {}
    validate_only = true
    request_id = "hello world"

    create_tenant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_tenant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tenant_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tenant({ parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tenant parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest.new(parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tenant({ parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest.new(parent: parent, tenant_id: tenant_id, tenant: tenant, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tenant_client_stub.call_count
      end
    end
  end

  def test_update_tenant
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tenant = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_tenant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_tenant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tenant_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tenant({ tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tenant tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest.new(tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tenant({ tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest.new(tenant: tenant, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tenant_client_stub.call_count
      end
    end
  end

  def test_delete_tenant
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_tenant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_tenant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tenant_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tenant({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tenant name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tenant ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tenant({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tenant(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tenant_client_stub.call_count
      end
    end
  end

  def test_list_unit_kinds
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_unit_kinds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_unit_kinds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_unit_kinds_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_unit_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_unit_kinds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_unit_kinds ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_unit_kinds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_unit_kinds(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_unit_kinds_client_stub.call_count
      end
    end
  end

  def test_get_unit_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_unit_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_unit_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_unit_kind({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_unit_kind name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_unit_kind({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_unit_kind_client_stub.call_count
      end
    end
  end

  def test_create_unit_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_kind_id = "hello world"
    unit_kind = {}
    validate_only = true
    request_id = "hello world"

    create_unit_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_unit_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_unit_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_unit_kind({ parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_unit_kind parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest.new(parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_unit_kind({ parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest.new(parent: parent, unit_kind_id: unit_kind_id, unit_kind: unit_kind, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_unit_kind_client_stub.call_count
      end
    end
  end

  def test_update_unit_kind
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    unit_kind = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_unit_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_unit_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_unit_kind({ unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_unit_kind unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest.new(unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_unit_kind({ unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest.new(unit_kind: unit_kind, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_unit_kind_client_stub.call_count
      end
    end
  end

  def test_delete_unit_kind
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_kind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_unit_kind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_unit_kind_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_unit_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_unit_kind name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_unit_kind ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_unit_kind({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_unit_kind(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_unit_kind_client_stub.call_count
      end
    end
  end

  def test_list_units
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_units_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_units_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_units_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_units({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_units parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_units ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_units({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_units(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_units_client_stub.call_count
      end
    end
  end

  def test_get_unit
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_unit_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_unit_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_unit({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_unit name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_unit({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_unit_client_stub.call_count
      end
    end
  end

  def test_create_unit
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_id = "hello world"
    unit = {}
    validate_only = true
    request_id = "hello world"

    create_unit_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_unit_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_unit_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_unit({ parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_unit parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest.new(parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_unit({ parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest.new(parent: parent, unit_id: unit_id, unit: unit, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_unit_client_stub.call_count
      end
    end
  end

  def test_update_unit
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    unit = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_unit_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_unit_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_unit({ unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_unit unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest.new(unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_unit({ unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest.new(unit: unit, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_unit_client_stub.call_count
      end
    end
  end

  def test_delete_unit
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_unit_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_unit_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_unit({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_unit name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_unit ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_unit({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_unit(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_unit_client_stub.call_count
      end
    end
  end

  def test_list_unit_operations
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_unit_operations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_unit_operations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_unit_operations_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_unit_operations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_unit_operations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_unit_operations ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_unit_operations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_unit_operations(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_unit_operations_client_stub.call_count
      end
    end
  end

  def test_get_unit_operation
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_unit_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_unit_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_unit_operation_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_unit_operation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_unit_operation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_unit_operation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_unit_operation_client_stub.call_count
      end
    end
  end

  def test_create_unit_operation
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    unit_operation_id = "hello world"
    unit_operation = {}
    validate_only = true
    request_id = "hello world"

    create_unit_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_unit_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_unit_operation_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_unit_operation({ parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_unit_operation parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest.new(parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_unit_operation({ parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest.new(parent: parent, unit_operation_id: unit_operation_id, unit_operation: unit_operation, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_unit_operation_client_stub.call_count
      end
    end
  end

  def test_update_unit_operation
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    unit_operation = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_unit_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_unit_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_unit_operation_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_unit_operation({ unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_unit_operation unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest.new(unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_unit_operation({ unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest.new(unit_operation: unit_operation, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_unit_operation_client_stub.call_count
      end
    end
  end

  def test_delete_unit_operation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_unit_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_unit_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_unit_operation_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_unit_operation({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_unit_operation name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_unit_operation ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_unit_operation({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_unit_operation(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_unit_operation_client_stub.call_count
      end
    end
  end

  def test_list_releases
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_list_releases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_releases_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_releases ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_releases(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_releases_client_stub.call_count
      end
    end
  end

  def test_get_release
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_get_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_release_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_release({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_release name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_release({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_release_client_stub.call_count
      end
    end
  end

  def test_create_release
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    validate_only = true
    request_id = "hello world"

    create_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_create_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_release_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_release({ parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_release parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_release({ parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_release_client_stub.call_count
      end
    end
  end

  def test_update_release
    # Create test objects.
    client_result = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    release = {}
    validate_only = true
    request_id = "hello world"
    update_mask = {}

    update_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_update_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_release_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_release({ release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_release release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest.new(release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_release({ release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest.new(release: release, validate_only: validate_only, request_id: request_id, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_release_client_stub.call_count
      end
    end
  end

  def test_delete_release
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    request_id = "hello world"

    delete_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.stub :transcode_delete_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_release_client_stub do
        # Create client
        client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_release({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_release name: name, etag: etag, validate_only: validate_only, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_release ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_release({ name: name, etag: etag, validate_only: validate_only, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_release(::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest.new(name: name, etag: etag, validate_only: validate_only, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_release_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client::Configuration, config
  end
end
