# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          # The request structure for the ListRollouts method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the rollout.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of rollouts to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListRolloutsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListRollouts method.
          # @!attribute [rw] rollouts
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout>]
          #     The resulting rollouts.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListRollouts call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListRolloutsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetRollout method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetRolloutRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateRollout method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the rollout.
          # @!attribute [rw] rollout_id
          #   @return [::String]
          #     Required. The ID value for the new rollout.
          # @!attribute [rw] rollout
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
          #     Required. The desired state for the rollout.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateRolloutRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateRollout method.
          # @!attribute [rw] rollout
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
          #     Required. The desired state for the rollout.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     Rollout resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     Rollout will be overwritten.
          class UpdateRolloutRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteRollout method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the rollout. This is
          #     used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the rollout. The Any wildcard (`*`) requires that the resource
          #     must already exists, and the Not Any wildcard (`!*`) requires that it must
          #     not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteRolloutRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListRolloutKinds method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the rollout kind.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of rollout kinds to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListRolloutKindsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListRolloutKinds method.
          # @!attribute [rw] rollout_kinds
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind>]
          #     The resulting rollout kinds.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListRolloutKinds call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListRolloutKindsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetRolloutKind method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetRolloutKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateRolloutKind method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the rollout kind.
          # @!attribute [rw] rollout_kind_id
          #   @return [::String]
          #     Required. The ID value for the new rollout kind.
          # @!attribute [rw] rollout_kind
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
          #     Required. The desired state for the rollout kind.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateRolloutKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateRolloutKind method.
          # @!attribute [rw] rollout_kind
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
          #     Required. The desired state for the rollout kind.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     RolloutKind resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     RolloutKind will be overwritten.
          class UpdateRolloutKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteRolloutKind method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the rollout kind.
          #     This is used with state-changing methods to prevent accidental overwrites
          #     when multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the rollout kind. The Any wildcard (`*`) requires that the
          #     resource must already exists, and the Not Any wildcard (`!*`) requires that
          #     it must not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteRolloutKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
