# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          # Represents a single rollout execution and its results
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/rollout/\\{rollout_id}"
          # @!attribute [rw] release
          #   @return [::String]
          #     Optional. Immutable. Name of the Release that gets rolled out to target
          #     Units. Required if no other type of release is specified.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Output only. The time when the rollout started executing. Will be
          #     empty if the rollout hasn't started yet.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Output only. The time when the rollout finished execution
          #     (regardless of  success, failure, or cancellation). Will be empty if the
          #     rollout hasn't finished yet. Once set, the rollout is in terminal state and
          #     all the results are final.
          # @!attribute [r] state
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout::RolloutState]
          #     Output only. Current state of the rollout.
          # @!attribute [r] state_message
          #   @return [::String]
          #     Output only. Human readable message indicating details about the last state
          #     transition.
          # @!attribute [r] state_transition_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Output only. The time when the rollout transitioned into its
          #     current state.
          # @!attribute [r] root_rollout
          #   @return [::String]
          #     Optional. Output only. The root rollout that this rollout is stemming from.
          #     The resource name (full URI of the resource) following the standard naming
          #     scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/rollouts/\\{rollout_id}"
          # @!attribute [r] parent_rollout
          #   @return [::String]
          #     Optional. Output only. The direct parent rollout that this rollout is
          #     stemming from. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/rollouts/\\{rollout_id}"
          # @!attribute [rw] rollout_orchestration_strategy
          #   @return [::String]
          #     Optional. The strategy used for executing this Rollout.
          #     This strategy will override whatever strategy is specified in the
          #     RolloutType. If not specified on creation, the
          #     strategy from RolloutType will be used.
          #
          #     There are two supported values strategies which are used to control
          #     - "Google.Cloud.Simple.AllAtOnce"
          #     - "Google.Cloud.Simple.OneLocationAtATime"
          #
          #     A rollout with one of these simple strategies will rollout across
          #     all locations defined in the targeted UnitKind's Saas Locations.
          # @!attribute [rw] unit_filter
          #   @return [::String]
          #     Optional. CEL(https://github.com/google/cel-spec) formatted filter string
          #     against Unit. The filter will be applied to determine the eligible unit
          #     population. This filter can only reduce, but not expand the scope of the
          #     rollout. If not provided, the unit_filter from the RolloutType will be
          #     used.
          # @!attribute [rw] rollout_kind
          #   @return [::String]
          #     Optional. Immutable. Name of the RolloutKind this rollout is stemming from
          #     and adhering to.
          # @!attribute [r] stats
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutStats]
          #     Optional. Output only. Details about the progress of the rollout.
          # @!attribute [rw] control
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutControl]
          #     Optional. Requested change to the execution of this rollout.
          #     Default RolloutControl.action is ROLLOUT_ACTION_RUN meaning
          #     the rollout will be executed to completion while progressing through
          #     all natural Rollout States (such as RUNNING -> SUCCEEDED or RUNNING ->
          #     FAILED). Requests can only be made when the Rollout is in a non-terminal
          #     state.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class Rollout
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The current state of the rollout.
            module RolloutState
              # Unspecified state.
              ROLLOUT_STATE_UNSPECIFIED = 0

              # Rollout is in progress.
              ROLLOUT_STATE_RUNNING = 1

              # Rollout has been paused.
              ROLLOUT_STATE_PAUSED = 2

              # Rollout completed successfully.
              ROLLOUT_STATE_SUCCEEDED = 3

              # Rollout has failed.
              ROLLOUT_STATE_FAILED = 4

              # Rollout has been canceled.
              ROLLOUT_STATE_CANCELLED = 5

              # Rollout is waiting for some condition to be met before starting.
              ROLLOUT_STATE_WAITING = 6

              # Rollout is being canceled.
              ROLLOUT_STATE_CANCELLING = 7

              # Rollout is being resumed.
              ROLLOUT_STATE_RESUMING = 8

              # Rollout is being paused.
              ROLLOUT_STATE_PAUSING = 9
            end
          end

          # An object that describes various settings of Rollout execution. Includes
          # built-in policies across GCP and GDC, and customizable policies.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/rolloutKinds/\\{rollout_kind_id}"
          # @!attribute [rw] unit_kind
          #   @return [::String]
          #     Required. Immutable. UnitKind that this rollout kind corresponds to.
          #     Rollouts stemming from this rollout kind will target the units of this unit
          #     kind. In other words, this defines the population of target units to be
          #     upgraded by rollouts.
          # @!attribute [rw] rollout_orchestration_strategy
          #   @return [::String]
          #     Optional. The strategy used for executing a Rollout. This is a required
          #     field.
          #
          #     There are two supported values strategies which are used to control
          #     - "Google.Cloud.Simple.AllAtOnce"
          #     - "Google.Cloud.Simple.OneLocationAtATime"
          #
          #     A rollout with one of these simple strategies will rollout across
          #     all locations defined in the associated UnitKind's Saas Locations.
          # @!attribute [rw] unit_filter
          #   @return [::String]
          #     Optional. CEL(https://github.com/google/cel-spec) formatted filter string
          #     against Unit. The filter will be applied to determine the eligible unit
          #     population. This filter can only reduce, but not expand the scope of the
          #     rollout.
          # @!attribute [rw] update_unit_kind_strategy
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind::UpdateUnitKindStrategy]
          #     Optional. The config for updating the unit kind. By default, the unit kind
          #     will be updated on the rollout start.
          # @!attribute [rw] error_budget
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ErrorBudget]
          #     Optional. The configuration for error budget. If the number of failed units
          #     exceeds max(allowed_count, allowed_ratio * total_units), the rollout will
          #     be paused. If not set, all units will be attempted to be updated regardless
          #     of the number of failures encountered.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class RolloutKind
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            module UpdateUnitKindStrategy
              # Strategy unspecified.
              UPDATE_UNIT_KIND_STRATEGY_UNSPECIFIED = 0

              # Update the unit kind strategy on the rollout start.
              UPDATE_UNIT_KIND_STRATEGY_ON_START = 1

              # Never update the unit kind.
              UPDATE_UNIT_KIND_STRATEGY_NEVER = 2
            end
          end

          # The configuration for error budget. If the number of failed units exceeds
          # max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
          # @!attribute [rw] allowed_count
          #   @return [::Integer]
          #     Optional. The maximum number of failed units allowed in a location without
          #     pausing the rollout.
          # @!attribute [rw] allowed_percentage
          #   @return [::Integer]
          #     Optional. The maximum percentage of units allowed to fail (0, 100] within a
          #     location without pausing the rollout.
          class ErrorBudget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # RolloutStats contains information about the progress of a rollout.
          # @!attribute [r] operations_by_state
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Aggregate>]
          #     Output only. A breakdown of the progress of operations triggered by the
          #     rollout. Provides a count of Operations by their state. This can be used to
          #     determine the number of units which have been updated, or are scheduled to
          #     be updated.
          #
          #     There will be at most one entry per group.
          #     Possible values for operation groups are:
          #     - "SCHEDULED"
          #     - "PENDING"
          #     - "RUNNING"
          #     - "SUCCEEDED"
          #     - "FAILED"
          #     - "CANCELLED"
          class RolloutStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # RolloutControl provides a way to request a change to the execution of a
          # Rollout by pausing or canceling it.
          # @!attribute [rw] run_params
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutControl::RunRolloutActionParams]
          #     Optional. Parameters for the RUN action. It is an error to specify this
          #     if the RolloutAction is not set to RUN. By default, the rollout will
          #     retry failed operations when resumed.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutAction]
          #     Required. Action to be performed on the Rollout.
          #     The default behavior is to run the rollout until it naturally reaches a
          #     terminal state.
          class RolloutControl
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Parameters for the RUN action controlling the behavior of the rollout
            # when it is resumed from a PAUSED state.
            # @!attribute [rw] retry_failed_operations
            #   @return [::Boolean]
            #     Required. If true, the rollout will retry failed operations when resumed.
            #     This is applicable only the current state of the Rollout is PAUSED and
            #     the requested action is RUN.
            class RunRolloutActionParams
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # RolloutAction indicates the action to be performed on the Rollout.
          module RolloutAction
            # Unspecified action, will be treated as RUN by default.
            ROLLOUT_ACTION_UNSPECIFIED = 0

            # Run the Rollout until it naturally reaches a terminal state.
            # A rollout requested to run will progress through all natural Rollout
            # States (such as RUNNING -> SUCCEEDED or RUNNING -> FAILED).
            # If retriable errors are encountered during the rollout, the rollout
            # will paused by default and can be resumed by re-requesting this RUN
            # action.
            ROLLOUT_ACTION_RUN = 1

            # Pause the Rollout until it is resumed (i.e. RUN is requested).
            ROLLOUT_ACTION_PAUSE = 2

            # Cancel the Rollout permanently.
            ROLLOUT_ACTION_CANCEL = 3
          end
        end
      end
    end
  end
end
