# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          # The request structure for the ListSaas method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the saas.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of saas to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListSaasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListSaas method.
          # @!attribute [rw] saas
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas>]
          #     The resulting saas.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListSaas call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListSaasResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetSaas method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetSaasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateSaas method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the saas.
          # @!attribute [rw] saas_id
          #   @return [::String]
          #     Required. The ID value for the new saas.
          # @!attribute [rw] saas
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
          #     Required. The desired state for the saas.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateSaasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateSaas method.
          # @!attribute [rw] saas
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
          #     Required. The desired state for the saas.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     Saas resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     Saas will be overwritten.
          class UpdateSaasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteSaas method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the saas. This is
          #     used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the saas. The Any wildcard (`*`) requires that the resource
          #     must already exists, and the Not Any wildcard (`!*`) requires that it must
          #     not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteSaasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListTenants method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the tenant.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of tenants to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListTenantsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListTenants method.
          # @!attribute [rw] tenants
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant>]
          #     The resulting tenants.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListTenants call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListTenantsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetTenant method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetTenantRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateTenant method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the tenant.
          # @!attribute [rw] tenant_id
          #   @return [::String]
          #     Required. The ID value for the new tenant.
          # @!attribute [rw] tenant
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
          #     Required. The desired state for the tenant.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateTenantRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateTenant method.
          # @!attribute [rw] tenant
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
          #     Required. The desired state for the tenant.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     Tenant resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     Tenant will be overwritten.
          class UpdateTenantRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteTenant method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the tenant. This is
          #     used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the tenant. The Any wildcard (`*`) requires that the resource
          #     must already exists, and the Not Any wildcard (`!*`) requires that it must
          #     not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteTenantRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListUnitKinds method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit kind.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of unit kinds to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListUnitKindsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListUnitKinds method.
          # @!attribute [rw] unit_kinds
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind>]
          #     The resulting unit kinds.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListUnitKinds call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListUnitKindsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetUnitKind method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetUnitKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateUnitKind method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit kind.
          # @!attribute [rw] unit_kind_id
          #   @return [::String]
          #     Required. The ID value for the new unit kind.
          # @!attribute [rw] unit_kind
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
          #     Required. The desired state for the unit kind.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateUnitKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateUnitKind method.
          # @!attribute [rw] unit_kind
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
          #     Required. The desired state for the unit kind.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     UnitKind resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     UnitKind will be overwritten.
          class UpdateUnitKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteUnitKind method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the unit kind. This
          #     is used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the unit kind. The Any wildcard (`*`) requires that the
          #     resource must already exists, and the Not Any wildcard (`!*`) requires that
          #     it must not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteUnitKindRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListUnits method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of units to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListUnitsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListUnits method.
          # @!attribute [rw] units
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit>]
          #     The resulting units.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListUnits call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListUnitsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetUnit method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetUnitRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateUnit method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit.
          # @!attribute [rw] unit_id
          #   @return [::String]
          #     Required. The ID value for the new unit.
          # @!attribute [rw] unit
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
          #     Required. The desired state for the unit.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateUnitRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateUnit method.
          # @!attribute [rw] unit
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
          #     Required. The desired state for the unit.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     Unit resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     Unit will be overwritten.
          class UpdateUnitRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteUnit method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the unit. This is
          #     used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the unit. The Any wildcard (`*`) requires that the resource
          #     must already exists, and the Not Any wildcard (`!*`) requires that it must
          #     not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteUnitRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListUnitOperations method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit operation.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of unit operations to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListUnitOperationsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListUnitOperations method.
          # @!attribute [rw] unit_operations
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation>]
          #     The resulting unit operations.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListUnitOperations call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListUnitOperationsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetUnitOperation method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetUnitOperationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateUnitOperation method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the unit operation.
          # @!attribute [rw] unit_operation_id
          #   @return [::String]
          #     Required. The ID value for the new unit operation.
          # @!attribute [rw] unit_operation
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
          #     Required. The desired state for the unit operation.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateUnitOperationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateUnitOperation method.
          # @!attribute [rw] unit_operation
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
          #     Required. The desired state for the unit operation.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     UnitOperation resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     UnitOperation will be overwritten.
          class UpdateUnitOperationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteUnitOperation method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the unit operation.
          #     This is used with state-changing methods to prevent accidental overwrites
          #     when multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the unit operation. The Any wildcard (`*`) requires that the
          #     resource must already exists, and the Not Any wildcard (`!*`) requires that
          #     it must not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteUnitOperationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the ListReleases method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the release.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of releases to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListReleasesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListReleases method.
          # @!attribute [rw] releases
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release>]
          #     The resulting releases.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListReleases call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListReleasesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetRelease method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetReleaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the CreateRelease method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the release.
          # @!attribute [rw] release_id
          #   @return [::String]
          #     Required. The ID value for the new release.
          # @!attribute [rw] release
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
          #     Required. The desired state for the release.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateReleaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the UpdateRelease method.
          # @!attribute [rw] release
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
          #     Required. The desired state for the release.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the
          #     Release resource by the update.
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the user does not provide a mask then all fields in the
          #     Release will be overwritten.
          class UpdateReleaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the DeleteRelease method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag known to the client for the expected state of the release. This is
          #     used with state-changing methods to prevent accidental overwrites when
          #     multiple user agents might be acting in parallel on the same resource.
          #
          #     An etag wildcard provide optimistic concurrency based on the expected
          #     existence of the release. The Any wildcard (`*`) requires that the resource
          #     must already exists, and the Not Any wildcard (`!*`) requires that it must
          #     not.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If "validate_only" is set to true, the service will try to validate
          #     that this request would succeed, but will not actually make changes.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     An optional request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class DeleteReleaseRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
