# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          # Location information that the service is available in.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of location.
          class Location
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Saas is a representation of a SaaS service managed by the Producer.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/saas/\\{saas}"
          # @!attribute [rw] locations
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Location>]
          #     Optional. List of locations that the service is available in. Rollout
          #     refers to the list to generate a rollout plan.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class Saas
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Tenant represents the service producer side of an instance of the
          # service created based on a request from a consumer. In a typical scenario a
          # Tenant has a one-to-one mapping with a resource given out to a service
          # consumer.
          #
          # Example:
          #
          #    tenant:
          #      name: "projects/svc1/locations/loc/tenants/inst-068afff8"
          #      consumer_resource: "projects/gshoe/locations/loc/shoes/black-shoe"
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/tenants/\\{tenant}"
          # @!attribute [rw] consumer_resource
          #   @return [::String]
          #     Optional. Immutable. A reference to the consumer resource this SaaS Tenant
          #     is representing.
          #
          #     The relationship with a consumer resource can be used by SaaS Runtime for
          #     retrieving consumer-defined settings and policies such as maintenance
          #     policies (using Unified Maintenance Policy API).
          # @!attribute [rw] saas
          #   @return [::String]
          #     Required. Immutable. A reference to the Saas that defines the product
          #     (managed service) that the producer wants to manage with SaaS Runtime. Part
          #     of the SaaS Runtime common data model.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class Tenant
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Definition of a Unit. Units belonging to the same UnitKind are managed
          # together; for example they follow the same release model (blueprints,
          # versions etc.) and are typically rolled out together.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/unitKinds/\\{unitKind}"
          # @!attribute [rw] default_release
          #   @return [::String]
          #     Optional. A reference to the Release object to use as default for creating
          #     new units of this UnitKind (optional).
          #
          #     If not specified, a new unit must explicitly reference which release to use
          #     for its creation.
          # @!attribute [rw] dependencies
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Dependency>]
          #     Optional. Immutable. List of other unit kinds that this release will depend
          #     on. Dependencies will be automatically provisioned if not found.
          #     Maximum 10.
          # @!attribute [rw] input_variable_mappings
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VariableMapping>]
          #     Optional. List of inputVariables for this release that will either be
          #     retrieved from a dependency’s outputVariables, or will be passed on to a
          #     dependency’s inputVariables. Maximum 100.
          # @!attribute [rw] output_variable_mappings
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VariableMapping>]
          #     Optional. List of outputVariables for this unit kind will be passed to this
          #     unit's outputVariables. Maximum 100.
          # @!attribute [rw] saas
          #   @return [::String]
          #     Required. Immutable. A reference to the Saas that defines the product
          #     (managed service) that the producer wants to manage with SaaS Runtime. Part
          #     of the SaaS Runtime common data model. Immutable once set.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class UnitKind
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A unit of deployment that has its lifecycle via a CRUD API using an actuation
          # engine under the hood (e.g. based on Terraform, Helm or a custom
          # implementation provided by a service producer). A building block of a SaaS
          # Tenant.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/units/\\{unit}"
          # @!attribute [rw] unit_kind
          #   @return [::String]
          #     Optional. Reference to the UnitKind this Unit belongs to. Immutable once
          #     set.
          # @!attribute [r] release
          #   @return [::String]
          #     Optional. Output only. The current Release object for this Unit.
          # @!attribute [rw] tenant
          #   @return [::String]
          #     Optional. Reference to the Saas Tenant resource this unit belongs to. This
          #     for example informs the maintenance policies to use for scheduling future
          #     updates on a unit. (optional and immutable once created)
          # @!attribute [r] ongoing_operations
          #   @return [::Array<::String>]
          #     Optional. Output only. List of concurrent UnitOperations that are operating
          #     on this Unit.
          # @!attribute [r] pending_operations
          #   @return [::Array<::String>]
          #     Optional. Output only. List of pending (wait to be executed) UnitOperations
          #     for this unit.
          # @!attribute [r] scheduled_operations
          #   @return [::Array<::String>]
          #     Optional. Output only. List of scheduled UnitOperations for this unit.
          # @!attribute [r] dependents
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitDependency>]
          #     Optional. Output only. List of Units that depend on this unit. Unit can
          #     only be deprovisioned if this list is empty. Maximum 1000.
          # @!attribute [r] dependencies
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitDependency>]
          #     Optional. Output only. Set of dependencies for this unit. Maximum 10.
          # @!attribute [r] input_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Output only. Indicates the current input variables deployed by
          #     the unit
          # @!attribute [r] output_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Output only. Set of key/value pairs corresponding to output
          #     variables from execution of actuation templates. The variables are declared
          #     in actuation configs (e.g in helm chart or terraform) and the values are
          #     fetched and returned by the actuation engine upon completion of execution.
          # @!attribute [rw] maintenance
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit::MaintenanceSettings]
          #     Optional. Captures requested directives for performing future maintenance
          #     on the unit. This includes a request for the unit to skip maintenance for a
          #     period of time and remain pinned to its current release as well as controls
          #     for postponing maintenance scheduled in future.
          # @!attribute [r] state
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit::UnitState]
          #     Optional. Output only. Current lifecycle state of the resource (e.g. if
          #     it's being created or ready to use).
          # @!attribute [r] conditions
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitCondition>]
          #     Optional. Output only. A set of conditions which indicate the various
          #     conditions this resource can have.
          # @!attribute [rw] management_mode
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit::ManagementMode]
          #     Optional. Immutable. Indicates whether the Unit life cycle is controlled
          #     by the user or by the system.
          #     Immutable once created.
          # @!attribute [r] system_managed_state
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit::SystemManagedState]
          #     Optional. Output only. Indicates the system managed state of the unit.
          # @!attribute [r] system_cleanup_at
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Output only. If set, indicates the time when the system will
          #     start removing the unit.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class Unit
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Captures requested directives for performing future maintenance on the
            # unit. This includes a request for the unit to skip maintenance for a period
            # of time and remain pinned to its current release as well as controls for
            # postponing maintenance scheduled in future.
            # @!attribute [rw] pinned_until_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Optional. If present, it fixes the release on the unit until the given
            #     time; i.e. changes to the release field will be rejected. Rollouts should
            #     and will also respect this by not requesting an upgrade in the first
            #     place.
            class MaintenanceSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # UnitState annotates what is the current state of the unit itself.
            module UnitState
              # Unspecified state.
              UNIT_STATE_UNSPECIFIED = 0

              # Unit is not provisioned.
              UNIT_STATE_NOT_PROVISIONED = 1

              # Unit is being provisioned.
              UNIT_STATE_PROVISIONING = 2

              # Unit is being updated. This is typically when a unit is being upgraded to
              # a new release or some of the input variables on the Unit is being
              # changed. Certain kinds of updates may cause the Unit to become unusable
              # while the update is in progress.
              UNIT_STATE_UPDATING = 3

              # Unit is being deleted.
              UNIT_STATE_DEPROVISIONING = 4

              # Unit has been provisioned and is ready for use
              UNIT_STATE_READY = 5

              # Unit has error, when it is not ready and some error operation
              UNIT_STATE_ERROR = 6
            end

            # ManagementMode describes who is responsible for the management of the unit.
            module ManagementMode
              MANAGEMENT_MODE_UNSPECIFIED = 0

              # Unit's lifecycle is managed by the user.
              MANAGEMENT_MODE_USER = 1

              # The system will decide when to deprovision and delete the unit.
              # User still can deprovision or delete the unit manually.
              MANAGEMENT_MODE_SYSTEM = 2
            end

            module SystemManagedState
              SYSTEM_MANAGED_STATE_UNSPECIFIED = 0

              # Unit has dependents attached.
              SYSTEM_MANAGED_STATE_ACTIVE = 1

              # Unit has no dependencies attached, but attachment is allowed.
              SYSTEM_MANAGED_STATE_INACTIVE = 2

              # Unit has no dependencies attached, and attachment is not allowed.
              SYSTEM_MANAGED_STATE_DECOMMISSIONED = 3
            end
          end

          # Set of dependencies for this unit. Maximum 10.
          # @!attribute [r] alias
          #   @return [::String]
          #     Output only. Alias for the name of the dependency.
          # @!attribute [r] unit
          #   @return [::String]
          #     Output only. A reference to the Unit object.
          class UnitDependency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # UnitOperation encapsulates the intent of changing/interacting with the
          # service component represented by the specific Unit. Multiple UnitOperations
          # can be created (requested) and scheduled in the future, however only one will
          # be allowed to execute at a time (that can change in the future for
          # non-mutating operations).
          #
          # UnitOperations allow different actors interacting with the same
          # unit to focus only on the change they have requested.
          #
          # This is a base object that contains the common fields in all unit operations.
          # Next: 19
          # @!attribute [rw] provision
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Provision]
          #     Note: The following fields are mutually exclusive: `provision`, `upgrade`, `deprovision`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] upgrade
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Upgrade]
          #     Note: The following fields are mutually exclusive: `upgrade`, `provision`, `deprovision`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] deprovision
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Deprovision]
          #     Note: The following fields are mutually exclusive: `deprovision`, `provision`, `upgrade`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #      "projects/\\{project}/locations/\\{location}/unitOperations/\\{unitOperation}"
          # @!attribute [rw] unit
          #   @return [::String]
          #     Required. Immutable. The Unit a given UnitOperation will act upon.
          # @!attribute [rw] parent_unit_operation
          #   @return [::String]
          #     Optional. Reference to parent resource: UnitOperation. If an operation
          #     needs to create other operations as part of its workflow, each of the child
          #     operations should have this field set to the parent. This can be used for
          #     tracing. (Optional)
          # @!attribute [rw] rollout
          #   @return [::String]
          #     Optional. Specifies which rollout created this Unit Operation. This cannot
          #     be modified and is used for filtering purposes only. If a dependent unit
          #     and unit operation are created as part of another unit operation, they will
          #     use the same rolloutId.
          # @!attribute [rw] cancel
          #   @return [::Boolean]
          #     Optional. When true, attempt to cancel the operation. Cancellation may fail
          #     if the operation is already executing. (Optional)
          # @!attribute [r] state
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation::UnitOperationState]
          #     Optional. Output only. UnitOperationState describes the current state of
          #     the unit operation.
          # @!attribute [r] conditions
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperationCondition>]
          #     Optional. Output only. A set of conditions which indicate the various
          #     conditions this resource can have.
          # @!attribute [rw] schedule
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Schedule]
          #     Optional. When to schedule this operation.
          # @!attribute [r] engine_state
          #   @return [::String]
          #     Optional. Output only. The engine state for on-going
          #     deployment engine operation(s).
          #     This field is opaque for external usage.
          # @!attribute [r] error_category
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperationErrorCategory]
          #     Optional. Output only. UnitOperationErrorCategory describe the error
          #     category.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class UnitOperation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # UnitOperationState describes the current state of the unit operation.
            module UnitOperationState
              UNIT_OPERATION_STATE_UNKNOWN = 0

              # Unit operation is accepted but not ready to run.
              UNIT_OPERATION_STATE_PENDING = 1

              # Unit operation is accepted and scheduled.
              UNIT_OPERATION_STATE_SCHEDULED = 2

              # Unit operation is running.
              UNIT_OPERATION_STATE_RUNNING = 4

              # Unit operation has completed successfully.
              UNIT_OPERATION_STATE_SUCCEEDED = 5

              # Unit operation has failed.
              UNIT_OPERATION_STATE_FAILED = 6

              # Unit operation was cancelled.
              UNIT_OPERATION_STATE_CANCELLED = 7
            end
          end

          # Provision is the unit operation that provision the underlying resources
          # represented by a Unit. Can only execute if the Unit is not currently
          # provisioned.
          # @!attribute [rw] release
          #   @return [::String]
          #     Optional. Reference to the Release object to use for the Unit. (optional).
          # @!attribute [rw] input_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Set of input variables. Maximum 100. (optional)
          class Provision
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Deprovision is the unit operation that deprovision the underlying
          # resources represented by a Unit. Can only execute if the Unit is currently
          # provisioned.
          class Deprovision
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Upgrade is the unit operation that upgrades a provisioned unit, which may
          # also include the underlying resources represented by a Unit. Can only execute
          # if the Unit is currently provisioned.
          # @!attribute [rw] release
          #   @return [::String]
          #     Optional. Reference to the Release object to use for the Unit. (optional).
          # @!attribute [rw] input_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Set of input variables. Maximum 100. (optional)
          class Upgrade
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A time specification to schedule the maintenance.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Start of operation. If not set, will be set to the start of the
          #     next window. (optional)
          class Schedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A new version to be propagated and deployed to units. This includes pointers
          # to packaged blueprints for actuation (e.g Helm or Terraform configuration
          # packages) via artifact registry.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name (full URI of the resource) following the
          #     standard naming scheme:
          #
          #       "projects/\\{project}/locations/\\{location}/releases/\\{release}"
          # @!attribute [rw] unit_kind
          #   @return [::String]
          #     Required. Immutable. Reference to the UnitKind this Release corresponds to
          #     (required and immutable once created).
          # @!attribute [rw] blueprint
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Blueprint]
          #     Optional. Blueprints are OCI Images that contain all of the artifacts
          #     needed to provision a unit.
          # @!attribute [rw] release_requirements
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release::ReleaseRequirements]
          #     Optional. Set of requirements to be fulfilled on the Unit when using this
          #     Release.
          # @!attribute [r] input_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Output only. List of input variables declared on the blueprint
          #     and can be present with their values on the unit spec
          # @!attribute [r] output_variables
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Output only. List of output variables declared on the blueprint
          #     and can be present with their values on the unit status
          # @!attribute [rw] input_variable_defaults
          #   @return [::Array<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable>]
          #     Optional. Mapping of input variables to default values. Maximum 100
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was created.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the resource was last updated. Any
          #     change to the resource made by users must refresh this value.
          #     Changes to a resource made by the service should refresh this value.
          class Release
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Set of requirements to be fulfilled on the Unit when using this Release.
            # @!attribute [rw] upgradeable_from_releases
            #   @return [::Array<::String>]
            #     Optional. A list of releases from which a unit can be upgraded to this
            #     one (optional). If left empty no constraints will be applied. When
            #     provided, unit upgrade requests to this release will check and enforce
            #     this constraint.
            class ReleaseRequirements
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Mapping of input variables to their respective output variable for
          # depedenencies
          # @!attribute [rw] from
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::FromMapping]
          #     Optional. Output variables which will get their values from dependencies
          #
          #     Note: The following fields are mutually exclusive: `from`, `to`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] to
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ToMapping]
          #     Optional. Input variables whose values will be passed on to dependencies.
          #
          #     Note: The following fields are mutually exclusive: `to`, `from`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] variable
          #   @return [::String]
          #     Required. name of the variable
          class VariableMapping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Output variables whose values will be passed on to dependencies
          # @!attribute [rw] dependency
          #   @return [::String]
          #     Required. Alias of the dependency that the outputVariable will pass its
          #     value to
          # @!attribute [rw] output_variable
          #   @return [::String]
          #     Required. Name of the outputVariable on the dependency
          class FromMapping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input variables whose values will be passed on to dependencies
          # @!attribute [rw] dependency
          #   @return [::String]
          #     Required. Alias of the dependency that the inputVariable will pass its
          #     value to
          # @!attribute [rw] input_variable
          #   @return [::String]
          #     Required. Name of the inputVariable on the dependency
          # @!attribute [rw] ignore_for_lookup
          #   @return [::Boolean]
          #     Optional. Tells SaaS Runtime if this mapping should be used during lookup
          #     or not
          class ToMapping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Dependency represent a single dependency with another unit kind by alias.
          # @!attribute [rw] unit_kind
          #   @return [::String]
          #     Required. Immutable. The unit kind of the dependency.
          # @!attribute [rw] alias
          #   @return [::String]
          #     Required. An alias for the dependency. Used for input variable mapping.
          class Dependency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
