# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          # Blueprints are OCI Images that contain all of the artifacts needed to
          # provision a unit. Metadata such as, type of the engine used to actuate the
          # blueprint (e.g. terraform, helm etc) and version will come from the image
          # manifest. If the hostname is omitted, it will be assumed to be the regional
          # path to Artifact Registry (eg. us-east1-docker.pkg.dev).
          # @!attribute [rw] package
          #   @return [::String]
          #     Optional. Immutable. URI to a blueprint used by the Unit (required unless
          #     unitKind or release is set).
          # @!attribute [r] engine
          #   @return [::String]
          #     Output only. Type of the engine used to actuate the blueprint. e.g.
          #     terraform, helm etc.
          # @!attribute [r] version
          #   @return [::String]
          #     Output only. Version metadata if present on the blueprint.
          class Blueprint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # UnitVariable describes a parameter for a Unit.
          # @!attribute [rw] variable
          #   @return [::String]
          #     Required. Immutable. Name of the variable from actuation configs.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitVariable::Type]
          #     Optional. Immutable. Name of a supported variable type. Supported types are
          #     string, int, bool.
          # @!attribute [rw] value
          #   @return [::String]
          #     Optional. String encoded value for the variable.
          class UnitVariable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enumeration of variable types.
            module Type
              # Variable type is unspecified.
              TYPE_UNSPECIFIED = 0

              # Variable type is string.
              STRING = 1

              # Variable type is int.
              INT = 2

              # Variable type is bool.
              BOOL = 3
            end
          end

          # UnitCondition describes the status of an Unit. UnitCondition is individual
          # components that contribute to an overall state.
          # @!attribute [rw] status
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitCondition::Status]
          #     Required. Status of the condition.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitCondition::Type]
          #     Required. Type of the condition.
          # @!attribute [rw] last_transition_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Last time the condition transited from one status to another.
          # @!attribute [rw] message
          #   @return [::String]
          #     Required. Human readable message indicating details about the last
          #     transition.
          # @!attribute [rw] reason
          #   @return [::String]
          #     Required. Brief reason for the condition's last transition.
          class UnitCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enumeration of condition statuses.
            module Status
              # Condition status is unspecified.
              STATUS_UNSPECIFIED = 0

              # Condition is unknown.
              STATUS_UNKNOWN = 1

              # Condition is true.
              STATUS_TRUE = 2

              # Condition is false.
              STATUS_FALSE = 3
            end

            # Enumeration of condition types.
            module Type
              # Condition type is unspecified.
              TYPE_UNSPECIFIED = 0

              # Condition type is ready.
              TYPE_READY = 1

              # Condition type is updating.
              TYPE_UPDATING = 2

              # Condition type is provisioned.
              TYPE_PROVISIONED = 3

              # Condition type is operationError.
              # True when the last unit operation fails with a non-ignorable error.
              TYPE_OPERATION_ERROR = 4
            end
          end

          # UnitOperationCondition describes the status of an Unit Operation.
          # UnitOperationCondition is individual components that contribute to an overall
          # state.
          # @!attribute [rw] status
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperationCondition::Status]
          #     Required. Status of the condition.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperationCondition::Type]
          #     Required. Type of the condition.
          # @!attribute [rw] last_transition_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Last time the condition transited from one status to another.
          # @!attribute [rw] message
          #   @return [::String]
          #     Required. Human readable message indicating details about the last
          #     transition.
          # @!attribute [rw] reason
          #   @return [::String]
          #     Required. Brief reason for the condition's last transition.
          class UnitOperationCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enumeration of condition statuses.
            module Status
              # Condition status is unspecified.
              STATUS_UNSPECIFIED = 0

              # Condition is unknown.
              STATUS_UNKNOWN = 1

              # Condition is true.
              STATUS_TRUE = 2

              # Condition is false.
              STATUS_FALSE = 3
            end

            # Enumeration of condition types.
            module Type
              # Condition type is unspecified.
              TYPE_UNSPECIFIED = 0

              # Condition type is scheduled.
              TYPE_SCHEDULED = 2

              # Condition type is running.
              TYPE_RUNNING = 3

              # Condition type is succeeded.
              TYPE_SUCCEEDED = 4

              # Condition type is cancelled.
              TYPE_CANCELLED = 5
            end
          end

          # Represents the aggregation of a set of population of like records by a
          # certain group. For example, a collection of unit counts can be aggregated and
          # grouped by their state.
          # @!attribute [rw] group
          #   @return [::String]
          #     Required. Group by which to aggregate.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     Required. Number of records in the group.
          class Aggregate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # UnitOperationErrorCategory describes the error category of the unit
          # operation.
          module UnitOperationErrorCategory
            # Unit operation error category is unspecified
            UNIT_OPERATION_ERROR_CATEGORY_UNSPECIFIED = 0

            # Unit operation error category is not applicable, or it is not an error
            NOT_APPLICABLE = 1

            # Unit operation error category is fatal
            FATAL = 2

            # Unit operation error category is retriable
            RETRIABLE = 3

            # Unit operation error category is ignorable
            IGNORABLE = 4

            # Unit operation error category is standard, counts towards Rollout error
            # budget
            STANDARD = 5
          end
        end
      end
    end
  end
end
