# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/saasplatform/saasservicemgmt/v1beta1/rollouts_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_rollouts/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          module SaasRollouts
            module Rest
              ##
              # REST client for the SaasRollouts service.
              #
              # Manages the rollout of SaaS services.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "saasservicemgmt.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :saas_rollouts_stub

                ##
                # Configure the SaasRollouts Client class.
                #
                # See {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all SaasRollouts clients
                #   ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "SaasPlatform", "SaasServiceMgmt", "V1beta1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.list_rollouts.timeout = 60.0
                    default_config.rpcs.list_rollouts.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_rollout.timeout = 60.0
                    default_config.rpcs.get_rollout.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_rollout.timeout = 60.0

                    default_config.rpcs.update_rollout.timeout = 60.0

                    default_config.rpcs.delete_rollout.timeout = 540.0
                    default_config.rpcs.delete_rollout.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_rollout_kinds.timeout = 60.0
                    default_config.rpcs.list_rollout_kinds.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_rollout_kind.timeout = 60.0
                    default_config.rpcs.get_rollout_kind.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_rollout_kind.timeout = 60.0

                    default_config.rpcs.update_rollout_kind.timeout = 60.0

                    default_config.rpcs.delete_rollout_kind.timeout = 60.0
                    default_config.rpcs.delete_rollout_kind.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the SaasRollouts Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @saas_rollouts_stub.universe_domain
                end

                ##
                # Create a new SaasRollouts REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the SaasRollouts client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @saas_rollouts_stub = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @saas_rollouts_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @saas_rollouts_stub.endpoint
                    config.universe_domain = @saas_rollouts_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @saas_rollouts_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @saas_rollouts_stub.logger
                end

                # Service calls

                ##
                # Retrieve a collection of rollouts.
                #
                # @overload list_rollouts(request, options = nil)
                #   Pass arguments to `list_rollouts` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_rollouts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_rollouts` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the rollout.
                #   @param page_size [::Integer]
                #     The maximum number of rollouts to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest.new
                #
                #   # Call the list_rollouts method.
                #   result = client.list_rollouts request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.
                #     p item
                #   end
                #
                def list_rollouts request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_rollouts.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_rollouts.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_rollouts.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.list_rollouts request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_rollouts_stub, :list_rollouts, "rollouts", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single rollout.
                #
                # @overload get_rollout(request, options = nil)
                #   Pass arguments to `get_rollout` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_rollout(name: nil)
                #   Pass arguments to `get_rollout` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest.new
                #
                #   # Call the get_rollout method.
                #   result = client.get_rollout request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.
                #   p result
                #
                def get_rollout request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_rollout.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_rollout.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_rollout.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.get_rollout request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new rollout.
                #
                # @overload create_rollout(request, options = nil)
                #   Pass arguments to `create_rollout` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_rollout(parent: nil, rollout_id: nil, rollout: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_rollout` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the rollout.
                #   @param rollout_id [::String]
                #     Required. The ID value for the new rollout.
                #   @param rollout [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout, ::Hash]
                #     Required. The desired state for the rollout.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest.new
                #
                #   # Call the create_rollout method.
                #   result = client.create_rollout request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.
                #   p result
                #
                def create_rollout request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_rollout.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_rollout.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_rollout.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.create_rollout request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single rollout.
                #
                # @overload update_rollout(request, options = nil)
                #   Pass arguments to `update_rollout` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_rollout(rollout: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_rollout` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param rollout [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout, ::Hash]
                #     Required. The desired state for the rollout.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     Rollout resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     Rollout will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest.new
                #
                #   # Call the update_rollout method.
                #   result = client.update_rollout request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Rollout.
                #   p result
                #
                def update_rollout request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_rollout.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_rollout.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_rollout.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.update_rollout request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single rollout.
                #
                # @overload delete_rollout(request, options = nil)
                #   Pass arguments to `delete_rollout` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_rollout(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_rollout` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the rollout. This is
                #     used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the rollout. The Any wildcard (`*`) requires that the resource
                #     must already exists, and the Not Any wildcard (`!*`) requires that it must
                #     not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest.new
                #
                #   # Call the delete_rollout method.
                #   result = client.delete_rollout request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_rollout request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_rollout.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_rollout.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_rollout.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.delete_rollout request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of rollout kinds.
                #
                # @overload list_rollout_kinds(request, options = nil)
                #   Pass arguments to `list_rollout_kinds` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_rollout_kinds(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_rollout_kinds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the rollout kind.
                #   @param page_size [::Integer]
                #     The maximum number of rollout kinds to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest.new
                #
                #   # Call the list_rollout_kinds method.
                #   result = client.list_rollout_kinds request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.
                #     p item
                #   end
                #
                def list_rollout_kinds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListRolloutKindsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_rollout_kinds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_rollout_kinds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_rollout_kinds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.list_rollout_kinds request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_rollouts_stub, :list_rollout_kinds, "rollout_kinds", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single rollout kind.
                #
                # @overload get_rollout_kind(request, options = nil)
                #   Pass arguments to `get_rollout_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_rollout_kind(name: nil)
                #   Pass arguments to `get_rollout_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest.new
                #
                #   # Call the get_rollout_kind method.
                #   result = client.get_rollout_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.
                #   p result
                #
                def get_rollout_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetRolloutKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_rollout_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_rollout_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_rollout_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.get_rollout_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new rollout kind.
                #
                # @overload create_rollout_kind(request, options = nil)
                #   Pass arguments to `create_rollout_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_rollout_kind(parent: nil, rollout_kind_id: nil, rollout_kind: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_rollout_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the rollout kind.
                #   @param rollout_kind_id [::String]
                #     Required. The ID value for the new rollout kind.
                #   @param rollout_kind [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind, ::Hash]
                #     Required. The desired state for the rollout kind.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest.new
                #
                #   # Call the create_rollout_kind method.
                #   result = client.create_rollout_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.
                #   p result
                #
                def create_rollout_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateRolloutKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_rollout_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_rollout_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_rollout_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.create_rollout_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single rollout kind.
                #
                # @overload update_rollout_kind(request, options = nil)
                #   Pass arguments to `update_rollout_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_rollout_kind(rollout_kind: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_rollout_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param rollout_kind [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind, ::Hash]
                #     Required. The desired state for the rollout kind.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     RolloutKind resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     RolloutKind will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest.new
                #
                #   # Call the update_rollout_kind method.
                #   result = client.update_rollout_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::RolloutKind.
                #   p result
                #
                def update_rollout_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateRolloutKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_rollout_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_rollout_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_rollout_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.update_rollout_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single rollout kind.
                #
                # @overload delete_rollout_kind(request, options = nil)
                #   Pass arguments to `delete_rollout_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_rollout_kind(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_rollout_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the rollout kind.
                #     This is used with state-changing methods to prevent accidental overwrites
                #     when multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the rollout kind. The Any wildcard (`*`) requires that the
                #     resource must already exists, and the Not Any wildcard (`!*`) requires that
                #     it must not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest.new
                #
                #   # Call the delete_rollout_kind method.
                #   result = client.delete_rollout_kind request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_rollout_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteRolloutKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_rollout_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_rollout_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_rollout_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_rollouts_stub.delete_rollout_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the SaasRollouts REST API.
                #
                # This class represents the configuration for SaasRollouts REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # list_rollouts to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_rollouts.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasRollouts::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_rollouts.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "saasservicemgmt.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the SaasRollouts API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `list_rollouts`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_rollouts
                    ##
                    # RPC-specific configuration for `get_rollout`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_rollout
                    ##
                    # RPC-specific configuration for `create_rollout`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_rollout
                    ##
                    # RPC-specific configuration for `update_rollout`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_rollout
                    ##
                    # RPC-specific configuration for `delete_rollout`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_rollout
                    ##
                    # RPC-specific configuration for `list_rollout_kinds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_rollout_kinds
                    ##
                    # RPC-specific configuration for `get_rollout_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_rollout_kind
                    ##
                    # RPC-specific configuration for `create_rollout_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_rollout_kind
                    ##
                    # RPC-specific configuration for `update_rollout_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_rollout_kind
                    ##
                    # RPC-specific configuration for `delete_rollout_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_rollout_kind

                    # @private
                    def initialize parent_rpcs = nil
                      list_rollouts_config = parent_rpcs.list_rollouts if parent_rpcs.respond_to? :list_rollouts
                      @list_rollouts = ::Gapic::Config::Method.new list_rollouts_config
                      get_rollout_config = parent_rpcs.get_rollout if parent_rpcs.respond_to? :get_rollout
                      @get_rollout = ::Gapic::Config::Method.new get_rollout_config
                      create_rollout_config = parent_rpcs.create_rollout if parent_rpcs.respond_to? :create_rollout
                      @create_rollout = ::Gapic::Config::Method.new create_rollout_config
                      update_rollout_config = parent_rpcs.update_rollout if parent_rpcs.respond_to? :update_rollout
                      @update_rollout = ::Gapic::Config::Method.new update_rollout_config
                      delete_rollout_config = parent_rpcs.delete_rollout if parent_rpcs.respond_to? :delete_rollout
                      @delete_rollout = ::Gapic::Config::Method.new delete_rollout_config
                      list_rollout_kinds_config = parent_rpcs.list_rollout_kinds if parent_rpcs.respond_to? :list_rollout_kinds
                      @list_rollout_kinds = ::Gapic::Config::Method.new list_rollout_kinds_config
                      get_rollout_kind_config = parent_rpcs.get_rollout_kind if parent_rpcs.respond_to? :get_rollout_kind
                      @get_rollout_kind = ::Gapic::Config::Method.new get_rollout_kind_config
                      create_rollout_kind_config = parent_rpcs.create_rollout_kind if parent_rpcs.respond_to? :create_rollout_kind
                      @create_rollout_kind = ::Gapic::Config::Method.new create_rollout_kind_config
                      update_rollout_kind_config = parent_rpcs.update_rollout_kind if parent_rpcs.respond_to? :update_rollout_kind
                      @update_rollout_kind = ::Gapic::Config::Method.new update_rollout_kind_config
                      delete_rollout_kind_config = parent_rpcs.delete_rollout_kind if parent_rpcs.respond_to? :delete_rollout_kind
                      @delete_rollout_kind = ::Gapic::Config::Method.new delete_rollout_kind_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
